/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallNtpBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.VrmRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.site.Site;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.site.SiteConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.RequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigVrmNtpSubTask
extends DeploySubTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigVrmNtpSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask_config_vrm_ntp";
    private static final String KEY_CHECK_VRM_TIMEOUT = "deployfc.vrm.max_check_vrm_timeout";
    private static final String KEY_WAIT_VRM_TIME = "deployfc.vrm.max_wait_vrm_time";

    public ConfigVrmNtpSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
        this.setTaskSkipMsgOnFailed(FcErrorCode.SKIP_CONFIG_VRM_TIMEZONE.getSuggestMessage());
    }

    @Override
    protected boolean executeSubTask(DeployFcVrmBo fcVrmBo) throws BasicException {
        try {
            VrmRequestClient vrmRequestClient = RequestUtils.createVrmRequestClient(fcVrmBo.getVrm());
            VrmInstallNtpBo ntpBo = fcVrmBo.getNtp();
            if (!ntpBo.isConfigNtp()) {
                log.info("Start to set time zone only.");
                if (!this.setTimeZone(vrmRequestClient, ntpBo)) {
                    log.info("not need to config timezone.");
                    return true;
                }
                return this.waitForFcServiceStatus(vrmRequestClient);
            }
            if (!this.checkRemoteNtpService(vrmRequestClient, ntpBo)) {
                log.warn("check ntp config failed.");
                return false;
            }
            log.info("Start to set NTP service and time zone.");
            if (!this.setNtpService(vrmRequestClient, ntpBo)) {
                log.info("not need to config ntp and timezone.");
                return true;
            }
            return this.waitForFcServiceStatus(vrmRequestClient);
        }
        catch (ApiException e) {
            log.error("Setting TimeZone or NTP service failed", (Throwable)e);
            this.setTaskFailed(FcErrorCode.TIMEZONE_NTP_FAILED, Collections.singletonList(e.getMessage()));
            return false;
        }
    }

    private boolean checkRemoteNtpService(VrmRequestClient vrmRequestClient, VrmInstallNtpBo ntpBo) {
        try {
            vrmRequestClient.checkRemoteNtpService(ntpBo);
            return true;
        }
        catch (ApiException e) {
            log.error("check NTP service failed", (Throwable)e);
            this.setTaskFailed(FcErrorCode.NTP_IP_ILLEGAL, Collections.singletonList(e.getMessage()));
            return false;
        }
    }

    boolean waitForFcServiceStatus(VrmRequestClient vrmRequestClient) {
        int waitTime = Math.max(1, ConfigUtils.getPropertiesValue(KEY_WAIT_VRM_TIME, 5));
        log.info("prepare to wait vrm [{}] for fusion compute service started.", (Object)waitTime);
        ThreadUtils.threadSafeSleep((int)waitTime, (TimeUnit)TimeUnit.MINUTES);
        int checkTimeout = Math.max(1, ConfigUtils.getPropertiesValue(KEY_CHECK_VRM_TIMEOUT, 10));
        log.info("prepare to check vrm [{}] for fusion compute service started.", (Object)checkTimeout);
        LocalDateTime timeLimit = LocalDateTime.now().plusSeconds(TimeUnit.MINUTES.toSeconds(checkTimeout));
        int loginSuccCnt = 0;
        do {
            ThreadUtils.threadSafeSleep((int)20, (TimeUnit)TimeUnit.SECONDS);
            log.info("start to check FusionCompute, current loginCnt = {}.", (Object)loginSuccCnt);
            if (!vrmRequestClient.checkVrmServiceStatus()) {
                loginSuccCnt = 0;
                continue;
            }
            if (++loginSuccCnt < 5) continue;
            return true;
        } while (timeLimit.isAfter(LocalDateTime.now()));
        log.error("timeout to login to FusionCompute Portal failed.");
        this.setTaskFailed(FcErrorCode.TASK_CHECK_VRM_SERVICE_FAILED, Collections.emptyList());
        return false;
    }

    private boolean setNtpService(VrmRequestClient vrmRequestClient, VrmInstallNtpBo ntpBo) {
        SiteConfig siteConfig = new SiteConfig();
        siteConfig.setNtpIp(ntpBo.getNtpIp1());
        if (StringUtils.isNotEmpty((CharSequence)ntpBo.getNtpIp2())) {
            siteConfig.setNtpIp2(ntpBo.getNtpIp2());
        }
        if (StringUtils.isNotEmpty((CharSequence)ntpBo.getNtpIp3())) {
            siteConfig.setNtpIp3(ntpBo.getNtpIp3());
        }
        siteConfig.setTimeZone(ntpBo.getTimeZone());
        siteConfig.setNtpCycle(ntpBo.getSyncPeriod());
        Optional<Site> opSize = vrmRequestClient.querySite();
        if (opSize.isPresent() && this.checkNtpSame(siteConfig, opSize.get())) {
            log.info("config ntp and current ntp is same, {} {} {} {}", new Object[]{ntpBo.getTimeZone(), ntpBo.getNtpIp1(), ntpBo.getNtpIp2(), ntpBo.getNtpIp3()});
            return false;
        }
        vrmRequestClient.configSite(siteConfig);
        return true;
    }

    boolean checkNtpSame(SiteConfig config, Site site) {
        log.info("config size : {}, current site : {}.", (Object)config, (Object)site);
        if (!Objects.equals(StringUtils.defaultString((String)config.getTimeZone()), StringUtils.defaultString((String)site.getTimeZone()))) {
            return false;
        }
        if (!Objects.equals(StringUtils.defaultString((String)config.getNtpIp()), StringUtils.defaultString((String)site.getNtpIp()))) {
            return false;
        }
        if (!Objects.equals(StringUtils.defaultString((String)config.getNtpIp2()), StringUtils.defaultString((String)site.getNtpIp2()))) {
            return false;
        }
        return Objects.equals(StringUtils.defaultString((String)config.getNtpIp3()), StringUtils.defaultString((String)site.getNtpIp3()));
    }

    boolean setTimeZone(VrmRequestClient vrmRequestClient, VrmInstallNtpBo ntpBo) {
        Optional<Site> opSite = vrmRequestClient.querySite();
        if (opSite.isPresent() && Objects.equals(StringUtils.defaultString((String)opSite.get().getTimeZone()), StringUtils.defaultString((String)ntpBo.getTimeZone()))) {
            log.info("config timezone and current timezone is same, {}", (Object)ntpBo.getTimeZone());
            return false;
        }
        SiteConfig siteConfig = new SiteConfig();
        siteConfig.setTimeZone(ntpBo.getTimeZone());
        vrmRequestClient.configSite(siteConfig);
        return true;
    }
}

