/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigVrmInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.LogicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.RemoteFileVrmServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigVrmParamSubTask
extends DeploySubTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigVrmParamSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask_config_vrm_params";

    public ConfigVrmParamSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
    }

    @Override
    protected boolean canBeSkipTask() {
        return false;
    }

    @Override
    protected boolean executeSubTask(DeployFcVrmBo deployFcVrmBo) throws BasicException {
        SshShellService shellService = this.findShellService();
        if (!this.checkCipherModeIsSameWithParam(shellService, deployFcVrmBo)) {
            this.setTaskFailed(FcErrorCode.TASK_PARAM_INVALID, Collections.singletonList(ValidationMsgUtils.getString("vrm.vrm.cipherMode")));
            log.error("check cipher mode failed, {}.", (Object)deployFcVrmBo.getVrm().getCipherMode());
            return false;
        }
        String invalidPwdNames = this.checkPasswordInvalid(shellService, deployFcVrmBo);
        if (StringUtils.isNotEmpty((CharSequence)invalidPwdNames)) {
            this.setTaskFailed(FcErrorCode.TASK_PASSWORD_TOO_WEAK, Collections.singletonList(invalidPwdNames));
            log.error("check weak pwd failed, {}.", (Object)invalidPwdNames);
            return false;
        }
        RemoteFileVrmServiceImpl fileVrmService = new RemoteFileVrmServiceImpl(this.findSftpService(), deployFcVrmBo.getPathBo().getInstallPath());
        Optional<ConfigVrmInfo> opVrmInfo = fileVrmService.fetchConfigFile2Obj(this.getTaskId());
        if (!opVrmInfo.isPresent()) {
            log.warn("remote vrm.json is not exist");
        }
        Map<String, String> passwords = this.encryptConfigPasswords(shellService, deployFcVrmBo);
        log.info("encrypt config texts size = {}.", (Object)passwords.size());
        ConfigVrmInfo vrmInfo = opVrmInfo.orElse(new ConfigVrmInfo());
        vrmInfo.setType(deployFcVrmBo.getType());
        vrmInfo.overrideVrm(deployFcVrmBo.getVrm(), passwords);
        vrmInfo.overrideCna(deployFcVrmBo.getCna(), passwords);
        vrmInfo.overrideSize(deployFcVrmBo.getSize());
        vrmInfo.overrideOther(false);
        if (!fileVrmService.commitObj2ConfigFile(this.getTaskId(), vrmInfo)) {
            this.setTaskFailed(new LogicException((ErrorKey)FcErrorCode.CONFIG_FILE_COMMIT_FAILED, Collections.singletonList(fileVrmService.getRemoteConfigFile())));
            return false;
        }
        this.appendDetail("[config vrm info]", "sftp save vrm info to remote successfully.");
        return true;
    }

    private boolean checkCipherModeIsSameWithParam(SshShellService shellService, DeployFcVrmBo deployFcVrmBo) throws BasicException {
        String cmd = "grep --color=never -E \"cipher_mode ?=\" /etc/vna-api/vna-api.conf";
        String result = shellService.execCommand(cmd, (SshEndJudge)new DefaultSshEndJudge());
        this.appendDetail(cmd, result);
        log.info("execute [{}], result = {}.", (Object)cmd, (Object)result);
        String cipherMode = Arrays.stream(result.split("\n")).filter(line -> line.contains("cipher_mode =")).flatMap(line -> Arrays.stream(line.split("="))).map(String::trim).filter(line -> StringUtils.containIgnoreCase((String)line, (String[])new String[]{"sm", "general"})).findFirst().orElse("");
        log.info("deploy node cipher mode is {}.", (Object)cipherMode);
        return StringUtils.isEmpty((CharSequence)cipherMode) || deployFcVrmBo.getVrm() != null && Objects.equals(cipherMode, deployFcVrmBo.getVrm().getCipherMode());
    }

    private String checkPasswordInvalid(SshShellService shellService, DeployFcVrmBo deployFcVrmBo) throws BasicException {
        HashMap<String, String> pwdMaps = new HashMap<String, String>();
        Optional.ofNullable(deployFcVrmBo.getVrm()).ifPresent(vrmBo -> {
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.rootPwd"), vrmBo.getRootPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.gandalfPwd"), vrmBo.getGandalfPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.grubPwd"), vrmBo.getGrubPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.postgresPwd"), vrmBo.getPostgresPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.galaxPwd"), vrmBo.getGalaxPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.adminPwd"), vrmBo.getAdminPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.sysAdminPwd"), vrmBo.getSysAdminPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.secAdminPwd"), vrmBo.getSecAdminPwd());
            pwdMaps.put(ValidationMsgUtils.getString("vrm.vrm.secAuditorPwd"), vrmBo.getSecAuditorPwd());
        });
        log.info("check pwd size = {}.", (Object)pwdMaps.size());
        return String.join((CharSequence)",", TaskUtils.getInvalidPasswordParamNames(shellService, pwdMaps));
    }

    private Map<String, String> encryptConfigPasswords(SshShellService shellService, DeployFcVrmBo deployFcVrmBo) throws BasicException {
        HashSet<String> plainTexts = new HashSet<String>();
        Optional.ofNullable(deployFcVrmBo.getCna()).ifPresent(cnaBo -> plainTexts.addAll(Arrays.asList(cnaBo.getMasterGandalfPwd(), cnaBo.getMasterRootPwd(), cnaBo.getSlaveGandalfPwd(), cnaBo.getSlaveRootPwd())));
        Optional.ofNullable(deployFcVrmBo.getVrm()).ifPresent(vrmBo -> plainTexts.addAll(Arrays.asList(vrmBo.getRootPwd(), vrmBo.getGrubPwd(), vrmBo.getGandalfPwd(), vrmBo.getAdminPwd(), vrmBo.getSecAuditorPwd(), vrmBo.getSecAdminPwd(), vrmBo.getSysAdminPwd(), vrmBo.getPostgresPwd(), vrmBo.getGalaxPwd(), vrmBo.getHsmPwd(), vrmBo.getHsmServicePwd())));
        return TaskUtils.encryptConfigPasswords(shellService, this.getTaskId(), plainTexts);
    }
}

