/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.fitframework.core.common.util.FileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.consistency.ConsistencyPattern;
import com.huawei.yinglong.river.sitedeployment.dcs.constant.InstallModeEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.DeployPathBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.UploadPackageBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.common.Switch2RootSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeployTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.AddNode2ClusterSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.CheckVrmServiceStateSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.ConfigMgntDataBackupSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.ConfigVrmNtpSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.ConfigVrmParamSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.InstallVrmSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.RemoteFileVrmLogServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.SelectDatastoreSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.UploadVrmPackageSubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FileOperateUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployVrmTask
extends DeployTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployVrmTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.task.deploy_vrm";
    private DeployFcVrmBo deployFcVrmBo;
    private UploadVrmPackageSubTask uploadPackageSubTask;
    private RemoteFileVrmLogServiceImpl vrmLogService;

    public DeployVrmTask(String taskId, DeployFcVrmBo deployFcVrmBo) {
        super(taskId, TASK_NAME_RES_KEY);
        this.deployFcVrmBo = deployFcVrmBo;
        this.initializeSubTasks(taskId);
    }

    private void initializeSubTasks(String taskId) {
        Switch2RootSubTask switch2RootSubTask = new Switch2RootSubTask(taskId);
        this.appendSubTask(switch2RootSubTask, () -> switch2RootSubTask.apply(DeployTaskManager.getManager().findRootPwd(taskId)));
        ConfigVrmParamSubTask configVrmParamSubTask = new ConfigVrmParamSubTask(taskId);
        this.appendSubTask(configVrmParamSubTask, () -> configVrmParamSubTask.apply(this.deployFcVrmBo));
        this.uploadPackageSubTask = new UploadVrmPackageSubTask(taskId, this.buildExtraUploadPackage());
        this.appendSubTask(this.uploadPackageSubTask, this::execUploadVrmTemplatePackageToRemoteSubTask);
        InstallVrmSubTask installVrmSubTask = new InstallVrmSubTask(taskId);
        this.appendSubTask(installVrmSubTask, () -> installVrmSubTask.apply(this.deployFcVrmBo));
        CheckVrmServiceStateSubTask checkVrmServiceStateSubTask = new CheckVrmServiceStateSubTask(taskId);
        this.appendSubTask(checkVrmServiceStateSubTask, () -> checkVrmServiceStateSubTask.apply(this.deployFcVrmBo.getVrm()));
        if (this.deployFcVrmBo.getInstallMode().contains(InstallModeEnum.CNA.getInstallMode())) {
            AddNode2ClusterSubTask addNode2ClusterSubTask = new AddNode2ClusterSubTask(taskId);
            this.appendSubTask(addNode2ClusterSubTask, () -> addNode2ClusterSubTask.apply(this.deployFcVrmBo));
        }
        if (Objects.nonNull(this.deployFcVrmBo.getBackup()) && this.deployFcVrmBo.getBackup().isConfigBackup()) {
            ConfigMgntDataBackupSubTask configMgntDataBackupSubTask = new ConfigMgntDataBackupSubTask(taskId);
            this.appendSubTask(configMgntDataBackupSubTask, () -> configMgntDataBackupSubTask.apply(this.deployFcVrmBo));
        }
        if (this.checkNeedSelectDatastore()) {
            SelectDatastoreSubTask datastoreSubTask = new SelectDatastoreSubTask(taskId);
            this.appendSubTask(datastoreSubTask, () -> datastoreSubTask.apply(this.deployFcVrmBo));
        }
        ConfigVrmNtpSubTask configVrmNtpSubTask = new ConfigVrmNtpSubTask(taskId);
        this.appendSubTask(configVrmNtpSubTask, () -> configVrmNtpSubTask.apply(this.deployFcVrmBo));
    }

    private boolean checkNeedSelectDatastore() {
        if (this.deployFcVrmBo.getInstallMode().contains("dme")) {
            if (this.deployFcVrmBo.isAutoCreateVm()) {
                return true;
            }
            return Optional.of(this.deployFcVrmBo.getInstallMode()).map(List::size).filter(size -> size > 3).isPresent();
        }
        return Optional.of(this.deployFcVrmBo.getInstallMode()).map(List::size).filter(size -> size > 2).isPresent();
    }

    private List<UploadPackageBo> buildExtraUploadPackage() {
        LinkedList<UploadPackageBo> uploadPackages = new LinkedList<UploadPackageBo>();
        Optional.ofNullable(this.deployFcVrmBo.getVrm()).filter(VrmInstallVrmBo::isEnableHsm).map(VrmInstallVrmBo::getHsmLibFile).filter(StringUtils::isNotEmpty).map(fileName -> UploadPackageBo.builder().packageType(4).remotePath("/installer/upload/kms").packageFile((String)fileName).build()).ifPresent(uploadPackages::add);
        Optional.ofNullable(this.deployFcVrmBo.getPathBo()).map(DeployPathBo::getPackagePath).filter(StringUtils::isNotEmpty).map(File::new).map(file -> FileOperateUtils.getSpecialFileNames((File)file, ConsistencyPattern::isMatchFusionComputeVmToolsPackage).stream().map(fileName -> new File((File)file, (String)fileName))).flatMap(Stream::findFirst).map(vmToolFile -> UploadPackageBo.builder().packageType(5).remotePath("/installer/upload/vmtools").packageFile(FileUtils.path((File)vmToolFile)).build()).ifPresent(uploadPackages::add);
        return uploadPackages;
    }

    private TaskResult execUploadVrmTemplatePackageToRemoteSubTask() {
        DeployPathBo pathBo = this.deployFcVrmBo.getPathBo();
        return this.uploadPackageSubTask.apply(UploadPackageBo.builder().packageType(2).installPath(pathBo.getInstallPath()).packageFile(pathBo.getPackageFile()).remotePath(pathBo.getRemotePath()).build());
    }

    @Override
    public String getRemoteRunningLogs() {
        try {
            if (this.vrmLogService == null || !this.vrmLogService.isConnected()) {
                this.vrmLogService = new RemoteFileVrmLogServiceImpl(this.findShellService());
            }
            Optional<String> optionalLogs = this.vrmLogService.fetchConfigFile2Obj(this.getTaskId());
            log.info("read remote vrm log, exist : {}.", (Object)optionalLogs.isPresent());
            return optionalLogs.orElse("");
        }
        catch (BasicException e) {
            log.error("read remote vrm log failed.", (Throwable)e);
            return super.getRemoteRunningLogs();
        }
    }

    @Override
    protected boolean updateDeployParams(DeployFcVrmBo fcVrmBo) {
        if (fcVrmBo == null) {
            log.error("update deploy vrm failed, vrm is null.");
            return false;
        }
        this.deployFcVrmBo = fcVrmBo;
        log.info("update deploy fc vrm param.");
        return true;
    }
}

