/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.dto.TaskProgressDto;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigInstallStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.config.ConfigVrmProgInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskResult;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.RemoteFileVrmProgServiceImpl;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.CommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.TaskUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.NumberUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallVrmSubTask
extends DeploySubTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InstallVrmSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask_install_vrm";
    private static final long QUERY_INITIAL_DELAY = 5L;
    private static final long QUERY_DEX_DELAY = 5L;
    private static final int DEX_CHECK_TASK_STATUS = 10;
    private static final int DEFAULT_TIMEOUT_WAIT_VRM_INSTALL = 50;
    private static final String KEY_TIMEOUT_WAIT_VRM_INSTALL = "deployfc.vrm.max_wait_timeout_vrm_install";
    private final List<String> vrmInstallSteps = Arrays.asList("VrmVirtualInstallService", "VrmVirtualCheckHost", "VrmVirtualCreateCluster", "VrmVirtualConfigHost", "VrmVirtualRefreshStorage", "VrmVirtualAddStorage", "VrmVirtualConfigDvsNetwork", "VrmVirtualConfigVm", "VrmVirtualImportTemplate", "VrmVirtualExportVrmDb", "VrmVirtualInitVrm", "VrmVirtualEnableKrm", "VrmVirtualReleaseEnvironment", "VrmVirtualUninstallService");
    private final List<TaskResult> childTaskResults = new ArrayList<TaskResult>(this.vrmInstallSteps.size());
    private String installPath;
    private ConfigVrmProgInfo lastVrmTaskProg;
    private RemoteFileVrmProgServiceImpl vrmProgService;
    private volatile String errorMessage;
    private ScheduledFuture<?> scheduledFuture;
    private final DefaultSshEndJudge endJudge = new DefaultSshEndJudge();
    private final Callable<Boolean> checkTaskStatus = () -> {
        while (!this.checkTaskFinish()) {
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
        }
        return this.isChildTaskSuccessfully();
    };

    public InstallVrmSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
        this.initializeChildTaskResults();
    }

    private void initializeChildTaskResults() {
        this.childTaskResults.addAll(this.vrmInstallSteps.stream().map(vrmInstallStep -> new TaskResult().setTaskId((String)vrmInstallStep).setTaskStatus(TaskStatus.NOT_START).setTaskName(this.getRealTaskName("task.name.vrm.subtask_install_vrm.step." + vrmInstallStep)).setDurationTime(this.getDurationTime("task.name.vrm.subtask_install_vrm.step." + vrmInstallStep))).collect(Collectors.toList()));
    }

    private String executeCommand(SshShellService shellService, String command) throws SshException {
        String result = shellService.execCommand(command, (SshEndJudge)this.endJudge);
        this.appendDetail(command, result);
        log.info("execute [{}] , result = {}.", (Object)command, (Object)result);
        return result;
    }

    private boolean execStartInstallVrmCommand(SshShellService shellService) throws SshException {
        String command = "rm -f /tmp/installer_work_process.pid";
        this.executeCommand(shellService, command);
        this.tryToRemoveGlobalVrmJsonFile(shellService);
        command = CommandUtils.getLanguageCommand("vrmInstaller classic-start");
        String result = this.executeCommand(shellService, command);
        if (SshErrParser.isInvalidResult((String)result)) {
            this.setTaskFailed(FcErrorCode.COMMAND_EXECUTE_FAILED, Arrays.asList(command, result));
            return false;
        }
        return true;
    }

    private void tryToRemoveGlobalVrmJsonFile(SshShellService shellService) throws SshException {
        Optional<TaskResult> opCheckHost = this.childTaskResults.stream().filter(childTask -> Objects.equals("VrmVirtualCheckHost", childTask.getTaskId())).filter(childTask -> !childTask.isSuccessfully()).findFirst();
        if (opCheckHost.isPresent()) {
            String globalVrmFile = FilePathValidatorUtils.createLinuxPaths((String)this.installPath, (String[])new String[]{"data/object/global_vrm.json"});
            this.executeCommand(shellService, StringUtils.formatTxt((String)"rm -f %s", (Object[])new Object[]{globalVrmFile}));
        }
    }

    private boolean isChildTaskSuccessfully() {
        return this.childTaskResults.stream().allMatch(TaskResult::isSuccessfully);
    }

    @Override
    public List<TaskProgressDto> getChildTaskProgress() {
        return this.childTaskResults.stream().map(this::buildTaskProgressByResult).collect(Collectors.toList());
    }

    @Override
    protected void clearFailedStatus() {
        super.clearFailedStatus();
        this.errorMessage = "";
        this.childTaskResults.stream().filter(TaskResult::isFailed).findFirst().ifPresent(taskResult -> taskResult.setTaskStatus(TaskStatus.RUNNING).setTaskFinishTime(0L).setMessage("").clearDetail());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean executeSubTask(DeployFcVrmBo fcVrmBo) throws BasicException {
        try {
            SshShellService shellService = this.findShellService();
            if (!TaskUtils.switchUser2Root(shellService, this.getTaskId())) {
                this.setTaskFailed((ErrorKey)SshErrorCode.SHELL_COMMAND_FAILED, Collections.singletonList("su"));
                boolean bl = false;
                return bl;
            }
            this.installPath = fcVrmBo.getPathBo().getInstallPath();
            if (!this.execStartInstallVrmCommand(shellService)) {
                boolean bl = false;
                return bl;
            }
            this.scheduledFuture = ThreadUtils.scheduleWithFixedDelay((Runnable)new QueryVrmProgressThread(), (long)5L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
            Future future = ThreadUtils.submit(this.checkTaskStatus);
            int waitTimeMinute = ConfigUtils.getPropertiesValue(KEY_TIMEOUT_WAIT_VRM_INSTALL, 50);
            waitTimeMinute = Math.max(1, waitTimeMinute);
            log.info("start to wait for vrm install task, waitTime = {}.", (Object)waitTimeMinute);
            boolean isSuccessfully = (Boolean)future.get(waitTimeMinute, TimeUnit.MINUTES);
            log.info("wait for vrm install task, result = {}.", (Object)isSuccessfully);
            if (!isSuccessfully) {
                this.setChildTaskFailedResultStatus(FcErrorCode.TASK_EXECUTE_FAILED.getErrorMessage());
                this.setTaskFailed(FcErrorCode.TASK_EXECUTE_FAILED, Arrays.asList("VRM", StringUtils.defaultString((String)this.errorMessage)));
            }
            boolean bl = isSuccessfully;
            return bl;
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("query vrm progress execution or interrupted failed.", (Throwable)e);
            this.tryToStopInstallVrmCommand();
            this.setChildTaskFailedResultStatus(e.getMessage());
            this.setTaskFailed(FcErrorCode.TASK_EXECUTE_FAILED, Arrays.asList("VRM", e.getMessage()));
            this.appendDetail("[exception]", "happened execution or interrupted failed.");
            boolean bl = false;
            return bl;
        }
        catch (TimeoutException e) {
            log.error("query vrm progress timeout failed.", (Throwable)e);
            this.tryToStopInstallVrmCommand();
            this.setChildTaskFailedResultStatus(FcErrorCode.TASK_WAIT_TIMEOUT.getErrorMessage());
            this.setTaskFailed(FcErrorCode.TASK_WAIT_TIMEOUT, Collections.emptyList());
            this.appendDetail("[timeout]", "wait for vrm install timeout.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.cancelScheduleTask();
        }
    }

    private void tryToStopInstallVrmCommand() {
        try {
            this.executeCommand(this.findShellService(), CommandUtils.getLanguageCommand("vrmInstaller stop"));
        }
        catch (BasicException e) {
            log.error("stop vrm failed.", (Throwable)e);
        }
    }

    private void setChildTaskFailedResultStatus(String message) {
        long finishTime = System.currentTimeMillis();
        this.childTaskResults.stream().filter(TaskResult::isRunning).forEach(taskResult -> taskResult.setTaskStatus(TaskStatus.ERROR).setMessage(message).setTaskFinishTime(finishTime));
    }

    private void cancelScheduleTask() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
            this.scheduledFuture.cancel(true);
        }
    }

    private boolean checkTaskFinish() {
        return this.childTaskResults.stream().anyMatch(TaskResult::isFailed) || this.isChildTaskSuccessfully();
    }

    private void updatePreviousTaskStatus(ConfigVrmProgInfo vrmProgInfo) {
        String currentTask = vrmProgInfo.getCurrentTask();
        if (StringUtils.isEmpty((CharSequence)currentTask)) {
            log.error("current task name is empty.");
            return;
        }
        boolean hasFindCurrentTask = false;
        long currentTime = System.currentTimeMillis();
        for (TaskResult task : this.childTaskResults) {
            if (hasFindCurrentTask) {
                task.setTaskBeginTime(0L).setTaskFinishTime(0L).setTaskStatus(TaskStatus.NOT_START).setMessage("").setSuggestion("").clearDetail();
                continue;
            }
            if (task.getTaskBeginTime() == 0L) {
                task.setTaskStatus(TaskStatus.RUNNING);
                task.setTaskBeginTime(currentTime).appendDetail(this.getRealTaskName("task.name.vrm.subtask_install_vrm.step.description") + task.getTaskName());
            }
            if (Objects.equals(task.getTaskId(), currentTask)) {
                task.setTaskStatus(TaskStatus.RUNNING);
                hasFindCurrentTask = true;
                continue;
            }
            if (task.getTaskFinishTime() != 0L) continue;
            task.setTaskFinishTime(currentTime);
            task.setTaskStatus(TaskStatus.END).appendDetail(JSON.toJSONString((Object)vrmProgInfo));
        }
    }

    private void setChildCurrentTaskStatus(String currentTask, TaskStatus taskStatus, String message) {
        this.childTaskResults.stream().filter(taskResult -> Objects.equals(taskResult.getTaskId(), currentTask) || StringUtils.isEmpty((CharSequence)currentTask)).findFirst().ifPresent(taskResult -> taskResult.setTaskStatus(taskStatus).setMessage(message).setTaskFinishTime(System.currentTimeMillis()));
    }

    private Optional<ConfigVrmProgInfo> fetchConfigVrmProgInfo() throws BasicException {
        if (this.vrmProgService == null || !this.vrmProgService.isConnected()) {
            this.vrmProgService = new RemoteFileVrmProgServiceImpl(this.findSftpService(), this.installPath);
        }
        return this.vrmProgService.fetchConfigFile2Obj(this.getTaskId());
    }

    private void checkRemoteTaskStatusChanged(ConfigVrmProgInfo vrmProgInfo) {
        if (!Objects.equals(this.lastVrmTaskProg, vrmProgInfo)) {
            String json = JSON.toJSONString((Object)vrmProgInfo);
            this.appendDetail("[query vrm progress]", json);
            this.lastVrmTaskProg = vrmProgInfo;
            log.info("record vrm progress, current task progress : {}.", (Object)json);
        }
    }

    private void checkRemoteTaskProgressStatus(ConfigVrmProgInfo vrmProgInfo) {
        ConfigInstallStatus status = ConfigInstallStatus.of(vrmProgInfo.getStatus());
        log.info("current vrm install status : {}.", (Object)status);
        if (status == ConfigInstallStatus.TASK_ERROR || status == ConfigInstallStatus.TASK_FAILED) {
            this.setChildCurrentTaskStatus(vrmProgInfo.getCurrentTask(), TaskStatus.ERROR, vrmProgInfo.getMessage());
            this.errorMessage = vrmProgInfo.getMessage();
            this.cancelScheduleTask();
        } else if (status == ConfigInstallStatus.TASK_FINISHED && NumberUtils.parseInt((String)vrmProgInfo.getProgress(), (int)0) == 100) {
            this.setChildCurrentTaskStatus(vrmProgInfo.getCurrentTask(), TaskStatus.END, null);
            this.cancelScheduleTask();
        } else {
            log.info("other scene, continue to query.");
        }
    }

    private class QueryVrmProgressThread
    implements Runnable {
        private QueryVrmProgressThread() {
        }

        @Override
        public void run() {
            try {
                Optional opVrmProgInfo = InstallVrmSubTask.this.fetchConfigVrmProgInfo();
                if (!opVrmProgInfo.isPresent()) {
                    log.error("vrm fetch progress config file is failed.");
                    return;
                }
                ConfigVrmProgInfo vrmProgInfo = (ConfigVrmProgInfo)opVrmProgInfo.get();
                InstallVrmSubTask.this.checkRemoteTaskStatusChanged(vrmProgInfo);
                InstallVrmSubTask.this.updatePreviousTaskStatus(vrmProgInfo);
                InstallVrmSubTask.this.checkRemoteTaskProgressStatus(vrmProgInfo);
            }
            catch (BasicException e) {
                log.error("query vrm progress failed.", (Throwable)e);
            }
        }
    }
}

