/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm;

import com.huawei.yinglong.river.sitedeployment.dcs.constant.TaskOperateEnum;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.exception.FcErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.DeploySubTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskStatus;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ConfigUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.ValidationMsgUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectDatastoreSubTask
extends DeploySubTask<DeployFcVrmBo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SelectDatastoreSubTask.class);
    private static final String TASK_NAME_RES_KEY = "task.name.vrm.subtask.config_share_datastore";
    private boolean hasExecutedTask = false;

    public SelectDatastoreSubTask(String taskId) {
        super(taskId, TASK_NAME_RES_KEY);
        this.setTaskSkipMsgOnFailed(FcErrorCode.SKIP_CONFIG_SHARED_DATASTORE.getSuggestMessage());
        this.taskResult.addActions(TaskOperateEnum.RESUME);
        this.taskResult.appendDetail(ValidationMsgUtils.getString("task.name.vrm.subtask.config_share_datastore.detail"));
    }

    @Override
    protected boolean executeSubTask(DeployFcVrmBo fcVrmBo) throws BasicException {
        boolean isSkipSelectDatastore = this.checkNeedSkipSelectDatastore();
        log.info("stop to wait for config datastore, has Executed Task : {}, skip : {}, modes : {}", new Object[]{this.hasExecutedTask, isSkipSelectDatastore, fcVrmBo.getInstallMode()});
        if (this.hasExecutedTask || isSkipSelectDatastore) {
            return true;
        }
        this.taskResult.setTaskStatus(TaskStatus.PAUSE);
        this.taskResult.setMessage(FcErrorCode.SKIP_CONFIG_SHARED_DATASTORE.getErrorMessage());
        this.taskResult.setSuggestion(FcErrorCode.SKIP_CONFIG_SHARED_DATASTORE.getSuggestMessage());
        this.appendDetail("", ValidationMsgUtils.getString("task.config.datastore.detail"));
        this.hasExecutedTask = true;
        return false;
    }

    private boolean checkNeedSkipSelectDatastore() {
        return Boolean.parseBoolean(ConfigUtils.getPropertiesValue("deployfc.skip.datastore.select", "false"));
    }
}

