/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init;

import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallNtpBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.VmRequestUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.VrmRequestApi;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.backup.MgntDataBackupInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.cluster.Cluster;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.cluster.ClusterCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.cluster.ClusterList;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.datastore.AddDataStore;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.datastore.DataStoreInfos;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.datastore.DataStoreList;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.datastore.Datastore;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.datastore.StorageUnit;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.dvswitch.DvSwitch;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.dvswitch.DvSwitches;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.host.Host;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.host.HostCreate;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.host.HostList;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.host.HostRefresh;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.ntp.CheckNtpRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.port.Port;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.port.PortList;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.site.Site;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.site.SiteConfig;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.site.SiteList;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.task.SimpleTask;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.task.Task;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.task.TaskResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.uplink.UpLinkPortRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.uplink.UplinkPort;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.uplink.UplinkRequest;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api.data.uplink.UplinkResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.QueryWithException;
import com.huawei.yinglong.river.sitedeployment.dcs.http.HttpRequestApiFactory;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.ThreadUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class VrmRequestClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VrmRequestClient.class);
    private static final String TOKEN_KEY = "X-Auth-Token";
    private static final String MANAGE_CLUSTER_NAME = "ManagementCluster";
    private final VrmRequestApi vrmRequestApi;
    private final FcInfo fcInfo;

    public VrmRequestClient(FcInfo fcInfo) {
        String url = StringUtils.formatTxt((String)"https://%s:7443", (Object[])new Object[]{fcInfo.getIp()});
        this.fcInfo = fcInfo;
        this.vrmRequestApi = (VrmRequestApi)HttpRequestApiFactory.createRequestApi((String)url, VrmRequestApi.class);
    }

    public boolean checkVrmServiceStatus() {
        try {
            this.executeWithHandler(this.vrmRequestApi::queryVersions);
            return true;
        }
        catch (ApiException e) {
            log.warn("check fc vrm versions failed.");
            return false;
        }
    }

    public void createCluster(String clusterName) {
        String siteId;
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        List<Cluster> clusters = this.getClusters(tokenHeaders, siteId = this.getSiteId(tokenHeaders));
        if (clusters.stream().anyMatch(cluster -> Objects.equals(clusterName, cluster.getName()))) {
            log.info("cluster [{}] has exist. ", (Object)clusterName);
            return;
        }
        Cluster manageCluster = clusters.stream().filter(cluster -> Objects.equals(MANAGE_CLUSTER_NAME, cluster.getName())).findFirst().orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        ClusterCreate clusterCreate = new ClusterCreate();
        clusterCreate.setName(clusterName);
        clusterCreate.setArch(manageCluster.getArch());
        clusterCreate.setCpuVendor(manageCluster.getCpuVendor());
        this.queryWithHandler(() -> this.vrmRequestApi.createCluster(tokenHeaders, siteId, clusterCreate)).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
    }

    public void createHostToManageCluster(HostCreate hostCreate) {
        this.createHostToCluster(hostCreate, MANAGE_CLUSTER_NAME);
    }

    public void createHostToCluster(HostCreate hostCreate, String clusterName) {
        String siteId;
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        List hosts = this.queryWithHandler(() -> this.lambda$createHostToCluster$3(tokenHeaders, siteId = this.getSiteId(tokenHeaders))).map(HostList::getHosts).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        if (hosts.stream().anyMatch(host -> Objects.equals(host.getIp(), hostCreate.getIp()))) {
            log.info("host {} exist, skipped", (Object)hostCreate.getIp());
            return;
        }
        String clusterUrn = this.getClusterUrn(tokenHeaders, siteId, clusterName);
        if (StringUtils.isEmpty((CharSequence)clusterUrn)) {
            log.info("cluster {} not find, skipped", (Object)clusterName);
            return;
        }
        hostCreate.setClusterUrn(clusterUrn);
        String taskUrn = this.queryWithHandler(() -> this.vrmRequestApi.addHost(tokenHeaders, siteId, hostCreate)).map(TaskResponse::getTaskUrn).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        String taskId = VmRequestUtils.getIdFromUrn(taskUrn);
        this.getTaskUntilFinish(tokenHeaders, siteId, taskId);
    }

    public Cluster getManageCluster() {
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        return this.getClusters(tokenHeaders, siteId).stream().filter(cluster -> Objects.equals(MANAGE_CLUSTER_NAME, cluster.getName())).findFirst().orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
    }

    public void createUplinkPorts(List<String> cnaNameList) {
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        String dvSwitchUrn = this.getDvSwitchUrn(tokenHeaders, siteId);
        String dvSwitchId = VmRequestUtils.getIdFromUrn(dvSwitchUrn);
        List uplinkPorts = this.queryWithHandler(() -> this.vrmRequestApi.getUpLinkPorts(tokenHeaders, siteId, this.buildUpLinkRequest(dvSwitchUrn))).map(UplinkResponse::getUplinkPorts).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        List bindHostNames = uplinkPorts.stream().map(UplinkPort::getHostName).collect(Collectors.toList());
        List hosts = this.queryWithHandler(() -> this.vrmRequestApi.getHosts(tokenHeaders, siteId)).map(HostList::getHosts).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        hosts.stream().filter(host -> this.canCreateUpLinkPort(cnaNameList, bindHostNames, (Host)host)).forEach(host -> this.createUpLinkPort(tokenHeaders, siteId, dvSwitchId, (Host)host));
    }

    public void attachDataStore(List<String> cnaNameList) {
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        List hosts = this.queryWithHandler(() -> this.vrmRequestApi.getHosts(tokenHeaders, siteId)).map(HostList::getHosts).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        List datastoreNames = this.queryWithHandler(() -> this.vrmRequestApi.getDataStoreInfos(tokenHeaders, siteId, VmRequestUtils.buildImageMap())).map(DataStoreInfos::getDatastores).orElse(Collections.emptyList()).stream().map(Datastore::getName).collect(Collectors.toList());
        hosts.stream().filter(host -> cnaNameList.contains(host.getName())).forEach(host -> this.attachDataStore(tokenHeaders, siteId, (Host)host, datastoreNames));
    }

    public void checkRemoteNtpService(VrmInstallNtpBo ntpBo) {
        CheckNtpRequest checkNtpRequest = new CheckNtpRequest();
        if (StringUtils.isNotEmpty((CharSequence)ntpBo.getNtpIp1())) {
            checkNtpRequest.setNtpIp1(ntpBo.getNtpIp1());
        }
        if (StringUtils.isNotEmpty((CharSequence)ntpBo.getNtpIp2())) {
            checkNtpRequest.setNtpIp2(ntpBo.getNtpIp2());
        }
        if (StringUtils.isNotEmpty((CharSequence)ntpBo.getNtpIp3())) {
            checkNtpRequest.setNtpIp3(ntpBo.getNtpIp3());
        }
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        this.executeWithHandler(() -> this.vrmRequestApi.checkRemoteNTPService(tokenHeaders, siteId, checkNtpRequest));
    }

    public void configSite(SiteConfig siteConfig) {
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        this.executeWithHandler(() -> this.vrmRequestApi.configSite(tokenHeaders, siteId, siteConfig));
    }

    public Optional<Site> querySite() {
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        return this.queryWithHandler(() -> this.vrmRequestApi.querySite(tokenHeaders, siteId));
    }

    public void configMgntDataBackup(MgntDataBackupInfo backupInfo) {
        Map<String, String> tokenHeaders = this.getTokenHeaders();
        String siteId = this.getSiteId(tokenHeaders);
        HashMap<String, String> queryMaps = new HashMap<String, String>();
        queryMaps.put("siteID", siteId);
        this.executeWithHandler(() -> this.vrmRequestApi.configMgntDataBackup(tokenHeaders, siteId, queryMaps, backupInfo));
    }

    private String getClusterUrn(Map<String, String> tokenHeaders, String siteId, String clusterName) {
        return this.getClusters(tokenHeaders, siteId).stream().filter(cluster -> Objects.equals(clusterName, cluster.getName())).findFirst().map(Cluster::getUrn).orElse("");
    }

    private List<Cluster> getClusters(Map<String, String> tokenHeaders, String siteId) {
        return this.queryWithHandler(() -> this.vrmRequestApi.getClusterList(tokenHeaders, siteId)).map(ClusterList::getClusters).orElse(Collections.emptyList());
    }

    private boolean canCreateUpLinkPort(List<String> cnaNameList, List<String> bindHostNames, Host host) {
        return cnaNameList.contains(host.getName()) && !bindHostNames.contains(host.getName());
    }

    private void createUpLinkPort(Map<String, String> tokenHeaders, String siteId, String dvSwitchId, Host host) {
        String hostId = VmRequestUtils.getIdFromUrn(host.getUrn());
        List ports = this.queryWithHandler(() -> this.vrmRequestApi.getPortList(tokenHeaders, siteId, hostId)).map(PortList::getPorts).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        Port port = ports.stream().filter(p -> p.getStatus() == 0).findFirst().orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        this.queryWithHandler(() -> this.vrmRequestApi.addHostPort(tokenHeaders, siteId, dvSwitchId, this.buildUplinkPortRequest(port, host)));
    }

    private void attachDataStore(Map<String, String> tokenHeaders, String siteId, Host host, List<String> datastoreNames) {
        this.refreshStorageUnits(tokenHeaders, siteId, host);
        List<StorageUnit> storageUnits = this.queryWithHandler(() -> this.vrmRequestApi.getStoreUnits(tokenHeaders, siteId, VmRequestUtils.buildStoredMap(host.getUrn(), siteId))).map(DataStoreList::getStorageUnits).orElseThrow(ApiException.thr(ApiError.DATA_ERROR)).stream().filter(storageUnit -> Objects.equals(storageUnit.getType(), "LOCAL")).filter(storageUnit -> storageUnit.getCapacityGB() > 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(storageUnits)) {
            log.warn("{} query local store unit fail.", (Object)host.getName());
            return;
        }
        storageUnits.forEach(storageUnit -> this.tryAttachDataStore(tokenHeaders, siteId, host, (StorageUnit)storageUnit, datastoreNames));
    }

    private void tryAttachDataStore(Map<String, String> tokenHeaders, String siteId, Host host, StorageUnit storageUnit, List<String> datastoreNames) {
        try {
            this.attachDataStore(tokenHeaders, siteId, host, storageUnit, datastoreNames);
        }
        catch (ApiException e) {
            log.error("try to attach datastore failed, host:{},storage:{}.", new Object[]{host.getName(), storageUnit.getName(), e});
        }
    }

    private void attachDataStore(Map<String, String> tokenHeaders, String siteId, Host host, StorageUnit storageUnit, List<String> datastoreNames) {
        String taskId = this.queryWithHandler(() -> this.vrmRequestApi.addDataStore(tokenHeaders, siteId, this.buildDataStore(storageUnit, host, this.buildDataStoreName(datastoreNames, host.getName())))).map(TaskResponse::getTaskUrn).map(VmRequestUtils::getIdFromUrn).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        this.getTaskUntilFinish(tokenHeaders, siteId, taskId);
    }

    private String buildDataStoreName(List<String> datastoreNames, String hostName) {
        for (int i = 1; i < Short.MAX_VALUE; ++i) {
            String dataStoreName = StringUtils.formatTxt((String)"auto_%s_%d", (Object[])new Object[]{hostName, i});
            if (datastoreNames.contains(dataStoreName)) continue;
            datastoreNames.add(dataStoreName);
            return dataStoreName;
        }
        return StringUtils.formatTxt((String)"auto_%s_%d", (Object[])new Object[]{hostName, System.currentTimeMillis()});
    }

    private void refreshStorageUnits(Map<String, String> tokenHeaders, String siteId, Host host) {
        String refreshTaskId = this.queryWithHandler(() -> this.vrmRequestApi.refreshStorageUnits(tokenHeaders, siteId, this.buildHostRefresh(host.getUrn()))).map(SimpleTask::getTaskUrn).map(VmRequestUtils::getIdFromUrn).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        this.getTaskUntilFinish(tokenHeaders, siteId, refreshTaskId);
    }

    private HostRefresh buildHostRefresh(String hostUrn) {
        HostRefresh refresh = new HostRefresh();
        refresh.setHostUrn(hostUrn);
        return refresh;
    }

    private AddDataStore buildDataStore(StorageUnit storageUnit, Host host, String dataStoreName) {
        AddDataStore dataStore = new AddDataStore();
        dataStore.setFormatFlag("1");
        dataStore.setHostUrn(host.getUrn());
        dataStore.setName(dataStoreName);
        dataStore.setStorageUnitUrn(storageUnit.getUrn());
        dataStore.setUseType("1");
        dataStore.setDescription("auto_create");
        dataStore.setClusterSize("1024");
        return dataStore;
    }

    private UpLinkPortRequest buildUplinkPortRequest(Port port, Host host) {
        UplinkPort uplinkPort = new UplinkPort();
        uplinkPort.setPortName(port.getName());
        uplinkPort.setPortUrn(port.getUrn());
        uplinkPort.setHostName(host.getName());
        uplinkPort.setHostUrn(host.getUrn());
        uplinkPort.setStatus(0);
        UpLinkPortRequest request = new UpLinkPortRequest();
        request.setHostPortSet(Collections.singletonList(uplinkPort));
        return request;
    }

    private UplinkRequest buildUpLinkRequest(String dvSwitchUrn) {
        UplinkRequest request = new UplinkRequest();
        request.setDvsurns(Collections.singletonList(dvSwitchUrn));
        request.setLimit(100);
        request.setOffset(0);
        request.setPage(1);
        return request;
    }

    private String getDvSwitchUrn(Map<String, String> tokenHeaders, String siteId) {
        return this.queryWithHandler(() -> this.vrmRequestApi.getDvSwitches(tokenHeaders, siteId)).map(DvSwitches::getDvSwitchs).map(dvSwitchList -> (DvSwitch)dvSwitchList.get(0)).map(DvSwitch::getUrn).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
    }

    private String getSiteId(Map<String, String> headers) {
        return this.queryWithHandler(() -> this.vrmRequestApi.getSites(headers)).map(SiteList::getSites).map(list -> (Site)list.get(0)).map(Site::getUrn).map(VmRequestUtils::getIdFromUrn).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
    }

    private Map<String, String> getTokenHeaders() {
        String token = this.login(this.fcInfo.getUser(), this.fcInfo.getPassword());
        return VmRequestUtils.buildHeaders(token);
    }

    private String login(String user, String password) {
        try {
            Response userInfoResponse = this.vrmRequestApi.login(VmRequestUtils.buildLoginHeaders(user, password)).execute();
            VmRequestUtils.dealResponse(userInfoResponse);
            return Optional.ofNullable(userInfoResponse.headers().get(TOKEN_KEY)).orElseThrow(ApiException.thr(ApiError.LOGIN_FAIL));
        }
        catch (IOException exception) {
            log.error("login error", (Throwable)exception);
            throw new ApiException(ApiError.LOGIN_FAIL);
        }
    }

    private void getTaskUntilFinish(Map<String, String> headers, String siteId, String taskId) {
        Task task = (Task)this.queryWithHandler(() -> this.vrmRequestApi.getTaskById(headers, siteId, taskId)).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        while (!task.isFinish()) {
            ThreadUtils.threadSafeSleep((int)10, (TimeUnit)TimeUnit.SECONDS);
            task = (Task)this.queryWithHandler(() -> this.vrmRequestApi.getTaskById(headers, siteId, taskId)).orElseThrow(ApiException.thr(ApiError.DATA_ERROR));
        }
        if (!task.isSuccess()) {
            throw new ApiException(task.getReasonDes());
        }
    }

    private <T> Optional<T> queryWithHandler(QueryWithException<Call<T>, ?> queryWithException) {
        try {
            return Optional.of(queryWithException.query().execute()).map(VmRequestUtils::dealResponse);
        }
        catch (ApiException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new ApiException(ApiError.DATA_ERROR);
        }
    }

    private void executeWithHandler(QueryWithException<Call<Void>, ?> queryWithException) {
        try {
            VmRequestUtils.dealResponse(queryWithException.query().execute());
        }
        catch (ApiException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw exception;
        }
        catch (IOException exception) {
            log.error(exception.getMessage(), (Throwable)exception);
            throw new ApiException(ApiError.DATA_ERROR);
        }
    }

    private /* synthetic */ Call lambda$createHostToCluster$3(Map tokenHeaders, String siteId) throws ApiException {
        return this.vrmRequestApi.getHosts(tokenHeaders, siteId);
    }

    public static class FcInfo {
        private String ip;
        private String user;
        private String password;

        @Generated
        FcInfo(String ip, String user, String password) {
            this.ip = ip;
            this.user = user;
            this.password = password;
        }

        @Generated
        public static FcInfoBuilder builder() {
            return new FcInfoBuilder();
        }

        @Generated
        public String getIp() {
            return this.ip;
        }

        @Generated
        public String getUser() {
            return this.user;
        }

        @Generated
        public String getPassword() {
            return this.password;
        }

        @Generated
        public static class FcInfoBuilder {
            @Generated
            private String ip;
            @Generated
            private String user;
            @Generated
            private String password;

            @Generated
            FcInfoBuilder() {
            }

            @Generated
            public FcInfoBuilder ip(String ip) {
                this.ip = ip;
                return this;
            }

            @Generated
            public FcInfoBuilder user(String user) {
                this.user = user;
                return this;
            }

            @Generated
            public FcInfoBuilder password(String password) {
                this.password = password;
                return this;
            }

            @Generated
            public FcInfo build() {
                return new FcInfo(this.ip, this.user, this.password);
            }

            @Generated
            public String toString() {
                return "VrmRequestClient.FcInfo.FcInfoBuilder(ip=" + this.ip + ", user=" + this.user + ", password=" + this.password + ")";
            }
        }
    }
}

