/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.api;

import com.alibaba.fastjson.JSON;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiError;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ApiException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.common.ErrorResponse;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Response;

public final class VmRequestUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VmRequestUtils.class);

    public static String getIdFromUrn(String urn) {
        if (!urn.contains(":")) {
            throw new ApiException(ApiError.DATA_ERROR);
        }
        return urn.substring(urn.lastIndexOf(":") + 1);
    }

    public static <T> T dealResponse(Response<T> response) {
        if (response.isSuccessful()) {
            return (T)response.body();
        }
        throw new ApiException(VmRequestUtils.getErrorDesc(response));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getErrorDesc(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            if (errorBody == null) {
                log.warn("{} errorBody is null", response);
                String string = "";
                return string;
            }
            String errorStr = errorBody.string();
            if (StringUtils.isEmpty((CharSequence)errorStr) || !errorStr.startsWith("{")) {
                String string = errorStr;
                return string;
            }
            ErrorResponse errorResponse = (ErrorResponse)JSON.parseObject((String)errorStr, ErrorResponse.class);
            String string = errorResponse == null ? "" : errorResponse.getErrorDes();
            return string;
        }
        catch (IOException e) {
            log.error("deal errorBody error", (Throwable)e);
            return "";
        }
    }

    public static Map<String, String> buildLoginHeaders(String username, String password) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("X-Auth-User", username);
        header.put("X-Auth-Key", password);
        header.put("Content-Type", "application/json; charset=UTF-8");
        header.put("Accept", "application/json;version=8.1;charset=UTF-8");
        header.put("X-Auth-AuthType", "0");
        header.put("X-Auth-UserType", "0");
        header.put("X-ENCRYPT-ALGORITHM", "1");
        return header;
    }

    public static Map<String, String> buildHeaders(String token) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("X-Auth-Token", token);
        header.put("Content-Type", "application/json; charset=UTF-8");
        header.put("Accept", "application/json;version=8.1;charset=UTF-8");
        return header;
    }

    public static Map<String, String> buildHostMap(String hostUrn) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("scope", hostUrn);
        queryMap.put("accessible", "1");
        queryMap.put("exceptDatastoreType", "LUN");
        return queryMap;
    }

    public static Map<String, String> buildOsMap(String arch, String cpuVendor) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("arch", arch);
        queryMap.put("cpuVendor", cpuVendor);
        return queryMap;
    }

    public static Map<String, String> buildImageMap() {
        HashMap<String, String> imageQueryMap = new HashMap<String, String>();
        imageQueryMap.put("page", "1");
        imageQueryMap.put("offset", "0");
        imageQueryMap.put("limit", "100");
        return imageQueryMap;
    }

    public static Map<String, String> buildUploadMap(String fileName, long length, String siteId, String dataStoreId) {
        HashMap<String, String> applyQueryMap = new HashMap<String, String>();
        applyQueryMap.put("name", fileName);
        applyQueryMap.put("size", String.valueOf(length));
        applyQueryMap.put("siteID", siteId);
        applyQueryMap.put("dataStoreID", dataStoreId);
        applyQueryMap.put("client", "html5");
        return applyQueryMap;
    }

    public static Map<String, String> buildStoredMap(String hostUrn, String siteId) {
        HashMap<String, String> applyQueryMap = new HashMap<String, String>();
        applyQueryMap.put("limit", "100");
        applyQueryMap.put("offset", "0");
        applyQueryMap.put("deviceType", "0");
        applyQueryMap.put("useState", "unexpanded");
        applyQueryMap.put("scope", hostUrn);
        applyQueryMap.put("siteID", siteId);
        return applyQueryMap;
    }

    @Generated
    private VmRequestUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

