/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils;

import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.VrmInstallVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.vrm.init.VrmRequestClient;
import com.huawei.yinglong.river.sitedeployment.dcs.http.fc.FcRequestClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class RequestUtils {
    public static Map<String, String> createLoginBmcHeaderMaps() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        header.put("Connection", "keep-alive");
        header.put("Accept-Encoding", "gzip, deflate, br");
        header.put("Accept", "*/*");
        return header;
    }

    public static Map<String, String> createLoginBmcBodyMaps(String userName, String userPwd) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("UserName", userName);
        map.put("Password", userPwd);
        return map;
    }

    public static Map<String, String> createDefaultHeaderMaps(String authToken) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("X-Auth-Token", authToken);
        map.put("Content-Type", "application/json");
        return map;
    }

    public static Map<String, Object> createPowerOnBodyMaps() {
        HashMap<String, Object> powerMap = new HashMap<String, Object>();
        powerMap.put("ResetType", "On");
        return powerMap;
    }

    public static VrmRequestClient createVrmRequestClient(VrmInstallVrmBo vrmBo) {
        boolean isDoubleMode = Objects.equals("double", vrmBo.getMode());
        boolean isUserNormal = Objects.equals("normal", vrmBo.getUserMode());
        VrmRequestClient.FcInfo fcInfo = VrmRequestClient.FcInfo.builder().ip(isDoubleMode ? vrmBo.getFloatIp() : vrmBo.getMasterIp()).user(isUserNormal ? "admin" : "sysadmin").password(isUserNormal ? vrmBo.getAdminPwd() : vrmBo.getSysAdminPwd()).build();
        return new VrmRequestClient(fcInfo);
    }

    public static FcRequestClient createFcRequestClient(VrmInstallVrmBo vrmBo) {
        boolean isDoubleMode = Objects.equals("double", vrmBo.getMode());
        boolean isUserNormal = Objects.equals("normal", vrmBo.getUserMode());
        String ip = isDoubleMode ? vrmBo.getFloatIp() : vrmBo.getMasterIp();
        String userName = isUserNormal ? "admin" : "sysadmin";
        String userPwd = isUserNormal ? vrmBo.getAdminPwd() : vrmBo.getSysAdminPwd();
        return new FcRequestClient(ip, userName, userPwd);
    }

    @Generated
    private RequestUtils() {
    }
}

