/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils;

import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.CnaInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.FcInstallParamsVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamCnaVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamNodeVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.InsParamVrmVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.TaskInfoVo;
import com.huawei.yinglong.river.deploy.virtualization.deployfc.entity.VrmInstallParamsVo;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.BasicException;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshErrorCode;
import com.huawei.yinglong.river.sitedeployment.dcs.exceptions.SshException;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.fit.FcInstallParamAssembler;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.Constants;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.CnaInitBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.DeployPathBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.cna.DeployFcCnaBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployFcInstallerBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.installer.DeployNofDriverBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.bo.vrm.DeployFcVrmBo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.DeployTaskManager;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.task.framework.TaskBasicInfo;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.CommandUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.fc.service.utils.FileUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.DefaultSshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshEndJudge;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshErrParser;
import com.huawei.yinglong.river.sitedeployment.dcs.ssh.SshShellService;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.FilePathValidatorUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.StringUtils;
import com.huawei.yinglong.river.sitedeployment.dcs.utils.exception.ErrorKey;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskUtils.class);
    private static final FcInstallParamAssembler FC_ASSEMBLER = (FcInstallParamAssembler)Mappers.getMapper(FcInstallParamAssembler.class);

    public static boolean switchUser2Root(SshShellService shellService, String taskId) throws BasicException {
        String rootPwd = DeployTaskManager.getManager().findRootPwd(taskId);
        if (StringUtils.isEmpty((CharSequence)rootPwd)) {
            log.error("not find current root text.");
            return false;
        }
        String result = shellService.execCommand("su");
        log.info("switch user to root result = {}.", (Object)result);
        if (result.contains("Password:")) {
            result = shellService.execCommand(rootPwd);
            log.info("input root text, result={}.", (Object)TaskUtils.replaceSensitiveTexts(result, rootPwd));
        }
        return result.trim().endsWith("#");
    }

    public static DeployPathBo createDeployPathBo(TaskInfoVo taskInfoVo, String packageFileName, String remotePath) {
        return DeployPathBo.builder().installPath(FilePathValidatorUtils.createLinuxPaths((String)"/home/GalaX8800", (String[])new String[]{FileUtils.removeFileSuffix(taskInfoVo.getInstallerFileName())})).packagePath(taskInfoVo.getPackagePath()).packageFile(FilePathValidatorUtils.getSafePath((File)new File(taskInfoVo.getPackagePath(), packageFileName)).orElse("")).remotePath(remotePath).build();
    }

    public static CnaInitBo createCnaInitBo(FcInstallParamsVo paramsVo) {
        CnaInstallParamsVo cnaParamVo = paramsVo.getCna();
        Optional<InsParamNodeVo> opNodeVo = TaskUtils.findMasterNode(cnaParamVo);
        if (cnaParamVo != null && opNodeVo.isPresent()) {
            InsParamNodeVo nodeVo = opNodeVo.get();
            return new CnaInitBo().setOsHostIp(nodeVo.getHostIp()).setBmcHostIp(nodeVo.getBmcIp()).setBmcUserName(nodeVo.getBmcUsername()).setBmcUserPwd(nodeVo.getBmcPwd()).setGandalfPwd(cnaParamVo.getGandalfPwd()).setRedisPwd(cnaParamVo.getRedisPwd()).setRootPwd(cnaParamVo.getRootPwd()).setGrubPwd(cnaParamVo.getGrubPwd()).setCipherMode(StringUtils.defaultString((String)cnaParamVo.getCipherMode(), (String)"general"));
        }
        VrmInstallParamsVo vrmParamVo = paramsVo.getVrm();
        if (vrmParamVo != null && vrmParamVo.getVrm() != null && vrmParamVo.getCna() != null) {
            InsParamVrmVo vrmVo = vrmParamVo.getVrm();
            InsParamCnaVo cnaVo = vrmParamVo.getCna();
            return new CnaInitBo().setOsHostIp(cnaVo.getMasterIp()).setGandalfPwd(cnaVo.getMasterGandalfPwd()).setRootPwd(cnaVo.getMasterRootPwd()).setCipherMode(StringUtils.defaultString((String)vrmVo.getCipherMode(), (String)"general"));
        }
        return new CnaInitBo();
    }

    private static Optional<InsParamNodeVo> findMasterNode(CnaInstallParamsVo cnaParamVo) {
        if (cnaParamVo == null || CollectionUtils.isEmpty((Collection)cnaParamVo.getNodes())) {
            return Optional.empty();
        }
        return cnaParamVo.getNodes().stream().filter(InsParamNodeVo::getIsMaster).findFirst();
    }

    public static TaskBasicInfo createTaskBasicInfo(TaskInfoVo taskInfoVo) {
        return new TaskBasicInfo().setTaskUuid(taskInfoVo.getTaskId()).setHostIp(taskInfoVo.getMasterIp()).setRootPwd(taskInfoVo.getMasterRootPwd()).setUserPwd(taskInfoVo.getMasterGandalfPwd());
    }

    public static DeployFcInstallerBo createDeployFcInstallerBo(FcInstallParamsVo paramsVo) {
        TaskInfoVo taskInfoVo = paramsVo.getTask();
        return DeployFcInstallerBo.builder().pathBo(TaskUtils.createDeployPathBo(taskInfoVo, taskInfoVo.getInstallerFileName(), "/home/GalaX8800")).cnaInitBo(TaskUtils.createCnaInitBo(paramsVo).setOpenSftp(true)).driverBo(TaskUtils.createDriverBo(paramsVo)).build();
    }

    private static DeployNofDriverBo createDriverBo(FcInstallParamsVo paramsVo) {
        String packagePath = Optional.ofNullable(paramsVo.getTask()).map(TaskInfoVo::getPackagePath).orElse("");
        return DeployNofDriverBo.builder().packagePath(packagePath).cnaDriver(Optional.ofNullable(paramsVo.getCna()).map(CnaInstallParamsVo::getCnaDriver).orElse(false)).build();
    }

    public static DeployFcCnaBo createDeployFcCnaBo(CnaInstallParamsVo cnaInstallParamsVo, TaskInfoVo taskInfoVo) {
        DeployFcCnaBo deployFcCnaBo = FC_ASSEMBLER.toBo(cnaInstallParamsVo);
        return deployFcCnaBo.setPathBo(TaskUtils.createDeployPathBo(taskInfoVo, taskInfoVo.getCnaIsoFileName(), "/installer/upload/cna"));
    }

    public static DeployFcVrmBo createDeployFcVrmBo(VrmInstallParamsVo vrmInstallParamsVo, TaskInfoVo taskInfoVo) {
        DeployFcVrmBo deployFcVrmBo = FC_ASSEMBLER.toBo(vrmInstallParamsVo);
        deployFcVrmBo.setInstallMode(ListUtils.emptyIfNull((List)taskInfoVo.getInstallMode()));
        deployFcVrmBo.setAutoCreateVm(Boolean.TRUE.equals(taskInfoVo.getAutoCreateVM()));
        return deployFcVrmBo.setPathBo(TaskUtils.createDeployPathBo(taskInfoVo, taskInfoVo.getVrmTempFileName(), "/installer/upload/vrm"));
    }

    public static String encryptPassword(SshShellService shellService, String password) throws BasicException {
        String escapePwd = CommandUtils.escapeCommand(password, Constants.Command.ENCRYPT_PWD_KMC_ESCAPE);
        String command = StringUtils.formatTxt((String)"linuxinstaller -c 'import fskmc;print(fskmc.FS_KMC_Manage().kmc_encrypt(\"%s\"))'", (Object[])new Object[]{escapePwd});
        String result = shellService.execCommand(command, (SshEndJudge)new DefaultSshEndJudge());
        log.info("execute [kmc_encrypt], result = ******.");
        if (SshErrParser.isInvalidResult((String)result)) {
            log.error("encrypt failed, invalid result.");
            throw new SshException((ErrorKey)SshErrorCode.SHELL_COMMAND_FAILED, Collections.singletonList("linuxinstaller kmc"));
        }
        String encPwd = FileUtils.readSpecialLineText(result, 2);
        int lastEqualIdx = encPwd.lastIndexOf("=");
        if (lastEqualIdx >= 0) {
            encPwd = encPwd.substring(0, lastEqualIdx + 1);
        }
        if (StringUtils.isEmpty((CharSequence)encPwd)) {
            log.error("not find encrypt content.");
            throw new SshException((ErrorKey)SshErrorCode.SHELL_COMMAND_FAILED, Collections.singletonList("linuxinstaller kmc"));
        }
        return encPwd;
    }

    public static Map<String, String> encryptConfigPasswords(SshShellService shellService, String taskId, Set<String> plainTexts) throws BasicException {
        plainTexts.removeIf(StringUtils::isEmpty);
        if (!TaskUtils.switchUser2Root(shellService, taskId)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> passwords = new HashMap<String, String>();
        for (String plainText : plainTexts) {
            String encText = TaskUtils.encryptPassword(shellService, plainText);
            passwords.put(plainText, encText);
        }
        return passwords;
    }

    public static String replaceSensitiveTexts(String result, String sensitive) {
        return result.replace(sensitive.trim(), "********");
    }

    public static boolean checkPasswordWeak(SshShellService shellService, String password) throws BasicException {
        String escapePwd = CommandUtils.escapeCommand(password, Constants.Command.CHECK_CRACKLIB_ESCAPE);
        String command = StringUtils.formatTxt((String)"echo %s | cracklib-check", (Object[])new Object[]{escapePwd});
        String result = shellService.execCommand(command, (SshEndJudge)new DefaultSshEndJudge());
        log.info("execute [echo ****** | cracklib-check], result = {}.", (Object)TaskUtils.replaceSensitiveTexts(result, password));
        if (SshErrParser.isInvalidResult((String)result)) {
            log.error("encrypt failed, invalid result.");
            throw new SshException((ErrorKey)SshErrorCode.SHELL_COMMAND_FAILED, Collections.singletonList("cracklib-check"));
        }
        return !result.contains("OK");
    }

    public static List<String> getInvalidPasswordParamNames(SshShellService shellService, Map<String, String> pwdMaps) throws BasicException {
        LinkedList<String> weakPwdNames = new LinkedList<String>();
        HashMap<String, Boolean> pwdResultMaps = new HashMap<String, Boolean>();
        for (Map.Entry<String, String> entry : pwdMaps.entrySet()) {
            String password = entry.getValue();
            if (StringUtils.isEmpty((CharSequence)password)) continue;
            if (!pwdResultMaps.containsKey(password)) {
                pwdResultMaps.put(password, TaskUtils.checkPasswordWeak(shellService, password));
            }
            if (!Boolean.TRUE.equals(pwdResultMaps.get(password))) continue;
            weakPwdNames.add(entry.getKey());
        }
        return weakPwdNames;
    }

    @Generated
    private TaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

