/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism;

import com.huawei.ism.common.resourcemanager.LocalResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameworkCommon {
    private static final Logger log = LoggerFactory.getLogger(FrameworkCommon.class);
    public static final String ISM_ARGS = "ISM_ARGS";
    public static final String RUN_MODE = "RUN_MODE";
    public static final String ISM_DEMO = "USE_DEMO";
    public static final String DEBUG = "DEBUG";
    public static final String APPLET = "APPLET";
    public static final String PROXY = "PROXY";
    public static final String APPLICATION = "APP";
    public static final String SOCKET_SSL = "-useSSL";
    public static final String DEVICE_TYPE = "-devicetype";
    public static final String PROTOCAL_TYPE = "-protocaltype";
    public static final String AUTHMODE = "-authMode";
    public static final String ISM_VERSION = "ism_version";
    public static final String PACKAGEE_PATH = "-path";
    public static final String VERSION_FILE_NAME = ".ver";
    private static final String LAUNCH_VERSION = "Version";
    private static FrameworkCommon singleton = null;
    private Map<String, Object> properties = new HashMap<String, Object>(0);
    private Map<String, TimeZone> timeZones = new HashMap<String, TimeZone>(0);

    public void init(String ismArg) {
        if (ismArg != null) {
            String[] argv;
            this.setProperty(ISM_ARGS, ismArg);
            for (String str : argv = ismArg.split(";")) {
                String[] strs = str.split("=");
                if (strs.length == 1) {
                    this.setProperty(strs[0], "true");
                    continue;
                }
                if (strs.length != 2) continue;
                this.setProperty(strs[0], strs[1]);
            }
        }
        this.registExceptionHandler();
    }

    public synchronized void trytoSetProperty(String key, Object value) {
        if (this.properties.get(key) == null) {
            this.properties.put(key, value);
        }
    }

    public synchronized Object getProperty(String key) {
        return this.properties.get(key);
    }

    public synchronized void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public boolean isDemoMode() {
        return Boolean.valueOf(this.getStrProperty(ISM_DEMO));
    }

    public synchronized String getStrProperty(String mapKey) {
        try {
            return (String)this.properties.get(mapKey);
        }
        catch (Exception e) {
            log.error("get string property error: {}", (Object)mapKey, (Object)e);
            return null;
        }
    }

    public synchronized String getStrProperty(String mapKey, String defaultStr) {
        try {
            String returnValue = (String)this.properties.get(mapKey);
            if (null == returnValue) {
                returnValue = defaultStr;
            }
            return returnValue;
        }
        catch (Exception e) {
            log.error("get string property error: {}", (Object)mapKey, (Object)e);
            return defaultStr;
        }
    }

    public String getIsmVersion() {
        String defaultValue = ResourceManager.getCfgProperties().getProperty("ISM_VERSION");
        String value = this.getStrProperty(ISM_VERSION, defaultValue);
        String title = ResourceManager.getString("ISM_VERSION");
        return title + " " + value;
    }

    public String getLaunchVersion() {
        String value = this.getStrProperty(LAUNCH_VERSION, "Launch version is not existed.");
        return value;
    }

    public void loadVender() {
        String vender = this.getStrProperty("VENDER", "");
        if (vender.trim().length() <= 0) {
            vender = "Huawei";
        }
        System.setProperty("VENDER", vender);
    }

    public static synchronized FrameworkCommon getInstance() {
        if (singleton == null) {
            singleton = new FrameworkCommon();
        }
        return singleton;
    }

    public String getRunMode() {
        String mode = this.getStrProperty(RUN_MODE, DEBUG);
        return mode;
    }

    public TimeZone getDeviceTimeZone(String deviceID) {
        TimeZone timeZone = this.timeZones.get(deviceID);
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        return timeZone;
    }

    public void setDeviceTimeZone(String deviceID, TimeZone zone) {
        this.timeZones.put(deviceID, zone);
    }

    private void registExceptionHandler() {
        boolean success;
        Date date = new Date();
        File root = new File(FilePathUtils.filterPath((String)(LocalResourceManager.getInstance().getISMRootDir() + File.separatorChar + "logs")));
        if (!root.exists() && !(success = root.mkdirs())) {
            log.error("Make dir \"{}\" error", (Object)root.getName());
        }
        this.createLaunchVerFile();
        Thread.setDefaultUncaughtExceptionHandler(new MyExceptionHandler(date, root));
    }

    private void createLaunchVerFile() {
        boolean success;
        String userDir = LocalResourceManager.getInstance().getUserDataDir();
        if (null == userDir || "".equals(userDir) || !userDir.endsWith("Default")) {
            return;
        }
        File verFile = new File(userDir, VERSION_FILE_NAME);
        if (verFile.exists() && !(success = verFile.delete())) {
            log.error("Delete the file \"{}\" failed.", (Object)verFile.getName());
        }
        try {
            success = verFile.createNewFile();
            if (!success) {
                log.error("Delete the file \"{}\" failed.", (Object)verFile.getName());
            }
        }
        catch (IOException e) {
            log.error("create file error", (Throwable)e);
        }
        try (FileOutputStream fileOutput = new FileOutputStream(verFile);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fileOutput, Charset.defaultCharset());){
            writer.write(this.getLaunchVersion());
        }
        catch (IOException e) {
            log.error("write into file error", (Throwable)e);
        }
    }

    private static final class MyExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Date date;
        private final File root;

        private MyExceptionHandler(Date date, File root) {
            this.date = date;
            this.root = root;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            log.error("thread: {}-{}-{} uncaught error.", new Object[]{thread.getName(), thread.getPriority(), thread.getContextClassLoader(), throwable});
        }
    }
}

