/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import com.huawei.ism.common.ICallback;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.model.MO;
import com.huawei.ism.service.MOsCache;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHandleCallBack
implements ICallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHandleCallBack.class);
    private ProgressDialog progressDialog = null;
    private Window parentFor = null;

    public DefaultHandleCallBack(Window parent, ProgressDialog progressDialog) {
        this.parentFor = parent;
        this.progressDialog = progressDialog;
    }

    @Override
    public void process(int percent) {
    }

    @Override
    public void complete(IsmMsg msg) {
        SwingUtil.runInEventDispatchThread(new MyRunnable(msg));
    }

    public Window getParentFor() {
        return this.parentFor;
    }

    public void setParentFor(Window parentFor) {
        this.parentFor = parentFor;
    }

    public ProgressDialog getProgressDialog() {
        return this.progressDialog;
    }

    public void setProgressDialog(ProgressDialog progressDialog) {
        this.progressDialog = progressDialog;
    }

    protected void handle(MO mo) {
        this.closeProgressDialog();
        DialogUtils.showInfoDialog(this.parentFor);
    }

    protected void handle() {
        this.closeProgressDialog();
        DialogUtils.showInfoDialog(this.parentFor);
    }

    protected void handle(MOsCache mosCache) {
        this.closeProgressDialog();
        DialogUtils.showInfoDialog(this.parentFor);
    }

    protected void handle(Map<Object, Object> resultMap) {
        this.closeProgressDialog();
        DialogUtils.showInfoDialog(this.parentFor);
    }

    protected void handle(Throwable throwable) {
        this.closeProgressDialog();
        DialogUtils.showErrorDialog(this.parentFor, throwable);
    }

    protected void closeProgressDialog() {
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
    }

    private class MyRunnable
    implements Runnable {
        private IsmMsg msg = null;

        public MyRunnable(IsmMsg msg) {
            this.msg = msg;
        }

        @Override
        public void run() {
            try {
                this.doProcess(this.msg);
            }
            catch (Exception ex) {
                LOGGER.error("", (Throwable)ex);
                DefaultHandleCallBack.this.closeProgressDialog();
                DialogUtils.showErrorDialog(DefaultHandleCallBack.this.parentFor, ResourceManager.getString("-1"));
            }
            catch (Error ex) {
                LOGGER.error("", (Throwable)ex);
                DefaultHandleCallBack.this.closeProgressDialog();
                DialogUtils.showErrorDialog(DefaultHandleCallBack.this.parentFor, ResourceManager.getString("-1"));
            }
        }

        private void doProcess(IsmMsg msgValue) {
            if (null == msgValue) {
                return;
            }
            Object exception = msgValue.getProperty("PROPERTY_EXCEPTION");
            if (exception != null && exception instanceof Throwable) {
                DefaultHandleCallBack.this.handle((Throwable)exception);
                return;
            }
            if (msgValue.getMsgType().equalsIgnoreCase("MSG_TYPE_INVOKE_METHOD_RESULT")) {
                DefaultHandleCallBack.this.handle(msgValue.propertyMap());
            } else if (msgValue.getMsgType().equalsIgnoreCase("MSG_TYPE_RETRIEVE_MO_RESULT")) {
                this.handleRetrieveMOResult(msgValue);
            } else {
                Object value = msgValue.getProperty("PROPERTY_MO");
                if (value instanceof MO) {
                    MO mo = (MO)value;
                    DefaultHandleCallBack.this.handle(mo);
                } else {
                    DefaultHandleCallBack.this.handle();
                }
            }
        }

        private void handleRetrieveMOResult(IsmMsg msgValue) {
            MOsCache cache = (MOsCache)msgValue.getProperty("PROPERTY_MOS_CACHE");
            if (null != cache) {
                DefaultHandleCallBack.this.handle(cache);
                return;
            }
            Object value = msgValue.getProperty("PROPERTY_MO");
            if (value instanceof MO) {
                MO mo = (MO)value;
                DefaultHandleCallBack.this.handle(mo);
            }
        }
    }
}

