/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common;

import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.ProductSpeciality;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.ui.module.event.EventProcessor;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.ui.widgets.action.BaseAction;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.ui2.perfstat.util.PerfStatDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;

public abstract class Launcher {
    public static final String VIEW_NOMAL = "TREENODE_VIEW_NOMAL";
    public static final String VIEW_N8000_SUBNODE = "TREENODE_VIEW_N8000_SUBNODE";
    public static final String VIEW_VIS_SUBNODE = "TREENODE_VIEW_VIS_SUBNODE";
    private DeviceContext devContext;
    private List<ProductSpeciality> supportedSpeciality = new Vector<ProductSpeciality>();
    private TimeZone timeZone = TimeZone.getDefault();
    private volatile long deviceTime = 0L;
    private List<String> subDeviceIDs = new ArrayList<String>(0);
    private BackgroundTask bgTask;

    public void start(DeviceContext deviceContext, BackgroundTask backgroundTask) {
        if (null == deviceContext) {
            throw new NullPointerException("device context can't be null!");
        }
        this.devContext = deviceContext;
        this.bgTask = backgroundTask;
    }

    public DeviceContext getDeviceContext() {
        return this.devContext;
    }

    public DeviceContext getDevContext() {
        return this.devContext;
    }

    public String checkSystemStatus(String deviceID) {
        return null;
    }

    public abstract boolean isReady();

    public abstract String getDeviceName();

    public String getProductVersion() {
        return "";
    }

    public BackgroundTask getBackgroundTask() {
        return this.bgTask;
    }

    public void setBackgroundTask(BackgroundTask backgroundTask) {
        this.bgTask = backgroundTask;
    }

    public void invokeMethod(String methodName, Map<String, Object> inArgs, Map<String, Object> outArgs) throws IsmException {
        IsmException be = new IsmException(-1L);
        be.setErrorMessage(ResourceManager.getString("33"));
        throw be;
    }

    public boolean isSupportMethod(String name) {
        return false;
    }

    public abstract Collection<Launcher> getSubLaunchers();

    public List<ProductSpeciality> getSupportedSpecialitys() {
        return this.supportedSpeciality;
    }

    public boolean isSupportSpeciality(ProductSpeciality productSpeciality) {
        return this.supportedSpeciality.contains((Object)productSpeciality);
    }

    public void addSupportSpeciality(ProductSpeciality productSpeciality) {
        if (null != productSpeciality) {
            this.supportedSpeciality.add(productSpeciality);
        }
    }

    public void removeSupportSpeciality(ProductSpeciality productSpeciality) {
        if (null != productSpeciality) {
            this.supportedSpeciality.remove((Object)productSpeciality);
        }
    }

    public abstract BaseAction<?> getAction(String var1);

    public abstract IsmTreeNode getDeviceTreeNode(String var1);

    public List<FeatureItem> getFeatureItems() {
        return Collections.emptyList();
    }

    public abstract void stop() throws IsmException;

    public abstract String getDeviceID();

    public TimeZone getDeviceTimeZone() {
        return this.timeZone;
    }

    public void setDeviceTimeZone(TimeZone zone) {
        if (zone != null) {
            this.timeZone = zone;
        }
    }

    public long getDeviceTime() {
        return this.deviceTime;
    }

    public void setDeviceTime(long deviceTime) {
        this.deviceTime = deviceTime;
    }

    public List<String> getSubDeviceIDs() {
        return this.subDeviceIDs;
    }

    public void addSubDeviceID(String subDeviceID) {
        if (null != subDeviceID && !this.subDeviceIDs.contains(subDeviceID)) {
            this.subDeviceIDs.add(subDeviceID);
        }
    }

    public abstract boolean containsPart(String var1);

    public abstract boolean authenticate();

    public abstract void retrieveDevice();

    public abstract void refresh() throws IsmException;

    public abstract List<EventProcessor> getEventProcessor();

    public abstract State getState();

    protected void retrieveAndHandleLicense() {
    }

    public PerfStatDataSource getPerfStatDataSource(String deviceID) {
        return null;
    }

    public void retrievePowerOnStatue() {
    }

    public static enum State {
        STARTING,
        DISCOVERING,
        RUNNING,
        STOPPED,
        REFRESHING;

    }
}

