/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.entity;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Type {
    private static final Logger LOGGER = LoggerFactory.getLogger(Type.class);
    public static final String DEFAULT_STR_VALUE = "--";
    public static final int TYPE_UNKNOW = Integer.MIN_VALUE;
    private static Type instance = new Type();

    private Type() {
    }

    public static Type getInstance() {
        return instance;
    }

    public static String getString(String string) {
        try {
            return ResourceManager.getString(string);
        }
        catch (MissingResourceException e) {
            LOGGER.warn("can't find Type description of " + string);
            return DEFAULT_STR_VALUE;
        }
    }

    public static enum LunMigrationLunType {
        SRCLUN(1),
        DSTLUN(2),
        UNKNOW(Integer.MIN_VALUE);

        private int value;

        private LunMigrationLunType(int value) {
            this.value = value;
        }

        public static LunMigrationLunType valueOf(int intValue) {
            LunMigrationLunType[] values;
            for (LunMigrationLunType value : values = LunMigrationLunType.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error("wrong Lun Migration.LunMigrationLunType value:" + intValue);
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum LunMigrationState {
        MOVING(1),
        QUEUE(2),
        COMPLETE(3),
        FAULT(4),
        UNKNOW(Integer.MIN_VALUE);

        private int value;

        private LunMigrationState(int value) {
            this.value = value;
        }

        public static LunMigrationState valueOf(int intValue) {
            LunMigrationState[] values;
            for (LunMigrationState value : values = LunMigrationState.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error("wrong Lun Migration LunMigrationState value:" + intValue);
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String packageName = "LUNMIGRATION.STATE.";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum SpeedLevelEnum {
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        EXTREME(4),
        UNKNOW(Integer.MIN_VALUE);

        private int value;

        private SpeedLevelEnum(int value) {
            this.value = value;
        }

        public static SpeedLevelEnum valueOf(int intValue) {
            SpeedLevelEnum[] values;
            for (SpeedLevelEnum value : values = SpeedLevelEnum.values()) {
                if (value.value != intValue) continue;
                return value;
            }
            LOGGER.error("wrong Lun Migration.SpeedLevel value:" + intValue);
            return UNKNOW;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            String packageName = "CSSType.SpeedLevel.";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum CloudCopyRoleType {
        SOURCE_LUN(1),
        OTHER_LUN(2),
        UNKNOW(Integer.MIN_VALUE);

        private int cloudCopyRoleValue;

        private CloudCopyRoleType(int value) {
            this.cloudCopyRoleValue = value;
        }

        public static CloudCopyRoleType getCloudCopyRoleType(int type) {
            CloudCopyRoleType ccrt = UNKNOW;
            for (CloudCopyRoleType cloudCopyRoleType : CloudCopyRoleType.values()) {
                ccrt = CloudCopyRoleType.getCloudCopyRoleType1(type, ccrt, cloudCopyRoleType);
            }
            LOGGER.error("wrong CloudCopyRoleType value:" + type);
            return ccrt;
        }

        private static CloudCopyRoleType getCloudCopyRoleType1(int type, CloudCopyRoleType ccrt, CloudCopyRoleType cloudCopyRoleType) {
            if (cloudCopyRoleType.cloudCopyRoleValue == type) {
                return cloudCopyRoleType;
            }
            return ccrt;
        }

        public int getValue() {
            return this.cloudCopyRoleValue;
        }

        public String getDescription() {
            if (1 == this.cloudCopyRoleValue) {
                return Type.getString("CLOUDCOPY_SOURCE_LUN");
            }
            if (2 == this.cloudCopyRoleValue) {
                return Type.getString("CLOUDCOPY_OTHER_LUN");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum CloudCopySyncType {
        MANUAL(1),
        TIMED(2),
        UNKNOW(Integer.MIN_VALUE);

        private int cloudCopyValue;

        private CloudCopySyncType(int value) {
            this.cloudCopyValue = value;
        }

        public static CloudCopySyncType valueOf(int intValue) throws IsmException {
            CloudCopySyncType[] values;
            for (CloudCopySyncType value : values = CloudCopySyncType.values()) {
                if (value.cloudCopyValue != intValue) continue;
                return value;
            }
            LOGGER.error("wrong CloudCopySyncType value:" + intValue);
            return UNKNOW;
        }

        public int getValue() {
            return this.cloudCopyValue;
        }

        public String toString() {
            String packageName = "CLOUDCOPY_";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum HostGroupMappingMode {
        InitiatorMode(200),
        FcPortMode(100),
        Unknown(-1);

        private int hostGroupValue;

        private HostGroupMappingMode(int value) {
            this.hostGroupValue = value;
        }

        public static HostGroupMappingMode getType(int value) {
            for (HostGroupMappingMode enumValue : HostGroupMappingMode.values()) {
                if (enumValue.hostGroupValue != value) continue;
                return enumValue;
            }
            return Unknown;
        }

        public int getValue() {
            return this.hostGroupValue;
        }

        public String toString() {
            return ResourceManager.getString(this.name().toUpperCase(Locale.ENGLISH));
        }

        public String getDescription() {
            String des = Type.getString("HostGroupMappingType_" + this.name());
            return des;
        }
    }

    public static enum MultiPathLinkStatus {
        NORMAL(0),
        DEGRADE(1),
        UNKNOWN(-1);

        private long multiValue;

        private MultiPathLinkStatus(int value) {
            this.multiValue = value;
        }

        public static MultiPathLinkStatus getMultiPathLinkStatus(long value) {
            for (MultiPathLinkStatus linkStatus : MultiPathLinkStatus.values()) {
                if (linkStatus.multiValue != value) continue;
                return linkStatus;
            }
            return UNKNOWN;
        }

        public long getValue() {
            return this.multiValue;
        }

        public String toString() {
            String packageName = "MULTIPATH_LINK_STATUS_";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum DateInfo {
        Year(0),
        Month(1),
        Day(2),
        Unknown(-1);

        private int dateInfoValue;

        private DateInfo(int value) {
            this.dateInfoValue = value;
        }

        public static DateInfo getPortMode(int value) {
            for (DateInfo enumValue : DateInfo.values()) {
                if (enumValue.dateInfoValue != value) continue;
                return enumValue;
            }
            return Unknown;
        }

        public int getValue() {
            return this.dateInfoValue;
        }

        public String toString() {
            return ResourceManager.getString(this.name().toUpperCase(Locale.ENGLISH));
        }
    }

    public static enum MappedObjectType {
        Host(1),
        HostGroup(2),
        UnKnown(-1);

        private int mappedValue;

        private MappedObjectType(int value) {
            this.mappedValue = value;
        }

        public static MappedObjectType getMappedObjectType(int value) {
            for (MappedObjectType ipType : MappedObjectType.values()) {
                if (ipType.mappedValue != value) continue;
                return ipType;
            }
            return UnKnown;
        }

        public int getValue() {
            return this.mappedValue;
        }
    }

    public static enum IPType {
        IPv4("IPv4"),
        IPv6("IPv6"),
        UnKnown("Unknown");

        private String ipTypeValue;

        private IPType(String value) {
            this.ipTypeValue = value;
        }

        public static IPType getIPType(String value) {
            for (IPType ipType : IPType.values()) {
                if (!ipType.ipTypeValue.equals(value)) continue;
                return ipType;
            }
            return UnKnown;
        }

        public String getValue() {
            return this.ipTypeValue;
        }
    }

    public static enum PortConfigMode {
        Manual_Semiduplex(1),
        Manual_FullDuplex(2),
        Self_Arrange(3),
        Unknown(-1);

        private long portValue;

        private PortConfigMode(int value) {
            this.portValue = value;
        }

        public static PortConfigMode getPortMode(long value) {
            for (PortConfigMode portMode : PortConfigMode.values()) {
                if (portMode.portValue != value) continue;
                return portMode;
            }
            return Unknown;
        }

        public long getValue() {
            return this.portValue;
        }

        public String toString() {
            String packageName = "ISCSI_PORT_CONFIG_MODE_";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum PortRunningMode {
        Semiduplex(1),
        FullDuplex(2),
        Round_Robin(3),
        Active_Backup(4),
        XOR(5),
        Broadcast(6),
        Dot3ad(7),
        TLB(8),
        ALB(9),
        Unknown(-1);

        private long portValue;

        private PortRunningMode(int value) {
            this.portValue = value;
        }

        public static PortRunningMode getPortMode(long value) {
            for (PortRunningMode portMode : PortRunningMode.values()) {
                if (portMode.portValue != value) continue;
                return portMode;
            }
            return Unknown;
        }

        public long getValue() {
            return this.portValue;
        }

        public String toString() {
            String packageName = "ISCSI_PORT_CONFIG_MODE_Manual_";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum ConsistentGroupType {
        HyperCLoneCG(1),
        HyperMirrorCG(0),
        Unknown(-1);

        private int consistentValue;

        private ConsistentGroupType(int value) {
            this.consistentValue = value;
        }

        public static ConsistentGroupType getType(int value) {
            for (ConsistentGroupType enumValue : ConsistentGroupType.values()) {
                if (enumValue.consistentValue != value) continue;
                return enumValue;
            }
            return Unknown;
        }

        public int getValue() {
            return this.consistentValue;
        }

        public String toString() {
            return ResourceManager.getString(this.name().toUpperCase(Locale.ENGLISH));
        }
    }

    public static class HyperCloneEnums {

        public static enum ResumePolicy {
            AUTO(1),
            MANUAL(2),
            UNKNOW(-1);

            private int resumePolicyValue;

            private ResumePolicy(int value) {
                this.resumePolicyValue = value;
            }

            public static ResumePolicy valueOf(int intValue) throws IsmException {
                ResumePolicy[] values;
                for (ResumePolicy value : values = ResumePolicy.values()) {
                    if (value.resumePolicyValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperCloneEnums.ResumePolicy value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.resumePolicyValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.ResumePolicy.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SpeedLevel {
            LOW(1),
            MEDIUM(2),
            HIGH(3),
            EXTREME(4),
            UNKNOW(-1);

            private int speedLevelValue;

            private SpeedLevel(int value) {
                this.speedLevelValue = value;
            }

            public static SpeedLevel valueOf(int intValue) throws IsmException {
                SpeedLevel[] values;
                for (SpeedLevel value : values = SpeedLevel.values()) {
                    if (value.speedLevelValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperCloneEnums.SpeedLevel value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.speedLevelValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.SpeedLevel.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum DataStatus {
            TARGET_INCONSISTENT(1),
            SOURCE_INCONSISTENT(2),
            SYNC_TARGET_LUN(3),
            SYNC_SOURCE_LUN(4),
            CONSISTENT(5),
            SYNCHRONIZED(6),
            FAULT(7),
            UNKNOW(-1);

            private int dataStatusValue;

            private DataStatus(int value) {
                this.dataStatusValue = value;
            }

            public static DataStatus valueOf(int intValue) throws IsmException {
                DataStatus[] values;
                for (DataStatus value : values = DataStatus.values()) {
                    if (value.dataStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperCloneEnums.DataStatus value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.dataStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.DataStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum PairStatus {
            SPLIT(1),
            SYNC_TARGET_LUN(2),
            SYNC_SOURCE_LUN(3),
            NORMAL(4),
            QUEUE(5),
            INTERRUPTED(6),
            WAIT_RECOVER(7),
            FAULT(8),
            UNKNOW(-1);

            private int pairStatusValue;

            private PairStatus(int value) {
                this.pairStatusValue = value;
            }

            public static PairStatus valueOf(int intValue) throws IsmException {
                PairStatus[] values;
                for (PairStatus value : values = PairStatus.values()) {
                    if (value.pairStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperCloneEnums.PairStatus value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.pairStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperCloneEnums.PairStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }
    }

    public static interface BasicTypeInterface {
        public boolean isLegalType(int var1);
    }

    public static class HyperMirrorEnums {

        public static enum RemoteArrayLinkStatus {
            NORMAL(1),
            INVALID(2),
            UNKNOW(Integer.MIN_VALUE);

            private int remoteValue;

            private RemoteArrayLinkStatus(int value) {
                this.remoteValue = value;
            }

            public static RemoteArrayLinkStatus valueOf(int intValue) throws IsmException {
                RemoteArrayLinkStatus[] values;
                for (RemoteArrayLinkStatus value : values = RemoteArrayLinkStatus.values()) {
                    if (value.remoteValue != intValue) continue;
                    return value;
                }
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("wrong HyperMirrorEnums.RemoteArrayLinkStatus value ! type:" + intValue);
                }
                return UNKNOW;
            }

            public int getValue() {
                return this.remoteValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.RemoteArrayLinkStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum Scope {
            ALL(1),
            CONNECTED(2),
            CONNECTED_WITH_CONFIG(3),
            ALL_CONFIG(4),
            CONNECTED_WITHOUT_CONFIG(5),
            UNKNOW(Integer.MIN_VALUE);

            private int scopeValue;

            private Scope(int value) {
                this.scopeValue = value;
            }

            public static Scope valueOf(int intValue) throws IsmException {
                Scope[] values;
                for (Scope value : values = Scope.values()) {
                    if (value.scopeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.Scope value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.scopeValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.Scope.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SyncType {
            MANUAL(1),
            AUTO_1(2),
            AUTO_2(3),
            UNKNOW(Integer.MIN_VALUE);

            private int syncTypeValue;

            private SyncType(int value) {
                this.syncTypeValue = value;
            }

            public static SyncType valueOf(int intValue) throws IsmException {
                SyncType[] values;
                for (SyncType value : values = SyncType.values()) {
                    if (value.syncTypeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.SyncType value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.syncTypeValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.SyncType.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SpeedLevel {
            LOW(1),
            MEDIUM(2),
            HIGH(3),
            EXTREME(4),
            UNKNOW(Integer.MIN_VALUE);

            private int speedLevelValue;

            private SpeedLevel(int value) {
                this.speedLevelValue = value;
            }

            public static SpeedLevel valueOf(int intValue) throws IsmException {
                SpeedLevel[] values;
                for (SpeedLevel value : values = SpeedLevel.values()) {
                    if (value.speedLevelValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.SpeedLevel value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.speedLevelValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.SpeedLevel.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum ResumePolicy {
            AUTO(1),
            MANUAL(2),
            UNKNOW(Integer.MIN_VALUE);

            private int resumeValue;

            private ResumePolicy(int value) {
                this.resumeValue = value;
            }

            public static ResumePolicy valueOf(int intValue) throws IsmException {
                ResumePolicy[] values;
                for (ResumePolicy value : values = ResumePolicy.values()) {
                    if (value.resumeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.ResumePolicy value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.resumeValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.ResumePolicy.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SplitMirrorCGStatus {
            SPLIT(1),
            SYNCCHRONIZING(2),
            REVERSE_SYNCHRONIZING(3),
            NORMAL(4),
            QUEUE(5),
            INTERRUPTED(6),
            TO_BE_RECOVERED(7),
            FAULT(8),
            UNKNOW(-1);

            private int splitValue;

            private SplitMirrorCGStatus(int value) {
                this.splitValue = value;
            }

            public static SplitMirrorCGStatus valueOf(int intValue) throws IsmException {
                SplitMirrorCGStatus[] values;
                for (SplitMirrorCGStatus value : values = SplitMirrorCGStatus.values()) {
                    if (value.splitValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong SplitMirrorCGStatus value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.splitValue;
            }

            public String toString() {
                String packageName = "CSSType.SplitMirrorCGStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum DataStatus {
            SYNCHRONIZED(1),
            CONSISTENT(2),
            SYNCHRONIZING(3),
            INITIAL_SYNC(4),
            INCONSISTENT(5),
            NOT_SYNC(6),
            UNKNOW(Integer.MIN_VALUE);

            private int dataStatusValue;

            private DataStatus(int value) {
                this.dataStatusValue = value;
            }

            public static DataStatus valueOf(int intValue) throws IsmException {
                DataStatus[] values;
                for (DataStatus value : values = DataStatus.values()) {
                    if (value.dataStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.DataStatus value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.dataStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.DataStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum PairStatus {
            NORMAL(1),
            SYNCHRONIZING(2),
            INTERRUPTED(4),
            WAIT_RECOVER(3),
            SPLITED(5),
            INVALID(6),
            UNKNOW(Integer.MIN_VALUE);

            private int pairStatusValue;

            private PairStatus(int value) {
                this.pairStatusValue = value;
            }

            public static PairStatus valueOf(int intValue) throws IsmException {
                PairStatus[] values;
                for (PairStatus value : values = PairStatus.values()) {
                    if (value.pairStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.PairStatus value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.pairStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.PairStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum LinkStatus {
            CONNECTED(1),
            DISCONNECTED(2),
            UNKNOW(Integer.MIN_VALUE);

            private int linkStatusValue;

            private LinkStatus(int value) {
                this.linkStatusValue = value;
            }

            public static LinkStatus valueOf(int intValue) throws IsmException {
                LinkStatus[] values;
                for (LinkStatus value : values = LinkStatus.values()) {
                    if (value.linkStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.LinkStatus value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.linkStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.LinkStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SyncMode {
            SYNC(1),
            ASYNC(2),
            UNKNOW(Integer.MIN_VALUE);

            private int syncModeValue;

            private SyncMode(int value) {
                this.syncModeValue = value;
            }

            public static SyncMode valueOf(int intValue) {
                SyncMode[] values;
                for (SyncMode value : values = SyncMode.values()) {
                    if (value.syncModeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.SyncMode value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.syncModeValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.SyncMode.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum LinkMode {
            PARAL(1),
            CROSS(2),
            UNKNOW(Integer.MIN_VALUE);

            private int linkModeValue;

            private LinkMode(int value) {
                this.linkModeValue = value;
            }

            public static LinkMode valueOf(int intValue) {
                LinkMode[] values;
                for (LinkMode value : values = LinkMode.values()) {
                    if (value.linkModeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong HyperMirrorEnums.LinkMode value:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.linkModeValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.LinkMode.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum LinkPortType {
            FC(1),
            ISCSI(2),
            UNKNOW(Integer.MIN_VALUE);

            private int linkPortValue;

            private LinkPortType(int value) {
                this.linkPortValue = value;
            }

            public static LinkPortType valueOf(int intValue) throws IsmException {
                LinkPortType[] values = LinkPortType.values();
                LinkPortType lpt = UNKNOW;
                for (LinkPortType value : values) {
                    lpt = LinkPortType.valueOf1(intValue, lpt, value);
                }
                LOGGER.error("wrong HyperMirrorEnums.LinkPortType value:" + intValue);
                return lpt;
            }

            private static LinkPortType valueOf1(int intValue, LinkPortType lpt, LinkPortType value) {
                if (value.linkPortValue == intValue) {
                    return value;
                }
                return lpt;
            }

            public int getValue() {
                return this.linkPortValue;
            }

            public String toString() {
                String packageName = "CSSType.HyperMirrorEnums.LinkPortType.";
                return ResourceManager.getString(packageName + this.name());
            }
        }
    }

    public static enum Choice {
        YES(true),
        NO(false);

        private boolean choiceValue;

        private Choice(boolean value) {
            this.choiceValue = value;
        }

        public static Choice valueOf(boolean boolValue) {
            if (boolValue) {
                return YES;
            }
            return NO;
        }

        public boolean getValue() {
            return this.choiceValue;
        }

        public String toString() {
            String packageName = "CSSType.Choice.";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum HibernateType {
        FORBID_HIBERNATE(0),
        TIMED_HIBERNATE(1),
        SIMPLE_HIBERNATE(2),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int hiberValue;

        private HibernateType(int value) {
            this.hiberValue = value;
        }

        public static HibernateType getHibernateType(int type) {
            HibernateType ht = UNKNOW;
            for (HibernateType hibernateType : HibernateType.values()) {
                ht = HibernateType.getHibernateType1(type, ht, hibernateType);
            }
            LOGGER.error("wrong HibernateType value:" + type);
            return ht;
        }

        private static HibernateType getHibernateType1(int type, HibernateType ht, HibernateType hibernateType) {
            if (hibernateType.hiberValue == type) {
                return hibernateType;
            }
            return ht;
        }

        public int getValue() {
            return this.hiberValue;
        }

        public String getDescription() {
            if (0 == this.hiberValue) {
                return Type.getString("FORBID_HIBERNATE");
            }
            if (1 == this.hiberValue) {
                return Type.getString("TIMED_HIBERNATE");
            }
            if (2 == this.hiberValue) {
                return Type.getString("SIMPLE_HIBERNATE");
            }
            return Type.getString("UNKNOW");
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum LunPoolType {
        A(0),
        B(1),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int lunPoolValue;

        private LunPoolType(int value) {
            this.lunPoolValue = value;
        }

        public static LunPoolType getLunPoolType(int type) {
            LunPoolType lpt = UNKNOW;
            for (LunPoolType lunPoolType : LunPoolType.values()) {
                if (lunPoolType.lunPoolValue != type) continue;
                lpt = lunPoolType;
                return lpt;
            }
            LOGGER.error("wrong LunPoolType value:" + type);
            return lpt;
        }

        public int getValue() {
            return this.lunPoolValue;
        }

        public String getDescription() {
            if (0 == this.lunPoolValue) {
                return "A";
            }
            if (1 == this.lunPoolValue) {
                return "B";
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum HyperLocationType {
        LOCATION_IN_DEVICE(0),
        LOCATION_OTHER_DEVICE(1),
        LOCATION_THIRDPARTY_DEVICE(2),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int hyperValue;

        private HyperLocationType(int value) {
            this.hyperValue = value;
        }

        public static HyperLocationType getHyperLocationType(int type) {
            HyperLocationType hlt = UNKNOW;
            for (HyperLocationType hyperLocationType : HyperLocationType.values()) {
                hlt = HyperLocationType.getHyperLocationType1(type, hlt, hyperLocationType);
            }
            LOGGER.error("wrong HyperLocationType value:" + type);
            return hlt;
        }

        private static HyperLocationType getHyperLocationType1(int type, HyperLocationType hlt, HyperLocationType hyperLocationType) {
            if (hyperLocationType.hyperValue == type) {
                return hyperLocationType;
            }
            return hlt;
        }

        public int getValue() {
            return this.hyperValue;
        }

        public String getDescription() {
            if (0 == this.hyperValue) {
                return Type.getString("LOCATION_IN_DEVICE");
            }
            if (1 == this.hyperValue) {
                return Type.getString("LOCATION_OTHER_DEVICE");
            }
            if (2 == this.hyperValue) {
                return Type.getString("LOCATION_THIRDPARTY_DEVICE");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum HyperCopyIdentityType {
        LUN_WWN(3),
        PWWN_NUMBER(4),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int hyperValue;

        private HyperCopyIdentityType(int value) {
            this.hyperValue = value;
        }

        public static HyperCopyIdentityType getHyperCopyIdentityType(int type) {
            HyperCopyIdentityType hcit = UNKNOW;
            for (HyperCopyIdentityType hyperCopyIdentityType : HyperCopyIdentityType.values()) {
                hcit = HyperCopyIdentityType.getHyperCopyIdentityType1(type, hcit, hyperCopyIdentityType);
            }
            LOGGER.error("wrong HyperCopyIdentityType value:" + type);
            return hcit;
        }

        private static HyperCopyIdentityType getHyperCopyIdentityType1(int type, HyperCopyIdentityType hcit, HyperCopyIdentityType hyperCopyIdentityType) {
            if (hyperCopyIdentityType.hyperValue == type) {
                return hyperCopyIdentityType;
            }
            return hcit;
        }

        public int getValue() {
            return this.hyperValue;
        }

        public String getDescription() {
            if (1 == this.hyperValue) {
                return Type.getString("LUN_WWN");
            }
            if (2 == this.hyperValue) {
                return Type.getString("PWWN_NUMBER");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum HyperCopyRoleType {
        LUN_SOURCE(1),
        LUN_TARGET(2),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int hyperValue;

        private HyperCopyRoleType(int value) {
            this.hyperValue = value;
        }

        public static HyperCopyRoleType getHyperCopyRoleType(int type) {
            HyperCopyRoleType hcrt = UNKNOW;
            for (HyperCopyRoleType hyperCopyRoleType : HyperCopyRoleType.values()) {
                hcrt = HyperCopyRoleType.getHyperCopyRoleType1(type, hcrt, hyperCopyRoleType);
            }
            LOGGER.error("wrong HyperCopyRoleType value:" + type);
            return hcrt;
        }

        private static HyperCopyRoleType getHyperCopyRoleType1(int type, HyperCopyRoleType hcrt, HyperCopyRoleType hyperCopyRoleType) {
            if (hyperCopyRoleType.hyperValue == type) {
                return hyperCopyRoleType;
            }
            return hcrt;
        }

        public int getValue() {
            return this.hyperValue;
        }

        public String getDescription() {
            if (1 == this.hyperValue) {
                return Type.getString("LUN_SOURCE");
            }
            if (2 == this.hyperValue) {
                return Type.getString("LUN_TARGET");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum ReplicaSpeedType implements BasicTypeInterface
    {
        LOW(1),
        MIDDLE(2),
        HIGN(3),
        ASAP(4),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int replicaValue;

        private ReplicaSpeedType(int value) {
            this.replicaValue = value;
        }

        public static ReplicaSpeedType getHyperCopyType(int type) {
            ReplicaSpeedType rst = UNKNOW;
            for (ReplicaSpeedType replicaSpeedType : ReplicaSpeedType.values()) {
                rst = ReplicaSpeedType.getHyperCopyType1(type, rst, replicaSpeedType);
            }
            LOGGER.error("wrong ReplicaSpeedType value:" + type);
            return rst;
        }

        private static ReplicaSpeedType getHyperCopyType1(int type, ReplicaSpeedType rst, ReplicaSpeedType replicaSpeedType) {
            if (replicaSpeedType.replicaValue == type) {
                return replicaSpeedType;
            }
            return rst;
        }

        public int getValue() {
            return this.replicaValue;
        }

        public String getDescription() {
            if (1 == this.replicaValue) {
                return Type.getString("LOW");
            }
            if (2 == this.replicaValue) {
                return Type.getString("MIDDLE");
            }
            if (3 == this.replicaValue) {
                return Type.getString("HIGN");
            }
            if (4 == this.replicaValue) {
                return Type.getString("ASAP");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }

        @Override
        public boolean isLegalType(int value) {
            return value == LOW.getValue() || value == MIDDLE.getValue() || value == HIGN.getValue() || value == ASAP.getValue();
        }
    }

    public static enum HyperCopyUserType {
        WEB_USER(1),
        REMOTE_USER(2),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int userTypeValue;

        private HyperCopyUserType(int value) {
            this.userTypeValue = value;
        }

        public static HyperCopyUserType getHyperCopyType(int type) {
            HyperCopyUserType hcut = UNKNOW;
            for (HyperCopyUserType userType : HyperCopyUserType.values()) {
                hcut = HyperCopyUserType.getHyperCopyType1(type, hcut, userType);
            }
            LOGGER.error("wrong HyperCopyUserType value:" + type);
            return hcut;
        }

        private static HyperCopyUserType getHyperCopyType1(int type, HyperCopyUserType hcut, HyperCopyUserType userType) {
            if (userType.userTypeValue == type) {
                return userType;
            }
            return hcut;
        }

        public int getValue() {
            return this.userTypeValue;
        }

        public String getDescription() {
            if (1 == this.userTypeValue) {
                return Type.getString("WEB_USER");
            }
            if (2 == this.userTypeValue) {
                return Type.getString("REMOTE_USER");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum HyperCopyType implements BasicTypeInterface
    {
        FULL(1),
        INCREACE(2),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int hyperValue;

        private HyperCopyType(int value) {
            this.hyperValue = value;
        }

        public static HyperCopyType getHyperCopyType(int type) {
            HyperCopyType hct = UNKNOW;
            for (HyperCopyType hyperCopyType : HyperCopyType.values()) {
                hct = HyperCopyType.getHyperCopyType1(type, hct, hyperCopyType);
            }
            LOGGER.error("wrong HyperCopyType value:" + type);
            return hct;
        }

        private static HyperCopyType getHyperCopyType1(int type, HyperCopyType hct, HyperCopyType hyperCopyType) {
            if (hyperCopyType.hyperValue == type) {
                return hyperCopyType;
            }
            return hct;
        }

        public int getValue() {
            return this.hyperValue;
        }

        public String getDescription() {
            return Type.getString(this.name());
        }

        public String toString() {
            return this.getDescription();
        }

        @Override
        public boolean isLegalType(int value) {
            return value == FULL.getValue() || value == INCREACE.getValue();
        }
    }

    public static enum SpeedType implements BasicTypeInterface
    {
        UNKNOW,
        ASAP,
        HIGH,
        MIDDLE,
        LOW;

        private static final int TYPE_ASAP = 4;
        private static final int TYPE_HIGH = 3;
        private static final int TYPE_MIDDLE = 2;
        private static final int TYPE_LOW = 1;
        private static final long serialVersionUID = -3424457777959959547L;

        public static SpeedType getSpeedType(int type) {
            SpeedType st = UNKNOW;
            if (4 == type) {
                st = ASAP;
            } else if (3 == type) {
                st = HIGH;
            } else if (2 == type) {
                st = MIDDLE;
            } else if (1 == type) {
                st = LOW;
            } else {
                LOGGER.error("wrong SpeedType value:" + type);
            }
            return st;
        }

        public static int getValue(SpeedType type) {
            if (type.equals(ASAP)) {
                return 4;
            }
            if (type.equals(HIGH)) {
                return 3;
            }
            if (type.equals(MIDDLE)) {
                return 2;
            }
            if (type.equals(LOW)) {
                return 1;
            }
            return Integer.MIN_VALUE;
        }

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            String description = this.allUser();
            return description;
        }

        private String allUser() {
            if (this.equals(ASAP)) {
                return Type.getString("ASAP");
            }
            if (this.equals(HIGH)) {
                return Type.getString("HIGH");
            }
            if (this.equals(MIDDLE)) {
                return Type.getString("MIDDLE");
            }
            if (this.equals(LOW)) {
                return Type.getString("LOW");
            }
            return Type.DEFAULT_STR_VALUE;
        }

        @Override
        public boolean isLegalType(int value) {
            return value == 4 || value == 3 || value == 2 || value == 1;
        }
    }

    public static enum ResumePolicyType {
        AUTO(1),
        MANUAL(2),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int resumeValue;

        private ResumePolicyType(int value) {
            this.resumeValue = value;
        }

        public static ResumePolicyType getResumePolicyType(int type) {
            ResumePolicyType rpt = UNKNOW;
            for (ResumePolicyType resumePolicyType : ResumePolicyType.values()) {
                rpt = ResumePolicyType.getResumePolicyType1(type, rpt, resumePolicyType);
            }
            LOGGER.error("wrong ResumePolicyType value:" + type);
            return rpt;
        }

        private static ResumePolicyType getResumePolicyType1(int type, ResumePolicyType rpt, ResumePolicyType resumePolicyType) {
            if (resumePolicyType.resumeValue == type) {
                return resumePolicyType;
            }
            return rpt;
        }

        public int getValue() {
            return this.resumeValue;
        }

        public String getDescription() {
            return Type.getString(this.name());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum ForeignArrayType {
        ALL(1),
        LINKED(2),
        LINKED_HAVEREMOTEMIRROR(3),
        LINKED_HAVEREMOTEMIRROR_ALL(4),
        LINKED_NOTHAVEREMOTEMIRROR(5),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int foreignTypeValue;

        private ForeignArrayType(int value) {
            this.foreignTypeValue = value;
        }

        public static ForeignArrayType getForeignArrayType(int type) {
            ForeignArrayType fat = UNKNOW;
            for (ForeignArrayType foreignArrayType : ForeignArrayType.values()) {
                fat = ForeignArrayType.getForeignArrayType1(type, fat, foreignArrayType);
            }
            LOGGER.error("wrong ForeignArrayType value:" + type);
            return fat;
        }

        private static ForeignArrayType getForeignArrayType1(int type, ForeignArrayType fat, ForeignArrayType foreignArrayType) {
            if (foreignArrayType.foreignTypeValue == type) {
                return foreignArrayType;
            }
            return fat;
        }

        public int getValue() {
            return this.foreignTypeValue;
        }

        public String getDescription() {
            return Type.getString(this.name());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum MemberLunType {
        UNKNOW,
        MASTER_LUN,
        SLAVE_LUN;

        private static final int TYPE_MASTER = 1;
        private static final int TYPE_SLAVE = 2;
        private static final long serialVersionUID = -3424457777959959547L;

        public static MemberLunType getMemberLunType(int type) {
            MemberLunType mlt = UNKNOW;
            if (1 == type) {
                mlt = MASTER_LUN;
            } else if (2 == type) {
                mlt = SLAVE_LUN;
            } else {
                LOGGER.error("wrong MemberLunType value:" + type);
            }
            return mlt;
        }

        public static int getValue(MemberLunType type) {
            if (type.equals((Object)MASTER_LUN)) {
                return 1;
            }
            if (type.equals((Object)SLAVE_LUN)) {
                return 2;
            }
            LOGGER.error("wrong MemberLunType value:" + (Object)((Object)type));
            return Integer.MIN_VALUE;
        }

        public String getDescription() {
            return Type.getString(this.name());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum LinkType {
        UNKNOW,
        FC,
        ISCSI;

        private static final int TYPE_FC = 1;
        private static final int TYPE_ISCSI = 2;
        private static final long serialVersionUID = -3424457777959959547L;

        public static LinkType getLinkType(int type) {
            LinkType lt = UNKNOW;
            if (1 == type) {
                lt = FC;
            } else if (2 == type) {
                lt = ISCSI;
            } else {
                LOGGER.error("wrong LinkType value:" + type);
            }
            return lt;
        }

        public static int getValue(LinkType type) {
            if (type.equals((Object)FC)) {
                return 1;
            }
            if (type.equals((Object)ISCSI)) {
                return 2;
            }
            LOGGER.error("wrong Link Type value:" + (Object)((Object)type));
            return Integer.MIN_VALUE;
        }

        public String getDescription() {
            return Type.getString(this.name());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum SerialPortType {
        UNKNOW(-1),
        ManagerSerialPort(0),
        UPSManagerSerialPort(1),
        SYSTEM_DEBUG_PORT(2),
        BMC_DEBUG_PORT(3),
        UPS_PORT(4);

        private int typeValue;

        private SerialPortType(int value) {
            this.typeValue = value;
        }

        public static SerialPortType getSerialPortType(int value) {
            for (SerialPortType type : SerialPortType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            LOGGER.error("SerialPortType.getSerialPortType: Can not find the SerialPortType: value :" + value);
            return UNKNOW;
        }

        public int getValue() {
            return this.typeValue;
        }

        public String toString() {
            String packageName = "Type.SerialPortType.";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum ClearExportDataType {
        Clear_Alarm_Data(0),
        Clear_Log_Data(1),
        Clear_Running_Data(2),
        Clear_Config_Data(3),
        Clear_Perf_Data(4);

        private int clearTypeValue;

        private ClearExportDataType(int value) {
            this.clearTypeValue = value;
        }

        public int getValue() {
            return this.clearTypeValue;
        }
    }

    public static enum LicenseFuncFeatureType {
        UNKNOW(-1),
        LMP(0),
        SupportDiskNumber(1),
        SnapShot(2),
        HyperClone(3),
        HyperImg(4),
        LunMigrate(5),
        SyncHyperMirror(6),
        AsyncHyperMirror(7),
        ExtendCopy(8),
        SmartTier(20),
        SmartMotion(21),
        SmartQoS(22),
        SmartDeduplication(23),
        HyperReplication(24),
        SmartThin(25),
        XVESystem(27),
        ManagementConsole(28),
        SmartVirtualization(29),
        HyperSoftwareSuite(30),
        SmartCache_SmartTier(31),
        SmartQuota(32),
        LoadBalance(33),
        HVS_BASIC_NLSAS(35),
        HVS_BASIC_SSD_SAS(36),
        HVS_ADVANCED_NLSAS(37),
        HVS_ADVANCED_SSD_SAS(38),
        SmartCompression(39),
        SmartPartition(40),
        DataDestruction(41),
        SystemReporter(42),
        THINPV("THINPV"),
        ASYNRE("ASYNRE"),
        SNAPSH("SNAPSH"),
        SYNREP("SYNREP"),
        CYCREP("CYCREP"),
        MAXNOD("MAXNOD"),
        FUNCHETST05("HETST05"),
        FUNCSNSH05("SNSH05"),
        FUNCMIRR05("MIRR05"),
        FUNCLUNCP05("LUNCP05");

        private int licenseFeatureTypeValue;
        private String featureValue;

        private LicenseFuncFeatureType(int featureName) {
            this.featureValue = String.valueOf(featureName);
            this.licenseFeatureTypeValue = featureName;
        }

        private LicenseFuncFeatureType(String featureName) {
            this.featureValue = featureName;
        }

        public static LicenseFuncFeatureType getFuncFeatureType(String featureValue) {
            for (LicenseFuncFeatureType type : LicenseFuncFeatureType.values()) {
                if (!type.getFeatureValue().equals(featureValue)) continue;
                return type;
            }
            LOGGER.error("LicenseFuncFeatureType.getFuncFeatureType: Can not find the LicenseFuncFeatureType: value :" + featureValue);
            return UNKNOW;
        }

        public static LicenseFuncFeatureType getFuncFeatureType(int value) {
            for (LicenseFuncFeatureType type : LicenseFuncFeatureType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            LOGGER.error("LicenseFuncFeatureType.getFuncFeatureType: Can not find the LicenseFuncFeatureType: value :" + value);
            return UNKNOW;
        }

        public String getFeatureValue() {
            return this.featureValue;
        }

        public int getValue() {
            return this.licenseFeatureTypeValue;
        }

        public String toString() {
            String packageName = "Type.LicenseFuncFeatureType.";
            return ResourceManager.getString(packageName + this.name());
        }

        public String toString(String ty) {
            if (null == ty || "".equals(ty)) {
                return this.toString();
            }
            String packageName = "Type.LicenseFuncFeatureType." + ty + ".";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum BindModeType {
        UNKNOW(-1),
        NORMAL(0),
        BIND_MODE_1(1),
        BIND_MODE_2(2),
        PART_BIND(3);

        private int bindModeTypeValue;

        private BindModeType(int value) {
            this.bindModeTypeValue = value;
        }

        public static BindModeType getBindModeType(int value) {
            for (BindModeType mode : BindModeType.values()) {
                if (mode.bindModeTypeValue != value) continue;
                return mode;
            }
            LOGGER.error("can not find the BindModeType: value :" + value);
            return UNKNOW;
        }

        public String toString() {
            String packageName = "Type.BindModeType.";
            return ResourceManager.getString(packageName + this.name());
        }

        public int getValue() {
            return this.bindModeTypeValue;
        }
    }

    public static class DynamicEnums {

        public static enum SpeedLevel {
            LOW(1),
            MEDIUM(2),
            HIGH(3),
            UNKNOW(-1);

            private int speedLevelValue;

            private SpeedLevel(int value) {
                this.speedLevelValue = value;
            }

            public static SpeedLevel valueOf(int intValue) throws IsmException {
                SpeedLevel[] values;
                for (SpeedLevel value : values = SpeedLevel.values()) {
                    if (value.speedLevelValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong DynamicEnums.SpeedLevel value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.speedLevelValue;
            }

            public String toString() {
                String packageName = "CSSType.DynamicEnums.SpeedLevel.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum OperateType {
            EXPAND(1),
            STRIPEDEPTH(2),
            FRAGMENTTIDY(3),
            LEVELCHANGE(4),
            UNKNOW(-1);

            private int operateTypeValue;

            private OperateType(int value) {
                this.operateTypeValue = value;
            }

            public static OperateType valueOf(int intValue) throws IsmException {
                OperateType[] values;
                for (OperateType value : values = OperateType.values()) {
                    if (value.operateTypeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong DynamicEnums.OperateType value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.operateTypeValue;
            }

            public String toString() {
                String packageName = "CSSType.DynamicEnums.OperateType.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum ExpandMode {
            EXPANDSUBGROUP(1),
            EXPANDINSIDEGROUP(2),
            UNKNOW(-1);

            private int expandModeValue;

            private ExpandMode(int value) {
                this.expandModeValue = value;
            }

            public static ExpandMode valueOf(int intValue) throws IsmException {
                ExpandMode[] values;
                for (ExpandMode expandMode : values = ExpandMode.values()) {
                    if (expandMode.expandModeValue != intValue) continue;
                    return expandMode;
                }
                LOGGER.error("wrong DynamicEnums.ExpandMode value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.expandModeValue;
            }

            public String toString() {
                String packageName = "CSSType.DynamicEnums.ExpandMode.";
                return ResourceManager.getString(packageName + this.name());
            }
        }
    }

    public static class VerifyEnums {

        public static enum CircleLife {
            DAY(1),
            WEEK(2),
            MONTH(3);

            private int circleLifeValue;

            private CircleLife(int value) {
                this.circleLifeValue = value;
            }

            public static CircleLife valueOf(int intValue) throws IsmException {
                CircleLife[] values;
                for (CircleLife value : values = CircleLife.values()) {
                    if (value.circleLifeValue != intValue) continue;
                    return value;
                }
                throw new IsmException(-1L, "wrong VerifyEnums.CircleLife value ! type:" + intValue);
            }

            public int getValue() {
                return this.circleLifeValue;
            }

            public String toString() {
                String packageName = "CSSType.VerifyEnums.CircleLife.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum Result {
            UNKNOW(-1),
            CONSISTENT(1),
            DISACCORD(2);

            private int resultValue;

            private Result(int value) {
                this.resultValue = value;
            }

            public static Result valueOf(int intValue) throws IsmException {
                Result[] values;
                for (Result value : values = Result.values()) {
                    if (value.resultValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong VerifyEnums.Result value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.resultValue;
            }

            public String toString() {
                String packageName = "CSSType.VerifyEnums.Result.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum LunStatus {
            UNKNOW(-1),
            RUN(1),
            STOP(2),
            WAIT(3),
            COMPLETE(4),
            CANCEL(5);

            private int lunStatusValue;

            private LunStatus(int value) {
                this.lunStatusValue = value;
            }

            public static LunStatus valueOf(int intValue) throws IsmException {
                LunStatus[] values;
                for (LunStatus value : values = LunStatus.values()) {
                    if (value.lunStatusValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong VerifyEnums.LunStatus value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.lunStatusValue;
            }

            public String toString() {
                String packageName = "CSSType.VerifyEnums.LunStatus.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum SpeedLevel {
            UNKNOW(-1),
            LOW(1),
            MEDIUM(2),
            HIGH(3);

            private int speedLevelValue;

            private SpeedLevel(int value) {
                this.speedLevelValue = value;
            }

            public static SpeedLevel valueOf(int intValue) throws IsmException {
                SpeedLevel[] values;
                for (SpeedLevel value : values = SpeedLevel.values()) {
                    if (value.speedLevelValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong VerifyEnums.SpeedLevel value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.speedLevelValue;
            }

            public String toString() {
                String packageName = "CSSType.VerifyEnums.SpeedLevel.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum RecoveryMode {
            UNKNOW(-1),
            AUTO(1),
            MANUAL(2);

            private int recoveryModeValue;

            private RecoveryMode(int value) {
                this.recoveryModeValue = value;
            }

            public static RecoveryMode valueOf(int intValue) throws IsmException {
                RecoveryMode[] values;
                for (RecoveryMode value : values = RecoveryMode.values()) {
                    if (value.recoveryModeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong VerifyEnums.RecoveryMode value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.recoveryModeValue;
            }

            public String toString() {
                String packageName = "CSSType.VerifyEnums.RecoveryMode.";
                return ResourceManager.getString(packageName + this.name());
            }
        }

        public static enum ExcuteMode {
            UNKNOW(-1),
            AUTO(1),
            MANUAL(2);

            private int excuteModeValue;

            private ExcuteMode(int value) {
                this.excuteModeValue = value;
            }

            public static ExcuteMode valueOf(int intValue) throws IsmException {
                ExcuteMode[] values;
                for (ExcuteMode value : values = ExcuteMode.values()) {
                    if (value.excuteModeValue != intValue) continue;
                    return value;
                }
                LOGGER.error("wrong VerifyEnums.ExcuteMode value ! type:" + intValue);
                return UNKNOW;
            }

            public int getValue() {
                return this.excuteModeValue;
            }

            public String toString() {
                String packageName = "CSSType.VerifyEnums.ExcuteMode.";
                return ResourceManager.getString(packageName + this.name());
            }
        }
    }

    public static enum BackgroudScanState {
        RUNNING_STATE(1),
        STOP_STATE(2),
        ILLEGAL(-1);

        private int backgroudScanStateValue;

        private BackgroudScanState(int value) {
            this.backgroudScanStateValue = value;
        }

        public static BackgroudScanState getBackgroundScanState(int value) {
            for (BackgroudScanState state : BackgroudScanState.values()) {
                if (state.backgroudScanStateValue != value) continue;
                return state;
            }
            LOGGER.warn("use ILLEGAL because can't find ChargeState which value = " + value);
            return ILLEGAL;
        }

        public String getDescription() {
            return ResourceManager.getString("BackgroudScanState." + this.name());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum ApplyContext {
        VIDEO_MONITOR(1),
        MS_SQL(2),
        MS_FILE_SYSTEM(3),
        BACKUP_RECOVERY(4);

        private int applyContextValue;

        private ApplyContext(int value) {
            this.applyContextValue = value;
        }

        public ApplyContext getApplyContext(int i) {
            for (ApplyContext context : ApplyContext.values()) {
                if (context.applyContextValue != i) continue;
                return context;
            }
            throw new IllegalArgumentException("wrong Apply Context value:" + i);
        }

        public int getValue() {
            return this.applyContextValue;
        }

        public String getDescription() {
            return ResourceManager.getString("ApplyContext." + this.name());
        }
    }

    public static enum WaitTimeType {
        NEVER_HIBERNATE(0L, "NeverHibernate"),
        AFTER_10_MINUTES(600L, "After10Minutes"),
        AFTER_30_MINUTES(1800L, "After30Minutes"),
        AFTER_1_HOUR(3600L, "After1Hour"),
        AFTER_3_HOURS(10800L, "After3Hours"),
        AFTER_5_HOURS(18000L, "After5Hours"),
        AFTER_12_HOURS(43200L, "After12Hours"),
        AFTER_1_DAY(86400L, "After1Day"),
        AFTER_2_DAYS(172800L, "After2Days");

        private static Map<Long, WaitTimeType> waitTimeMap;
        private final String description;
        private final long seconds;

        private WaitTimeType(long second, String description) {
            this.seconds = second;
            this.description = description;
        }

        public long getWaitTime() {
            return this.seconds;
        }

        public String getDescription() {
            return this.description;
        }

        public static long getWaitTime(WaitTimeType waitTimeType) {
            return waitTimeType.seconds;
        }

        public static WaitTimeType getMuteTypeFromMuteTime(long seconds) {
            WaitTimeType waitTimeType = waitTimeMap.get(seconds);
            if (waitTimeType == null) {
                LOGGER.error("an error occurred when invoke WaitTimeType.getMuteTypeFromMuteTime(long seconds) method, the reason is the illegal input argument");
                throw new IllegalArgumentException("illegal input argument hibernate waiting time " + seconds);
            }
            return waitTimeType;
        }

        public static String getDescription(WaitTimeType waitTimeType) {
            return ResourceManager.getString(waitTimeType.description);
        }

        static {
            waitTimeMap = new HashMap<Long, WaitTimeType>(9);
            waitTimeMap.put(WaitTimeType.NEVER_HIBERNATE.seconds, NEVER_HIBERNATE);
            waitTimeMap.put(WaitTimeType.AFTER_10_MINUTES.seconds, AFTER_10_MINUTES);
            waitTimeMap.put(WaitTimeType.AFTER_30_MINUTES.seconds, AFTER_30_MINUTES);
            waitTimeMap.put(WaitTimeType.AFTER_1_HOUR.seconds, AFTER_1_HOUR);
            waitTimeMap.put(WaitTimeType.AFTER_3_HOURS.seconds, AFTER_3_HOURS);
            waitTimeMap.put(WaitTimeType.AFTER_5_HOURS.seconds, AFTER_5_HOURS);
            waitTimeMap.put(WaitTimeType.AFTER_12_HOURS.seconds, AFTER_12_HOURS);
            waitTimeMap.put(WaitTimeType.AFTER_1_DAY.seconds, AFTER_1_DAY);
            waitTimeMap.put(WaitTimeType.AFTER_2_DAYS.seconds, AFTER_2_DAYS);
        }
    }

    public static enum ComponentType {
        RAID_GROUP(1),
        DRIVE(2);

        private static Map<Integer, ComponentType> componentTypeMap;
        private int componentTypeValue;

        private ComponentType(int typeValue) {
            this.componentTypeValue = typeValue;
        }

        public static ComponentType getComponentType(int typeValue) {
            ComponentType componentType = componentTypeMap.get(typeValue);
            if (componentType == null) {
                LOGGER.error("an error occurred when invoke ComponentType.getComponentType(int typeValue) method, the reason is the illegal input argument");
                throw new IllegalArgumentException("illegal component type value " + typeValue);
            }
            return componentType;
        }

        public static int getComponentTypeValue(ComponentType componentType) {
            return componentType.componentTypeValue;
        }

        static {
            componentTypeMap = new HashMap<Integer, ComponentType>(2);
            componentTypeMap.put(ComponentType.RAID_GROUP.componentTypeValue, RAID_GROUP);
            componentTypeMap.put(ComponentType.DRIVE.componentTypeValue, DRIVE);
        }
    }

    public static enum IsmVersion {
        Current_version,
        Latest_version,
        Download_version;


        public String getDescription() {
            return Type.getString(this.name());
        }
    }

    public static enum SerialPortName {
        UPS_PORT,
        MNG_PORT;


        public String getDescription() {
            return Type.getString(this.name());
        }

        public static String getDescription(String id) {
            if (id.equals("00")) {
                return UPS_PORT.getDescription();
            }
            if (id.equals("01")) {
                return MNG_PORT.getDescription();
            }
            return Type.DEFAULT_STR_VALUE;
        }
    }

    public static enum ImportExportConnectFail {
        ImportConnectFail,
        ExportConnectFail;


        public String getDescription() {
            return Type.getString(this.name());
        }
    }

    public static enum ProtocolType {
        IB,
        FC,
        ISCSI,
        SAS,
        FCoE;

        private static final long serialVersionUID = 8013781040702510103L;

        public String getDescription() {
            return Type.getString("ProtocolType_" + this.name());
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum ControllerType {
        INVALIDATE,
        CONTROLLER_A,
        CONTROLLER_B;

        private static final int TYPE_A = 0;
        private static final int TYPE_B = 1;
        private static final long serialVersionUID = -3424457777959959547L;

        public static ControllerType getController(long controllerID) {
            int type = (int)(controllerID % 2L);
            switch (type) {
                case 0: {
                    return CONTROLLER_A;
                }
                case 1: {
                    return CONTROLLER_B;
                }
            }
            LOGGER.error("default controller type value and use default type is B");
            return CONTROLLER_B;
        }

        public static int getValue(ControllerType type) {
            if (type.equals((Object)CONTROLLER_A)) {
                return 0;
            }
            if (type.equals((Object)CONTROLLER_B)) {
                return 1;
            }
            throw new IllegalArgumentException("wrong Controller Type value:" + (Object)((Object)type));
        }

        public String toString() {
            if (this.equals((Object)CONTROLLER_A)) {
                return Type.getString("ControllerA");
            }
            if (this.equals((Object)CONTROLLER_B)) {
                return Type.getString("ControllerB");
            }
            throw new IllegalArgumentException("wrong Controller value:" + this.name());
        }
    }

    public static enum WritePolicyType {
        INVALIDATE,
        WRITE_BACK,
        WRITE_THROUTH,
        WRITE_BACK_MANDATORY;

        private static final int TYPE_WRITE_BACK = 1;
        private static final int TYPE_WRITE_THROUTH = 2;
        private static final int TYPE_WRITE_BACK_MANDATORY = 3;
        private static final int TYPE_INVALIDATE = -1;
        private static final long serialVersionUID = 8013781040702159303L;

        public static WritePolicyType getWritePolicy(int type) {
            switch (type) {
                case 1: {
                    return WRITE_BACK;
                }
                case 2: {
                    return WRITE_THROUTH;
                }
                case 3: {
                    return WRITE_BACK_MANDATORY;
                }
            }
            return INVALIDATE;
        }

        public static int getValue(WritePolicyType type) {
            if (type.equals((Object)WRITE_THROUTH)) {
                return 2;
            }
            if (type.equals((Object)WRITE_BACK)) {
                return 1;
            }
            if (type.equals((Object)WRITE_BACK_MANDATORY)) {
                return 3;
            }
            if (type.equals((Object)INVALIDATE)) {
                return -1;
            }
            throw new IllegalArgumentException("wrong WritePolicyType Type value:" + (Object)((Object)type));
        }

        public static String getDiscription(WritePolicyType type) {
            if (type.equals((Object)WRITE_THROUTH)) {
                return Type.getString("write_through");
            }
            if (type.equals((Object)WRITE_BACK)) {
                return Type.getString("write_back");
            }
            if (type.equals((Object)WRITE_BACK_MANDATORY)) {
                return Type.getString("write_back_mandatory");
            }
            if (type.equals((Object)INVALIDATE)) {
                return Type.DEFAULT_STR_VALUE;
            }
            throw new IllegalArgumentException("wrong WritePolicyType Type value:" + (Object)((Object)type));
        }

        public String toString() {
            return WritePolicyType.getDiscription(this);
        }
    }

    public static enum LUNType {
        FAT(1, false),
        THINLUN(2, true),
        THICKLUN(3, true);

        private int lunTypeValue;
        private boolean isThinLun = false;

        private LUNType(int value, boolean isThinLun) {
            this.lunTypeValue = value;
            this.isThinLun = isThinLun;
        }

        public int getValue() {
            return this.lunTypeValue;
        }

        public boolean isThinLun() {
            return this.isThinLun;
        }

        public String toString() {
            String str = "";
            switch (this) {
                case FAT: {
                    str = Type.getString("Type.LUNType.FAT");
                    break;
                }
                case THINLUN: {
                    str = Type.getString("Type.LUNType.THIN");
                    break;
                }
                case THICKLUN: {
                    str = Type.getString("Type.LUNType.THICK");
                    break;
                }
            }
            return str;
        }

        public static List<LUNType> getAllThinLun() {
            LUNType[] types;
            ArrayList<LUNType> thinLuns = new ArrayList<LUNType>(0);
            for (LUNType type : types = LUNType.values()) {
                if (!type.isThinLun()) continue;
                thinLuns.add(type);
            }
            return thinLuns;
        }

        public static boolean isThinLUNByValue(int id) {
            List<LUNType> allThinLun = LUNType.getAllThinLun();
            for (LUNType type : allThinLun) {
                if (type.getValue() != id) continue;
                return true;
            }
            return false;
        }

        public static LUNType getLUNTypeByValue(int id) {
            LUNType[] types;
            for (LUNType type : types = LUNType.values()) {
                if (type.getValue() != id) continue;
                return type;
            }
            return null;
        }
    }

    public static enum RaidType {
        RAID_0(3),
        RAID_10(1),
        RAID_5(2),
        RAID_3(7),
        RAID_1(4),
        RAID_50(6),
        RAID_6(5),
        UNKNOWN(-1);

        private static final long serialVersionUID = 8013781040702510103L;
        private int raidTypeValue;

        private RaidType(int value) {
            this.raidTypeValue = value;
        }

        public static RaidType getRaidGroupType(int type) {
            for (RaidType raidType : RaidType.values()) {
                if (raidType.raidTypeValue != type) continue;
                return raidType;
            }
            LOGGER.error("wrong Raid Type value:" + type);
            return UNKNOWN;
        }

        public int getValue() {
            return this.raidTypeValue;
        }

        public static String getDescription(RaidType type) {
            if (type.equals((Object)RAID_0)) {
                return Type.getString("raid_0");
            }
            if (type.equals((Object)RAID_1)) {
                return Type.getString("raid_1");
            }
            if (type.equals((Object)RAID_10)) {
                return Type.getString("raid_10");
            }
            if (type.equals((Object)RAID_5)) {
                return Type.getString("raid_5");
            }
            if (type.equals((Object)RAID_50)) {
                return Type.getString("raid_50");
            }
            if (type.equals((Object)RAID_6)) {
                return Type.getString("raid_6");
            }
            if (type.equals((Object)RAID_3)) {
                return Type.getString("raid_3");
            }
            if (type.equals((Object)UNKNOWN)) {
                return Type.getString(Type.DEFAULT_STR_VALUE);
            }
            throw new IllegalArgumentException("wrong Raid Type value:" + (Object)((Object)type));
        }
    }

    public static enum PrefetchPolicyType {
        NO_PREFETCH(0),
        FIXUP_PREFETCH(1),
        UNCERTAIN_PREFETCH(2),
        APTITUDE_PREFETCH(3);

        private static final long serialVersionUID = 8013102340702587303L;
        private int prefetchPolicyTypeValue;

        private PrefetchPolicyType(int value) {
            this.prefetchPolicyTypeValue = value;
        }

        public static PrefetchPolicyType getPrefetchType(int type) {
            for (PrefetchPolicyType prefetchPolicyType : PrefetchPolicyType.values()) {
                if (prefetchPolicyType.prefetchPolicyTypeValue != type) continue;
                return prefetchPolicyType;
            }
            throw new IllegalArgumentException("wrong PrefetchPolicy Type value:" + type);
        }

        public int getValue() {
            return this.prefetchPolicyTypeValue;
        }

        public static String getDescription(PrefetchPolicyType policy) {
            if (policy.equals((Object)APTITUDE_PREFETCH)) {
                return Type.getString("aptitude_prefetch");
            }
            if (policy.equals((Object)FIXUP_PREFETCH)) {
                return Type.getString("fixup_prefetch");
            }
            if (policy.equals((Object)NO_PREFETCH)) {
                return Type.getString("no_prefetch");
            }
            if (policy.equals((Object)UNCERTAIN_PREFETCH)) {
                return Type.getString("unchertain_prefetch");
            }
            throw new IllegalArgumentException("wrong PrefetchPolicyType  value:" + (Object)((Object)policy));
        }

        public String toString() {
            return PrefetchPolicyType.getDescription(this);
        }
    }

    public static enum FanRunLevel {
        LOWEST(0),
        LOW(1),
        MEDIUM(2),
        HIGH(3),
        UNKNOW(-1);

        private static final long serialVersionUID = -3424454101029959547L;
        private int fanRunLevelValue;

        private FanRunLevel(int value) {
            this.fanRunLevelValue = value;
        }

        public int getValue() {
            return this.fanRunLevelValue;
        }

        public static FanRunLevel getFanRunLevel(int type) {
            for (FanRunLevel fanRunLevel : FanRunLevel.values()) {
                if (fanRunLevel.getValue() != type) continue;
                return fanRunLevel;
            }
            LOGGER.warn("return UNKNOW because can't find FanRunLevel which value = " + type);
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString("FanRunLevel_" + this.name());
            return des;
        }
    }

    public static enum PowerType {
        DCNM(0),
        ACNM(1),
        ACM(2),
        DCM(3),
        UNKNOW(-1);

        private static final long serialVersionUID = 8013781040412587303L;
        private int powerTypeValue;

        private PowerType(int value) {
            this.powerTypeValue = value;
        }

        public static PowerType getPowerType(int type) {
            for (PowerType powerType : PowerType.values()) {
                if (powerType.powerTypeValue != type) continue;
                return powerType;
            }
            LOGGER.warn("return UNKNOW because can't find PowerType which value = " + type);
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString("PowerType_" + this.name());
            return des;
        }
    }

    public static class PortType
    implements Serializable {
        public static final int PORTTYPE_EXPANDERPORT_VALUE = 2;
        public static final int PORTTYPE_MANAGEMENTPORT_VALUE = 3;
        public static final int PORTTYPE_SERIALPORT_VALUE = 4;
        public static final int PORTTYPE_IBCPORT_VALUE = 5;
        public static final int PORTTYPE_UPS_SERIAL_VALUE = 6;
        private static final long serialVersionUID = 7770470958947831750L;
    }

    public static class PortCardType
    implements Serializable {
        public static final PortCardType PORTCARD_FC_4X4G = new PortCardType("PORTCARD_FC_4X4G", 1);
        public static final PortCardType PORTCARD_FC_2X4G = new PortCardType("PORTCARD_FC_2X4G", 2);
        public static final PortCardType PORTCARD_GE_RJ45_2X = new PortCardType("PORTCARD_GE_RJ45_2X", 3);
        public static final PortCardType PORTCARD_SASI_4X = new PortCardType("PORTCARD_SASI_4X", 4);
        public static final PortCardType PORTCARD_FC_4X4G_EXPAND = new PortCardType("PORTCARD_FC_4X4G_EXPAND", 5);
        public static final PortCardType PORTCARD_ISCSI_2X10GE = new PortCardType("PORTCARD_ISCSI_2X10GE", 6);
        public static final PortCardType PORTCARD_FC_1X8G = new PortCardType("PORTCARD_FC_1X8G", 7);
        public static final PortCardType PORTCARD_FC_2X8G = new PortCardType("PORTCARD_FC_2X8G", 8);
        public static final PortCardType PORTCARD_SASII_2X = new PortCardType("PORTCARD_SASII_2X", 9);
        public static final PortCardType PORTCARD_SASII_4X = new PortCardType("PORTCARD_SASII_4X", 10);
        public static final PortCardType PORTCARD_COMBO_2FCX2GE = new PortCardType("PORTCARD_Combo_2FCx2GE", 11);
        public static final PortCardType PORTCARD_ISCSI_4X = new PortCardType("PORTCARD_iSCSI_4X", 12);
        public static final PortCardType PORTCARD_FC_4X8G = new PortCardType("PORTCARD_FC_4X8G", 13);
        public static final PortCardType PORTCARD_COMBO_2X8GFCX2GE = new PortCardType("PORTCARD_Combo_2X8GFCx2GE", 14);
        public static final PortCardType PORTCARD_MINISAS_4X = new PortCardType("PORTCARD_MINISAS_4X", 16);
        public static final PortCardType PORTCARD_ISCSI_4XGE = new PortCardType("PORTCARD_ISCSI_4XGE", 20);
        public static final PortCardType PORTCARD_FCOE_4X = new PortCardType("PORTCARD_FCoE_4X", 21);
        public static final PortCardType PORTCARD_SASA_2X6G = new PortCardType("PORTCARD_SASA_2X6G", 22);
        public static final PortCardType PORTCARD_SASB_2X6G = new PortCardType("PORTCARD_SASB_2X6G", 23);
        public static final PortCardType PORTCARD_TOE_4X = new PortCardType("PORTCARD_TOE_4X", 24);
        public static final PortCardType PORTCARD_SWITCH_8XGE = new PortCardType("PORTCARD_SWITCH_8XGE", 25);
        public static final PortCardType PORTCARD_IB_2X = new PortCardType("PORTCARD_IB_2X", 15);
        private static final long serialVersionUID = 8013781040702587303L;
        private static Collection<PortCardType> cache = Collections.synchronizedList(new ArrayList());
        private int portCardTypeValue;
        private String portCardTypeName;
        private String description;

        public PortCardType(String name, int value) {
            this.portCardTypeName = name;
            this.portCardTypeValue = value;
        }

        public PortCardType(String name, int value, String des) {
            this(name, value);
            this.description = des;
        }

        public static PortCardType getPortCardType(int type) {
            for (PortCardType portCardType : cache) {
                if (portCardType.getValue() != type) continue;
                return portCardType;
            }
            throw new IllegalArgumentException("wrong PortCardType Type value:" + type);
        }

        public void addNewPortCardType(PortCardType type) {
            cache.add(type);
        }

        public int getValue() {
            return this.portCardTypeValue;
        }

        public String getName() {
            return this.portCardTypeName;
        }

        public boolean isFcTypePortcard() {
            switch (this.getValue()) {
                case 1: 
                case 2: 
                case 5: 
                case 7: 
                case 8: 
                case 11: 
                case 13: 
                case 14: 
                case 21: {
                    return true;
                }
            }
            return false;
        }

        public boolean isSasTypePortcard() {
            switch (this.getValue()) {
                case 4: 
                case 9: 
                case 10: 
                case 22: 
                case 23: {
                    return true;
                }
            }
            return false;
        }

        public boolean isIscsiTypePortcard() {
            boolean flag1 = this == PORTCARD_GE_RJ45_2X || this == PORTCARD_ISCSI_4X || this == PORTCARD_COMBO_2FCX2GE;
            boolean flag2 = this == PORTCARD_COMBO_2X8GFCX2GE || this == PORTCARD_ISCSI_2X10GE || this == PORTCARD_ISCSI_4XGE;
            return flag1 || flag2;
        }

        public String getDescription() {
            if (this.description == null) {
                this.description = Type.getString(this.getName());
            }
            return this.description;
        }

        static {
            cache.add(PORTCARD_FC_4X4G);
            cache.add(PORTCARD_FC_2X4G);
            cache.add(PORTCARD_GE_RJ45_2X);
            cache.add(PORTCARD_SASI_4X);
            cache.add(PORTCARD_FC_4X4G_EXPAND);
            cache.add(PORTCARD_ISCSI_2X10GE);
            cache.add(PORTCARD_FC_1X8G);
            cache.add(PORTCARD_FC_2X8G);
            cache.add(PORTCARD_SASII_2X);
            cache.add(PORTCARD_SASII_4X);
            cache.add(PORTCARD_COMBO_2FCX2GE);
            cache.add(PORTCARD_COMBO_2X8GFCX2GE);
            cache.add(PORTCARD_ISCSI_4X);
            cache.add(PORTCARD_MINISAS_4X);
            cache.add(PORTCARD_FC_4X8G);
            cache.add(PORTCARD_ISCSI_4XGE);
            cache.add(PORTCARD_FCOE_4X);
            cache.add(PORTCARD_SASA_2X6G);
            cache.add(PORTCARD_SASB_2X6G);
            cache.add(PORTCARD_TOE_4X);
            cache.add(PORTCARD_IB_2X);
            cache.add(PORTCARD_SWITCH_8XGE);
        }
    }

    public static enum ChassisModel {
        BMC_4U(0),
        SAS_2U_12_CONTROLLER(1),
        SAS_2U_24_CONTROLLER(2),
        SAS_2U_25_CONTROLLER(3),
        SAS_2U_12_EXPANDER(16),
        SAS_2U_24_EXPANDER(17),
        SAS_4U_24_EXPANDER(18),
        FC_4U_24_EXPANDER(19),
        SAS_2U_25_EXPANDER(20),
        INVALID(-1);

        private static final long serialVersionUID = -3412352826959959547L;
        private int chassisModelValue;

        private ChassisModel(int value) {
            this.chassisModelValue = value;
        }

        public static ChassisModel getChassisModel(int value) {
            for (ChassisModel chassisModel : ChassisModel.values()) {
                if (chassisModel.chassisModelValue != value) continue;
                return chassisModel;
            }
            throw new IllegalArgumentException("wrong ChassisModel type argument:" + value);
        }

        public String getDescription() {
            String des = Type.getString("ChassisModel_" + this.name());
            return des;
        }

        public int getValue() {
            return this.chassisModelValue;
        }
    }

    public static enum PhysicalChassisType {
        MIX(3),
        SAS(0),
        FC(1),
        ISCSI(2),
        SAT(4),
        INVALID(-1);

        private static final long serialVersionUID = -3412352826959959547L;
        private int physicalChassisTypeValue;

        private PhysicalChassisType(int value) {
            this.physicalChassisTypeValue = value;
        }

        public static PhysicalChassisType getPhysicalChassisType(int value) {
            for (PhysicalChassisType physicalChassisType : PhysicalChassisType.values()) {
                if (physicalChassisType.physicalChassisTypeValue != value) continue;
                return physicalChassisType;
            }
            return INVALID;
        }

        public String getDescription() {
            String des = Type.getString("ChassisType_" + this.name());
            return des;
        }
    }

    public static enum OperationSystemType {
        LINUX,
        WINDOWS2003,
        SOLARIS,
        HP_UX,
        AIX,
        XenServer,
        MAC_OS,
        Vmware_ESX,
        Unknown;

        private static final int TYPE_LINUX = 0;
        private static final int TYPE_WINDOWS2003 = 1;
        private static final int TYPE_SOLARIS = 2;
        private static final int TYPE_HP_UX = 3;
        private static final int TYPE_AIX = 4;
        private static final int TYPE_XEN_SERVER = 5;
        private static final int TYPE_MAC_OS = 6;
        private static final int TYPE_VMWARE_ESX = 7;
        private static final int UNKNOWN = -1;
        private static final long serialVersionUID = -3424454826959910320L;

        public static OperationSystemType getOperationSystem(int type) {
            OperationSystemType osType = null;
            switch (type) {
                case 1: {
                    osType = WINDOWS2003;
                    break;
                }
                case 0: {
                    osType = LINUX;
                    break;
                }
                case 2: {
                    osType = SOLARIS;
                    break;
                }
                case 3: {
                    osType = HP_UX;
                    break;
                }
                case 4: {
                    osType = AIX;
                    break;
                }
                case 5: {
                    osType = XenServer;
                    break;
                }
                case 6: {
                    osType = MAC_OS;
                    break;
                }
                case 7: {
                    osType = Vmware_ESX;
                    break;
                }
                case -1: {
                    osType = Unknown;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("wrong OperationSystem Type value:" + type);
                }
            }
            return osType;
        }

        public static int getValue(OperationSystemType type) {
            if (type.equals((Object)LINUX)) {
                return 0;
            }
            if (type.equals((Object)WINDOWS2003)) {
                return 1;
            }
            if (type.equals((Object)SOLARIS)) {
                return 2;
            }
            if (type.equals((Object)HP_UX)) {
                return 3;
            }
            if (type.equals((Object)AIX)) {
                return 4;
            }
            if (type.equals((Object)XenServer)) {
                return 5;
            }
            if (type.equals((Object)MAC_OS)) {
                return 6;
            }
            if (type.equals((Object)Vmware_ESX)) {
                return 7;
            }
            if (type.equals((Object)Unknown)) {
                return -1;
            }
            throw new IllegalArgumentException("wrong OperationSystem Type value:" + (Object)((Object)type));
        }

        public static String getDescription(OperationSystemType type) {
            if (type.equals((Object)LINUX)) {
                return Type.getString("linux");
            }
            if (type.equals((Object)WINDOWS2003)) {
                return Type.getString("windows2003");
            }
            if (type.equals((Object)SOLARIS)) {
                return Type.getString("solaris");
            }
            if (type.equals((Object)HP_UX)) {
                return Type.getString("hp_ux");
            }
            if (type.equals((Object)AIX)) {
                return Type.getString("aix");
            }
            if (type.equals((Object)XenServer)) {
                return Type.getString("XenServer");
            }
            if (type.equals((Object)MAC_OS)) {
                return Type.getString("Mac_os");
            }
            if (type.equals((Object)Vmware_ESX)) {
                return Type.getString("Vmware_ESX");
            }
            if (type.equals((Object)Unknown)) {
                return Type.DEFAULT_STR_VALUE;
            }
            throw new IllegalArgumentException("wrong OperationSystem Type value:" + (Object)((Object)type));
        }

        public static OperationSystemType getOperationSystemType(String type) {
            if (type.equalsIgnoreCase("Linux")) {
                return LINUX;
            }
            if (type.equalsIgnoreCase("Windows")) {
                return WINDOWS2003;
            }
            if (type.equalsIgnoreCase("Solaris")) {
                return SOLARIS;
            }
            if (type.equalsIgnoreCase("HP-UX")) {
                return HP_UX;
            }
            if (type.equalsIgnoreCase("AIX")) {
                return AIX;
            }
            if (type.equalsIgnoreCase("XenServer")) {
                return XenServer;
            }
            if (type.equalsIgnoreCase("Mac OS X")) {
                return MAC_OS;
            }
            if (type.equalsIgnoreCase("Vmware ESX")) {
                return Vmware_ESX;
            }
            if (type.equalsIgnoreCase("Unknown")) {
                return Unknown;
            }
            throw new IllegalArgumentException("wrong OperationSystem Type value:" + type);
        }
    }

    public static class LogicalChassisType {
        public static final int CONTROLLERCHASSIS = 1;
        public static final int HARDDRIVECHASSIS = 0;
        public static final int PCIECHASSIS = 2;
        public static final int NASCHASSIS = 11;
        public static final int FILECHASSIS = 12;
        private static final long serialVersionUID = -3424483598369959547L;

        public static String getDescription(String value) {
            return Type.getString("LogicalChassisType_" + value);
        }

        public static String getDescription(int value) {
            return Type.getString("LogicalChassisType_" + value);
        }
    }

    public static enum FCModeType {
        UNKNOW(-1),
        TGT(0),
        INI(1),
        COM(2);

        private static final long serialVersionUID = -3424454826912301547L;
        private int fcModeTypeValue;

        private FCModeType(int value) {
            this.fcModeTypeValue = value;
        }

        public static FCModeType getFCModeType(int type) {
            for (FCModeType fcModeType : FCModeType.values()) {
                if (fcModeType.fcModeTypeValue != type) continue;
                return fcModeType;
            }
            LOGGER.warn("return UNKNOW because can't find fcModeType which value = " + type);
            return UNKNOW;
        }

        public int getValue() {
            return this.fcModeTypeValue;
        }

        public String getDescription() {
            String des = Type.getString("FCModeType_" + this.name());
            return des;
        }
    }

    public static enum FCPortType {
        UNKNOW(-1),
        Fabric(1),
        PublicLoop(2),
        PointtoPoint(3),
        Auto(4);

        private static final long serialVersionUID = -3424454826912301547L;
        private int fcPortTypeValue;

        private FCPortType(int value) {
            this.fcPortTypeValue = value;
        }

        public static FCPortType getFCPortType(int type) {
            for (FCPortType fcPortType : FCPortType.values()) {
                if (fcPortType.fcPortTypeValue != type) continue;
                return fcPortType;
            }
            LOGGER.warn("return UNKNOW because can't find FCPortType which value = " + type);
            return UNKNOW;
        }

        public int getValue() {
            return this.fcPortTypeValue;
        }

        public String getDescription() {
            String des = Type.getString("FCPortType_" + this.name());
            return des;
        }
    }

    public static enum ExpanderPortType {
        FC(1),
        SAS(0),
        UNKNOW(-1);

        private static final long serialVersionUID = -3424454826912301547L;
        private int expanderPortTypeValue;

        private ExpanderPortType(int value) {
            this.expanderPortTypeValue = value;
        }

        public static ExpanderPortType getExpanderPortType(int type) {
            if (ExpanderBoardType.FC.expanderBoardTypeValue == type) {
                return SAS;
            }
            if (ExpanderBoardType.SAS.expanderBoardTypeValue == type) {
                return FC;
            }
            LOGGER.warn("return UNKNOW because can't find ExpanderPortType which value = " + type);
            return UNKNOW;
        }

        public static ExpanderPortType getExpanderPortTypeAfterNex(int type) {
            for (ExpanderPortType expanderPortType : ExpanderPortType.values()) {
                if (expanderPortType.expanderPortTypeValue != type) continue;
                return expanderPortType;
            }
            LOGGER.warn("return UNKNOW because can't find ExpanderPortType which value = " + type);
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString("ExpanderPortType_" + this.name());
            return des;
        }
    }

    public static enum PortLogicType {
        SERVICE(1L),
        IBC(2L),
        IBS(3L),
        EXPANDER(4L),
        Management(5L),
        UPSManager(6L),
        IPMI(7L),
        MaintainNet(8L),
        ManageService(9L),
        MaintainServiceNet(10L),
        ETHSwitch(11L),
        UNKNOW(-1L);

        private static final long serialVersionUID = -3424454826912301547L;
        private long portLogicTypeValue;

        private PortLogicType(long value) {
            this.portLogicTypeValue = value;
        }

        public static PortLogicType getPortLogicType(long type) {
            for (PortLogicType expanderPortType : PortLogicType.values()) {
                if (expanderPortType.portLogicTypeValue != type) continue;
                return expanderPortType;
            }
            LOGGER.warn("return UNKNOW because can't find PortLogicType which value = " + type);
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString("Port.Logic.Type." + this.name());
            return des;
        }

        public long getValue() {
            return this.portLogicTypeValue;
        }
    }

    public static enum PortWorkModeType {
        UNKNOW(-1),
        INI(1),
        TARGET(2),
        BOTH(3);

        private int portWorkModeTypeValue = 0;

        private PortWorkModeType(int value) {
            this.portWorkModeTypeValue = value;
        }

        public static PortWorkModeType getPortWorkModeType(int value) {
            for (PortWorkModeType type : PortWorkModeType.values()) {
                if (type.portWorkModeTypeValue != value) continue;
                return type;
            }
            LOGGER.error("can not find the PortWorkModeType: value :" + value);
            return UNKNOW;
        }

        public String toString() {
            return Type.getString("Type.PortWorkModeType." + this.name());
        }

        public int getValue() {
            return this.portWorkModeTypeValue;
        }
    }

    public static enum PortPhyicalType {
        SAS(0L),
        FC(1L),
        NIC(2L),
        PCIE(3L),
        BOND(5L),
        COM(6L),
        USB(7L),
        IB(11L),
        FCOE(8L),
        UNKNOW(-1L);

        private static final long serialVersionUID = -3424454878969959547L;
        private long portPhyicalTypeValue;

        private PortPhyicalType(long value) {
            this.portPhyicalTypeValue = value;
        }

        public static PortPhyicalType getPortType(long type) {
            for (PortPhyicalType portPhyicalType : PortPhyicalType.values()) {
                if (portPhyicalType.portPhyicalTypeValue != type) continue;
                return portPhyicalType;
            }
            LOGGER.warn("return UNKNOW because can't find PortPhyicalType which value = " + type);
            return UNKNOW;
        }

        public long getValue() {
            return this.portPhyicalTypeValue;
        }

        public String getDescription() {
            String des = Type.getString("Port.Phyical.Type." + this.name());
            return des;
        }
    }

    public static enum BoardType {
        UNKNOW(-1),
        Controller(1),
        ExpanderModule(2),
        PortModule(3),
        ManageModule(4);

        private long boardTypeValue;

        private BoardType(int value) {
            this.boardTypeValue = value;
        }

        public static BoardType getBoardType(long value) {
            for (BoardType type : BoardType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            LOGGER.error("BoardType.getBoardType: Can not find the BoardType: value :" + value);
            return UNKNOW;
        }

        public long getValue() {
            return this.boardTypeValue;
        }

        public String toString() {
            String packageName = "Type.BoardType.";
            return ResourceManager.getString(packageName + this.name());
        }
    }

    public static enum ExpanderBoardType {
        SAS(0),
        FC(1),
        ISCSI(2),
        COMBO(3),
        UNKNOW(-1);

        private static final long serialVersionUID = -3424454878969959547L;
        private int expanderBoardTypeValue;

        private ExpanderBoardType(int value) {
            this.expanderBoardTypeValue = value;
        }

        public static ExpanderBoardType getExpansionBoardType(int type) {
            for (ExpanderBoardType expanderBoardType : ExpanderBoardType.values()) {
                if (expanderBoardType.expanderBoardTypeValue != type) continue;
                return expanderBoardType;
            }
            LOGGER.warn("return UNKNOW because can't find ExpanderBoardType which value = " + type);
            return UNKNOW;
        }

        public String getDescription() {
            String des = Type.getString("ExpanderBoardType_" + this.name());
            return des;
        }

        public String toString() {
            String des = Type.getString("ExpanderBoardPhyiscalType_" + this.name());
            return des;
        }
    }

    public static enum DiskPhysicalType {
        DISK_FC(0),
        DISK_SAS(1),
        DISK_SATA(2),
        DISK_SSD(3),
        DISK_NLSAS(4),
        DISK_UNKNOW(-1);

        private static final long serialVersionUID = -3424454826959951237L;
        private int diskPhysicalTypeValue;

        private DiskPhysicalType(int value) {
            this.diskPhysicalTypeValue = value;
        }

        public static DiskPhysicalType getPhysicalType(int type) {
            for (DiskPhysicalType diskPhysicalType : DiskPhysicalType.values()) {
                if (diskPhysicalType.diskPhysicalTypeValue != type) continue;
                return diskPhysicalType;
            }
            LOGGER.warn("return DISK_UNKNOW because can't find DiskPhysicalType which value = " + type);
            return DISK_UNKNOW;
        }

        public String getDiskTypeDescription() {
            if (this.equals((Object)DISK_NLSAS) || this.equals((Object)DISK_SATA)) {
                return Type.getString("DiskPhysicalType_DISK_SATA_OR_NLSAS");
            }
            return Type.getString("DiskPhysicalType_" + this.name());
        }

        public String getDescription() {
            String des = Type.getString("DiskPhysicalType_" + this.name());
            return des;
        }

        public int getValue() {
            return this.diskPhysicalTypeValue;
        }
    }

    public static enum DiskLogicalType {
        Free(1),
        RaidMember(2),
        Spare(3),
        Ssdc(4),
        UNKNOW(Integer.MIN_VALUE);

        private static final long serialVersionUID = -3424454826452359547L;
        private int diskLogicalTypeValue;

        private DiskLogicalType(int value) {
            this.diskLogicalTypeValue = value;
        }

        public static DiskLogicalType getDiskLogicalType(int type) {
            for (DiskLogicalType diskLogicalType : DiskLogicalType.values()) {
                if (diskLogicalType.diskLogicalTypeValue != type) continue;
                return diskLogicalType;
            }
            throw new IllegalArgumentException("wrong DiskLogicalType value:" + type);
        }

        public int getValue() {
            return this.diskLogicalTypeValue;
        }

        public String getDescription() {
            String des = Type.getString("DiskLogicalType_" + this.name());
            return des;
        }
    }
}

