/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.common.license;

import com.huawei.ism.common.license.LicenseFunction;
import com.huawei.ism.common.license.LicenseInfo;
import com.huawei.ism.common.license.LicenseResource;
import com.huawei.ism.common.license.LicenseUsageInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class License
implements Serializable {
    private static final long serialVersionUID = 886119476225389930L;
    private transient List<LicenseInfo> licenseInfoList = new ArrayList<LicenseInfo>(0);
    private transient List<LicenseFunction> licenseFuncList = new ArrayList<LicenseFunction>(0);
    private transient Map<String, LicenseFunction> licenseFunctionMap = new HashMap<String, LicenseFunction>(0);
    private transient List<LicenseResource> licenseResourceList = new ArrayList<LicenseResource>(0);
    private transient Map<String, LicenseResource> licenseResourceMap = new HashMap<String, LicenseResource>(0);
    private transient List<LicenseUsageInfo> licenceUsageInfoList = new ArrayList<LicenseUsageInfo>(0);
    private transient Map<String, LicenseUsageInfo> licenseUsageInfoMap = new HashMap<String, LicenseUsageInfo>(0);
    private LicenseHead head = null;

    public License(LicenseHead head) {
        this.head = head;
    }

    public void addLicenseInfo(LicenseInfo licenseInfo) {
        this.licenseInfoList.add(licenseInfo);
    }

    public LicenseInfo getLicenseInfo(int index) {
        return this.licenseInfoList.get(index);
    }

    public Collection<LicenseInfo> getLicenseInfoList() {
        ArrayList<LicenseInfo> resultList = new ArrayList<LicenseInfo>(this.licenseInfoList.size());
        resultList.addAll(this.licenseInfoList);
        return resultList;
    }

    public void addLicenseFunction(LicenseFunction func) {
        this.licenseFuncList.add(func);
        this.licenseFunctionMap.put(String.valueOf(func.getFeatureName().getValue()), func);
    }

    public void addLicenseFunction(List<LicenseFunction> funcItems) {
        this.licenseFuncList.addAll(funcItems);
    }

    public LicenseFunction getLicenseFunction(int index) {
        return this.licenseFuncList.get(index);
    }

    public Collection<LicenseFunction> getLicenseFuncList() {
        ArrayList<LicenseFunction> resultList = new ArrayList<LicenseFunction>(this.licenseFuncList.size());
        resultList.addAll(this.licenseFuncList);
        return resultList;
    }

    public void addLicenseResource(LicenseResource licenseResource) {
        this.licenseResourceList.add(licenseResource);
        this.licenseResourceMap.put(licenseResource.getFeatureName(), licenseResource);
    }

    public void addLicenseResource(List<LicenseResource> resItems) {
        this.licenseResourceList.addAll(resItems);
    }

    public LicenseResource getLicenseResource(int index) {
        return this.licenseResourceList.get(index);
    }

    public Collection<LicenseResource> getLicenseResourceList() {
        ArrayList<LicenseResource> resultList = new ArrayList<LicenseResource>(this.licenseResourceList.size());
        resultList.addAll(this.licenseResourceList);
        return resultList;
    }

    public LicenseHead getHead() {
        return this.head;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("headCountry", (Object)this.head.headCountry).append("headCreatedTime", (Object)this.head.headCreatedTime).append("headCreator", (Object)this.head.headCreator).append("headCustom", (Object)this.head.headCustom).append("headInfo", (Object)this.head.headInfo).append("headOffice", (Object)this.head.headOffice).append("headSerialNo", (Object)this.head.headSerialNo).append("licenseInfoList", this.licenseInfoList).append("licenseFuncList", this.licenseFuncList).append("licenseResourceList", this.licenseResourceList).toString();
    }

    public List<LicenseUsageInfo> getLicenceUsageInfoList() {
        return this.licenceUsageInfoList;
    }

    public void setLicenceUsageInfoList(List<LicenseUsageInfo> licenceUsageInfoList) {
        this.licenceUsageInfoList = licenceUsageInfoList;
    }

    public void addLicenseUsageInfo(LicenseUsageInfo info) {
        this.licenceUsageInfoList.add(info);
        this.licenseUsageInfoMap.put(String.valueOf(info.getFeatureID()), info);
    }

    public Map<String, LicenseResource> getLicenseResourceMap() {
        return this.licenseResourceMap;
    }

    public Map<String, LicenseUsageInfo> getLicenseUsageInfoMap() {
        return this.licenseUsageInfoMap;
    }

    public Map<String, LicenseFunction> getLicenseFunctionMap() {
        return this.licenseFunctionMap;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public static class LicenseHead
    implements Serializable {
        private static final long serialVersionUID = -9083610732980189865L;
        private String headCountry = "";
        private String headCreatedTime = "";
        private String headCreator = "";
        private String headCustom = "";
        private String headInfo = "";
        private String headOffice = "";
        private String headSerialNo = "";

        public LicenseHead(String info, String serialNo, String creator, String createdTime, String country, String custom, String office) {
            this.headInfo = info;
            this.headSerialNo = serialNo;
            this.headCreator = creator;
            this.headCreatedTime = createdTime;
            this.headCountry = country;
            this.headCustom = custom;
            this.headOffice = office;
        }

        public String getCountry() {
            return this.headCountry;
        }

        public void setCountry(String country) {
            this.headCountry = country;
        }

        public String getCreatedTime() {
            return this.headCreatedTime;
        }

        public void setCreatedTime(String createdTime) {
            this.headCreatedTime = createdTime;
        }

        public String getCreator() {
            return this.headCreator;
        }

        public void setCreator(String creator) {
            this.headCreator = creator;
        }

        public String getCustom() {
            return this.headCustom;
        }

        public void setCustom(String custom) {
            this.headCustom = custom;
        }

        public String getInfo() {
            if (this.headInfo != null) {
                return this.headInfo.trim();
            }
            return this.headInfo;
        }

        public void setInfo(String info) {
            this.headInfo = info;
        }

        public String getOffice() {
            return this.headOffice;
        }

        public void setOffice(String office) {
            this.headOffice = office;
        }

        public String getSerialNo() {
            return this.headSerialNo;
        }

        public void setSerialNo(String serialNo) {
            this.headSerialNo = serialNo;
        }
    }

    public static enum State {
        NOT_EXISTED(-1),
        VALID(1),
        TO_BE_OVERDUE(2),
        OVERDUE(3);

        private int value;

        private State(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static State getState(int value) {
            for (State state : State.values()) {
                if (state.getValue() != value) continue;
                return state;
            }
            return NOT_EXISTED;
        }
    }

    public static enum Type {
        Active(0),
        Inactive(1);

        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

