/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.model;

import com.huawei.ism.model.MO;
import com.huawei.ism.model.MOType;
import com.huawei.ism.model.UUID;
import com.huawei.ism.util.Assert;
import java.util.Arrays;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class Associator
extends MO {
    private static final long serialVersionUID = -991395536700997419L;
    private UUID[] uuids = new UUID[2];

    public Associator(MOType type, String deviceID, UUID dependent, UUID antecedent) {
        super(deviceID);
        Assert.notNull(dependent);
        Assert.notNull(antecedent);
        this.setMOType(type);
        if (dependent.hashCode() < antecedent.hashCode()) {
            this.uuids[0] = dependent;
            this.uuids[1] = antecedent;
        } else {
            this.uuids[1] = dependent;
            this.uuids[0] = antecedent;
        }
        this.setID(this.uuids[0].getID() + this.uuids[1].getID());
    }

    public UUID getAnotherUUID(UUID uuid) {
        if (uuid.equals(this.uuids[0])) {
            return this.uuids[1];
        }
        if (uuid.equals(this.uuids[1])) {
            return this.uuids[0];
        }
        return null;
    }

    public UUID[] getAssociateUUIDs() {
        return (UUID[])this.uuids.clone();
    }

    public int getAssociateType() {
        return this.getMOTypeValue();
    }

    public boolean isAssociateTo(UUID uuid) {
        return this.uuids[0].equals(uuid) || this.uuids[1].equals(uuid);
    }

    public boolean isAssociatorOf(MOType associateType, UUID oneUUID, UUID anotherUUID) {
        Associator tmp = new Associator(associateType, oneUUID.getDeviceID(), oneUUID, anotherUUID);
        return this.equals(tmp);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.uuids);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Associator other = (Associator)obj;
        return Arrays.equals(this.uuids, other.uuids);
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append("dependentUUID", (Object)this.uuids[0]).append("antecedentUUID", (Object)this.uuids[1]).toString();
    }
}

