/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.model;

import com.huawei.ism.model.IMOKey;
import com.huawei.ism.model.MOType;
import com.huawei.ism.util.ProductToolContainer;
import java.util.ArrayList;
import java.util.List;

public final class MOKeyManager {
    private static final MOKeyManager INSTANCE_MOKEY_MANAGE = new MOKeyManager();
    private ProductToolContainer<MOType, List<? extends IMOKey>> keyMap = new ProductToolContainer();
    private ProductToolContainer<String, List<? extends IMOKey>> methodKeyMap = new ProductToolContainer();

    private MOKeyManager() {
    }

    public static MOKeyManager getInstance() {
        return INSTANCE_MOKEY_MANAGE;
    }

    public void registerMOKey(String deviceType, MOType moType, List<? extends IMOKey> keys) {
        this.keyMap.registerTool(deviceType, moType, keys);
    }

    public List<IMOKey> getMOKeyList(String deviceType, MOType moType) {
        ArrayList<IMOKey> results = new ArrayList<IMOKey>(0);
        List<? extends IMOKey> list = this.keyMap.getTool(deviceType, moType);
        if (null != list) {
            results.addAll(list);
        }
        return results;
    }

    public void registerMethodKey(String deviceType, String method, List<? extends IMOKey> keys) {
        this.methodKeyMap.registerTool(deviceType, method, keys);
    }

    public List<IMOKey> getMethodKeyList(String deviceType, String method) {
        ArrayList<IMOKey> results = new ArrayList<IMOKey>(0);
        List<? extends IMOKey> list = this.methodKeyMap.getTool(deviceType, method);
        if (null != list) {
            results.addAll(list);
        }
        return results;
    }
}

