/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tlv.lang;

import com.huawei.ism.tlv.docoder.ParamType;
import com.huawei.ism.tlv.lang.IsmUnsignedInteger;

public class UnsignedInt32
extends IsmUnsignedInteger {
    public static final UnsignedInt32 ALL_FFFF = new UnsignedInt32(0xFFFFFFFFL);
    private static final long serialVersionUID = -4505752174646939468L;
    private final long unSignedIntvalue;

    public UnsignedInt32(long value) {
        this.unSignedIntvalue = value;
    }

    public UnsignedInt32(byte[] bytes) {
        this.unSignedIntvalue = this.fromByteArray(bytes, bytes.length);
    }

    public UnsignedInt32(byte[] bytes, int offset) {
        if (null == bytes) {
            throw new IllegalArgumentException("Data cannot be null");
        }
        if (offset < 0 || bytes.length - offset < 4) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        byte[] tmp = new byte[4];
        System.arraycopy(bytes, offset, tmp, 0, 4);
        this.unSignedIntvalue = this.fromByteArray(tmp, tmp.length);
    }

    public UnsignedInt32(int value) {
        this.unSignedIntvalue = value;
    }

    private long fromByteArray(byte[] abyte0, int bytesToRead) {
        if (abyte0.length < bytesToRead || bytesToRead <= 0) {
            throw new IllegalArgumentException("Data size mismatch");
        }
        int arrayLength = abyte0.length;
        int count = bytesToRead >= 4 ? 4 : bytesToRead;
        long longVal = abyte0[arrayLength - 1] & 0xFF;
        for (int i = 2; i <= count; ++i) {
            longVal <<= 8;
            longVal |= (long)(abyte0[arrayLength - i] & 0xFF);
        }
        return longVal;
    }

    @Override
    public byte[] toByteArray() {
        byte[] returnArray = new byte[4];
        returnArray[3] = (byte)(this.unSignedIntvalue >>> 24);
        returnArray[2] = (byte)(this.unSignedIntvalue >>> 16 & 0xFFL);
        returnArray[1] = (byte)(this.unSignedIntvalue >>> 8 & 0xFFL);
        returnArray[0] = (byte)this.unSignedIntvalue;
        return returnArray;
    }

    @Override
    public double doubleValue() {
        return this.unSignedIntvalue;
    }

    @Override
    public float floatValue() {
        return this.unSignedIntvalue;
    }

    @Override
    public int intValue() {
        return (int)this.unSignedIntvalue;
    }

    @Override
    public long longValue() {
        return this.unSignedIntvalue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.unSignedIntvalue ^ this.unSignedIntvalue >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnsignedInt32 other = (UnsignedInt32)obj;
        return this.unSignedIntvalue == other.unSignedIntvalue;
    }

    @Override
    public ParamType getType() {
        return ParamType.U32INT_TYPE;
    }

    @Override
    public boolean isFFFF() {
        return (this.unSignedIntvalue & 0xFFFFFFFFL) == 0xFFFFFFFFL;
    }
}

