/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

public final class DiskLocation
implements Comparable<DiskLocation> {
    private String diskEnclosure;
    private String diskSlot;
    private String diskLocation;
    private String diskId;

    public DiskLocation() {
    }

    public DiskLocation(String diskID, boolean isdiskID) {
        this.diskId = diskID;
        this.diskEnclosure = null;
        this.diskLocation = null;
        this.diskSlot = null;
    }

    public DiskLocation(String diskLocation) {
        this.diskEnclosure = diskLocation.split("\\(")[1].split(",")[0].trim();
        this.diskSlot = diskLocation.split(",")[1].split("\\)")[0].trim();
        this.diskLocation = "(" + this.diskEnclosure + "," + this.diskSlot + ")";
        this.diskId = null;
    }

    public DiskLocation(String diskEnclosure, String diskSlot) {
        this.diskEnclosure = diskEnclosure.trim();
        this.diskSlot = diskSlot.trim();
        this.diskLocation = "(" + diskEnclosure.trim() + ", " + diskSlot.trim() + ")";
        this.diskId = null;
    }

    public String getDiskId() {
        return this.diskId;
    }

    public void setDiskId(String diskId) {
        this.diskId = diskId;
    }

    public String getDiskEnclosure() {
        return this.diskEnclosure;
    }

    public void setDiskEnclosure(String diskEnclosure) {
        this.diskEnclosure = diskEnclosure;
    }

    public String getDiskSlot() {
        return this.diskSlot;
    }

    public void setDiskSlot(String diskSlot) {
        this.diskSlot = diskSlot;
    }

    public String getDiskLocation() {
        return this.diskLocation;
    }

    public void setDiskLocation(String diskLocation) {
        this.diskLocation = diskLocation;
    }

    public String toString() {
        return this.diskId != null ? this.diskId : "(" + this.diskEnclosure + "," + this.diskSlot + ")";
    }

    @Override
    public int compareTo(DiskLocation diskLocation) {
        if (diskLocation.diskId != null && this.diskId != null) {
            String[] thisDiskIdArr = this.diskId.split("\\.");
            String[] componentDiskIdArr = diskLocation.diskId.split("\\.");
            return this.comPareDiskID(diskLocation, thisDiskIdArr, componentDiskIdArr);
        }
        if (this.diskEnclosure != null && this.diskSlot != null && diskLocation.diskEnclosure != null && diskLocation.diskSlot != null) {
            int encCmpRet = Integer.parseInt(this.getDiskEnclosure()) - Integer.parseInt(diskLocation.getDiskEnclosure());
            int slotCmpRet = 0 == encCmpRet ? Integer.parseInt(this.getDiskSlot()) - Integer.parseInt(diskLocation.getDiskSlot()) : encCmpRet;
            return slotCmpRet;
        }
        if (this.diskId != null) {
            return 1;
        }
        if (this.diskEnclosure != null && this.diskSlot != null) {
            return -1;
        }
        return 0;
    }

    private int comPareDiskID(DiskLocation diskLocation, String[] thisDiskIdArr, String[] componentDiskIdArr) {
        if (thisDiskIdArr.length >= 2 && componentDiskIdArr.length >= 2) {
            int thisDiskLeng = thisDiskIdArr.length;
            int componendDiskLeng = componentDiskIdArr.length;
            int shortLength = thisDiskLeng;
            String[] big = componentDiskIdArr;
            if (thisDiskLeng > componendDiskLeng) {
                big = thisDiskIdArr;
                shortLength = componendDiskLeng;
            }
            for (int index = 0; index < shortLength - 1; ++index) {
                String thisDisk = thisDiskIdArr[index];
                String componentDisk = componentDiskIdArr[index];
                if (thisDisk.equals(componentDisk)) continue;
                return thisDisk.compareTo(componentDisk);
            }
            if (thisDiskIdArr.length == componentDiskIdArr.length) {
                return this.diskId.compareTo(diskLocation.diskId);
            }
            return "0".compareTo(big[shortLength]);
        }
        return this.diskId.compareTo(diskLocation.diskId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.diskEnclosure == null ? 0 : this.diskEnclosure.hashCode());
        result = 31 * result + (this.diskLocation == null ? 0 : this.diskLocation.hashCode());
        result = 31 * result + (this.diskSlot == null ? 0 : this.diskSlot.hashCode());
        result = 31 * result + (this.diskId == null ? 0 : this.diskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiskLocation other = (DiskLocation)obj;
        if (this.diskLocation != null) {
            return this.diskLocation.equals(other.diskLocation);
        }
        return this.diskId.equals(other.diskId);
    }
}

