/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.hardware;

import com.huawei.ism.model.MO;
import com.huawei.ism.tool.framework.pubservice.hardware.BackupPowerMO;
import com.huawei.ism.tool.framework.pubservice.hardware.BayMO;
import com.huawei.ism.tool.framework.pubservice.hardware.ControllerMO;
import com.huawei.ism.tool.framework.pubservice.hardware.DiskMO;
import com.huawei.ism.tool.framework.pubservice.hardware.EnclosureMO;
import com.huawei.ism.tool.framework.pubservice.hardware.EthPortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.ExpBoardMO;
import com.huawei.ism.tool.framework.pubservice.hardware.FCInitiatorMO;
import com.huawei.ism.tool.framework.pubservice.hardware.FCoEPortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.FanMO;
import com.huawei.ism.tool.framework.pubservice.hardware.FcPortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.IHardwareInfo;
import com.huawei.ism.tool.framework.pubservice.hardware.IntfModuleMO;
import com.huawei.ism.tool.framework.pubservice.hardware.IscsiInitiatorMO;
import com.huawei.ism.tool.framework.pubservice.hardware.PCIePortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.PowerMO;
import com.huawei.ism.tool.framework.pubservice.hardware.SasPortMO;
import com.huawei.ism.tool.framework.pubservice.hardware.SftOpticalMO;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HardwareBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareBuilder.class);
    private static final Map<String, Class<? extends IHardwareInfo>> TYPE_CLASS_MAP = new HashMap<String, Class<? extends IHardwareInfo>>();

    private HardwareBuilder() {
    }

    public static IHardwareInfo build(String typeName, MO mo) {
        Class<? extends IHardwareInfo> cls = TYPE_CLASS_MAP.get(typeName);
        if (null == cls) {
            return null;
        }
        try {
            Constructor<? extends IHardwareInfo> constructor = cls.getConstructor(MO.class);
            return constructor.newInstance(mo);
        }
        catch (IllegalAccessException exception) {
            LOGGER.error(cls + " is private, please change into public!", (Throwable)exception);
        }
        catch (InstantiationException exception) {
            LOGGER.error("Instantiate class error: " + cls, (Throwable)exception);
        }
        catch (SecurityException exception) {
            LOGGER.error("SecurityException: " + cls, (Throwable)exception);
        }
        catch (NoSuchMethodException exception) {
            LOGGER.error("NoSuchMethodException: " + cls, (Throwable)exception);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.error("IllegalArgumentException: " + cls, (Throwable)exception);
        }
        catch (InvocationTargetException exception) {
            LOGGER.error("InvocationTargetException: " + cls, (Throwable)exception);
        }
        return null;
    }

    static {
        TYPE_CLASS_MAP.put("BAY", BayMO.class);
        TYPE_CLASS_MAP.put("ENCLOSURE", EnclosureMO.class);
        TYPE_CLASS_MAP.put("CONTROLLER", ControllerMO.class);
        TYPE_CLASS_MAP.put("INTF_MODULE", IntfModuleMO.class);
        TYPE_CLASS_MAP.put("FC_PORT", FcPortMO.class);
        TYPE_CLASS_MAP.put("SAS_PORT", SasPortMO.class);
        TYPE_CLASS_MAP.put("PCIE_PORT", PCIePortMO.class);
        TYPE_CLASS_MAP.put("ETH_PORT", EthPortMO.class);
        TYPE_CLASS_MAP.put("POWER", PowerMO.class);
        TYPE_CLASS_MAP.put("BACKUP_POWER", BackupPowerMO.class);
        TYPE_CLASS_MAP.put("FAN", FanMO.class);
        TYPE_CLASS_MAP.put("EXPBOARD", ExpBoardMO.class);
        TYPE_CLASS_MAP.put("DISK", DiskMO.class);
        TYPE_CLASS_MAP.put("FCOE_PORT", FCoEPortMO.class);
        TYPE_CLASS_MAP.put("SFP_OPTICAL_TRANSCEIVER", SftOpticalMO.class);
        TYPE_CLASS_MAP.put("ISCSI_INITIATOR", IscsiInitiatorMO.class);
        TYPE_CLASS_MAP.put("FC_INITIATOR", FCInitiatorMO.class);
    }
}

