/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.URLLinkLabel;
import com.huawei.ism.ui.swing.control.RoundCornerPane;
import com.huawei.ism.ui.swing.dialog.HeadlessDialog;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class AboutDialog
extends HeadlessDialog {
    private static final long serialVersionUID = 1L;

    public AboutDialog() {
        super((Window)Framework.getInstance().getMainFrame());
        this.setModal(true);
        this.setResizable(false);
        this.toFront();
        this.setTitle(ResourceManager.getOEMString("HELP_ABOUT_DESCRIPTION"));
        this.doLayoutUI();
        this.pack();
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.setDefaultCloseOperation(2);
        this.addMouseListener(new MouseAction());
    }

    private void doLayoutUI() {
        ImageIcon headIcon = ResourceManager.getOEMImage("about_head.png");
        ImagePanel topImage = new ImagePanel(headIcon);
        topImage.setPreferredSize(new Dimension(headIcon.getIconWidth(), headIcon.getIconHeight()));
        JLabel ismImageL = new JLabel(ResourceManager.getOEMImage("ISM.png"), 2);
        JLabel ismDesc = new JLabel("Integrated Storage Manager");
        JLabel version = new JLabel(Framework.getInstance().getIsmVersion(), 2);
        String websiteLableStr = ResourceManager.getString("WEBSITE") + ": ";
        JLabel websitelable = new JLabel(websiteLableStr);
        String website = ResourceManager.getOEMString("COMPANY_HTTP_WEBSITE");
        URLLinkLabel websiteL = new URLLinkLabel(website, website);
        FontMetrics fm = websiteL.getFontMetrics(websiteL.getFont());
        int length = fm.stringWidth(website);
        UCD.setJComponentSize(websiteL, new Dimension(length, fm.getHeight()));
        length = fm.stringWidth(websiteLableStr);
        UCD.setJComponentSize(websitelable, new Dimension(length, fm.getHeight()));
        JLabel warningTextArea = new JLabel();
        warningTextArea.setText(UCD.wrapTextWithHTML(fm, ResourceManager.getString("ABOUTDIALOG_VERSION_WARNING"), 400));
        JComponent warningBox = UCD.buildHorizotalBox((Border)new EmptyBorder(0, 0, 0, 0), warningTextArea);
        JComponent versionBox = UCD.buildVerticalBox((Border)new EmptyBorder(20, 40, 0, 40), 5, UCD.buildHBoxLeft(ismImageL), UCD.buildHBoxLeft(ismDesc), UCD.buildHBoxLeft(version));
        JComponent companyBox = UCD.buildVerticalBox((Border)new EmptyBorder(11, 40, 20, 40), 5, UCD.buildHBoxLeft(0, websitelable, websiteL), warningBox);
        JComponent contentPane = UCD.buildVerticalBox(null, versionBox, companyBox);
        JLabel copyright = new JLabel();
        copyright.setText(ResourceManager.getOEMString("ABOUTDIALOG_COPY_RIGHT"));
        Box copyRightBox = Box.createHorizontalBox();
        copyRightBox.add(Box.createHorizontalGlue());
        copyRightBox.add(copyright);
        copyRightBox.add(Box.createHorizontalGlue());
        copyRightBox.setBorder(new EmptyBorder(18, 4, 8, 4));
        if (ResourceManager.getLocale().getLanguage().equalsIgnoreCase("en")) {
            copyright.setFont(new Font("Dialog", 0, 11));
        }
        RoundCornerPane contentPanel = new RoundCornerPane(new Color(0x202122));
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)topImage, "North");
        contentPanel.add((Component)contentPane, "Center");
        contentPanel.add((Component)this.createButtonPane(copyRightBox), "South");
        contentPanel.setBackground(new Color(0xF1F1F1));
        this.setLayout(new BorderLayout());
        this.add((Component)contentPanel, "Center");
    }

    private class MouseAction
    extends MouseAdapter {
        private MouseAction() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            AboutDialog.this.dispose();
        }
    }
}

