/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.common.Framework;
import com.huawei.ism.ui.swing.tree.IsmTree;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.ui.widgets.tree.DevicesTreeNode;
import com.huawei.ism.util.SwingUtil;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.tree.TreePath;

public class MainPaneTree
extends IsmTree {
    private static final long serialVersionUID = 9032211139732844508L;

    public MainPaneTree() {
        super(false);
        String runMode = Framework.getInstance().getRunMode();
        if (!runMode.equals("APPLET")) {
            DevicesTreeNode treeNode = new DevicesTreeNode();
            this.getTreeModel().addTopNode(treeNode);
        }
    }

    @Override
    public IsmTreeNode getSelectionNode() {
        TreePath treePath = this.getSelectionPath();
        if (null == treePath) {
            return null;
        }
        return (IsmTreeNode)treePath.getLastPathComponent();
    }

    public void deleteDeviceTreeNode(String deviceID) {
        IsmTreeNode deviceNode = this.findRootDeviceNode(deviceID);
        if (null != deviceNode) {
            this.deleteTreeNode(deviceNode, true);
        }
    }

    public void addDeviceTreeNode(IsmTreeNode deviceNode) {
        this.getTreeModel().addTreeNode(this.getRootNode(), deviceNode);
    }

    public void updateStatus(String deviceID) {
        IsmTreeNode rootNode = (IsmTreeNode)this.getTreeModel().getRoot();
        IsmTreeNode updateNode = this.findRootDeviceNode(rootNode, deviceID);
        this.updateNodeAndChildren(updateNode);
    }

    public IsmTreeNode findRootDeviceNode(String deviceID) {
        IsmTreeNode rootNode = (IsmTreeNode)this.getTreeModel().getRoot();
        if (rootNode == null) {
            return null;
        }
        return this.findRootDeviceNode(rootNode, deviceID);
    }

    public void updateNodeAndChildren(final IsmTreeNode treeNode) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LinkedList<IsmTreeNode> changeTreeNodes = new LinkedList<IsmTreeNode>();
                LinkedList<IsmTreeNode> structureChangedNodes = new LinkedList<IsmTreeNode>();
                LinkedList<IsmTreeNode> nodeQueue = new LinkedList<IsmTreeNode>();
                nodeQueue.add(treeNode);
                IsmTreeNode child = null;
                IsmTreeNode node = null;
                int nCount = 0;
                while (!nodeQueue.isEmpty()) {
                    node = (IsmTreeNode)nodeQueue.remove(0);
                    node.updateStatus(structureChangedNodes, changeTreeNodes);
                    nCount = node.getChildCount();
                    for (int i = 0; i < nCount; ++i) {
                        child = (IsmTreeNode)node.getChildAt(i);
                        nodeQueue.add(child);
                    }
                }
                TreePath[] selectionPath = null;
                Object[] path = null;
                Enumeration<TreePath> treePath = null;
                for (IsmTreeNode changeNode : structureChangedNodes) {
                    selectionPath = MainPaneTree.this.getSelectionModel().getSelectionPaths();
                    path = MainPaneTree.this.getTreeModel().getPathToRoot(changeNode);
                    MainPaneTree.this.getTreeModel().nodeStructureChanged(changeNode);
                    MainPaneTree.this.setSelectionPaths(selectionPath);
                    treePath = MainPaneTree.this.getExpandedDescendants(new TreePath(path));
                    MainPaneTree.this.expandNode(treePath);
                }
                for (IsmTreeNode changeNode : changeTreeNodes) {
                    selectionPath = MainPaneTree.this.getSelectionModel().getSelectionPaths();
                    MainPaneTree.this.getTreeModel().nodeChanged(changeNode);
                    MainPaneTree.this.setSelectionPaths(selectionPath);
                }
            }
        };
        SwingUtil.runInEventDispatchThread(run);
    }

    private IsmTreeNode findRootDeviceNode(IsmTreeNode from, String deviceID) {
        if (deviceID.equals(from.getDeviceID())) {
            return from;
        }
        int nCount = from.getChildCount();
        IsmTreeNode treeNode = null;
        IsmTreeNode findNode = null;
        for (int i = 0; i < nCount; ++i) {
            treeNode = (IsmTreeNode)from.getChildAt(i);
            findNode = this.findRootDeviceNode(treeNode, deviceID);
            if (null == findNode) continue;
            return findNode;
        }
        return null;
    }

    public IsmTreeNode getRootNode() {
        return (IsmTreeNode)this.getTreeModel().getRoot();
    }
}

