/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.forms.mainframe;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.module.event.EventBuzzHandle;
import com.huawei.ism.ui.module.event.EventStatPane;
import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.widgets.action.ActionManager;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ToolBarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private EventStatPane eventStatPane = new EventStatPane();
    private JToolBar toolBar = new JToolBar();

    public ToolBarPanel() {
        BorderLayout layout = new BorderLayout();
        this.setLayout(layout);
        this.toolBar.setLayout(new BoxLayout(this.toolBar, 0));
        ArrayList<String> actionResourceList = new ArrayList<String>(0);
        if (CommonUtil.isModuleEnable("DISABLE_DISCOVERY_MODULE")) {
            actionResourceList.add("discoveryArray");
            actionResourceList.add("discoveryArray.png");
        }
        if (CommonUtil.isModuleEnable("DISABLE_PFS_MODULE")) {
            actionResourceList.add("performanceStatistics");
            actionResourceList.add("performance.png");
        }
        if (CommonUtil.isModuleEnable("DISABLE_ALARM_MODULE")) {
            actionResourceList.add("manageAlarm");
            actionResourceList.add("alarm.png");
        }
        actionResourceList.add("refreshAll");
        actionResourceList.add("refresh.png");
        String[] actionResources = actionResourceList.toArray(new String[0]);
        ActionManager actionManager = ActionManager.getInstance();
        String actionID = null;
        Action deligateAction = null;
        ToolBarButton toolBarButton = null;
        String iconName = null;
        ImageIcon icon = null;
        for (int i = 0; i < actionResources.length; i += 2) {
            actionID = actionResources[i];
            deligateAction = actionManager.getAction(actionID);
            toolBarButton = new ToolBarButton(deligateAction);
            toolBarButton.setMnemonic(0);
            iconName = actionResources[i + 1];
            icon = ResourceManager.getImage(iconName);
            toolBarButton.setIcon(icon);
            toolBarButton.setText(null);
            this.toolBar.add(toolBarButton);
        }
        this.toolBar.setFloatable(false);
        if (CommonUtil.isModuleEnable("DISABLE_ALARM_MODULE")) {
            this.eventStatPane.setMaximumSize(new Dimension(300, 25));
            this.toolBar.add(Box.createHorizontalGlue());
            this.toolBar.add(this.createBuzzerButton());
            this.toolBar.add(Box.createHorizontalStrut(10));
            this.toolBar.add(this.eventStatPane);
        }
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            this.toolBar.setPreferredSize(new Dimension(0, 30));
        }
        this.toolBar.setMinimumSize(this.getPreferredSize());
        this.add(this.toolBar);
        this.validate();
        SwingUtil.setName(this);
    }

    private JButton createBuzzerButton() {
        String opentImgName = "open_alarm_buzzer.gif";
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            opentImgName = "open_alarm_buzzer.png";
        }
        ToolBarButton buzzerBtn = new ToolBarButton(ResourceManager.getImage(opentImgName), new Dimension(24, 24), ResourceManager.getString("OPEN_ALARM_BUZZER"));
        buzzerBtn.addActionListener(new BuzzBtnListner(buzzerBtn));
        return buzzerBtn;
    }

    public EventStatPane getEventStatPane() {
        return this.eventStatPane;
    }

    private static final class BuzzBtnListner
    implements ActionListener {
        private final JButton buzzerBtn;

        private BuzzBtnListner(JButton buzzerBtn) {
            this.buzzerBtn = buzzerBtn;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isEnable = EventBuzzHandle.getInstance().isBuzzEnable();
            EventBuzzHandle.getInstance().setBuzzEnable(!isEnable);
            String strWarnMsg = isEnable ? ResourceManager.getString("SHUTDOWN_ALARM_BUZZER_MESSAGE") : ResourceManager.getString("OPEN_ALARM_BUZZER_MESSAGE");
            String opentImgName = "open_alarm_buzzer.gif";
            String closeImgName = "close_alarm_buzzer.gif";
            if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
                opentImgName = "open_alarm_buzzer.png";
                closeImgName = "close_alarm_buzzer.png";
            }
            ImageIcon icon = isEnable ? ResourceManager.getImage(closeImgName) : ResourceManager.getImage(opentImgName);
            String tip = isEnable ? ResourceManager.getString("SHUTDOWN_ALARM_BUZZER") : ResourceManager.getString("OPEN_ALARM_BUZZER");
            this.buzzerBtn.setToolTipText(tip);
            this.buzzerBtn.setIcon(icon);
            DialogUtils.showInfoDialog(Framework.getInstance().getMainFrame(), strWarnMsg);
        }
    }
}

