/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.layout;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;

public class HorizontalBox {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_BOTH = 2;
    public static final int ALIGN_TOP = 3;
    public static final int ALIGN_BOTTOM = 4;
    public static final int ALIGN_CENTER = 5;
    private List<Component> components = new ArrayList<Component>(0);
    private int align = 0;

    public HorizontalBox(int align) {
        this.align = align;
    }

    public HorizontalBox(int align, Component ... components) {
        this.align = align;
        this.components.addAll(Arrays.asList(components));
    }

    public void addComponent(Component ... componentsTemp) {
        this.components.addAll(Arrays.asList(componentsTemp));
    }

    public void addComponent(Collection<Component> componentsTemp) {
        this.components.addAll(componentsTemp);
    }

    public JComponent doLayout() {
        Box rowBox = Box.createHorizontalBox();
        switch (this.align) {
            case 0: {
                this.doLayoutWhenComponentsEqualsHeight(rowBox);
                break;
            }
            case 1: {
                rowBox.add(Box.createHorizontalGlue());
                this.doLayoutWhenComponentsEqualsHeight(rowBox);
                break;
            }
            case 2: {
                this.doLayoutWhenAlignBoth(rowBox);
                break;
            }
            case 3: {
                this.doLayoutWhenAlignTop(rowBox);
                break;
            }
            case 4: {
                this.doLayoutWhenAlignBottom(rowBox);
                break;
            }
            case 5: {
                this.doLayoutWhenAlignCenter(rowBox);
                break;
            }
        }
        return rowBox;
    }

    private void doLayoutWhenComponentsEqualsHeight(Box rowBox) {
        Component component = null;
        Box vBox = null;
        Component nexComponent = null;
        for (int i = 0; i < this.components.size(); ++i) {
            component = this.components.get(i);
            vBox = Box.createVerticalBox();
            vBox.add(component);
            vBox.add(Box.createVerticalGlue());
            rowBox.add(vBox);
            if (i + 1 < this.components.size()) {
                nexComponent = this.components.get(i + 1);
                rowBox.add(Box.createHorizontalStrut(this.getGap(component, nexComponent)));
            }
            if (i + 1 >= this.components.size()) continue;
            nexComponent = this.components.get(i + 1);
            rowBox.add(Box.createHorizontalStrut(this.getGap(component, nexComponent)));
        }
    }

    private void doLayoutWhenAlignBoth(Box rowBox) {
        if (this.components.size() == 2) {
            Component first = this.components.get(0);
            Component sencond = this.components.get(1);
            rowBox.add(first);
            rowBox.add(Box.createHorizontalGlue());
            rowBox.add(sencond);
        } else if (this.components.size() == 1) {
            rowBox.add(this.components.get(0));
        } else {
            throw new IllegalArgumentException("");
        }
    }

    private void doLayoutWhenAlignTop(Box rowBox) {
        Component nComponent = null;
        Box vBox = null;
        Component component = null;
        for (int i = 0; i < this.components.size(); ++i) {
            component = this.components.get(i);
            vBox = Box.createVerticalBox();
            vBox.add(component);
            vBox.add(Box.createVerticalGlue());
            rowBox.add(vBox);
            if (i + 1 >= this.components.size()) continue;
            nComponent = this.components.get(i + 1);
            rowBox.add(Box.createHorizontalStrut(this.getGap(component, nComponent)));
        }
    }

    private void doLayoutWhenAlignBottom(Box rowBox) {
        Component component = null;
        Component nexComponent = null;
        Box vvBox = null;
        for (int i = 0; i < this.components.size(); ++i) {
            component = this.components.get(i);
            vvBox = Box.createVerticalBox();
            vvBox.add(Box.createVerticalGlue());
            vvBox.add(component);
            rowBox.add(vvBox);
            if (i + 1 >= this.components.size()) continue;
            nexComponent = this.components.get(i + 1);
            rowBox.add(Box.createHorizontalStrut(this.getGap(component, nexComponent)));
        }
    }

    private void doLayoutWhenAlignCenter(Box rowBox) {
        Component component = null;
        Component nComponent = null;
        for (int i = 0; i < this.components.size(); ++i) {
            component = this.components.get(i);
            rowBox.add(component);
            if (i + 1 >= this.components.size()) continue;
            nComponent = this.components.get(i + 1);
            rowBox.add(Box.createHorizontalStrut(this.getGap(component, nComponent)));
        }
    }

    private int getGap(Component thisComponent, Component nexComponent) {
        return 12;
    }
}

