/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.module.event;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.ui.module.event.EventDetailDialog;
import com.huawei.ism.ui.module.event.EventManager;
import com.huawei.ism.ui.module.event.EventManagerLayout;
import com.huawei.ism.ui.module.event.EventManagerPanel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.KeywordFilterField;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.templets.IsmDialog;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EventManagerFrame
extends IsmDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManagerFrame.class);
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_LEVEL = new Pair<String, String>("COMBOBOX_ITEM_ALL_LEVEL", ResourceManager.getString("EVENT_ALL_LEVEL"));
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_SOURCE = new Pair<String, String>("COMBOBOX_ITEM_ALL_SOURCE", ResourceManager.getString("EVENT_ALL_SOURCE"));
    static final Pair<?, ?> COMBOBOX_ITEM_ALL_DEVICE = new Pair<String, String>("COMBOBOX_ITEM_ALL_DEVICE", ResourceManager.getString("EVENT_ALL_DEVICE"));
    static final Pair<?, ?> COMBOBOX_ITEM_SELECT_SOURCE = new Pair<String, String>("COMBOBOX_ITEM_SELECT_SOURCE", ResourceManager.getString("EVENT_SELECT_SOURCE"));
    static final Pair<?, ?> COMBOBOX_ITEM_SELECT_DEVICE = new Pair<String, String>("COMBOBOX_ITEM_SELECT_DEVICE", ResourceManager.getString("EVENT_SELECT_DEVICE"));
    private static Map<Event.Level, IsmTableCell.IconCell> levelCellMap = new HashMap<Event.Level, IsmTableCell.IconCell>(0);
    private static final long serialVersionUID = 9107016092855552004L;
    private static EventManagerFrame frame = null;
    private boolean isWindowValidBool = true;
    private EventManagerPanel panel = new EventManagerPanel(this);
    private EventManagerLayout eventManagerLayout;
    private Map<String, Set<String>> deviceIDMap = new HashMap<String, Set<String>>(0);
    private static final Object LOCK = new Object();

    public EventManagerFrame(Window parent, EventManagerLayout layout) {
        super(parent);
        this.eventManagerLayout = layout;
    }

    public EventManagerFrame(Frame frame) {
        super((Window)frame, "", IsmDialog.ECommonButton.Close, IsmDialog.ECommonButton.Help);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle(ResourceManager.getString("ALARM_DIALOG_ALARM_MANAGE"));
        this.setDefaultCloseOperation(2);
        this.setIconImage(ResourceManager.getImage("alarm.gif").getImage());
        this.panel.setBorder(null);
        super.addContentPane(this.panel);
        this.setMinimumSize(new Dimension(880, 600));
        EventManager.getInstance().addEventManagerListener(this.panel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                EventManagerFrame.this.panel.remvoeAllTableEvent();
                EventManager.getInstance().removeEventManagerListener(EventManagerFrame.this.panel);
            }
        });
        SwingUtil.setCloseWhenEscKeyPressed(this);
        this.pack();
        SwingUtil.setName(this);
        this.getRootPane().setDefaultButton(this.getButtonBy(IsmDialog.ECommonButton.Close));
    }

    public static void showFrame() {
        EventManagerFrame.showFrame(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showFrame(Event.Level level, String deviceID) {
        Object object = LOCK;
        synchronized (object) {
            if (null == frame || !frame.isVisible()) {
                frame = new EventManagerFrame(Framework.getInstance().getMainFrame());
                EventManagerFrame.syncEventManager(level, deviceID);
            }
            SwingUtil.putScreenCenter(frame);
            frame.getEventManagerPanel().sortTime();
            frame.setVisible(true);
        }
    }

    private static void syncEventManager(final Event.Level level, final String deviceID) {
        AsyncExcutor.execute(new Callable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call() throws Exception {
                Object object = LOCK;
                synchronized (object) {
                    this.dealFrameEventManagerSync();
                    return null;
                }
            }

            private void dealFrameEventManagerSync() {
                if (null != frame) {
                    frame.getEventManagerPanel().synWithEventCache();
                    frame.getEventManagerPanel().setFilter(level, deviceID);
                }
            }
        });
    }

    @Override
    protected String getHelpKey() {
        return "alarm_manage";
    }

    public EventManagerPanel getEventManagerPanel() {
        return this.panel;
    }

    public void setFilter(Event.Level level, String deviceID) {
        Pair item;
        JComboBox deviceComboBox = this.eventManagerLayout.getFaultLayout().getDeviceComboBox();
        if (null == deviceID) {
            deviceComboBox.setSelectedIndex(0);
        } else {
            int size = deviceComboBox.getItemCount();
            item = null;
            for (int i = 0; i < size; ++i) {
                item = (Pair)deviceComboBox.getItemAt(i);
                if (!deviceID.equals(item.getKey())) continue;
                deviceComboBox.setSelectedIndex(i);
                break;
            }
        }
        JComboBox levelComboBox = this.eventManagerLayout.getFaultLayout().getLevelComboBox();
        if (null == level || !level.isFault()) {
            levelComboBox.setSelectedIndex(0);
        } else {
            item = null;
            int size = levelComboBox.getItemCount();
            for (int i = 0; i < size; ++i) {
                item = (Pair)levelComboBox.getItemAt(i);
                if (!level.equals(item.getKey())) continue;
                levelComboBox.setSelectedIndex(i);
                break;
            }
        }
        this.refreshSourceComboBox(this.eventManagerLayout.getFaultLayout().getDeviceComboBox());
        this.updateButtonState();
    }

    public void synWithEventCache() {
        if (!this.isWindowValidBool) {
            return;
        }
        this.eventManagerLayout.getFaultTableModel().removeAll();
        this.fireFaultEventsAdded(EventManager.getInstance().getAllEvents());
        List<String> sourceIDs = EventManager.getInstance().getSourceIDs();
        this.deviceIDMap.clear();
        this.fireSourceAdded(sourceIDs.toArray(new String[sourceIDs.size()]));
    }

    public void fireFaultCleared(Collection<Event> events, Map<Event.Identifier, Long> failedMap) {
        if (!this.isWindowValidBool) {
            return;
        }
        ArrayList<TableRow<Event, Event.Identifier>> tableRows = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        HashMap<String, TimeZone> deviceTimeZone = CommonUtil.getTimeZones();
        TimeZone zone = null;
        TableRow<Event, Event.Identifier> tableRow = null;
        for (Event event : events) {
            if (failedMap.containsKey(event.getIdentifier())) continue;
            zone = deviceTimeZone.get(event.getIdentifier().getDeviceID());
            tableRow = this.convertFaultRow(event, zone);
            tableRows.add(tableRow);
        }
    }

    public void fireSourceAdded(String ... sourceIDs) {
        if (!this.isWindowValidBool) {
            return;
        }
        Launcher launcher = null;
        String deviceID = null;
        boolean hasDevice = false;
        Set<String> sourceIDSet = null;
        Pair<String, String> deviceItem = null;
        String deviceName = null;
        for (String sourceID : sourceIDs) {
            launcher = LauncherManager.getInstance().findDeviceOwner(sourceID);
            if (null == launcher) continue;
            deviceID = launcher.getDeviceID();
            hasDevice = true;
            if (!this.deviceIDMap.containsKey(deviceID)) {
                this.deviceIDMap.put(deviceID, new HashSet(0));
                hasDevice = false;
            }
            if (!(sourceIDSet = this.deviceIDMap.get(deviceID)).contains(sourceID)) {
                sourceIDSet.add(sourceID);
            }
            if (hasDevice) continue;
            deviceName = EventManagerFrame.getDeviceName(deviceID);
            deviceItem = new Pair<String, String>(deviceID, deviceName);
            this.eventManagerLayout.getEventLayout().getDeviceComboBox().addItem(deviceItem);
            this.eventManagerLayout.getFaultLayout().getDeviceComboBox().addItem(deviceItem);
        }
    }

    private void refreshSourceComboBox(JComboBox dc) {
        JComboBox cb = this.eventManagerLayout.getFaultLayout().getSourceComboBox();
        KeywordFilterField kf = this.eventManagerLayout.getFaultLayout().getKeywordFilter();
        Object selObj = cb.getSelectedItem();
        boolean isEventTab = false;
        if (dc == this.eventManagerLayout.getEventLayout().getDeviceComboBox()) {
            isEventTab = true;
            cb = this.eventManagerLayout.getEventLayout().getSourceComboBox();
            kf = this.eventManagerLayout.getEventLayout().getKeywordFilter();
        }
        if (cb.getItemCount() > 1) {
            int len = cb.getItemCount();
            for (int i = 1; i < len; ++i) {
                cb.removeItemAt(1);
            }
        }
        Pair selectItem = (Pair)dc.getSelectedItem();
        ArrayList<String> deviceIDs = new ArrayList<String>(0);
        if (selectItem.equals(COMBOBOX_ITEM_SELECT_DEVICE)) {
            LOGGER.info("COMBOBOX_ITEM_SELECT_DEVICE seleted.");
        } else if (selectItem.equals(COMBOBOX_ITEM_ALL_DEVICE)) {
            deviceIDs.addAll(this.deviceIDMap.keySet());
        } else {
            deviceIDs.add((String)selectItem.getKey());
        }
        String sourceName = null;
        Pair<String, String> item = null;
        for (String deviceID : deviceIDs) {
            for (String sourceID : this.deviceIDMap.get(deviceID)) {
                sourceName = EventManagerFrame.getDeviceName(sourceID);
                item = new Pair<String, String>(sourceID, sourceName);
                cb.addItem(item);
            }
        }
        if (isEventTab && cb.getItemCount() == 2) {
            cb.setSelectedIndex(1);
        } else if (null != selObj) {
            cb.setSelectedItem(selObj);
        }
        kf.updateFilter();
    }

    public void fireClearAllEvents() {
        if (!this.isWindowValidBool) {
            return;
        }
        this.eventManagerLayout.getEventTableModel().removeAll();
    }

    public void fireSourceRemoved(String ... deviceIDs) {
        if (!this.isWindowValidBool) {
            return;
        }
        Pair<String, String> item = null;
        String deviceName = null;
        List<TableRow> rows = null;
        ArrayList<TableRow> rowsToBeDeleted = null;
        Event curEvent = null;
        for (String deviceID : deviceIDs) {
            deviceName = EventManagerFrame.getDeviceName(deviceID);
            item = new Pair<String, String>(deviceID, deviceName);
            this.eventManagerLayout.getEventLayout().getSourceComboBox().removeItem(item);
            this.eventManagerLayout.getFaultLayout().getSourceComboBox().removeItem(item);
            rows = this.eventManagerLayout.getEventTableModel().getAllRows();
            rowsToBeDeleted = new ArrayList<TableRow>(0);
            for (TableRow row : rows) {
                curEvent = (Event)row.getUserObject();
                if (!curEvent.getIdentifier().getDeviceID().equals(deviceID)) continue;
                rowsToBeDeleted.add(row);
            }
            this.eventManagerLayout.getEventTableModel().removeRow(rowsToBeDeleted.toArray(new TableRow[rowsToBeDeleted.size()]));
            this.eventManagerLayout.getFaultTableModel().removeRow(rowsToBeDeleted.toArray(new TableRow[rowsToBeDeleted.size()]));
        }
    }

    public void fireFaultEventsAdded(Collection<Event> events) {
        if (!this.isWindowValidBool) {
            return;
        }
        ArrayList<TableRow<Event, Event.Identifier>> faultToBeAdded = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        HashMap<String, TimeZone> deviceTimeZone = CommonUtil.getTimeZones();
        TimeZone zone = null;
        for (Event event : events) {
            if (!event.getLevel().isFault() || event.isRecovered()) continue;
            zone = deviceTimeZone.get(event.getIdentifier().getDeviceID());
            faultToBeAdded.add(this.convertFaultRow(event, zone));
        }
        this.eventManagerLayout.getFaultTableModel().addRow(faultToBeAdded.toArray(new TableRow[faultToBeAdded.size()]));
        this.setFilter(this.eventManagerLayout.getFaultLayout().getLevelComboBox());
    }

    public void fireEventsAdded(List<Event> events) {
        if (!this.isWindowValidBool) {
            return;
        }
        ArrayList<TableRow<Event, Event.Identifier>> rowList = new ArrayList<TableRow<Event, Event.Identifier>>(0);
        HashMap<String, TimeZone> deviceTimeZone = CommonUtil.getTimeZones();
        TimeZone zone = null;
        for (Event event : events) {
            zone = deviceTimeZone.get(event.getIdentifier().getDeviceID());
            rowList.add(this.convertEventRow(event, zone));
        }
        this.eventManagerLayout.getEventTableModel().addRow(rowList.toArray(new TableRow[rowList.size()]));
        this.setFilter(this.eventManagerLayout.getFaultLayout().getLevelComboBox());
    }

    private void setFilter(JComboBox levelbox) {
        Pair levelFilter;
        int size;
        String deviceId = null;
        JComboBox deviceComboBox = this.eventManagerLayout.getFaultLayout().getDeviceComboBox();
        if (null != deviceComboBox && (size = deviceComboBox.getSelectedIndex()) > 0) {
            Pair item = (Pair)deviceComboBox.getSelectedItem();
            deviceId = (String)item.getKey();
        }
        if (null != (levelFilter = (Pair)levelbox.getModel().getSelectedItem()) && levelFilter != COMBOBOX_ITEM_ALL_LEVEL) {
            Event.Level eventLevel = (Event.Level)((Object)levelFilter.getKey());
            this.setFilter(eventLevel, deviceId);
        }
    }

    public void fireFaultEventUpdated(Collection<Event> events) {
        if (!this.isWindowValidBool) {
            return;
        }
        TimeZone zone = null;
        HashMap<String, TimeZone> deviceTimeZone = CommonUtil.getTimeZones();
        for (Event event : events) {
            if (!event.getLevel().isFault()) continue;
            zone = deviceTimeZone.get(event.getIdentifier().getDeviceID());
            if (!event.isRecovered()) {
                this.eventManagerLayout.getFaultTableModel().updateRow(this.convertFaultRow(event, zone));
                continue;
            }
            this.eventManagerLayout.getFaultTableModel().removeRow(this.convertFaultRow(event, zone));
        }
        this.setFilter(this.eventManagerLayout.getFaultLayout().getLevelComboBox());
    }

    public void fireFaultEventRemoved(Collection<Event> events) {
        if (!this.isWindowValidBool) {
            return;
        }
        ArrayList<DefaultTableRow<Event, Event.Identifier>> faultToBeRemoved = new ArrayList<DefaultTableRow<Event, Event.Identifier>>(0);
        DefaultTableRow<Event, Event.Identifier> row = null;
        for (Event event : events) {
            row = new DefaultTableRow<Event, Event.Identifier>(1, event, event.getIdentifier());
            if (!event.getLevel().isFault() || event.isRecovered()) continue;
            faultToBeRemoved.add(row);
        }
        this.eventManagerLayout.getFaultTableModel().removeRow(faultToBeRemoved.toArray(new TableRow[faultToBeRemoved.size()]));
        this.setFilter(this.eventManagerLayout.getFaultLayout().getLevelComboBox());
    }

    private void updateButtonState() {
        if (this.isFaultTabSelected()) {
            int sourceCount = this.eventManagerLayout.getFaultLayout().getSourceComboBox().getItemCount();
            int markedFaultCount = this.eventManagerLayout.getFaultTable().getSelectedRowCount();
            this.eventManagerLayout.getFaultLayout().getClearButton().setEnabled(markedFaultCount > 0);
            this.eventManagerLayout.getFaultLayout().getSaveButton().setEnabled(markedFaultCount > 0);
            this.eventManagerLayout.getFaultLayout().getRefreshButton().setEnabled(sourceCount > 1);
        } else {
            int sourceindex = this.eventManagerLayout.getEventLayout().getSourceComboBox().getSelectedIndex();
            int markedEventCount = this.eventManagerLayout.getEventTable().getSelectedRowCount();
            this.eventManagerLayout.getEventLayout().getSaveButton().setEnabled(markedEventCount > 0);
            this.eventManagerLayout.getEventLayout().getQueryButton().setEnabled(sourceindex > 0);
        }
    }

    private TableRow<Event, Event.Identifier> convertFaultRow(Event event, TimeZone timeZone) {
        if (null == event) {
            return null;
        }
        int columnCount = EventManagerLayout.getFaultColumnName().length;
        DefaultTableRow<Event, Event.Identifier> tableRow = new DefaultTableRow<Event, Event.Identifier>(columnCount, event, event.getIdentifier());
        String startTime = TimeUtil.gmtToString(event.getStartTime(), timeZone != null ? timeZone : TimeZone.getDefault());
        tableRow.setValueAt(0, EventManagerFrame.getLevelCell(event.getLevel()));
        tableRow.setValueAt(1, EventManagerFrame.getDeviceName(event.getIdentifier().getDeviceID()));
        tableRow.setValueAt(2, new IsmTableCell.HexCell(event.getEventID()));
        tableRow.setValueAt(3, event.getDescription());
        tableRow.setValueAt(4, startTime);
        long sn = event.getIdentifier().getEventSN();
        tableRow.setValueAt(5, new IsmTableCell.NumberCell<Long>(sn));
        String view = ResourceManager.getString("COMMON.TXT.VIEW");
        tableRow.setValueAt(6, new IsmTableCell.HyperlinkCell(view, new ViewActionListener(true)));
        return tableRow;
    }

    private TableRow<Event, Event.Identifier> convertEventRow(Event event, TimeZone zone) {
        if (null == event) {
            return null;
        }
        if (null == EventManagerLayout.getEventColumnName()) {
            throw new NullPointerException();
        }
        int columnCount = EventManagerLayout.getEventColumnName().length;
        DefaultTableRow<Event, Event.Identifier> row = new DefaultTableRow<Event, Event.Identifier>(columnCount, event, event.getIdentifier());
        String startTime = TimeUtil.gmtToString(event.getStartTime(), zone);
        String recoverTime = event.isRecovered() ? TimeUtil.gmtToString(event.getRecoverTime(), zone) : "";
        row.setValueAt(0, EventManagerFrame.getLevelCell(event.getLevel()));
        row.setValueAt(1, EventManagerFrame.getDeviceName(event.getIdentifier().getDeviceID()));
        row.setValueAt(2, new IsmTableCell.HexCell(event.getEventID()));
        row.setValueAt(3, event.getDescription());
        row.setValueAt(4, startTime);
        row.setValueAt(5, recoverTime);
        long sn = event.getIdentifier().getEventSN();
        row.setValueAt(6, new IsmTableCell.NumberCell<Long>(sn));
        String view = ResourceManager.getString("COMMON.TXT.VIEW");
        row.setValueAt(7, new IsmTableCell.HyperlinkCell(view, new ViewActionListener(false)));
        return row;
    }

    private static IsmTableCell.IconCell getLevelCell(Event.Level level) {
        IsmTableCell.IconCell cell = levelCellMap.get((Object)level);
        if (null == cell) {
            String desc = level.toString();
            ImageIcon icon = null;
            switch (level) {
                case CRITICAL: {
                    icon = ResourceManager.getImage("critical.png");
                    break;
                }
                case MAJOR: {
                    icon = ResourceManager.getImage("major.png");
                    break;
                }
                case WARNING: {
                    icon = ResourceManager.getImage("warning.png");
                    break;
                }
                default: {
                    icon = ResourceManager.getImage("info.png");
                }
            }
            cell = new IsmTableCell.IconCell(icon, desc, (Comparable)((Object)level));
            levelCellMap.put(level, cell);
        }
        return cell;
    }

    private static String getDeviceName(String deviceID) {
        return CommonUtil.getDeviceName(deviceID);
    }

    private boolean isFaultTabSelected() {
        return this.eventManagerLayout.getEventTabbedPane().getSelectedIndex() == 0;
    }

    public void sortTime() {
        this.eventManagerLayout.getFaultTable().getRowSorter().toggleSortOrder(4);
        this.eventManagerLayout.getEventTable().getRowSorter().toggleSortOrder(4);
        this.eventManagerLayout.getFaultTable().getRowSorter().toggleSortOrder(4);
        this.eventManagerLayout.getEventTable().getRowSorter().toggleSortOrder(4);
    }

    public boolean isWindowValid() {
        return this.isWindowValidBool;
    }

    public void setWindowValid(boolean isWindowVali) {
        this.isWindowValidBool = isWindowVali;
    }

    private class ViewActionListener
    implements ActionListener {
        private boolean isFaultTabPane;

        public ViewActionListener(boolean isFaultTab) {
            this.isFaultTabPane = isFaultTab;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int row;
            IsmTable source = (IsmTable)actionEvent.getSource();
            TableRow tableRow = null;
            if (this.isFaultTabPane) {
                row = EventManagerFrame.this.eventManagerLayout.getFaultTable().convertRowIndexToModel(source.getCurRolloverRow());
                tableRow = EventManagerFrame.this.eventManagerLayout.getFaultTableModel().getRow(row);
            } else {
                row = EventManagerFrame.this.eventManagerLayout.getEventTable().convertRowIndexToModel(source.getCurRolloverRow());
                tableRow = EventManagerFrame.this.eventManagerLayout.getEventTableModel().getRow(row);
            }
            Event event = (Event)tableRow.getUserObject();
            new EventDetailDialog((Window)EventManagerFrame.this, event).setVisible(true);
        }
    }
}

