/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing;

import com.huawei.ism.util.NetUtil;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

public class URLLinkLabel
extends JLabel {
    private static final long serialVersionUID = 1L;
    private String url;
    private ActionListener action;

    public URLLinkLabel(String text, String url) {
        this(text, url, null);
    }

    public URLLinkLabel(String text, ActionListener action) {
        this(text, null, action);
    }

    public URLLinkLabel(String text, String url, ActionListener action) {
        this.setText(text);
        this.setForeground(new Color(26879));
        this.action = action;
        this.url = url;
        this.addMouseListener(new LinkLabelMouseListener());
    }

    private final class LinkLabelMouseListener
    extends MouseAdapter {
        private LinkLabelMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            URLLinkLabel.this.setCursor(new Cursor(12));
            URLLinkLabel.this.setForeground(new Color(4359891));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            URLLinkLabel.this.setForeground(new Color(26879));
            URLLinkLabel.this.setCursor(new Cursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (null != URLLinkLabel.this.action) {
                URLLinkLabel.this.action.actionPerformed(new ActionEvent(mouseEvent.getSource(), 1001, URLLinkLabel.this.getName()));
            } else if (null != URLLinkLabel.this.url) {
                NetUtil.browseURL(URLLinkLabel.this.url);
            }
            URLLinkLabel.this.setForeground(new Color(26879));
        }
    }
}

