/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.border;

import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class TitleBorderPane
extends JPanel {
    private static final long serialVersionUID = 1020610077812748189L;
    private static final Color TOP_GRADIENT = new Color(15198441);
    private static final int GRADIENT_HEIGHT = 15;
    private TitleBar titleBar;
    private JPanel contentPane;

    public TitleBorderPane() {
        this.doLayoutUI();
    }

    private void doLayoutUI() {
        this.titleBar = new TitleBar();
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setOpaque(false);
        JPanel titlePane = new JPanel(new BorderLayout());
        titlePane.setOpaque(false);
        titlePane.add((Component)this.titleBar, "West");
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.add((Component)titlePane, "North");
        this.add((Component)this.contentPane, "Center");
        this.setBorder(new EmptyBorder(4, 2, 2, 2));
    }

    public void setTitle(String title) {
        this.titleBar.setTitle(title);
        this.titleBar.revalidate();
        this.titleBar.repaint();
    }

    public void appendRightCorner(JComponent component) {
        this.titleBar.appendRightCorner(component);
        this.titleBar.revalidate();
        this.titleBar.repaint();
    }

    public void addTextStylePane(JComponent contentPaneValue) {
        this.contentPane.add(contentPaneValue);
        this.contentPane.setBorder(new EmptyBorder(5, 10, 15, 10));
        this.revalidate();
        this.repaint();
    }

    public void addTableStylePane(JComponent contentPaneValue) {
        this.contentPane.add(contentPaneValue);
        this.contentPane.setBorder(new EmptyBorder(0, 5, 5, 5));
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.titleBar.setEnabled(enabled);
        this.contentPane.setEnabled(enabled);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, TOP_GRADIENT, 0.0f, 15.0f, Color.WHITE, false);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setPaint(gradientPaint);
        g2d.fillRect(2, 3, this.getWidth() - 4, 15);
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        super.paintBorder(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        Color innerColor = UIManager.getColor("Control.borderColor");
        graphics.setColor(innerColor);
        graphics.drawRoundRect(1, 1, width - 3, height - 3, 5, 5);
        Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 15);
        graphics.setColor(outterColor);
        graphics.drawRoundRect(0, 0, width - 1, height - 1, 5, 5);
        graphics.setColor(Color.WHITE);
        graphics.drawLine(4, 2, width - 8, 2);
    }

    private static class TitleBar
    extends ImgsAssembledPane {
        private static final long serialVersionUID = 1070153257336757070L;
        private JPanel titleRightPane;
        private JLabel titleLabel;

        public TitleBar() {
            super(ImgsAssembledPane.Style.HORIZONAL);
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.titleLabel = new JLabel();
            this.titleLabel.setFont(IsmFontFactory.getBold12Font());
            this.titleRightPane = new JPanel(new BorderLayout());
            this.titleRightPane.setOpaque(false);
            JPanel titlePane = new JPanel(new BorderLayout(2, 2));
            titlePane.setOpaque(false);
            titlePane.add((Component)this.titleLabel, "West");
            titlePane.add((Component)this.titleRightPane, "Center");
            titlePane.setBorder(new EmptyBorder(0, 13, 4, 2));
            this.setLayout(new BoxLayout(this, 0));
            this.setOpaque(false);
            this.add(titlePane);
            this.add(Box.createRigidArea(new Dimension(this.getPreferredSize().width, 31)));
        }

        public void setTitle(String title) {
            this.titleLabel.setText(title);
        }

        public void appendRightCorner(Component component) {
            this.titleRightPane.add(component, "Center");
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.titleLabel.setEnabled(enabled);
        }

        @Override
        public ImageIcon getCenterIcon() {
            ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("TitleBorder.centerBG");
            return centerIcon;
        }

        @Override
        public ImageIcon getLeftUPIcon() {
            ImageIcon leftIcon = (ImageIcon)UIManager.getIcon("TitleBorder.leftBG");
            return leftIcon;
        }

        @Override
        public ImageIcon getRightDownIcon() {
            ImageIcon rightIcon = (ImageIcon)UIManager.getIcon("TitleBorder.rightBG");
            return rightIcon;
        }
    }
}

