/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendar;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimeClock
extends JComponent
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private static Color selectColor = new Color(100, 106, 91);
    private TimeZone timezone;
    private Calendar calendar;
    private int[] xLabel = new int[4];
    private int[] yLabel = new int[4];

    public TimeClock(JSpinner time, TimeZone timezone) {
        this.timezone = timezone;
        time.addChangeListener(this);
        this.stateChanged(new ChangeEvent(time));
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner sp = (JSpinner)changeEvent.getSource();
        Date date = (Date)sp.getValue();
        if (this.calendar == null) {
            this.calendar = new GregorianCalendar();
            if (null != this.timezone) {
                this.calendar.setTimeZone(this.timezone);
            }
        }
        this.calendar.setTime(date);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float ox = (float)this.getWidth() / 2.0f;
        float oy = (float)this.getHeight() / 2.0f;
        float rr = 60.0f;
        Ellipse2D.Float oval = new Ellipse2D.Float();
        float i1 = 0.0f;
        float dx = 0.0f;
        float dy = 0.0f;
        for (int i = 0; i < 360; i += 6) {
            i1 = (float)i / 360.0f * (float)Math.PI * 2.0f;
            dx = (float)Math.sin(i1) * 60.0f;
            dy = (float)Math.cos(i1) * 60.0f;
            g2.setColor(i % 30 == 0 ? Color.black : Color.lightGray);
            BigDecimal bd1 = new BigDecimal(ox);
            BigDecimal bd2 = new BigDecimal(dx);
            BigDecimal bd3 = new BigDecimal(1.0);
            BigDecimal bd4 = new BigDecimal(oy);
            BigDecimal bd5 = new BigDecimal(dy);
            oval.setFrame(bd1.subtract(bd2).subtract(bd3).floatValue(), bd4.subtract(bd5).subtract(bd3).floatValue(), 2.0f, 2.0f);
            g2.fill(oval);
            if (i % 30 != 0) continue;
            g2.setColor(selectColor);
            BigDecimal bd7 = new BigDecimal(oy);
            BigDecimal bd8 = new BigDecimal(dy);
            BigDecimal bd9 = new BigDecimal(1.0);
            oval.setFrame(ox + dx - 2.0f, bd7.add(bd8).subtract(bd9).floatValue(), 2.0f, 2.0f);
            g2.fill(oval);
        }
        this.drawHands(g2, ox, oy);
    }

    private void drawHands(Graphics2D g2, float ox, float oy) {
        int hour = this.calendar.get(10);
        int minute = this.calendar.get(12);
        int second = this.calendar.get(13);
        float ha = 0.5235988f * ((float)hour + (float)minute / 60.0f);
        float ma = 0.10471976f * ((float)minute + (float)second / 60.0f);
        float sa = 0.10471976f * (float)second;
        g2.setColor(Color.lightGray);
        g2.translate(1, 1);
        this.drawHand(g2, ox, oy, ha, 40.0f);
        g2.translate(1, 1);
        this.drawHand(g2, ox, oy, ma, 48.0f);
        g2.translate(1, 1);
        this.drawHand(g2, ox, oy, sa, 50.0f, false);
        g2.translate(-3, -3);
        g2.setColor(selectColor);
        this.drawHand(g2, ox, oy, ha, 40.0f);
        this.drawHand(g2, ox, oy, ma, 48.0f);
        g2.setColor(Color.black);
        this.drawHand(g2, ox, oy, sa, 50.0f, false);
    }

    private void drawHand(Graphics2D g2, float ox, float oy, float aa, float len, boolean ww) {
        this.xLabel[2] = (int)(ox + (float)Math.sin(aa) * len);
        this.yLabel[2] = (int)(oy - (float)Math.cos(aa) * len);
        this.xLabel[0] = (int)(ox + (float)Math.sin((double)aa + Math.PI) * 10.0f);
        this.yLabel[0] = (int)(oy - (float)Math.cos((double)aa + Math.PI) * 10.0f);
        if (ww) {
            this.xLabel[1] = (int)(ox + (float)Math.sin((double)aa + 1.5707963267948966) * 3.0f);
            this.yLabel[1] = (int)(oy - (float)Math.cos((double)aa + 1.5707963267948966) * 3.0f);
            this.xLabel[3] = (int)(ox + (float)Math.sin((double)aa + 4.71238898038469) * 3.0f);
            this.yLabel[3] = (int)(oy - (float)Math.cos((double)aa + 4.71238898038469) * 3.0f);
            g2.fillPolygon(this.xLabel, this.yLabel, 4);
        } else {
            Line2D.Float line = new Line2D.Float(this.xLabel[0], this.yLabel[0], this.xLabel[2], this.yLabel[2]);
            g2.draw(line);
        }
    }

    private void drawHand(Graphics2D g2, float ox, float oy, float floatNum, float len) {
        this.drawHand(g2, ox, oy, floatNum, len, true);
    }
}

