/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendarpicker;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.calendarpicker.CalendarPickerInterface;
import com.huawei.ism.ui.swing.calendarpicker.CalendarPickerPopup;
import com.huawei.ism.ui.swing.calendarpicker.DayPickerPane;
import com.huawei.ism.ui.swing.calendarpicker.LabelButton;
import com.huawei.ism.ui.swing.calendarpicker.TimePickerPane;
import com.huawei.ism.util.CommonUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

class CalendarPickerPane
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private int cSelectYear;
    private int cSelectMonth;
    private CalendarPickerPopup cPopup;
    private YearMonthPicker yearMonthPicker = null;
    private DayPickerPane dayPicker = null;
    private TimePickerPane timePicker = null;
    private Timer timer = new Timer(60, this);
    private Dimension paneSize = new Dimension(210, 275);
    private Dimension noTimePaneSize = new Dimension(210, 245);
    private boolean showTimeField = true;
    private float alpha = 0.1f;
    private int year;
    private int month;
    private int grayYear;
    private int grayMonth;
    private boolean enabledFrontCalendar;
    private transient CalendarPickerInterface cp = null;
    private String[] monthStrs = new String[]{ResourceManager.getString("MONTH_JANUARY"), ResourceManager.getString("MONTH_JANUARY"), ResourceManager.getString("MONTH_FEBRUARY"), ResourceManager.getString("MONTH_MARCH"), ResourceManager.getString("MONTH_APRIL"), ResourceManager.getString("MONTH_MAY"), ResourceManager.getString("MONTH_JUNE"), ResourceManager.getString("MONTH_JULY"), ResourceManager.getString("MONTH_AUGUST"), ResourceManager.getString("MONTH_SEPERTEMBER"), ResourceManager.getString("MONTH_OCTOBER"), ResourceManager.getString("MONTH_NOVEMBER"), ResourceManager.getString("MONTH_DECEMBER")};

    public CalendarPickerPane(CalendarPickerPopup cPopup) {
        this.cPopup = cPopup;
        this.timer.start();
        this.doLayoutUI();
    }

    private void doLayoutUI() {
        this.createComponents();
        this.addHandler();
        Calendar cal = Calendar.getInstance();
        this.resetLayout(cal, cal, false, true);
    }

    public void reset(Calendar cal, Calendar selectCal, boolean showTimeFielded, boolean enabledFrontedCalendar) {
        this.alpha = 0.1f;
        this.timer.start();
        this.resetLayout(cal, selectCal, showTimeFielded, enabledFrontedCalendar);
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g2d = CommonUtil.convertObject(graphics, Graphics2D.class);
        g2d.setComposite(AlphaComposite.getInstance(3, this.alpha));
        super.paint(g2d);
    }

    public void addCallBackListener(CalendarPickerInterface cpif) {
        this.cp = cpif;
    }

    private void createComponents() {
        Calendar cal = Calendar.getInstance();
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.yearMonthPicker = new YearMonthPicker();
        this.yearMonthPicker.monthYearLabel.setText(this.getString(this.month + 1, this.year));
        this.dayPicker = new DayPickerPane(cal);
        this.timePicker = new TimePickerPane(cal);
    }

    private void resetLayout(Calendar cCal, Calendar selectCal, boolean showTimeFielded, boolean enabledFrontedCalendar) {
        this.grayYear = cCal.get(1);
        this.grayMonth = cCal.get(2);
        this.enabledFrontCalendar = enabledFrontedCalendar;
        this.showTimeField = showTimeFielded;
        this.year = selectCal.get(1);
        this.month = selectCal.get(2);
        this.yearMonthPicker.monthYearLabel.setText(this.getString(this.month + 1, this.year));
        this.dayPicker.resetLayout(cCal, selectCal, showTimeFielded, enabledFrontedCalendar);
        this.timePicker.resetLayout(selectCal, showTimeFielded);
        this.validateFrontCal();
        this.layoutComponents();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.alpha = (float)((double)this.alpha + 0.1);
        if (this.alpha >= 1.0f) {
            this.alpha = 1.0f;
            this.timer.stop();
        }
        this.repaint();
    }

    private void layoutComponents() {
        this.removeAll();
        if (this.showTimeField) {
            this.setPreferredSize(this.paneSize);
        } else {
            this.setPreferredSize(this.noTimePaneSize);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.yearMonthPicker, "North");
        this.add((Component)this.dayPicker, "Center");
        if (this.showTimeField) {
            this.add((Component)this.timePicker, "South");
        }
    }

    private void validateFrontCal() {
        if (!this.enabledFrontCalendar) {
            if (this.year - this.grayYear == 1 && this.month - this.grayMonth >= 0 || this.year - this.grayYear > 1) {
                this.yearMonthPicker.leftYearButton.setEnabled(true);
            } else {
                this.yearMonthPicker.leftYearButton.setEnabled(false);
            }
            if (this.grayMonth >= this.month && this.grayYear >= this.year) {
                this.yearMonthPicker.leftMonthButton.setEnabled(false);
            } else {
                this.yearMonthPicker.leftMonthButton.setEnabled(true);
            }
        }
    }

    private void addHandler() {
        this.yearMonthPicker.rightMonthButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ArrowLabel iconButton = (ArrowLabel)mouseEvent.getSource();
                if (iconButton.isEnabled()) {
                    CalendarPickerPane.this.nextMonth();
                    CalendarPickerPane.this.validateFrontCal();
                }
            }
        });
        this.yearMonthPicker.leftMonthButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ArrowLabel iconButton = (ArrowLabel)mouseEvent.getSource();
                if (iconButton.isEnabled()) {
                    CalendarPickerPane.this.previousMonth();
                    CalendarPickerPane.this.validateFrontCal();
                }
            }
        });
        this.yearMonthPicker.rightYearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ArrowLabel iconButton = (ArrowLabel)mouseEvent.getSource();
                if (iconButton.isEnabled()) {
                    CalendarPickerPane.this.nextYear();
                    CalendarPickerPane.this.validateFrontCal();
                }
            }
        });
        this.yearMonthPicker.leftYearButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ArrowLabel iconButton = (ArrowLabel)mouseEvent.getSource();
                if (iconButton.isEnabled()) {
                    CalendarPickerPane.this.previousYear();
                    CalendarPickerPane.this.validateFrontCal();
                }
            }
        });
        this.timePicker.getOkButton().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                CalendarPickerPane.this.callBackMethod();
                CalendarPickerPane.this.validateFrontCal();
            }
        });
        this.addDaysHandler();
    }

    private void addDaysHandler() {
        LabelButton[] labelDays = this.dayPicker.getDays();
        for (int i = 1; i <= 31; ++i) {
            labelDays[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    LabelButton button = (LabelButton)mouseEvent.getSource();
                    if (button.isEnabled() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        CalendarPickerPane.this.callBackMethod();
                    }
                }
            });
        }
    }

    private void callBackMethod() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.cSelectYear, this.cSelectMonth - 1, this.dayPicker.getCSelectDay(), this.timePicker.getHour(), this.timePicker.getMinute(), this.timePicker.getSecond());
        this.cp.callback(calendar);
        this.cPopup.setVisible(false);
    }

    private void nextMonth() {
        GregorianCalendar cal = new GregorianCalendar(this.year, this.month, 1);
        ((Calendar)cal).add(2, 1);
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.yearMonthPicker.monthYearLabel.setText(this.getString(this.month + 1, this.year));
        this.dayPicker.layoutComponents(cal);
    }

    private void previousMonth() {
        GregorianCalendar cal = new GregorianCalendar(this.year, this.month, 1);
        ((Calendar)cal).add(2, -1);
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.yearMonthPicker.monthYearLabel.setText(this.getString(this.month + 1, this.year));
        this.dayPicker.layoutComponents(cal);
    }

    private void nextYear() {
        GregorianCalendar cal = new GregorianCalendar(this.year, this.month, 1);
        ((Calendar)cal).add(1, 1);
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.yearMonthPicker.monthYearLabel.setText(this.getString(this.month + 1, this.year));
        this.dayPicker.layoutComponents(cal);
    }

    private void previousYear() {
        GregorianCalendar cal = new GregorianCalendar(this.year, this.month, 1);
        ((Calendar)cal).add(1, -1);
        this.year = cal.get(1);
        this.month = cal.get(2);
        this.yearMonthPicker.monthYearLabel.setText(this.getString(this.month + 1, this.year));
        this.dayPicker.layoutComponents(cal);
    }

    private String getString(int calendarMonth, int calendarYear) {
        this.cSelectYear = calendarYear;
        this.cSelectMonth = calendarMonth;
        StringBuilder sb = new StringBuilder();
        sb.append(this.monthStrs[calendarMonth]);
        if (ResourceManager.getLocale().getLanguage().equals("en")) {
            sb.append(" " + calendarYear);
        } else {
            sb.append(',').append(calendarYear).append(ResourceManager.getString("YEAR"));
        }
        return sb.toString();
    }

    private static class ArrowLabel
    extends JLabel {
        private static final long serialVersionUID = -7201544516945586181L;
        private Icon icon;
        private Icon overIcon;
        private Icon grayIcon;

        public ArrowLabel(Icon icon, Icon overIcon, Icon grayIcon) {
            this.icon = icon;
            this.overIcon = overIcon;
            this.grayIcon = grayIcon;
            this.setIcon();
            this.addHandler();
        }

        private void addHandler() {
            this.addMouseListener(new MouseAdapterImpl());
        }

        @Override
        public void setEnabled(boolean enabled) {
            if (enabled) {
                this.setIcon(this.icon);
            } else {
                this.setIcon(this.grayIcon);
            }
            super.setEnabled(enabled);
        }

        private void setIcon() {
            this.setIcon(this.icon);
        }

        private void setOverIcon() {
            this.setIcon(this.overIcon);
        }

        private class MouseAdapterImpl
        extends MouseAdapter {
            private MouseAdapterImpl() {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ArrowLabel iconButton = (ArrowLabel)mouseEvent.getSource();
                if (iconButton.isEnabled()) {
                    ArrowLabel.this.setCursor(new Cursor(12));
                    ArrowLabel.this.setOverIcon();
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ArrowLabel iconButton = (ArrowLabel)mouseEvent.getSource();
                if (iconButton.isEnabled()) {
                    ArrowLabel.this.setCursor(new Cursor(0));
                    ArrowLabel.this.setIcon();
                }
            }
        }
    }

    private static class YearMonthPicker
    extends JPanel {
        private static final long serialVersionUID = 8794666179125811861L;
        private ArrowLabel leftYearButton = null;
        private JLabel monthYearLabel = null;
        private ArrowLabel rightYearButton = null;
        private ArrowLabel leftMonthButton = null;
        private ArrowLabel rightMonthButton = null;

        public YearMonthPicker() {
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.createComponents();
            this.layoutComponents();
        }

        private void createComponents() {
            this.leftYearButton = new ArrowLabel(UIManager.getIcon("DatePicker.LeftYearArraw"), UIManager.getIcon("DatePicker.LeftYearArrawOver"), UIManager.getIcon("DatePicker.LeftYearArrawGray"));
            this.leftYearButton.setPreferredSize(new Dimension(18, 10));
            this.leftYearButton.setName("CalendarPickerPane.LeftYearButton");
            this.rightYearButton = new ArrowLabel(UIManager.getIcon("DatePicker.RightYearArraw"), UIManager.getIcon("DatePicker.RightYearArrawOver"), UIManager.getIcon("DatePicker.RightYearArrawGray"));
            this.rightYearButton.setPreferredSize(new Dimension(18, 10));
            this.rightYearButton.setName("CalendarPickerPane.RightYearButton");
            this.leftMonthButton = new ArrowLabel(UIManager.getIcon("DatePicker.LeftMonthArraw"), UIManager.getIcon("DatePicker.LeftMonthArrawOver"), UIManager.getIcon("DatePicker.LeftMonthArrawGray"));
            this.leftMonthButton.setPreferredSize(new Dimension(18, 10));
            this.leftMonthButton.setName("CalendarPickerPane.LeftMonthButton");
            this.rightMonthButton = new ArrowLabel(UIManager.getIcon("DatePicker.RightMonthArraw"), UIManager.getIcon("DatePicker.RightMonthArrawOver"), UIManager.getIcon("DatePicker.RightMonthArrawGray"));
            this.rightMonthButton.setPreferredSize(new Dimension(18, 10));
            this.rightMonthButton.setName("CalendarPickerPane.RightMonthButton");
            this.monthYearLabel = new JLabel("", 0);
            this.monthYearLabel.setPreferredSize(new Dimension(80, 21));
        }

        private void layoutComponents() {
            this.add(this.leftYearButton);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.leftMonthButton);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.monthYearLabel);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.rightMonthButton);
            this.add(Box.createHorizontalStrut(1));
            this.add(this.rightYearButton);
        }
    }
}

