/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.calendarpicker;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.calendarpicker.LabelButton;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;

class DayPickerPane
extends JPanel {
    private static final long serialVersionUID = -5248782230139788341L;
    private int selectYear;
    private int selectMonth;
    private int selectDay;
    private int cYear;
    private int cMonth;
    private int cDay;
    private boolean enabledFrontCalendar = true;
    private JLabel[] weeks = null;
    private boolean showTimeField;
    private int month;
    private LabelButton[] days = null;
    private int cSelectDay;
    private String[] weekTitle = new String[]{ResourceManager.getString("WEEK_SUNDAY"), ResourceManager.getString("WEEK_MONDAY"), ResourceManager.getString("WEEK_TUESDAY"), ResourceManager.getString("WEEK_WEDNESDAY"), ResourceManager.getString("WEEK_THURSDAY"), ResourceManager.getString("WEEK_FRIDAY"), ResourceManager.getString("WEEK_SATURDAY")};

    public DayPickerPane(Calendar cal) {
        this.doLayoutUI(cal);
        this.addHandler();
    }

    private void doLayoutUI(Calendar cal) {
        this.createComponents();
        this.resetLayout(cal, cal, true, true);
    }

    private void createComponents() {
        int i;
        this.weeks = new JLabel[7];
        boolean isLeftBorder = false;
        for (i = 0; i < 7; ++i) {
            this.weeks[i] = new JLabel(this.weekTitle[i], 0);
            this.weeks[i].setOpaque(true);
            isLeftBorder = i != 0;
            this.weeks[i].setBorder(new HeadLabelBorder(isLeftBorder));
            this.weeks[i].setBackground(IsmPlafUtils.mixAlpha(Color.BLACK, 20));
        }
        this.days = new LabelButton[32];
        for (i = 1; i <= 31; ++i) {
            this.days[i] = new LabelButton("" + i, 0);
        }
    }

    private void addHandler() {
        for (int i = 1; i <= 31; ++i) {
            this.days[i].addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    LabelButton button = (LabelButton)mouseEvent.getSource();
                    if (button.isEnabled()) {
                        DayPickerPane.this.resetDaysBackground();
                        LabelButton labelButton = (LabelButton)mouseEvent.getSource();
                        DayPickerPane.this.cSelectDay = Integer.parseInt(labelButton.getText());
                        labelButton.setPressed();
                    }
                }
            });
        }
    }

    private void resetDaysBackground() {
        for (int i = 1; i <= 31; ++i) {
            this.days[i].setExited();
        }
    }

    private void resetDays() {
        for (int i = 1; i <= 31; ++i) {
            this.days[i].reset();
        }
    }

    public void resetLayout(Calendar cCal, Calendar selectCal, boolean showTimeFieldTemp, boolean enabledFrontCalendarTemp) {
        this.showTimeField = showTimeFieldTemp;
        this.enabledFrontCalendar = enabledFrontCalendarTemp;
        this.selectYear = selectCal.get(1);
        this.selectMonth = selectCal.get(2);
        this.selectDay = selectCal.get(5);
        this.cYear = cCal.get(1);
        this.cMonth = cCal.get(2);
        this.cDay = cCal.get(5);
        this.layoutComponents(selectCal);
    }

    public void layoutComponents(Calendar calendar) {
        this.removeAll();
        this.resetDays();
        int year = calendar.get(1);
        this.month = calendar.get(2);
        calendar.set(5, 1);
        calendar.add(2, 1);
        calendar.add(5, -1);
        this.setLayout(new GridLayout(7, 7));
        calendar.set(5, 1);
        int weekday = calendar.get(7);
        calendar.add(5, 1 - weekday);
        LabelButton tmpLabel = null;
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (i == 0) {
                    this.add(this.weeks[j]);
                    continue;
                }
                tmpLabel = calendar.get(2) == this.month ? this.days[calendar.get(5)] : new LabelButton("");
                this.setLabelButtonBorder(tmpLabel, i, j);
                if (j == 0) {
                    tmpLabel.setForeground(UIManager.getColor("IsmButton.defaultBorderColor"));
                    tmpLabel.setDefualtForeground(UIManager.getColor("IsmButton.defaultBorderColor"));
                }
                if (year == this.selectYear && this.month == this.selectMonth && calendar.get(5) == this.selectDay) {
                    tmpLabel.setBackground(Color.LIGHT_GRAY);
                    tmpLabel.setForeground(Color.WHITE);
                    tmpLabel.setFont(IsmFontFactory.getDialogBold());
                    tmpLabel.setDefualtBackground(Color.LIGHT_GRAY);
                    this.cSelectDay = this.selectDay;
                }
                if (!this.enabledFrontCalendar && year <= this.cYear && this.month <= this.cMonth && calendar.get(5) < this.cDay) {
                    tmpLabel.setEnabled(false);
                }
                this.add(tmpLabel);
                calendar.add(5, 1);
            }
        }
    }

    public int getCSelectDay() {
        return this.cSelectDay;
    }

    public void setCSelectDay(int selectDayValue) {
        this.cSelectDay = selectDayValue;
    }

    public LabelButton[] getDays() {
        return this.days;
    }

    public void setDays(LabelButton[] days) {
        this.days = days;
    }

    private void setLabelButtonBorder(LabelButton tmpLabel, int i, int j) {
        if (this.showTimeField) {
            if (i == 6 && j != 0) {
                tmpLabel.setBorder(new BodyLabelBorder(true, true));
            } else if (i == 6) {
                tmpLabel.setBorder(new BodyLabelBorder(false, true));
            } else if (j == 0) {
                tmpLabel.setBorder(new BodyLabelBorder(false, false));
            } else {
                tmpLabel.setBorder(new BodyLabelBorder(true, false));
            }
        } else {
            this.setLabelButtonBorderByNoShowTime(tmpLabel, i, j);
        }
    }

    private void setLabelButtonBorderByNoShowTime(LabelButton tmpLabel, int i, int j) {
        if (i == 6 && j != 0) {
            tmpLabel.setBorder(new BodyLabelBorder(true, false));
        } else if (i == 6) {
            tmpLabel.setBorder(new BodyLabelBorder(false, false));
        } else if (j == 0) {
            tmpLabel.setBorder(new BodyLabelBorder(false, false));
        } else {
            tmpLabel.setBorder(new BodyLabelBorder(true, false));
        }
    }

    private static class HeadLabelBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -6561724735516172063L;
        private boolean leftLine = false;

        public HeadLabelBorder(boolean leftLine) {
            this.leftLine = leftLine;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 50);
            graphics.setColor(outterColor);
            graphics.fillRect(xx, yy, width, 1);
            outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 30);
            graphics.setColor(outterColor);
            graphics.fillRect(xx, yy + 1, width, 1);
            outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 10);
            graphics.setColor(outterColor);
            graphics.fillRect(xx, yy + 2, width, 1);
            if (this.leftLine) {
                graphics.fillRect(xx, yy, 1, height);
            }
        }
    }

    private static class BodyLabelBorder
    extends AbstractBorder {
        private static final long serialVersionUID = -6561724654216172063L;
        private boolean leftLine = false;
        private boolean bottomLine = false;

        public BodyLabelBorder(boolean leftLine, boolean bottomLine) {
            this.leftLine = leftLine;
            this.bottomLine = bottomLine;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            Color outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 50);
            graphics.setColor(outterColor);
            graphics.fillRect(xx, yy, width, 1);
            if (this.leftLine) {
                graphics.fillRect(xx, yy, 1, height);
            }
            if (this.bottomLine) {
                outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 50);
                graphics.setColor(outterColor);
                graphics.fillRect(xx, yy + height - 1, width, 1);
                outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 30);
                graphics.setColor(outterColor);
                graphics.fillRect(xx, yy + height - 2, width, 1);
                outterColor = IsmPlafUtils.mixAlpha(Color.BLACK, 10);
                graphics.setColor(outterColor);
                graphics.fillRect(xx, yy + height - 3, width, 1);
            }
        }
    }
}

