/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.control;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class ToolBarButton
extends JButton {
    private static final long serialVersionUID = 7442391517617621616L;
    private static final String TOOLBAR_BUTTON_ID = "IsmToolBarButtonUI";

    public ToolBarButton(Action action) {
        super(action);
        if (IsmPlafUtils.isUnifyStyle()) {
            this.setBorderPainted(false);
            this.addMouseListener(new MouseHandler());
        }
    }

    public ToolBarButton(ImageIcon icon, Dimension size, String tooltip) {
        super(icon);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
        this.setMinimumSize(size);
        this.setToolTipText(tooltip);
        if (IsmPlafUtils.isUnifyStyle()) {
            this.setBorderPainted(false);
            this.addMouseListener(new MouseHandler());
        }
    }

    public ToolBarButton(Icon icon) {
        super(icon);
        if (IsmPlafUtils.isUnifyStyle()) {
            this.setBorderPainted(false);
            this.addMouseListener(new MouseHandler());
        }
    }

    @Override
    public String getUIClassID() {
        return TOOLBAR_BUTTON_ID;
    }

    private static class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JButton button = (JButton)mouseEvent.getComponent();
            button.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JButton button = (JButton)mouseEvent.getComponent();
            button.setCursor(Cursor.getDefaultCursor());
        }
    }
}

