/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.listener.FieldDocumentListener;
import com.huawei.ism.ui.swing.text.PlaceHolderInputField;
import com.huawei.ism.util.UCD;
import java.awt.FlowLayout;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputConfirmPanel
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(InputConfirmPanel.class);
    private final JTextField inputField;
    private final String confirmInfo;
    private final List<JComponent> visibleComponent;

    public InputConfirmPanel(String labelInfo, String confirmInfo, List<JComponent> visibleComponent) {
        this.visibleComponent = visibleComponent;
        this.disableComponent();
        this.inputField = new PlaceHolderInputField(ResourceManager.getStringWithParams("input.info.to.confirm", confirmInfo));
        JLabel label = new JLabel(labelInfo);
        this.confirmInfo = confirmInfo;
        this.initActionListener();
        Box jComponent = UCD.buildHBoxLeft(8, new JLabel(ResourceManager.getStringWithParams("input.info.to.confirm", confirmInfo)), this.inputField);
        this.add(UCD.buildVerticalBox(null, 8, UCD.buildHBoxLeft(label), UCD.buildHorizontalBoxLeft(jComponent)));
        this.setLayout(new FlowLayout(0));
    }

    private void initActionListener() {
        this.inputField.getDocument().addDocumentListener(new FieldDocumentListener(this::enableComponentIfInput));
    }

    private void enableComponentIfInput(String input) {
        if (StringUtils.isNULLStr((String)input)) {
            this.disableComponent();
            return;
        }
        if (!input.equalsIgnoreCase(this.confirmInfo)) {
            this.disableComponent();
            return;
        }
        this.enableComponent();
    }

    private void enableComponent() {
        this.visibleComponent.forEach(component -> component.setEnabled(true));
    }

    private void disableComponent() {
        this.visibleComponent.forEach(component -> component.setEnabled(false));
    }

    public JTextField getInputField() {
        return this.inputField;
    }
}

