/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.dialog;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.DialogsConstants;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.text.IsmTextField;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import com.huawei.ism.util.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import org.apache.commons.lang3.StringUtils;

public class SftpInputPassWordDialog
extends JDialog
implements DialogsConstants {
    private static final String PASSWD_FAULT = new IsmException(1073949186L).getErrorMessage();
    private static SftpInputPassWordDialog instance = null;
    private static final long serialVersionUID = 8635228456353555320L;
    private JButton confirmButton;
    private JButton cancelButton;
    private JButton helpButton;
    private IsmPasswordField passwordField;
    private IsmTextField userNameTextField;
    private JLabel promptMesLable;
    private String passWord;
    private int faultTimes;
    private boolean autoCheck = true;
    private String promptMess = ResourceManager.getString("DISCOVERY_DIALOG_NULL_USER_PASSWORD");

    private SftpInputPassWordDialog(Window window) {
        super(window);
        this.setTitle(ResourceManager.getString("INPUT_USER_INFO_TITLE"));
        this.initComponent();
        this.doUILayout();
        this.setDefaultCloseOperation(2);
        this.initButtonEvent();
        this.setResizable(false);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.confirmButton);
        HelpManager.getInstance().linkHelp((AbstractButton)this.helpButton, "find_array");
        SwingUtil.setName(this);
        this.pack();
        this.toFront();
        this.setCompName();
        SwingUtil.putParentCenter(this, window);
        this.addWindowListener(new MyWindowListener());
    }

    public static SftpInputPassWordDialog getInstance(Window window, String userName) {
        if (null == instance) {
            instance = new SftpInputPassWordDialog(window);
        }
        return instance;
    }

    public void setPrompt(String prompt) {
        this.promptMess = prompt;
        this.promptMesLable.setText(prompt + ":");
    }

    private void initComponent() {
        this.userNameTextField = IsmTextField.getNameTextField("^[a-zA-Z][0-9a-zA-Z_]*", "", 32, 20);
        this.passwordField = new IsmPasswordField(4, 32);
        this.passwordField.setColumns(16);
        this.passwordField.getPasswordPopupInfo().removeAllInform();
        this.promptMesLable = new JLabel(ResourceManager.getString("CHAP_PASSWORD"));
        this.passwordField.requestFocus();
        this.confirmButton = new JButton(ResourceManager.getString("WARNING_DIALOG_CONFIRM"));
        this.confirmButton.setMnemonic('O');
        this.cancelButton = new JButton(ResourceManager.getString("WARNING_DIALOG_CANNEL"));
        this.cancelButton.setMnemonic('C');
        this.helpButton = new JButton(ResourceManager.getString("WizardDialog.HELP"));
        this.helpButton.setMnemonic('H');
    }

    public void setUserInfo(String userName, String passWordTemp) {
        this.userNameTextField.setText(userName);
        this.faultTimes = 0;
        this.passwordField.setText("");
        this.passWord = passWordTemp;
        this.passwordField.requestFocus();
    }

    public String getUserName() {
        return this.userNameTextField.getText();
    }

    public String getPasswd() {
        return Utils.getStringValueOfPassordFiled(this.passwordField);
    }

    @Override
    public String getName() {
        return this.userNameTextField.getText();
    }

    private void initButtonEvent() {
        this.confirmButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SftpInputPassWordDialog.this.confimButtonAction(actionEvent);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SftpInputPassWordDialog.this.cancelButtonAction(actionEvent);
            }
        });
    }

    public JButton getCancelBtn() {
        return this.cancelButton;
    }

    public void setAutoCheck(boolean autoCheck) {
        this.autoCheck = autoCheck;
    }

    private void confimButtonAction(ActionEvent actionEvent) {
        String name = this.userNameTextField.getText();
        String password = Utils.getStringValueOfPassordFiled(this.passwordField);
        if (StringUtils.isEmpty((CharSequence)name)) {
            DialogUtils.showErrorDialog(this, this.promptMess);
            this.userNameTextField.requestFocus();
            return;
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            DialogUtils.showErrorDialog(this, this.promptMess);
            this.passwordField.requestFocus();
            return;
        }
        if (!this.passwordField.checkLength()) {
            return;
        }
        if (this.autoCheck) {
            ++this.faultTimes;
            String inputPassWord = AESEncrypt.encrypt((String)Utils.getStringValueOfPassordFiled(this.passwordField));
            if (this.faultTimes < 3 && !inputPassWord.equals(this.passWord)) {
                DialogUtils.showErrorDialog(this, PASSWD_FAULT);
                this.passwordField.requestFocus();
                return;
            }
        }
        this.setVisible(false);
    }

    private void cancelButtonAction(ActionEvent e) {
        this.faultTimes = 0;
        this.passwordField.setText("");
        this.setVisible(false);
    }

    protected void doUILayout() {
        this.setDefaultCloseOperation(2);
        JPanel wholePanel = new JPanel();
        wholePanel.setLayout(new BoxLayout(wholePanel, 1));
        Box left = Box.createVerticalBox();
        left.add(new JLabel(ResourceManager.getString("LOGIN_DIALOG_USER_NAME")));
        left.add(Box.createVerticalStrut(12));
        left.add(this.promptMesLable);
        left.add(Box.createVerticalStrut(12));
        Box right = Box.createVerticalBox();
        right.add(UCD.buildHorizontalBoxLeft(this.userNameTextField));
        right.add(Box.createVerticalStrut(12));
        right.add(this.passwordField);
        right.add(Box.createVerticalStrut(12));
        Box centerBox = Box.createHorizontalBox();
        centerBox.add(left);
        centerBox.add(Box.createHorizontalStrut(12));
        centerBox.add(right);
        centerBox.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(12, 12, 0, 12)));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.confirmButton);
        buttonPanel.add(Box.createHorizontalStrut(6));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(6));
        buttonPanel.add(this.helpButton);
        JSeparator separator = new JSeparator();
        if (IsmPlafUtils.getLAFStyle() == IsmPlafUtils.LAFStyle.armor) {
            separator = new MyArmorSeparator();
        }
        Box totalBox = Box.createVerticalBox();
        totalBox.add(centerBox);
        totalBox.add(Box.createVerticalStrut(12));
        totalBox.add(separator);
        totalBox.add(Box.createVerticalStrut(12));
        wholePanel.add((Component)totalBox, "Center");
        wholePanel.add((Component)buttonPanel, "South");
        wholePanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)wholePanel, "Center");
    }

    private void setCompName() {
        this.confirmButton.setName("_Button_confirmButton");
        this.cancelButton.setName("_Button_cancelButton");
        this.helpButton.setName("_Button_helpButton");
        this.passwordField.setName("_TextField_passwordField");
        this.userNameTextField.setName("_TextField_userNameTextField");
    }

    private class MyWindowListener
    implements WindowListener {
        private MyWindowListener() {
        }

        @Override
        public void windowActivated(WindowEvent arg0) {
        }

        @Override
        public void windowClosed(WindowEvent arg0) {
            SftpInputPassWordDialog.this.userNameTextField.setText("");
            SftpInputPassWordDialog.this.passwordField.setText("");
        }

        @Override
        public void windowClosing(WindowEvent arg0) {
            SftpInputPassWordDialog.this.userNameTextField.setText("");
            SftpInputPassWordDialog.this.passwordField.setText("");
        }

        @Override
        public void windowDeactivated(WindowEvent arg0) {
        }

        @Override
        public void windowDeiconified(WindowEvent arg0) {
        }

        @Override
        public void windowIconified(WindowEvent arg0) {
        }

        @Override
        public void windowOpened(WindowEvent arg0) {
        }
    }

    private static final class MyArmorSeparator
    extends JSeparator {
        private static final long serialVersionUID = -6149201948604054011L;

        private MyArmorSeparator() {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xCECECE));
            graphics.drawLine(0, 0, this.getWidth(), 0);
            graphics.setColor(Color.WHITE);
            graphics.drawLine(0, 1, this.getWidth(), 1);
        }
    }
}

