/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;

public final class IsmBorders {
    public static final int SHADOW_PIXEL_NUM = 4;
    private static Border menuBarBorder;
    private static Border textFieldBorder;
    private static Border popupMenuBorder;
    private static Border comboBoxBorder;

    public static Border getRolloverButtonButton(boolean drawArrow) {
        if (drawArrow) {
            return new BorderUIResource.CompoundBorderUIResource(new RolloverButtonBorder(), new EmptyBorder(0, 7, 0, 15));
        }
        return new BorderUIResource.CompoundBorderUIResource(new RolloverButtonBorder(), new EmptyBorder(0, 7, 0, 7));
    }

    public static Border getScrollPaneBorder() {
        return new ScrollPaneBorder(1, false);
    }

    public static Border getSplitPaneDividerBorder() {
        SplitPaneDividerBorder splitPaneBorder = new SplitPaneDividerBorder();
        return splitPaneBorder;
    }

    public static Border getSplitPaneBorder() {
        SplitPaneBorder splitPaneBorder = new SplitPaneBorder();
        return splitPaneBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BorderUIResource.EmptyBorderUIResource(0, 2, 0, 0));
        }
        return textFieldBorder;
    }

    public static Border getTableHeaderBorder() {
        return new TableHeaderBorder();
    }

    public static Border getComboBoxBorder() {
        if (comboBoxBorder == null) {
            comboBoxBorder = new BorderUIResource.CompoundBorderUIResource(new TextFieldBorder(), new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0));
        }
        return comboBoxBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = new IsmPopupMenuBorder();
        }
        return popupMenuBorder;
    }

    public static Border getMenuBarBorder() {
        if (menuBarBorder == null) {
            menuBarBorder = new IsmMenuBarBorder();
        }
        return menuBarBorder;
    }

    public static Border getShadowBorder(BufferedImage backgroundImage) {
        return new ShadowBorder(backgroundImage);
    }

    public static Border getButtonBorder(boolean isRound) {
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(isRound), new MarginBorder());
    }

    public static Border getToolBarButtonBorder(boolean isRound) {
        return new BorderUIResource.CompoundBorderUIResource(new ButtonBorder(isRound), new EmptyBorder(0, 2, 0, 2));
    }

    public static Border getToolBarBorder() {
        return new IsmToolBarBorder();
    }

    public static class ScrollPaneBorder
    extends LineBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;

        public ScrollPaneBorder(int thickness, boolean roundedCorners) {
            super(Color.RED, thickness, roundedCorners);
        }

        @Override
        public void paintBorder(Component component1, Graphics graphics, int xx, int yy, int width, int height) {
            Color oldColor = graphics.getColor();
            JScrollPane sp = null;
            if (!(component1 instanceof JScrollPane)) {
                return;
            }
            sp = (JScrollPane)component1;
            Component component = sp.getViewport().getView();
            String lineColorKey = "ScrollPane.borderColor_disable";
            if (null != component) {
                lineColorKey = Optional.ofNullable(sp).map(JScrollPane::getViewport).map(JViewport::getView).map(Component::isEnabled).orElse(false) != false ? "ScrollPane.borderColor" : "ScrollPane.borderColor_disable";
            }
            graphics.setColor(UIManager.getColor(lineColorKey));
            for (int ii = 0; ii < this.thickness; ++ii) {
                if (!this.roundedCorners) {
                    graphics.drawRect(xx + ii, yy + ii, width - ii - ii - 1, height - ii - ii - 1);
                    continue;
                }
                graphics.drawRoundRect(xx + ii, yy + ii, width - ii - ii - 1, height - ii - ii - 1, this.thickness, this.thickness);
            }
            graphics.setColor(oldColor);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.bottom = 2;
            insets.right = 2;
            insets.top = 2;
            insets.left = 2;
            return insets;
        }
    }

    public static class SplitPaneDividerBorder
    implements Border,
    UIResource {
        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            Color highlight = UIManager.getColor("SplitPane.borderColor");
            Color shadow = UIManager.getColor("SplitPane.borderColor");
            JSplitPane splitPane = null;
            if (!(component instanceof BasicSplitPaneDivider)) {
                return;
            }
            BasicSplitPaneDivider tmp = (BasicSplitPaneDivider)component;
            splitPane = tmp.getBasicSplitPaneUI().getSplitPane();
            Dimension size = component.getSize();
            Component child = splitPane.getLeftComponent();
            boolean borderCutted = UIManager.getBoolean("SplitPaneDivider.BorderCutted");
            graphics.setColor(borderCutted ? highlight : component.getBackground());
            graphics.drawRect(xx, yy, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                if (child != null) {
                    graphics.setColor(highlight);
                    graphics.drawLine(0, 0, 0, size.height);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    graphics.setColor(shadow);
                    graphics.drawLine(size.width - 1, 0, size.width - 1, size.height);
                }
                if (UIManager.getBoolean("SplitPaneDivider.BorderCutted")) {
                    graphics.setColor(UIManager.getColor("IsmArmorStyle.BaseColor"));
                    graphics.fillRect(0, 0, width, 3);
                    graphics.fillRect(0, height - 3, width, height);
                }
            } else {
                if (child != null) {
                    graphics.setColor(highlight);
                    graphics.drawLine(0, 0, size.width, 0);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    graphics.setColor(shadow);
                    graphics.drawLine(0, size.height - 1, size.width, size.height - 1);
                }
            }
        }

        @Override
        public Insets getBorderInsets(Component component) {
            JSplitPane splitPane;
            BasicSplitPaneUI bspui;
            Insets insets = new Insets(0, 0, 0, 0);
            if (component instanceof BasicSplitPaneDivider && (bspui = ((BasicSplitPaneDivider)component).getBasicSplitPaneUI()) != null && (splitPane = bspui.getSplitPane()) != null) {
                if (splitPane.getOrientation() == 1) {
                    insets.bottom = 0;
                    insets.top = 0;
                    insets.right = 1;
                    insets.left = 1;
                } else {
                    insets.bottom = 1;
                    insets.top = 1;
                    insets.right = 0;
                    insets.left = 0;
                }
                return insets;
            }
            insets.right = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.top = 1;
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class SplitPaneBorder
    implements Border,
    UIResource {
        @Override
        public void paintBorder(Component component, Graphics graphics, int x, int y, int width, int height) {
            Color highlight = UIManager.getColor("SplitPane.borderColor");
            Color shadow = UIManager.getColor("SplitPane.borderColor");
            Color borderGapColor = UIManager.getColor("SplitPane.borderGapColor");
            JSplitPane splitPane = null;
            if (!(component instanceof JSplitPane)) {
                return;
            }
            splitPane = (JSplitPane)component;
            Component childComponent = splitPane.getLeftComponent();
            graphics.setColor(borderGapColor);
            graphics.drawRect(x, y, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                Rectangle cBoundsRectangle;
                if (childComponent != null) {
                    cBoundsRectangle = childComponent.getBounds();
                    graphics.setColor(shadow);
                    graphics.drawLine(0, 0, cBoundsRectangle.width + 1, 0);
                    graphics.drawLine(0, 1, 0, cBoundsRectangle.height + 2);
                    graphics.setColor(highlight);
                    graphics.drawLine(1, cBoundsRectangle.height + 1, cBoundsRectangle.width + 1, cBoundsRectangle.height + 1);
                }
                if ((childComponent = splitPane.getRightComponent()) != null) {
                    cBoundsRectangle = childComponent.getBounds();
                    int maxX = cBoundsRectangle.x + cBoundsRectangle.width;
                    int maxY = cBoundsRectangle.y + cBoundsRectangle.height;
                    graphics.setColor(shadow);
                    graphics.drawLine(cBoundsRectangle.x - 1, 0, maxX, 0);
                    graphics.drawLine(cBoundsRectangle.x - 1, maxY, cBoundsRectangle.x, maxY);
                    graphics.setColor(highlight);
                    graphics.drawLine(cBoundsRectangle.x, maxY, maxX, maxY);
                    graphics.drawLine(maxX, 0, maxX, maxY + 1);
                }
            } else {
                this.setGraphicsWithNoHordrizontalSplit(childComponent, graphics, splitPane);
            }
        }

        private void setGraphicsWithNoHordrizontalSplit(Component childComponent, Graphics graphics, JSplitPane splitPane) {
            Component rightComp;
            Rectangle cBoundsRectangle;
            Color shadow = UIManager.getColor("SplitPane.borderColor");
            Color highlight = UIManager.getColor("SplitPane.borderColor");
            if (childComponent != null) {
                cBoundsRectangle = childComponent.getBounds();
                graphics.setColor(shadow);
                graphics.drawLine(0, 0, cBoundsRectangle.width + 1, 0);
                graphics.drawLine(0, 1, 0, cBoundsRectangle.height);
                graphics.setColor(highlight);
                graphics.drawLine(1 + cBoundsRectangle.width, 0, 1 + cBoundsRectangle.width, cBoundsRectangle.height + 1);
                graphics.drawLine(0, cBoundsRectangle.height + 1, 0, cBoundsRectangle.height + 1);
            }
            if ((rightComp = splitPane.getRightComponent()) != null) {
                cBoundsRectangle = rightComp.getBounds();
                int maxX = cBoundsRectangle.x + cBoundsRectangle.width;
                int maxY = cBoundsRectangle.y + cBoundsRectangle.height;
                graphics.setColor(shadow);
                graphics.drawLine(0, cBoundsRectangle.y - 1, 0, maxY);
                graphics.drawLine(maxX, cBoundsRectangle.y - 1, maxX, cBoundsRectangle.y - 1);
                graphics.setColor(highlight);
                graphics.drawLine(0, maxY, cBoundsRectangle.width + 1, maxY);
                graphics.drawLine(maxX, cBoundsRectangle.y, maxX, maxY);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return UIManager.getInsets("IsmSplitPane.BorderInsets");
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class DashedBorder
    extends LineBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;

        public DashedBorder(Color color) {
            super(color);
        }

        public DashedBorder(Color color, int thickness) {
            super(color, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.lineColor);
            for (int i = 0; i < this.thickness; ++i) {
                BasicGraphicsUtils.drawDashedRect(g, x + i, y + i, width - i - i, height - i - i);
            }
            g.setColor(oldColor);
        }
    }

    private static class IsmPopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;

        private IsmPopupMenuBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(UIManager.getColor("Popup.borderColor"));
            g.drawRect(x, y, w - 1, h - 1);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return UIManager.getInsets("IsmPopMenuItem.inserts");
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets borderInsets = this.getBorderInsets(component);
            newInsets.top = borderInsets.top;
            newInsets.left = borderInsets.left;
            newInsets.bottom = borderInsets.bottom;
            newInsets.right = borderInsets.right;
            return newInsets;
        }
    }

    private static class IsmMenuBarBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 116001977502172752L;

        private IsmMenuBarBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (UIManager.getBoolean("IsmMenuBar.BorderPainted")) {
                g.setColor(UIManager.getColor("MenuBar.borderUpColor"));
                g.drawLine(0, height - 1, width, height - 1);
                g.setColor(UIManager.getColor("MenuBar.borderDownColor"));
                g.drawLine(0, height - 0, width, height - 0);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return UIManager.getInsets("IsmMenuBar.Insets");
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets tmpIns = this.getBorderInsets(component);
            insets.top = tmpIns.top;
            insets.left = tmpIns.left;
            insets.bottom = tmpIns.bottom;
            insets.right = tmpIns.right;
            return insets;
        }
    }

    public static class MarginBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;

        @Override
        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets margin = null;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = CommonUtil.convertObject(component, AbstractButton.class);
                if (!(abstractButton instanceof ToolBarButton)) {
                    margin = abstractButton.getMargin();
                }
            } else if (component instanceof JToolBar) {
                JToolBar jToolBar = CommonUtil.convertObject(component, JToolBar.class);
                margin = jToolBar.getMargin();
            } else if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = CommonUtil.convertObject(component, JTextComponent.class);
                margin = jTextComponent.getMargin();
            }
            insets.top = margin != null ? margin.top : 0;
            insets.left = margin != null ? margin.left : 0;
            insets.bottom = margin != null ? margin.bottom : 0;
            insets.right = margin != null ? margin.right : 0;
            return insets;
        }
    }

    private static interface Filter {
        public double filter(int var1, int var2, int var3);
    }

    private static class ShadowBorder
    implements Border {
        private static final double RAW_BLACK = 1.0;
        private static double[] grayGrade = new double[]{0.5647058823529412, 0.6745098039215687, 0.8313725490196079, 0.9450980392156862};
        private static double[][] grayMatrix = new double[][]{{0.6078431372549019, 0.7058823529411765, 0.8509803921568627, 0.9490196078431372}, {0.7058823529411765, 0.7803921568627451, 0.8901960784313725, 0.9607843137254902}, {0.8509803921568627, 0.8901960784313725, 0.9450980392156862, 0.9803921568627451}, {0.9490196078431372, 0.9607843137254902, 0.9803921568627451, 0.9921568627450981}};
        private BufferedImage rightImage;
        private BufferedImage bottomImage;
        private BufferedImage rightBottomImage;

        ShadowBorder(BufferedImage backgroundImage) {
            this.generateRightImage(backgroundImage);
            this.generateBottomImage(backgroundImage);
            this.generateRightBottomImage(backgroundImage);
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            graphics.drawImage(this.rightImage, xx + width - 4, yy, component);
            graphics.drawImage(this.bottomImage, xx, yy + height - 4, component);
            graphics.drawImage(this.rightBottomImage, xx + width - 4, yy + height - 4, component);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(0, 0, 4, 4);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private void generateBottomImage(BufferedImage backgroundImage) {
            int width = backgroundImage.getWidth();
            int height = backgroundImage.getHeight();
            this.bottomImage = backgroundImage.getSubimage(0, height - 4, width - 4, 4);
            this.shadowBottom();
        }

        private void generateRightBottomImage(BufferedImage backgroundImage) {
            int width = backgroundImage.getWidth();
            int height = backgroundImage.getHeight();
            this.rightBottomImage = backgroundImage.getSubimage(width - 4, height - 4, 4, 4);
            this.shadowRightBottom();
        }

        private void generateRightImage(BufferedImage backgroundImage) {
            int width = backgroundImage.getWidth();
            int height = backgroundImage.getHeight();
            this.rightImage = backgroundImage.getSubimage(width - 4, 0, 4, height - 4);
            this.shadowRight();
        }

        private void shadowBottom() {
            this.filterImage(this.bottomImage, new BottomImageFilter());
        }

        private void shadowRight() {
            this.filterImage(this.rightImage, new RightImgFilter());
        }

        private void shadowRightBottom() {
            this.filterImage(this.rightBottomImage, new RightBottomImgFilter());
        }

        private int gradeRGB(int rgb, double grade) {
            int aa = rgb & 0xFF000000;
            int red = (rgb & 0xFF0000) >> 16;
            int green = (rgb & 0xFF00) >> 8;
            int blue = rgb & 0xFF;
            red = (int)(grade * (double)red) << 16;
            green = (int)(grade * (double)green) << 8;
            blue = (int)(grade * (double)blue);
            return aa | red | green | blue;
        }

        private void filterImage(BufferedImage image, Filter filter) {
            int width = image.getWidth();
            int height = image.getHeight();
            int rgb = 0;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    rgb = image.getRGB(x, y);
                    double grade = filter.filter(x, y, rgb);
                    rgb = this.gradeRGB(rgb, grade);
                    image.setRGB(x, y, rgb);
                }
            }
        }

        private static final class BottomImageFilter
        implements Filter {
            private BottomImageFilter() {
            }

            @Override
            public double filter(int x, int y, int rgb) {
                if (x < 4) {
                    return 1.0;
                }
                if (x < 8) {
                    return grayMatrix[7 - x][y];
                }
                return grayGrade[y];
            }
        }

        private static final class RightImgFilter
        implements Filter {
            private RightImgFilter() {
            }

            @Override
            public double filter(int x, int y, int rgb) {
                if (y < 4) {
                    return 1.0;
                }
                if (y < 8) {
                    return grayMatrix[x][7 - y];
                }
                return grayGrade[x];
            }
        }

        private static final class RightBottomImgFilter
        implements Filter {
            private RightBottomImgFilter() {
            }

            @Override
            public double filter(int x, int y, int rgb) {
                return grayMatrix[x][y];
            }
        }
    }

    public static class TextFieldBorder
    extends BorderUIResource.BevelBorderUIResource {
        private static final long serialVersionUID = 1L;

        public TextFieldBorder() {
            super(1);
        }

        @Override
        public Color getHighlightOuterColor(Component component) {
            if (component.isEnabled()) {
                JTextComponent textComponent;
                if (component instanceof JTextComponent && (textComponent = (JTextComponent)component).isEditable() && textComponent.isFocusOwner()) {
                    return UIManager.getColor("TextField.rdFocusOuterColor");
                }
                return UIManager.getColor("TextField.rdNormalOuterColor");
            }
            return UIManager.getColor("TextField.disabledBorderColor");
        }

        @Override
        public Color getHighlightInnerColor(Component comp) {
            return comp.getBackground();
        }

        @Override
        public Color getShadowInnerColor(Component comp) {
            if (comp.isEnabled()) {
                JTextComponent textComponent;
                if (comp instanceof JTextComponent && (textComponent = (JTextComponent)comp).isEditable() && textComponent.isFocusOwner()) {
                    return UIManager.getColor("TextField.luFocusOuterColor");
                }
                return UIManager.getColor("TextField.luNormalOuterColor");
            }
            return UIManager.getColor("TextField.disabledBorderColor");
        }

        @Override
        public Color getShadowOuterColor(Component component) {
            if (component.isEnabled()) {
                JTextComponent textComponent;
                if (component instanceof JTextComponent && (textComponent = (JTextComponent)component).isEditable() && textComponent.isFocusOwner()) {
                    return UIManager.getColor("TextField.luInnerColor");
                }
                return UIManager.getColor("TextField.luInnerColor");
            }
            return component.getBackground();
        }
    }

    private static class TableHeaderBorder
    extends AbstractBorder {
        private static final long serialVersionUID = 1L;
        private Insets editorBorderInsets = new Insets(2, 0, 2, 0);

        private TableHeaderBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.translate(x, y);
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 0, 0, h - 2);
            g.translate(-x, -y);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = this.editorBorderInsets.left;
            insets.top = this.editorBorderInsets.top;
            insets.right = this.editorBorderInsets.right;
            insets.bottom = this.editorBorderInsets.bottom;
            return insets;
        }
    }

    private static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static Insets toolbarButtonInsets = new Insets(1, 1, 1, 1);
        private static Insets buttonInsets = new Insets(0, 3, 0, 3);
        private boolean isRounded;

        public ButtonBorder(boolean isRound) {
            this.isRounded = isRound;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)component;
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("Button.style");
            if (button.getParent() instanceof JComboBox) {
                style = (IsmButtonStyle)UIManager.get("ComboBoxButton.style");
            }
            if (IsmPlafUtils.isButtonOnToolBar(button)) {
                style = (IsmButtonStyle)UIManager.get("ToolBarButton.style");
            }
            IsmButtonStyle.ButtonState state = IsmPlafUtils.getButtonState(button);
            IsmPlafUtils.drawButtonBorder(style, state, graphics, new Rectangle(xx, yy, width, height), this.isRounded);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            if (component instanceof ToolBarButton) {
                return toolbarButtonInsets;
            }
            return buttonInsets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            newInsets.top = this.getBorderInsets((Component)component).top;
            newInsets.left = this.getBorderInsets((Component)component).left;
            newInsets.bottom = this.getBorderInsets((Component)component).bottom;
            newInsets.right = this.getBorderInsets((Component)component).right;
            return newInsets;
        }
    }

    private static class RolloverButtonBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 1L;
        private static Insets rolloverButtonInsets = new Insets(0, 0, 0, 0);

        private RolloverButtonBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            if (!(component instanceof AbstractButton)) {
                return;
            }
            AbstractButton button = (AbstractButton)component;
            IsmButtonStyle style = (IsmButtonStyle)UIManager.get("RolloverButton.style");
            IsmButtonStyle.ButtonState state = IsmPlafUtils.getRolloverButtonState(button);
            IsmPlafUtils.drawButtonBorder(style, state, graphics, new Rectangle(xx, yy, width, height), true);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return rolloverButtonInsets;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            newInsets.top = this.getBorderInsets((Component)component).top;
            newInsets.left = this.getBorderInsets((Component)component).left;
            newInsets.bottom = this.getBorderInsets((Component)component).bottom;
            newInsets.right = this.getBorderInsets((Component)component).right;
            return newInsets;
        }
    }

    private static class IsmToolBarBorder
    extends AbstractBorder
    implements UIResource {
        private static final long serialVersionUID = 8343966141200657215L;

        private IsmToolBarBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return UIManager.getInsets("IsmToolBar.Insets");
        }

        @Override
        public Insets getBorderInsets(Component component, Insets newInsets) {
            Insets inset = this.getBorderInsets(component);
            newInsets.top = inset.top;
            newInsets.left = inset.left;
            newInsets.bottom = inset.bottom;
            newInsets.right = inset.right;
            return newInsets;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int xx, int yy, int width, int height) {
            JToolBar toolBar = null;
            if (!(component instanceof JToolBar)) {
                return;
            }
            toolBar = (JToolBar)component;
            graphics.setColor(UIManager.getColor("IsmToolBar.BorderColor"));
            graphics.fillRect(xx, yy, width, UIManager.getInt("IsmToolBar.BorderHeight"));
            if (toolBar.isFloatable()) {
                graphics.translate(xx, yy);
                for (int i = 0; i < height - 2; ++i) {
                    graphics.setColor(UIManager.getColor("ToolBar.borderDragAreaP1"));
                    graphics.drawLine(8, i + 3, 9, i + 3);
                    graphics.setColor(UIManager.getColor("ToolBar.borderDragAreaP2"));
                    graphics.drawLine(8, 4 + i, 9, 4 + i);
                    graphics.setColor(UIManager.getColor("ToolBar.borderDragAreaP3"));
                    graphics.drawLine(9, 4 + i, 10, 4 + i);
                    i += 6;
                }
            }
        }
    }
}

