/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.ui.swing.plaf.IsmButtonStyle;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.plaf.ColorUIResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsmHSBButtonStyle
implements IsmButtonStyle {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsmHSBButtonStyle.class);
    private ColorUIResource borderColor;
    private ColorUIResource borderCornerColor;
    private ColorUIResource innerBorderColorLU;
    private ColorUIResource inneBorderColorRD;
    private List<?> gradentUL;
    private List<?> gradentDR;
    private Map<IsmButtonStyle.ButtonState, Integer> saturationRatio;
    private Map<IsmButtonStyle.ButtonState, Integer> brightnessRatio;
    private Map<IsmButtonStyle.ButtonState, Integer> innerBorderalphaRatio;

    public IsmHSBButtonStyle(List<?> gradientUL, List<?> gradientDR, Color borderColor, Color borderCornerColor, Color innerBorderColorLU, Color innerBorderColorRD) {
        this.gradentUL = gradientUL;
        this.gradentDR = gradientDR;
        this.borderColor = new ColorUIResource(borderColor);
        this.borderCornerColor = new ColorUIResource(borderCornerColor);
        this.innerBorderColorLU = new ColorUIResource(innerBorderColorLU);
        this.inneBorderColorRD = new ColorUIResource(innerBorderColorRD);
        this.saturationRatio = new HashMap<IsmButtonStyle.ButtonState, Integer>(0);
        this.brightnessRatio = new HashMap<IsmButtonStyle.ButtonState, Integer>(0);
        this.innerBorderalphaRatio = new HashMap<IsmButtonStyle.ButtonState, Integer>(0);
    }

    public void setSaturation(IsmButtonStyle.ButtonState state, int ratio) {
        if (ratio >= 0) {
            this.saturationRatio.put(state, ratio);
        }
    }

    public void setInnerBorderAlpha(IsmButtonStyle.ButtonState state, int ratio) {
        if (ratio >= 0) {
            this.innerBorderalphaRatio.put(state, ratio);
        }
    }

    public void setBrightness(IsmButtonStyle.ButtonState state, int ratio) {
        if (ratio >= 0) {
            this.brightnessRatio.put(state, ratio);
        }
    }

    @Override
    public List<?> getGradientUL(IsmButtonStyle.ButtonState state) {
        LinkedList gradientUL = new LinkedList(this.gradentUL);
        Object color = null;
        for (int i = 2; i < this.gradentUL.size(); ++i) {
            color = this.gradentUL.get(i);
            if (null == color || !(color instanceof Color)) continue;
            gradientUL.set(i, this.getColor(state, color));
        }
        return gradientUL;
    }

    @Override
    public List<?> getGradientDR(IsmButtonStyle.ButtonState state) {
        LinkedList gradientDR = new LinkedList(this.gradentDR);
        Object color = null;
        for (int i = 2; i < this.gradentDR.size(); ++i) {
            color = this.gradentDR.get(i);
            if (null == color || !(color instanceof Color)) continue;
            gradientDR.set(i, this.getColor(state, color));
        }
        return gradientDR;
    }

    @Override
    public Color getBorderColor(IsmButtonStyle.ButtonState state) {
        return this.getColor(state, this.borderColor);
    }

    @Override
    public Color getBorderCornerColor(IsmButtonStyle.ButtonState state) {
        return this.getColor(state, this.borderCornerColor);
    }

    @Override
    public Color getInnerBorderColorLU(IsmButtonStyle.ButtonState state) {
        ColorUIResource innerBorderColor = this.innerBorderColorLU;
        if (state == IsmButtonStyle.ButtonState.PRESSED) {
            innerBorderColor = this.inneBorderColorRD;
        }
        return this.getInnerBorderColor(state, innerBorderColor);
    }

    @Override
    public Color getInnerBorderColorRD(IsmButtonStyle.ButtonState state) {
        ColorUIResource innerBorderColor = this.inneBorderColorRD;
        if (state == IsmButtonStyle.ButtonState.PRESSED) {
            innerBorderColor = this.innerBorderColorLU;
        }
        return this.getInnerBorderColor(state, innerBorderColor);
    }

    @Override
    public IsmHSBButtonStyle clone() {
        try {
            super.clone();
            IsmHSBButtonStyle instance = (IsmHSBButtonStyle)super.clone();
            instance.gradentUL = new LinkedList(this.gradentUL);
            instance.gradentDR = new LinkedList(this.gradentDR);
            instance.saturationRatio = new HashMap<IsmButtonStyle.ButtonState, Integer>(this.saturationRatio);
            instance.brightnessRatio = new HashMap<IsmButtonStyle.ButtonState, Integer>(this.brightnessRatio);
            instance.innerBorderalphaRatio = new HashMap<IsmButtonStyle.ButtonState, Integer>(this.innerBorderalphaRatio);
            return instance;
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error("", (Throwable)e);
            throw new EncapsulatedRuntimeException("clone error!", (Throwable)e);
        }
    }

    private Color getColor(IsmButtonStyle.ButtonState state, Color defaultColor) {
        int ratio;
        if (null == defaultColor) {
            return null;
        }
        Color modifiedColor = defaultColor;
        if (this.saturationRatio.containsKey((Object)state)) {
            ratio = this.saturationRatio.get((Object)state);
            modifiedColor = IsmPlafUtils.modifySaturation(modifiedColor, ratio);
        }
        if (this.brightnessRatio.containsKey((Object)state)) {
            ratio = this.brightnessRatio.get((Object)state);
            modifiedColor = IsmPlafUtils.modifyBrightness(modifiedColor, ratio);
        }
        return modifiedColor;
    }

    private Color getInnerBorderColor(IsmButtonStyle.ButtonState state, Color innerBorderColor) {
        Color modifiedColor = this.getColor(state, innerBorderColor);
        if (null == modifiedColor) {
            return null;
        }
        if (this.innerBorderalphaRatio.containsKey((Object)state)) {
            int ratio = this.innerBorderalphaRatio.get((Object)state);
            modifiedColor = IsmPlafUtils.modifyAlpha(modifiedColor, ratio);
        }
        return modifiedColor;
    }

    @Override
    public List<?> getGradient(IsmButtonStyle.ButtonState state) {
        return null;
    }
}

