/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.UCD;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class IsmLabelUI
extends BasicLabelUI {
    private static final IsmLabelUI ISM_LABEL_UI = new IsmLabelUI();
    private static final String CUSTOM_TOOL_TIP = "Custom_TooltipKey";
    private static final String GENERATE_TOOL_TIP = "Genearate_TooltipKey";

    public static ComponentUI createUI(JComponent c) {
        return ISM_LABEL_UI;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Icon icon;
        super.update(graphics, jComponent);
        JLabel label = CommonUtil.convertObject(jComponent, JLabel.class);
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        Rectangle paintIconR = new Rectangle();
        Rectangle paintTextR = new Rectangle();
        Rectangle paintViewR = new Rectangle();
        Insets paintViewInsets = new Insets(0, 0, 0, 0);
        FontMetrics fm = IsmPlafUtils.getFontMetrics(label, graphics);
        Insets insets = jComponent.getInsets(paintViewInsets);
        paintViewR.setLocation(insets.left, insets.top);
        paintViewR.width = jComponent.getWidth() - (insets.left + insets.right);
        paintViewR.height = jComponent.getHeight() - (insets.top + insets.bottom);
        paintIconR.setLocation(0, 0);
        paintTextR.setLocation(0, 0);
        paintIconR.height = 0;
        paintIconR.width = 0;
        paintTextR.height = 0;
        paintTextR.width = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        String oldTooltip = label.getToolTipText();
        if (null == label.getClientProperty(CUSTOM_TOOL_TIP) && null != oldTooltip && null == label.getClientProperty(GENERATE_TOOL_TIP)) {
            label.putClientProperty(CUSTOM_TOOL_TIP, oldTooltip);
        }
        if (null != label.getClientProperty(CUSTOM_TOOL_TIP)) {
            return;
        }
        if (!clippedText.equals(text)) {
            String newTooltip = UCD.wrapTextWithHTML(fm, text, 300);
            if (null == oldTooltip && null != text) {
                label.setToolTipText(newTooltip);
                label.putClientProperty(GENERATE_TOOL_TIP, newTooltip);
            }
            if (null != oldTooltip && !oldTooltip.equals(newTooltip)) {
                label.setToolTipText(newTooltip);
                label.putClientProperty(GENERATE_TOOL_TIP, newTooltip);
            }
        } else if (null != label.getToolTipText()) {
            label.setToolTipText(null);
        }
    }
}

