/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf;

import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public class IsmTreeUI
extends MetalTreeUI {
    public static ComponentUI createUI(JComponent x) {
        return new IsmTreeUI();
    }

    static Object getUIOfType(ComponentUI ui, Class<?> klass) {
        if (klass.isInstance(ui)) {
            return ui;
        }
        return null;
    }

    @Override
    protected TreeCellRenderer createDefaultCellRenderer() {
        return new IsmTreeCellRenderer();
    }

    private static final class IsmTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3018348351954396262L;

        public IsmTreeCellRenderer() {
            this.setBorderSelectionColor(null);
            this.setBackgroundNonSelectionColor(null);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            IsmTreeNode treeNode = null;
            if (value instanceof IsmTreeNode) {
                treeNode = (IsmTreeNode)value;
            }
            if (null != treeNode) {
                Icon icon = treeNode.getIcon();
                if (icon instanceof ImageIcon) {
                    ImageIcon imageIcon = (ImageIcon)icon;
                    imageIcon.setImageObserver(tree);
                }
                this.setIcon(icon);
                String text = treeNode.getText();
                this.setText(text);
                String toolTip = treeNode.getTooltipText();
                if (toolTip != null) {
                    this.setToolTipText(toolTip);
                }
            }
            return this;
        }
    }
}

