/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.armor;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public final class ArmorIconFactory {
    private static Icon sliderHorizIcon;
    private static Icon sliderVertIcon;

    public static Icon getSliderHIcon() {
        if (sliderHorizIcon == null) {
            sliderHorizIcon = new SliderHorizontalIcon(true);
        }
        return sliderHorizIcon;
    }

    public static Icon getSliderVIcon() {
        if (sliderVertIcon == null) {
            sliderVertIcon = new SliderHorizontalIcon(false);
        }
        return sliderVertIcon;
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource,
    Serializable {
        private static final long serialVersionUID = 1191199335214123414L;
        private static final int ICON_W = 15;
        private static final int ICON_H = 15;
        private boolean isHorizonal = false;

        public SliderHorizontalIcon(boolean isHorizonal) {
            this.isHorizonal = isHorizonal;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int xx, int yy) {
            if (!(component instanceof JSlider)) {
                return;
            }
            JSlider slider = (JSlider)component;
            Color borderColor = null;
            if (component.hasFocus()) {
                this.drawContentArea(graphics, slider, "JSlider.pumbRolloverHighlight", "JSlider.pumbRolloverGrient");
                borderColor = UIManager.getColor("JSlider.pumbNormalBorderColor");
            } else {
                this.drawNormalContentArea(graphics, "JSlider.pumbNormalHighlight", "JSlider.pumbNormalBackground");
                borderColor = UIManager.getColor("JSlider.pumbRolloverBorderColor");
            }
            ImageIcon pumbIcon = (ImageIcon)UIManager.getIcon("JSlider.pumbHIcon");
            if (!this.isHorizonal) {
                pumbIcon = (ImageIcon)UIManager.getIcon("JSlider.pumbVIcon");
            }
            graphics.drawImage(pumbIcon.getImage(), this.getIconWidth() - pumbIcon.getIconWidth() >> 1, this.getIconHeight() - pumbIcon.getIconHeight() >> 1, pumbIcon.getIconWidth(), pumbIcon.getIconHeight(), slider);
            IsmPlafUtils.drawBorderStyle(graphics, borderColor, borderColor, new Rectangle(xx, yy, this.getIconWidth(), this.getIconHeight()), true);
        }

        private void drawNormalContentArea(Graphics graphics, String hightlightKey, String normalKey) {
            if (null != hightlightKey) {
                graphics.setColor(UIManager.getColor(hightlightKey));
                graphics.fillRect(0, 2, this.getIconWidth() - 1, 1);
                graphics.setColor(UIManager.getColor(normalKey));
                graphics.fillRect(0, 3, this.getIconWidth() - 1, this.getIconHeight());
            } else {
                graphics.setColor(UIManager.getColor(normalKey));
                graphics.fillRect(0, 2, this.getIconWidth() - 1, this.getIconHeight() - 1);
            }
        }

        private void drawContentArea(Graphics graphics, JSlider jSlider, String highlightKey, String grientKey) {
            graphics.setColor(UIManager.getColor(highlightKey));
            graphics.fillRect(0, 2, this.getIconWidth(), 1);
            IsmPlafUtils.drawGradient((Component)jSlider, graphics, grientKey, new Rectangle(0, 3, this.getIconWidth(), this.getIconHeight()), true);
        }

        @Override
        public int getIconWidth() {
            return 15;
        }

        @Override
        public int getIconHeight() {
            return 15;
        }
    }
}

