/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class UnifySplitPaneDivider
extends BasicSplitPaneDivider {
    private static final long serialVersionUID = 7135621031622871151L;
    private static final String DRAG_BUMG_PREFIX = "SplitPaneDiviter.Bumb";
    private static final String ONE_TOUCH_BUMB_PREFIX = "SplitPaneDiviter.OneTouchBumb";

    public UnifySplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        String direction = "Vertical";
        if (this.orientation == 0) {
            direction = "Horizonal";
        }
        String stateKey = "Normal";
        if (!this.isEnabled()) {
            stateKey = "Disable";
        } else if (this.isMouseOver()) {
            stateKey = "Rollover";
        }
        Icon bump = null;
        bump = this.splitPane.isOneTouchExpandable() ? UIManager.getIcon(ONE_TOUCH_BUMB_PREFIX + direction + stateKey) : UIManager.getIcon(DRAG_BUMG_PREFIX + direction + stateKey);
        if (bump != null) {
            bump.paintIcon(this, graphics, this.getWidth() - bump.getIconWidth() + 1 >> 1, this.getHeight() - bump.getIconHeight() >> 1);
        }
        super.paint(graphics);
    }

    protected void paintBackground(Graphics graphics) {
        boolean isHorizonal;
        boolean bl = isHorizonal = this.orientation == 1;
        if (!isHorizonal) {
            ImageIcon leftIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.HorizonalLeftBG");
            ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.HorizonalCenterBG");
            ImageIcon rightIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.HorizonalRightBG");
            int width = this.getWidth();
            graphics.drawImage(leftIcon.getImage(), 0, 0, leftIcon.getIconWidth(), leftIcon.getIconHeight(), this);
            graphics.drawImage(centerIcon.getImage(), leftIcon.getIconWidth(), 0, width - leftIcon.getIconWidth() - rightIcon.getIconWidth(), centerIcon.getIconHeight(), this);
            graphics.drawImage(rightIcon.getImage(), width - rightIcon.getIconWidth(), 0, rightIcon.getIconWidth(), rightIcon.getIconHeight(), this);
        } else {
            ImageIcon upIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.VerticalUpBG");
            ImageIcon centerIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.VerticalCenterBG");
            ImageIcon downIcon = (ImageIcon)UIManager.getIcon("SplitPaneDiviter.VerticalDownBG");
            int height = this.getHeight();
            graphics.drawImage(upIcon.getImage(), 0, 0, upIcon.getIconWidth(), upIcon.getIconHeight(), this);
            graphics.drawImage(centerIcon.getImage(), 0, upIcon.getIconHeight(), centerIcon.getIconWidth(), height - upIcon.getIconHeight() - downIcon.getIconHeight(), this);
            graphics.drawImage(downIcon.getImage(), 0, height - downIcon.getIconHeight(), downIcon.getIconWidth(), downIcon.getIconHeight(), this);
        }
    }

    @Override
    protected void setMouseOver(boolean mouseOver) {
        super.setMouseOver(mouseOver);
        this.repaint();
    }
}

