/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.plaf.unify;

import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.plaf.IsmTableHeaderCellRenderer;
import com.huawei.ism.util.CommonUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class UnifyTableHeaderUI
extends BasicTableHeaderUI {
    private static int rolloverColumn = -1;
    private TableCellRenderer render;

    public static ComponentUI createUI(JComponent h) {
        return new UnifyTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.render = this.header.getDefaultRenderer();
        if (this.render instanceof UIResource) {
            this.header.setDefaultRenderer(new TableHeaderCellRender(CommonUtil.convertObject(jComponent, JTableHeader.class)));
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new BasicTableHeaderUI.MouseInputHandler(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                super.mouseMoved(mouseEvent);
                UnifyTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                super.mouseEntered(mouseEvent);
                if (UnifyTableHeaderUI.this.header.getCursor() != Cursor.getPredefinedCursor(11)) {
                    UnifyTableHeaderUI.this.header.setCursor(Cursor.getPredefinedCursor(12));
                }
                UnifyTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                super.mouseExited(mouseEvent);
                rolloverColumn = -1;
                UnifyTableHeaderUI.this.header.repaint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
                if (UnifyTableHeaderUI.this.header.getReorderingAllowed()) {
                    rolloverColumn = -1;
                    UnifyTableHeaderUI.this.header.repaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                super.mouseDragged(mouseEvent);
                UnifyTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(mouseEvent);
                UnifyTableHeaderUI.this.updateRolloverColumn(mouseEvent);
            }
        };
    }

    private void updateRolloverColumn(MouseEvent mouseEvent) {
        int col;
        if (this.header.getDraggedColumn() == null && this.header.contains(mouseEvent.getPoint()) && (col = this.header.columnAtPoint(mouseEvent.getPoint())) != rolloverColumn) {
            rolloverColumn = col;
            this.header.repaint();
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (this.header.getDefaultRenderer() instanceof IsmTableHeaderCellRenderer) {
            this.header.setDefaultRenderer(this.render);
        }
        super.uninstallUI(jComponent);
    }

    public static void paintBackGroud(JComponent comp, Graphics graphics, boolean isRecovered) {
        String style = "TableHeader.bgGradient";
        if (isRecovered) {
            String selectedStyle = "TableHeader.selectedGradient";
            IsmPlafUtils.drawDualGradient((Component)comp, graphics, selectedStyle, style, new Rectangle(0, 0, comp.getWidth(), comp.getHeight()), true);
        } else {
            IsmPlafUtils.drawGradient((Component)comp, graphics, style, new Rectangle(0, 0, comp.getWidth(), comp.getHeight()), true);
        }
    }

    private static class TableHeaderCellRender
    extends IsmTableHeaderCellRenderer {
        private static final long serialVersionUID = -466364326409311619L;
        private boolean isSelected;
        private boolean hasFocus;
        private boolean hasRollover;

        public TableHeaderCellRender(JTableHeader header) {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(2);
            this.setIconTextGap(4);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelectedTemp, boolean hasFocusTemp, int row, int column) {
            this.isSelected = isSelectedTemp;
            this.hasFocus = hasFocusTemp;
            this.hasRollover = column == rolloverColumn;
            return super.getTableCellRendererComponent(table, value, isSelectedTemp, hasFocusTemp, row, column);
        }

        @Override
        public void paint(Graphics graphics) {
            UnifyTableHeaderUI.paintBackGroud(this, graphics, this.isSelected || this.hasFocus || this.hasRollover);
            super.paint(graphics);
        }
    }
}

