/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.text.NameRegexDocument;
import com.huawei.ism.ui.swing.text.RegexDocument;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import com.huawei.ism.util.SwingUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;

public class HintTextField
extends JTextField {
    private static final int DEFAULT_OFFSET = 1;
    private static final int MARGIN_TOP = 4;
    private static final int UCD_CONSTRANTS_HIGHT = 22;
    private static final int MAX_WIDTH = 800;
    private transient List<InputValidator> validators = new ArrayList<InputValidator>();
    private int offSet;
    private String hintText;
    private String inputValueName = null;

    public HintTextField(RegexDocument regexDoc, String text, int columns) {
        super(regexDoc, text, columns);
        this.setMaximumSize(new Dimension(800, 22));
        SwingUtil.applyKeyBoardLockPatch(this);
    }

    public HintTextField(RegexDocument regexDoc, int columns) {
        this(regexDoc, "", columns);
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (StringUtils.isNULLStr((String)this.hintText)) {
            return;
        }
        String text = this.getText();
        if (!this.hasFocus() && StringUtils.isNULLStr((String)text)) {
            graphics.setColor(Color.GRAY);
            int xPos = this.offSet == Integer.MAX_VALUE ? 1 : this.offSet;
            int yPos = this.getHeight() / 2 + 4;
            graphics.drawString(this.hintText, xPos, yPos);
        }
    }

    public void addInputValidator(InputValidator validator) {
        this.validators.add(validator);
    }

    public String validateInput() {
        String input = this.getText();
        for (InputValidator validator : this.validators) {
            String errorMsg = validator.validateInput(input, this.inputValueName);
            if (StringUtils.isNULLStr((String)errorMsg)) continue;
            errorMsg = errorMsg + ResourceManager.getString("pattern.validate.not.blank.tooltip");
            return errorMsg;
        }
        return "";
    }

    public static HintTextField getNameTextField(String regex, String text, int maxContentLength, int fieldLength) {
        NameRegexDocument nameRegexDocument = new NameRegexDocument(regex, maxContentLength);
        HintTextField hintTextField = new HintTextField(nameRegexDocument, fieldLength);
        hintTextField.setText(text);
        return hintTextField;
    }

    public void setOffSet(int offSet) {
        this.offSet = offSet;
    }

    public int getOffSet() {
        return this.offSet;
    }

    public void setHintText(String hintText) {
        this.hintText = hintText;
    }

    public String getHintText() {
        return this.hintText;
    }

    public void setInputValueName(String inputValueName) {
        this.inputValueName = inputValueName;
    }

    public String getInputValueName() {
        return this.inputValueName;
    }
}

