/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text;

import com.huawei.ism.ui.swing.text.RegexDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LengthDocument
extends RegexDocument {
    private static final Logger LOGGER = LoggerFactory.getLogger(LengthDocument.class);
    private static final long serialVersionUID = 4484807512382654464L;
    private int inputNumberimit;

    public LengthDocument(String regex, int inputNumberLimit) {
        super(regex);
        this.inputNumberimit = inputNumberLimit;
    }

    @Override
    public void insertString(int offs, String newContent, AttributeSet attr) {
        try {
            if (attr == null || !attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                String proposedInsert;
                try {
                    proposedInsert = this.getText(0, offs) + newContent + this.getText(offs, this.getLength() - offs);
                }
                catch (BadLocationException e1) {
                    LOGGER.error("BadLocationException", (Throwable)e1);
                    return;
                }
                if (this.inputNumberimit < proposedInsert.getBytes("UTF8").length) {
                    return;
                }
            }
            super.insertString(offs, newContent, attr);
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

