/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.swing.text.validator;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.text.validator.InputValidator;
import java.text.MessageFormat;
import java.util.Locale;

public class EnumerateInputValidator
implements InputValidator {
    private static final long serialVersionUID = 7032722639186731037L;
    private int[] numArray;
    private String numString = "";

    public EnumerateInputValidator(int ... numList) {
        this.numArray = numList;
    }

    public void setNmeberList(int ... numList) {
        this.numArray = numList;
        this.numString = "";
        for (int i = 0; i < this.numArray.length; ++i) {
            this.numString = this.numString + String.valueOf(this.numArray[i]);
            if (i == this.numArray.length - 1) continue;
            this.numString = Locale.getDefault().getLanguage().equals("zh") ? this.numString + "\u3001" : this.numString + ",";
        }
    }

    @Override
    public String getToolTip() {
        return MessageFormat.format(ResourceManager.getString("textfield.enum.value.tooltip"), this.numString);
    }

    @Override
    public String validateInput(String input, String inputValueName) {
        boolean isValid = false;
        for (int i = 0; i < this.numArray.length; ++i) {
            if (Integer.parseInt(input) != this.numArray[i]) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            return MessageFormat.format(ResourceManager.getString("textfield.enum.value.validatetip"), inputValueName, this.numString);
        }
        return null;
    }
}

