/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableRow;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class IntegratedUpgradeLayout
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] DEVICE_MODEL_NAME = new String[]{ResourceManager.getString("COMPONENT_NAME"), ResourceManager.getString("COMPONENT_TYPE")};
    private JButton upgradeButton;
    private JButton cancelButton;
    private JButton helpButton;
    private JLabel extractLable;
    private IsmTable deviceListTable;
    private DefaultTableModel deviceTableModel;
    private String device;
    private ImageIcon leftImage;
    private IsmTextArea textArea;

    public IntegratedUpgradeLayout(String deviceID) {
        this.device = deviceID;
        this.initComponent();
        this.initUI();
        this.initData();
        this.addListeners();
    }

    private void initComponent() {
        String imgName = "wizard_step_bg.png";
        if (IsmPlafUtils.LAFStyle.armor == IsmPlafUtils.getLAFStyle()) {
            imgName = "wizard_step_bg_armor.png";
        }
        this.leftImage = ResourceManager.getImage(imgName);
        this.textArea = new IsmTextArea();
        this.extractLable = new JLabel();
        this.extractLable.setText("<html><u>" + ResourceManager.getString("UPGRADE_EXTRACT") + "</html>");
        this.extractLable.setForeground(Color.BLUE);
        this.upgradeButton = UCD.createButton(ResourceManager.getString("UPGRADE_BUTTON"), 'U');
        this.upgradeButton.setEnabled(false);
        this.cancelButton = UCD.createButton(ResourceManager.getString("ALARM_DIALOG_CLOSE"), 'L');
        this.helpButton = UCD.createButton(ResourceManager.getString("COMMON_HELP"), 'H');
        this.deviceTableModel = new DefaultTableModel(DEVICE_MODEL_NAME, new int[0]);
        this.deviceListTable = new IsmTable(this.deviceTableModel);
    }

    private void initUI() {
        Box contentBox = this.getTopBox();
        Box southBox = this.getBottomButtonBox();
        southBox.setBackground(new Color(16054010));
        this.setLayout(new BoxLayout(this, 1));
        this.add((Component)contentBox, "Center");
        this.add((Component)southBox, "South");
        this.add(Box.createGlue());
    }

    private Box getBottomButtonBox() {
        Box buttonPanelHorizontalBox = Box.createHorizontalBox();
        buttonPanelHorizontalBox.add(Box.createHorizontalGlue());
        buttonPanelHorizontalBox.add(this.cancelButton);
        buttonPanelHorizontalBox.add(Box.createHorizontalStrut(10));
        buttonPanelHorizontalBox.add(this.helpButton);
        buttonPanelHorizontalBox.add(Box.createHorizontalStrut(12));
        buttonPanelHorizontalBox.setBackground(new Color(13688042));
        Box southBox = Box.createVerticalBox();
        southBox.add(new JSeparator());
        southBox.add(Box.createVerticalStrut(12));
        southBox.add(buttonPanelHorizontalBox);
        southBox.add(Box.createVerticalStrut(12));
        return southBox;
    }

    private Box getTopBox() {
        Box rightPanel = this.infoBoxes();
        JPanel tablePane = new JPanel(new BorderLayout());
        JPanel upgradeTablePanel = new JPanel(new BorderLayout());
        TableScrollPane tablePanel = new TableScrollPane(this.deviceListTable);
        upgradeTablePanel.add(tablePanel);
        upgradeTablePanel.setBackground(this.getBackground());
        upgradeTablePanel.setBorder(new CompoundBorder(new TitledBorder(ResourceManager.getString("BASE_INFO")), new EmptyBorder(8, 8, 5, 8)));
        tablePane.add((Component)upgradeTablePanel, "Center");
        tablePane.setBackground(this.getBackground());
        tablePane.setBorder(new EmptyBorder(0, 8, 0, 0));
        rightPanel.add(tablePane);
        JLabel leftLabel = new JLabel();
        leftLabel.setIcon(this.leftImage);
        Box rightBox = Box.createVerticalBox();
        rightBox.add(Box.createVerticalStrut(12));
        Box upgradeButtonBox = Box.createHorizontalBox();
        upgradeButtonBox.add(Box.createHorizontalGlue());
        upgradeButtonBox.add(this.upgradeButton);
        this.upgradeButton.setAlignmentX(0.0f);
        upgradeButtonBox.setBorder(new EmptyBorder(10, 0, 0, 0));
        rightPanel.add(upgradeButtonBox);
        rightBox.add(rightPanel);
        rightBox.add(Box.createVerticalGlue());
        rightBox.add(Box.createVerticalStrut(12));
        Box contentBox = new Box(0);
        leftLabel.setAlignmentY(0.0f);
        leftLabel.setAlignmentX(0.0f);
        contentBox.add(leftLabel);
        rightBox.setAlignmentX(0.0f);
        rightBox.setAlignmentY(0.0f);
        contentBox.add(Box.createHorizontalStrut(6));
        contentBox.add(rightBox);
        contentBox.add(Box.createHorizontalGlue());
        contentBox.add(Box.createHorizontalStrut(12));
        UCD.setJComponentSize(contentBox, new Dimension(580, this.leftImage.getIconHeight()));
        return contentBox;
    }

    private Box infoBoxes() {
        this.textArea.setBorder(new EmptyBorder(0, 10, 10, 0));
        Box rightPanel = Box.createVerticalBox();
        rightPanel.add(this.textArea);
        Box extractBox = Box.createHorizontalBox();
        JLabel label1 = new JLabel();
        label1.setText(ResourceManager.getString("PRE_UPGRADE_PROMPT"));
        JPanel extract = new JPanel(new BorderLayout());
        extract.add((Component)this.extractLable, "North");
        label1.setBorder(new EmptyBorder(0, 10, 6, 0));
        extract.setBorder(new EmptyBorder(0, 0, 10, 0));
        extractBox.add(label1);
        extractBox.add(extract);
        extractBox.add(Box.createHorizontalGlue());
        if (this.isExtractPackage()) {
            rightPanel.add(extractBox);
        }
        return rightPanel;
    }

    protected void initData() {
        if (null != this.getUpgradePrompt()) {
            this.textArea.setText(this.getUpgradePrompt());
        }
        ArrayList<DefaultTableRow<UpgradeObject, String>> rows = new ArrayList<DefaultTableRow<UpgradeObject, String>>(0);
        DefaultTableRow<UpgradeObject, String> row = null;
        for (UpgradeObject item : this.getAllUpgradeDevices()) {
            row = new DefaultTableRow<UpgradeObject, String>(DEVICE_MODEL_NAME.length, item, item.getObjectDeviceID());
            row.setValueAt(0, item.getObjectName());
            row.setValueAt(1, item.getObjectTypeDes());
            rows.add(row);
        }
        this.deviceTableModel.setTableData(rows.toArray(new TableRow[rows.size()]));
    }

    protected void addListeners() {
        this.deviceListTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                IntegratedUpgradeLayout.this.controlUpgradeButtonStatus();
            }
        });
    }

    private void controlUpgradeButtonStatus() {
        if (this.deviceListTable.getSelectedRow() >= 0) {
            this.upgradeButton.setEnabled(true);
        } else {
            this.upgradeButton.setEnabled(false);
        }
    }

    protected String getDeviceID() {
        return this.device;
    }

    public void addNextStepAction(Action action) {
        this.upgradeButton.addActionListener(new UpgradeBtnListner(action));
    }

    public void addCancelAction(Action action) {
        this.cancelButton.addActionListener(new CancelBtnLinstner(action));
    }

    public void addHelpAction(Action action) {
        this.helpButton.addActionListener(new HelpBtnListner(action));
    }

    protected abstract String getUpgradePrompt();

    protected abstract List<UpgradeObject> getAllUpgradeDevices();

    protected abstract boolean isExtractPackage();

    public JButton getUpgradeButton() {
        return this.upgradeButton;
    }

    public void setUpgradeButton(JButton upgradeButton) {
        this.upgradeButton = upgradeButton;
    }

    public JButton getCancelButton() {
        return this.cancelButton;
    }

    public void setCancelButton(JButton cancelButton) {
        this.cancelButton = cancelButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public void setHelpButton(JButton helpButton) {
        this.helpButton = helpButton;
    }

    public IsmTable getDeviceListTable() {
        return this.deviceListTable;
    }

    public void setDeviceListTable(IsmTable deviceListTable) {
        this.deviceListTable = deviceListTable;
    }

    public DefaultTableModel getDeviceTableModel() {
        return this.deviceTableModel;
    }

    public void setDeviceTableModel(DefaultTableModel deviceTableModel) {
        this.deviceTableModel = deviceTableModel;
    }

    public JLabel getExtractLable() {
        return this.extractLable;
    }

    public static class UpgradeObject {
        private String deviceID = null;
        private String deviceName = null;
        private String productTypeDes = null;

        public UpgradeObject(String deviceID, String deviceName, String productTypeDes) {
            this.deviceID = deviceID;
            this.deviceName = deviceName;
            this.productTypeDes = productTypeDes;
        }

        public String getObjectDeviceID() {
            return this.deviceID;
        }

        public String getObjectName() {
            return this.deviceName;
        }

        public String getObjectTypeDes() {
            return this.productTypeDes;
        }
    }

    private static final class UpgradeBtnListner
    implements ActionListener {
        private final Action action;

        private UpgradeBtnListner(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }
    }

    private static final class CancelBtnLinstner
    implements ActionListener {
        private final Action action;

        private CancelBtnLinstner(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }
    }

    private static final class HelpBtnListner
    implements ActionListener {
        private final Action action;

        private HelpBtnListner(Action action) {
            this.action = action;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.action.actionPerformed(actionEvent);
        }
    }
}

