/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PropertyDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Dimension DIM_KEY = new Dimension(150, 20);
    private static final Dimension DIM_VAL = new Dimension(190, 20);
    private JPanel contentPane;

    public PropertyDialog(Dialog owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initLayout();
        this.setResizable(false);
    }

    public PropertyDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
        this.initLayout();
        this.setResizable(false);
    }

    public void setPairs(Pair<String, String> ... pairs) {
        this.contentPane.removeAll();
        JLabel keyLabel = null;
        JLabel valLabel = null;
        Box box = null;
        for (Pair<String, String> pair : pairs) {
            keyLabel = new JLabel(pair.getKey(), 10);
            valLabel = new JLabel(pair.getValue(), 10);
            box = this.createHPairBox(keyLabel, DIM_KEY, 5, valLabel, DIM_VAL);
            this.contentPane.add(box);
            this.contentPane.add(Box.createVerticalStrut(5));
        }
        this.contentPane.add(Box.createGlue());
        this.pack();
        SwingUtil.putScreenCenter(this);
    }

    private void initLayout() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
        this.contentPane.setBackground(Color.WHITE);
        this.contentPane.setBorder(UCD.createEtchedBorder());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createGlue());
        JButton closeButton = UCD.createButton(ResourceManager.getString("ALARM_DIALOG_CLOSE"), 'L');
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyDialog.this.dispose();
            }
        });
        buttonBox.add(closeButton);
        JPanel basePanel = new JPanel(new BorderLayout(8, 8));
        basePanel.setBorder(UCD.createEmptyBorder());
        basePanel.add((Component)this.contentPane, "Center");
        basePanel.add((Component)buttonBox, "South");
        this.getContentPane().add(basePanel);
    }

    private Box createHPairBox(JComponent key, Dimension keyDim, int gap, JComponent value, Dimension valDim) {
        Box pair = Box.createHorizontalBox();
        key.setPreferredSize(keyDim);
        key.setMaximumSize(keyDim);
        key.setMinimumSize(keyDim);
        pair.add(key);
        pair.add(Box.createHorizontalStrut(gap));
        value.setPreferredSize(valDim);
        value.setMaximumSize(valDim);
        value.setMinimumSize(valDim);
        pair.add(value);
        return pair;
    }
}

