/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.settingpane;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.swing.control.ImgsAssembledPane;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.layoutmanager.GroupLayout;
import com.huawei.ism.ui.templets.settingpane.DefaultRightPane;
import com.huawei.ism.ui.templets.settingpane.NavigationLabel;
import com.huawei.ism.ui.templets.settingpane.SettingsRightPane;
import com.huawei.ism.ui2.mainframe.device.FeatureModulePane;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SettingsPane
extends FeatureModulePane {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsPane.class);
    private static final long serialVersionUID = -6276777216340290201L;
    private JPanel leftPane = null;
    private JPanel rightPanel = null;
    private SettingItem currentItem = null;
    private List<NavigationLabel> labels = new ArrayList<NavigationLabel>(0);
    private int leftWidthen = 200;
    private int leftWidthzh = 200;

    public SettingsPane(String deviceID) {
        this(deviceID, 200, 200);
    }

    public SettingsPane(String deviceID, int widthen, int widthzh) {
        super(deviceID);
        this.leftWidthen = widthen;
        this.leftWidthzh = widthzh;
        this.doLayoutUI();
    }

    @Override
    public void updateProperty(int updateMode) {
        if (1 == updateMode) {
            return;
        }
        this.aboutToShow(this.currentItem);
    }

    @Override
    public boolean allowLeaveOff() {
        if (null == this.currentItem) {
            return true;
        }
        boolean alloweLeaveOff = true;
        SettingsRightPane rightPane = this.currentItem.getContentPane();
        Window parent = SwingUtilities.getWindowAncestor(this);
        if (rightPane.isChanged()) {
            boolean confirm = ConfirmDialog.showDialog(parent, ConfirmDialog.Level.INFO, ResourceManager.getString("SETTINGSPANE.CHANGE.LEAVEOFF_DESC"), ResourceManager.getString("SETTINGSPANE.CHANGE.LEAVEOFF_RESULT"), "", "");
            if (confirm) {
                rightPane.doCancelTask();
                alloweLeaveOff = true;
            } else {
                alloweLeaveOff = false;
            }
        }
        return alloweLeaveOff;
    }

    protected abstract List<SettingsRightPane> getAllSettingItems();

    @Override
    public String getHelpKey() {
        if (null == this.currentItem) {
            return super.getHelpKey();
        }
        return this.currentItem.getContentPane().getHelpKey();
    }

    void aboutToShow(SettingItem settingItem) {
        Assert.notNull(settingItem);
        this.doTaskBeforeHiding();
        final SettingsRightPane rightPane = settingItem.getContentPane();
        Window window = SwingUtilities.getWindowAncestor(this);
        rightPane.setParentWindow(window);
        Callable<Boolean> task = new Callable<Boolean>(){

            @Override
            public Boolean call() {
                rightPane.setDeviceID(SettingsPane.this.getDeviceID());
                return rightPane.onInitCommand();
            }
        };
        List<?> results = AsyncExcutor.execute(window, task);
        if (null == results) {
            return;
        }
        Object result = results.get(0);
        this.showRightPane(settingItem, result, rightPane.getErrorInfor(), rightPane.getButtonText(), rightPane.isShowErrorInfor());
    }

    private void showRightPane(SettingItem settingItem, Object result, String errorInfor, String buttonText, Boolean isShow) {
        SettingsRightPane rightPane = settingItem.getContentPane();
        this.currentItem = settingItem;
        if (result instanceof Boolean) {
            Boolean boolResult = (Boolean)result;
            if (boolResult.booleanValue()) {
                this.showRightPane(rightPane);
            } else {
                this.resetDefaultRightPane("", settingItem, errorInfor, buttonText, isShow);
            }
        } else if (result instanceof Exception) {
            LOGGER.error("", result);
            String errMsg = CommonUtil.change2ErrMsg((Exception)result);
            this.resetDefaultRightPane(errMsg, settingItem, errorInfor, buttonText, isShow);
        }
    }

    private void doTaskBeforeHiding() {
        if (null == this.currentItem) {
            return;
        }
        SettingsRightPane oldRightPane = this.currentItem.getContentPane();
        MyHaidingTask runnable = new MyHaidingTask(oldRightPane);
        ThreadPoolManager.getInstance().execute(runnable);
    }

    void resetDefaultRightPane(String errMsg, SettingItem failedItem, String errorInfor, String buttonText, Boolean isShowErrorInfor) {
        DefaultRightPane defaultRightPane = DefaultRightPane.getInstance();
        defaultRightPane.setErrMsg(errMsg);
        if (isShowErrorInfor.booleanValue() && null != errorInfor) {
            defaultRightPane.setErrMsg(errorInfor);
        }
        if (isShowErrorInfor.booleanValue() && null != buttonText) {
            defaultRightPane.setButtonText(buttonText);
        }
        defaultRightPane.setSettingItem(failedItem);
        this.showRightPane(defaultRightPane);
    }

    SettingItem getCurrentSettingItem() {
        return this.currentItem;
    }

    private void showRightPane(final SettingsRightPane rightPane) {
        Assert.notNull(rightPane);
        SwingUtil.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                SettingsPane.this.rightPanel.removeAll();
                SettingsPane.this.rightPanel.add((Component)rightPane, "Center");
                SettingsPane.this.rightPanel.repaint();
                SettingsPane.this.rightPanel.revalidate();
                rightPane.afterShow();
            }
        });
    }

    private void doLayoutUI() {
        this.setLayout(new BorderLayout());
        this.setOpaque(false);
        this.leftPane = UCD.createTransparentPane(new GroupLayout());
        Box leftBox = Box.createVerticalBox();
        leftBox.add(this.leftPane);
        leftBox.add(Box.createVerticalGlue());
        if (Locale.getDefault().equals(Locale.ENGLISH)) {
            leftBox.setMinimumSize(new Dimension(this.leftWidthen, 0));
            leftBox.setPreferredSize(new Dimension(this.leftWidthen, 0));
        } else {
            leftBox.setMinimumSize(new Dimension(this.leftWidthzh, 0));
            leftBox.setPreferredSize(new Dimension(this.leftWidthzh, 0));
        }
        this.rightPanel = UCD.createTransparentPane(new BorderLayout());
        this.rightPanel.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.rightPanel.setMinimumSize(new Dimension(300, 0));
        this.add((Component)UCD.buildHBoxLeft(leftBox, new ImgsAssembledPane.VerticalSeparator()), "West");
        this.add((Component)this.rightPanel, "Center");
        this.addSettingItem();
    }

    private void addSettingItem() {
        this.labels.clear();
        List<SettingsRightPane> featureItems = this.getAllSettingItems();
        Assert.notNullList(featureItems);
        SettingItem settingItem = null;
        NavigationLabel navigation = null;
        for (SettingsRightPane rightPane : featureItems) {
            settingItem = new SettingItem(rightPane);
            navigation = new NavigationLabel(settingItem);
            this.labels.add(navigation);
            this.leftPane.add(navigation);
            if (null != this.currentItem) continue;
            this.currentItem = settingItem;
            navigation.setSelected(true);
        }
    }

    void updateNavigation() {
        for (NavigationLabel label : this.labels) {
            if (label.getSettingItem() == this.currentItem) {
                label.setSelected(true);
                continue;
            }
            label.setSelected(false);
        }
    }

    @Override
    public final void stopDisplay() {
        super.stopDisplay();
        this.doTaskBeforeHiding();
    }

    static class SettingItem {
        private SettingsRightPane contentPane;

        public SettingItem(SettingsRightPane contentPane) {
            Assert.notNull(contentPane);
            this.contentPane = contentPane;
        }

        public SettingsRightPane getContentPane() {
            return this.contentPane;
        }

        public String getName() {
            return this.contentPane.getItemTitle();
        }
    }

    private static final class MyHaidingTask
    implements Runnable {
        private final SettingsRightPane oldRightPane;

        private MyHaidingTask(SettingsRightPane oldRightPane) {
            this.oldRightPane = oldRightPane;
        }

        @Override
        public void run() {
            this.oldRightPane.doTaskBeforeHiding();
        }
    }
}

