/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.templets.wizard;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.templets.wizard.Wizard;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import javax.swing.JPanel;

public abstract class Card {
    public static final String COMMAND_LIST_IDENTIFIER = "CommandListIdentifier";
    public static final String COMMAND_EXCUTOR_MODE = "CommandExcutorMode";
    static final Step FINISH_STEP = new Step(0, 1, null, null);
    private Wizard wizard;
    private JPanel cardView;
    private StepID currentStepID;
    private Step currentStep;
    private boolean isInitial = false;
    private Step currentCardStep;

    public Card() {
        this.cardView = UCD.createTransparentPane(new BorderLayout());
    }

    public Card(JPanel cardView) {
        this.setCardView(cardView);
    }

    public final void setCardView(JPanel cardView) {
        this.cardView = cardView;
        cardView.setOpaque(false);
    }

    protected final JPanel getCardView() {
        return this.cardView;
    }

    Step getCurrentStep() {
        this.currentStep = null != this.currentCardStep ? this.currentCardStep : this.getStep();
        return this.currentStep;
    }

    protected abstract Step getStep();

    protected abstract Wizard.CardHead getCardHead();

    protected abstract String getHelpKey();

    void setCurrentStepID(StepID stepID) {
        this.currentStepID = stepID;
    }

    StepID getCurrentStepID() {
        return this.currentStepID;
    }

    protected boolean onNextCommand() {
        return true;
    }

    protected boolean onPreviousCommand() {
        return true;
    }

    boolean doCloseTask() {
        Step step = null;
        step = null == this.getCurrentCardStep() ? this.getStep() : this.getCurrentCardStep();
        if (step != FINISH_STEP) {
            boolean isSummaryCard = this.getWizard().getModel().arraivedSummaryCard();
            if (isSummaryCard && !this.getWizard().isShowFinishedCard()) {
                return this.onCancelCommand();
            }
            String msg = ResourceManager.getStringWithParams("wizard.cancel.warning", this.getWizard().getWizardTitle());
            WarningDialog dlg = DialogUtils.showYesNoDialog(this.getWizard(), msg);
            if (dlg.getValue() != 0) {
                return false;
            }
        }
        return this.onCancelCommand();
    }

    void doAfterClosing() {
    }

    protected boolean onCancelCommand() {
        return true;
    }

    protected boolean onFinishCommand() {
        return true;
    }

    protected boolean doInitTask() {
        return true;
    }

    protected final boolean isInitiated() {
        return this.isInitial;
    }

    boolean onInitCommand() {
        boolean initSuccess = this.doInitTask();
        if (initSuccess && !this.isInitial) {
            this.isInitial = true;
        }
        return initSuccess;
    }

    protected void showing() {
    }

    void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    protected Wizard getWizard() {
        return this.wizard;
    }

    public Step getCurrentCardStep() {
        return this.currentCardStep;
    }

    public void setCurrentCardStep(Step currentCardStep) {
        this.currentCardStep = currentCardStep;
    }

    public static class Step {
        private int currentStep;
        private int totalStep;
        private StepID prevStepID;
        private StepID nextStepID;

        public Step(int currentStep, int totalStep, StepID prevStepID, StepID nextStepID) {
            this.currentStep = currentStep;
            this.totalStep = totalStep;
            this.prevStepID = prevStepID;
            this.nextStepID = nextStepID;
        }

        public int getCurrentStep() {
            return this.currentStep;
        }

        public int getTotalStep() {
            return this.totalStep;
        }

        public StepID getNextStepID() {
            return this.nextStepID;
        }

        public StepID getPrevStepID() {
            return this.prevStepID;
        }
    }

    public static enum StepID {
        FinishedCard,
        FirstCard,
        SecondCard,
        ThirdCard,
        FourCard,
        FiveCard,
        SixCard,
        SevenCard,
        EightCard,
        NineCard,
        TenCard;

    }
}

