/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui.widgets.action;

import com.huawei.ism.common.bean.User;
import com.huawei.ism.ui.widgets.action.CfgElement;
import com.huawei.ism.util.parser.XmlUtils;
import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.KeyStroke;
import org.w3c.dom.Element;

public class ActionElement
extends CfgElement {
    public static final int VALID_ACCELERATOR_LENGTH = 2;
    public static final int SINGLE_CHARACTER = 1;
    public static final String NODE_NAME_USER = "user";
    public static final String NODE_NAME_CLASS_NAME = "class-name";
    public static final String NODE_NAME_KEY = "key";
    public static final String NODE_NAME_ACTION_ID = "action-id";
    public static final String NODE_NAME_MNEMONIC = "mnemonic";
    public static final String NODE_NAME_ACCELEATOR = "accelerator";
    public static final String NODE_NAME_PROPERTY_FILE = "property-file";
    private static final String ACCELERATOR_VALUE_CTRL = "ctrl";
    private static final String ACCELERATOR_VALUE_SHIFT = "shift";
    private static final String ACCELERATOR_VALUE_ALT = "alt";
    private static final String ACCELERATOR_VALUE_META = "meta";
    private static final int INVALID_VALUE = -1;
    private String actionID = null;
    private String key = null;
    private String className = null;
    private int mnemonic = -1;
    private KeyStroke keyStore = null;
    private User.Level userType = null;
    private String propertyFile = null;
    private boolean isNeedLoad;
    private Map<String, String> property = new HashMap<String, String>(0);

    public ActionElement(Element element) {
        this.parseActionElement(element);
    }

    public String getActionID() {
        return this.actionID;
    }

    public String getKey() {
        return this.key;
    }

    public String getClassName() {
        return this.className;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public boolean isNeedLoad() {
        return this.isNeedLoad;
    }

    public KeyStroke getKeyStore() {
        return this.keyStore;
    }

    public User.Level getUserType() {
        return this.userType;
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    private void parseActionElement(Element node) {
        String proerptyFile;
        String strAccelerator;
        String strMnemonic;
        this.actionID = XmlUtils.getTextContentOfChild(node, NODE_NAME_ACTION_ID);
        if (ActionElement.isNull(this.actionID)) {
            RuntimeException ex = new RuntimeException("There is an action doesn't have \"actionID\" in action.xml");
            throw ex;
        }
        this.className = XmlUtils.getTextContentOfChild(node, NODE_NAME_CLASS_NAME);
        if (ActionElement.isNull(this.className)) {
            RuntimeException ex = new RuntimeException("The class name of the action \"" + this.actionID + "\" is null");
            throw ex;
        }
        this.key = XmlUtils.getTextContentOfChild(node, NODE_NAME_KEY);
        if (ActionElement.isNull(this.key)) {
            RuntimeException ex = new RuntimeException("The key of the action \"" + this.actionID + "\" is null");
            throw ex;
        }
        String user = XmlUtils.getTextContentOfChild(node, NODE_NAME_USER);
        if (!ActionElement.isNull(user)) {
            this.userType = this.getUserLevel(user);
        }
        if (!ActionElement.isNull(strMnemonic = XmlUtils.getTextContentOfChild(node, NODE_NAME_MNEMONIC))) {
            int iMnemonic = ActionElement.dealWithMnemonic(strMnemonic);
            this.mnemonic = (char)iMnemonic;
        }
        if (!ActionElement.isNull(strAccelerator = XmlUtils.getTextContentOfChild(node, NODE_NAME_ACCELEATOR))) {
            this.keyStore = this.getAccelerator(strAccelerator);
        }
        if (!ActionElement.isNull(proerptyFile = XmlUtils.getTextContentOfChild(node, NODE_NAME_PROPERTY_FILE))) {
            this.propertyFile = proerptyFile;
        }
        this.isNeedLoad = true;
        String needLoad = node.getAttribute("load");
        if (!ActionElement.isNull(needLoad)) {
            this.isNeedLoad = Boolean.valueOf(needLoad);
        }
    }

    private KeyStroke getAccelerator(String accelerator) {
        if (ActionElement.isNull(accelerator)) {
            return null;
        }
        String[] strings = accelerator.split(",");
        int keyValue = -1;
        int modifiers = 0;
        if (strings.length == 1) {
            keyValue = this.getVKValue(strings[0]);
        } else if (strings.length == 2) {
            keyValue = this.getVKValue(strings[1]);
            modifiers = this.getModifiers(strings[0]);
        }
        KeyStroke keyStroke = null;
        if (-1 != keyValue && -1 != modifiers) {
            keyStroke = modifiers == 128 ? KeyStroke.getKeyStroke(keyValue, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false) : KeyStroke.getKeyStroke(keyValue, modifiers);
        } else {
            RuntimeException ex = new RuntimeException("The accelerator of the action \"" + this.actionID + "\" is invalid");
            throw ex;
        }
        return keyStroke;
    }

    private int getVKValue(String str) {
        if (ActionElement.isNull(str)) {
            return -1;
        }
        if (str.equalsIgnoreCase("f1")) {
            return 112;
        }
        if (str.equalsIgnoreCase("f5")) {
            return 116;
        }
        if (str.equalsIgnoreCase("esc")) {
            return 27;
        }
        if (1 == str.length()) {
            char charAt = str.toUpperCase(Locale.ENGLISH).charAt(0);
            return charAt;
        }
        return -1;
    }

    private int getModifiers(String modifiers) {
        int mask = -1;
        if (ACCELERATOR_VALUE_CTRL.equalsIgnoreCase(modifiers)) {
            mask = 128;
        } else if (ACCELERATOR_VALUE_SHIFT.equalsIgnoreCase(modifiers)) {
            mask = 64;
        } else if (ACCELERATOR_VALUE_ALT.equalsIgnoreCase(modifiers)) {
            mask = 512;
        } else if (ACCELERATOR_VALUE_META.equalsIgnoreCase(modifiers)) {
            mask = 256;
        }
        return mask;
    }

    private User.Level getUserLevel(String user) {
        User.Level userLevel = null;
        if ("admin".equalsIgnoreCase(user)) {
            userLevel = User.Level.Admin;
        } else if ("super".equalsIgnoreCase(user)) {
            userLevel = User.Level.SuperAdmin;
        } else if ("readonly".equalsIgnoreCase(user)) {
            userLevel = User.Level.ReadOnly;
        } else {
            this.property.put(NODE_NAME_USER, user);
        }
        return userLevel;
    }

    public static class UserType {
        public static final String ADMIN = "admin";
        public static final String READONLY = "readonly";
        public static final String COMMON = "common";
        public static final String SUPER = "super";
    }
}

