/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.ui2.mainframe.device;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.IDataChangeListener;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.TimerTaskManager;
import com.huawei.ism.common.UIController;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.RunningState;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.ui.forms.help.HelpKeyGetter;
import com.huawei.ism.ui.forms.help.HelpManager;
import com.huawei.ism.ui.forms.lockui.LogoutTimeSettingDialog;
import com.huawei.ism.ui.module.event.EventBuzzHandle;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.IsmGradientPanel;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.control.NavigationPane;
import com.huawei.ism.ui.swing.control.ToolBarButton;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.ui2.mainframe.device.AboutPopup;
import com.huawei.ism.ui2.mainframe.device.DeviceApplet;
import com.huawei.ism.ui2.module.event.DefaultEventStatPane;
import com.huawei.ism.ui2.module.event.alarmbuzzer.IsmAlarmBuzzerSwitchDialog;
import com.huawei.ism.ui2.module.featuremanager.FeatureItem;
import com.huawei.ism.ui2.module.featuremanager.FeatureItemFactory;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.Pair;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.UCD;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevicePane
extends ImagePanel
implements IDataChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevicePane.class);
    private static final long serialVersionUID = -7345935865028367509L;
    private static AboutPopup aboutPopup = new AboutPopup();
    private DeviceApplet devApplet = null;
    private DeviceContext deviceContext = null;
    private MainPane mainPane = null;
    private StatusBar statusBar = null;

    public DevicePane(DeviceContext deviceContext) {
        this(deviceContext, null);
    }

    public DevicePane(DeviceContext deviceContext, DeviceApplet deviceApplet) {
        super(ResourceManager.getImage("mainframe_background.png"), ImagePanel.ExtendOrient.HORIZONAL_AND_VETICAL);
        this.deviceContext = deviceContext;
        this.devApplet = deviceApplet;
        this.doLayoutUI();
        SwingUtil.setName(this);
        UIController.getInstance().addDataChangeListener(this);
    }

    void updateFeaturePane() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DevicePane.this.mainPane.updateFeaturePane();
                DevicePane.this.statusBar.update();
            }
        };
        SwingUtil.runInEventDispatchThread(runnable);
    }

    void stopShow() {
        this.mainPane.stopShow();
    }

    public void setFeaturePane(final FeatureItem featureItem) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DevicePane.this.mainPane.setFeaturePane(featureItem);
                DevicePane.this.statusBar.update();
            }
        };
        SwingUtil.runInEventDispatchThread(runnable);
    }

    private void doLayoutUI() {
        TitleBar titleBar = new TitleBar(this.devApplet);
        this.mainPane = new MainPane(this.deviceContext);
        this.statusBar = new StatusBar(this.deviceContext.getDeviceID());
        this.setLayout(new BorderLayout());
        this.add((Component)titleBar, "North");
        this.add((Component)this.mainPane, "Center");
        this.add((Component)this.statusBar, "South");
        this.setBorder(new EmptyBorder(0, 5, 0, 5));
    }

    @Override
    public void dataChanged(IDataChangeListener.DataChangeEvent dataChangeEvent) {
        this.updateFeaturePane();
    }

    static {
        final Toolkit tk = Toolkit.getDefaultToolkit();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                tk.addAWTEventListener(new MouseGrabberListener(), -2147352464L);
                return null;
            }
        });
    }

    private static class RightNavigation
    extends JToggleButton
    implements ActionListener {
        private static final long serialVersionUID = 913794642197353832L;
        private transient FeatureItem item;

        public RightNavigation(FeatureItem featureItem) {
            this.item = featureItem;
            this.setBorderPainted(false);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.setIcon(featureItem.getNormalIcon());
            this.setRolloverIcon(featureItem.getSelectedIcon());
            this.setSelectedIcon(featureItem.getSelectedIcon());
            this.setMargin(new Insets(0, 1, 0, 2));
            if (null == featureItem.getTooltipText()) {
                this.setToolTipText(featureItem.getName());
            }
            this.addActionListener(this);
        }

        @Override
        public void setUI(ButtonUI ui) {
            super.setUI(new MetalToggleButtonUI());
        }

        public FeatureItem getFeatureItem() {
            return this.item;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FeatureItem featureItem = this.getFeatureItem();
            DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, this);
            if (!featureItem.isTopFeatureItemn() && Framework.getInstance().getStrProperty("-devicetype").equals("N8000")) {
                FeatureItem parentfeatureItem = FeatureItemFactory.getFeatureItem(this.getNasDeviceID(featureItem.getDeviceID()), DeviceType.N8000, "all_device_view");
                featureItem.setParent(parentfeatureItem);
            }
            devicePane.setFeaturePane(featureItem);
        }

        private String getNasDeviceID(String deviceID) {
            String nasDeviceID = null;
            nasDeviceID = LauncherManager.getInstance().getLauncher(deviceID).getDevContext().getDeviceType().equals((Object)DeviceType.N8000) ? deviceID : this.getNasDeviceIDN8();
            return nasDeviceID;
        }

        private String getNasDeviceIDN8() {
            String nasDeviceID = null;
            List<Launcher> allLauncher = LauncherManager.getInstance().getAllLauncher();
            for (Launcher tempLauncher : allLauncher) {
                if (!tempLauncher.getDevContext().getDeviceType().equals((Object)DeviceType.N8000)) continue;
                nasDeviceID = tempLauncher.getDeviceID();
                break;
            }
            return nasDeviceID;
        }
    }

    private static class RightNavigationPane
    extends JPanel {
        private static final long serialVersionUID = 727633637624164500L;
        private static final ImageIcon TOP_IMG_ICON = ResourceManager.getImage("device_navigation_top_background.png");
        private static final ImageIcon CENTER_IMG_ICON = ResourceManager.getImage("device_navigation_center_background.png");
        private static final ImageIcon BOTTOM_IMG_ICON = ResourceManager.getImage("device_navigation_bottom_background.png");

        public RightNavigationPane() {
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.drawImage(TOP_IMG_ICON.getImage(), 0, 0, width, TOP_IMG_ICON.getIconHeight(), this);
            graphics.drawImage(CENTER_IMG_ICON.getImage(), 0, TOP_IMG_ICON.getIconHeight(), width, height - TOP_IMG_ICON.getIconHeight() - BOTTOM_IMG_ICON.getIconHeight(), this);
            graphics.drawImage(BOTTOM_IMG_ICON.getImage(), 0, height - BOTTOM_IMG_ICON.getIconHeight(), width, TOP_IMG_ICON.getIconHeight(), this);
        }
    }

    private static class TopNavigationHandler
    extends MouseAdapter {
        private TopNavigationHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            TopNavigation topNavigation = (TopNavigation)mouseEvent.getSource();
            DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, topNavigation);
            devicePane.setFeaturePane(topNavigation.getFeatureItem());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TopNavigation topNavigation = (TopNavigation)mouseEvent.getSource();
            topNavigation.setForeground(UIManager.getColor("IsmOEMTheme.renderColor"));
            topNavigation.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TopNavigation topNavigation = (TopNavigation)mouseEvent.getSource();
            topNavigation.setForeground(UIManager.getColor("PlainFont.color"));
            topNavigation.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static class TopNavigation
    extends JLabel {
        private static final long serialVersionUID = -2020038155278743658L;
        private transient FeatureItem featureItem;

        public TopNavigation(FeatureItem featureItem) {
            this.featureItem = featureItem;
            this.setFont(IsmFontFactory.getBold12Font());
            this.setText(featureItem.getName());
            this.setBorder(new EmptyBorder(0, 2, 0, 2));
        }

        public FeatureItem getFeatureItem() {
            return this.featureItem;
        }

        @Override
        public void paint(Graphics graphics) {
            CommonUtil.convertObject(graphics, Graphics2D.class).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            super.paint(graphics);
        }
    }

    private static class TopNavigationPane
    extends JPanel {
        private static final long serialVersionUID = -5915671434054352582L;
        private static final Icon SEPARATOR = ResourceManager.getImage("navigationpane_rightarrow.png");
        private String deviceID;
        private NavigationPane navigationPane;
        private DeviceNameLabel deviceNamePane;
        private boolean isNas;
        private transient FeatureItem tempfeature = null;

        public TopNavigationPane(String deviceID) {
            this.deviceID = deviceID;
            this.navigationPane = new NavigationPane();
            this.deviceNamePane = new DeviceNameLabel(deviceID, true);
            this.setLayout(new BorderLayout());
            this.add((Component)this.navigationPane, "Center");
            this.setBorder(new EmptyBorder(0, 0, 2, 0));
            this.setOpaque(false);
        }

        public TopNavigationPane(String deviceID, boolean isNas) {
            this(deviceID);
            this.deviceNamePane = new DeviceNameLabel(deviceID, isNas);
            this.isNas = isNas;
        }

        private JPanel createNavBox(FeatureItem featureItem) {
            JPanel hBox = new JPanel();
            hBox.setLayout(new BoxLayout(hBox, 0));
            hBox.add(this.deviceNamePane);
            if (!this.isNas) {
                hBox.add(this.createSeperatorBox());
            }
            this.degradeForcreateNavBox(featureItem, hBox);
            if (this.isNas) {
                this.deviceID = featureItem.getDeviceID() != null ? featureItem.getDeviceID() : this.deviceID;
                this.deviceNamePane.setText("");
            }
            TopNavigation selectedFeatureItem = new TopNavigation(featureItem);
            if (this.isNas && !featureItem.isTopFeatureItemn() && !featureItem.getParents().isEmpty() && featureItem.getParents().get(featureItem.getParents().size() - 1).isTopFeatureItemn()) {
                selectedFeatureItem.setText(CommonUtil.getDeviceNameOrDeviceID(featureItem.getDeviceID()) + "__" + featureItem.getName());
            }
            selectedFeatureItem.setForeground(UIManager.getColor("IsmOEMTheme.renderColor"));
            hBox.add(selectedFeatureItem);
            hBox.add(Box.createHorizontalGlue());
            ImageIcon helpIcon = ResourceManager.getImage("table_help.png");
            JLabel helpLink = new JLabel(helpIcon);
            UCD.setJComponentSize(helpLink, new Dimension(helpIcon.getIconWidth(), helpIcon.getIconHeight()));
            HelpManager.getInstance().linkHelp(helpLink, (HelpKeyGetter)featureItem.getPropertyPane());
            hBox.add(helpLink);
            return hBox;
        }

        private void degradeForcreateNavBox(FeatureItem featureItem, JPanel hBox) {
            List<FeatureItem> parentItems = featureItem.getParents();
            TopNavigation parentNavigation = null;
            for (FeatureItem feature : parentItems) {
                if (this.isNas && feature.isTopFeatureItemn()) {
                    this.tempfeature = feature;
                    this.degradeDepth(hBox);
                } else {
                    parentNavigation = new TopNavigation(feature);
                    parentNavigation.addMouseListener(new TopNavigationHandler());
                    hBox.add(parentNavigation);
                    hBox.add(this.createSeperatorBox());
                }
                if (null == parentNavigation || !this.isNas || feature.isTopFeatureItemn() || feature.getParents().isEmpty() || !feature.getParents().get(0).isTopFeatureItemn()) continue;
                parentNavigation.setText(CommonUtil.getDeviceNameOrDeviceID(featureItem.getDeviceID()) + "__" + feature.getName());
            }
        }

        private void degradeDepth(JPanel hBox) {
            JComboBox<String> allFeatureCombo = new JComboBox<String>();
            UCD.setJComponentSize(allFeatureCombo, new Dimension(200, 20));
            List<FeatureItem> allFeatureItem = SwingUtil.getFeatureItems(this.tempfeature.getDeviceID());
            for (FeatureItem tempFeatureItem : allFeatureItem) {
                allFeatureCombo.addItem(tempFeatureItem.getName());
            }
            allFeatureCombo.addActionListener(new AllFeatureListener());
            hBox.add(allFeatureCombo);
            hBox.add(this.createSeperatorBox());
        }

        private Box createSeperatorBox() {
            Box seperatorBox = Box.createHorizontalBox();
            seperatorBox.add(Box.createHorizontalStrut(5));
            seperatorBox.add(new JLabel(SEPARATOR));
            seperatorBox.add(Box.createHorizontalStrut(5));
            return seperatorBox;
        }

        private void updateSystemStatusIcon() {
            DeviceContext deviceContext = LauncherManager.getInstance().getDeviceContext(this.deviceID);
            String deviceStatus = null;
            if (null == deviceContext) {
                LOGGER.error("deviceContext is null.");
                return;
            }
            deviceStatus = deviceContext.getDeviceStatus();
            if (deviceContext.getDeviceType().toString().equals(DeviceType.N8000.toString()) || deviceContext.getDeviceType().toString().equals(DeviceType.NEX.toString())) {
                deviceStatus = deviceContext.getDeviceRunningState();
                if (null == deviceStatus) {
                    deviceStatus = ResourceManager.getString("EnumDefine.RUNNING_STATUS_E.OFFLINE");
                    LOGGER.error("deviceContext is null.");
                }
                this.updateStatusWithNEXAndN8000(deviceStatus);
                return;
            }
            if (deviceStatus.equalsIgnoreCase(ResourceManager.getString("EnumDefine.RUNNING_STATUS_E.OFFLINE"))) {
                this.deviceNamePane.setIcon(ResourceManager.getImage("state_offline.png"));
            } else if (deviceStatus.equalsIgnoreCase(ResourceManager.getString("EnumDefine.RUNNING_STATUS_E.NORMAL"))) {
                this.deviceNamePane.setIcon(ResourceManager.getImage("state_normal.png"));
            } else if (deviceStatus.equalsIgnoreCase(ResourceManager.getString("EnumDefine.RUNNING_STATUS_E.NOT_RUNNING")) || deviceStatus.equalsIgnoreCase(ResourceManager.getString("EnumDefine.RUNNING_STATUS_E.UPGRADING"))) {
                this.deviceNamePane.setIcon(ResourceManager.getImage("state_fault.png"));
            }
        }

        private void updateStatusWithNEXAndN8000(String deviceStatus) {
            if (deviceStatus.equalsIgnoreCase(RunningState.ONLINE.getDescription()) || deviceStatus.equalsIgnoreCase(ResourceManager.getString("EnumDefine.RUNNING_STATUS_E.NORMAL"))) {
                this.deviceNamePane.setIcon(ResourceManager.getImage("state_normal.png"));
            } else if (deviceStatus.equalsIgnoreCase(RunningState.OFFLINE.getDescription())) {
                this.deviceNamePane.setIcon(ResourceManager.getImage("state_offline.png"));
            } else {
                this.deviceNamePane.setIcon(ResourceManager.getImage("state_fault.png"));
            }
        }

        void manualUpdate(FeatureItem featureItem) {
            JPanel navBox = this.createNavBox(featureItem);
            this.navigationPane.addContentPane(navBox);
            if (!this.isNas) {
                this.deviceNamePane.update();
            }
            this.updateSystemStatusIcon();
            this.navigationPane.revalidate();
            this.navigationPane.repaint();
        }

        void autoUpdate() {
            if (!this.isNas) {
                this.deviceNamePane.update();
            }
            this.updateSystemStatusIcon();
            this.revalidate();
            this.repaint();
        }

        class AllFeatureListener
        implements ActionListener {
            AllFeatureListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox topNavigation = (JComboBox)actionEvent.getSource();
                DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, topNavigation);
                List<FeatureItem> allFeatureItem = SwingUtil.getFeatureItems(TopNavigationPane.this.tempfeature.getDeviceID());
                FeatureItem selectedFeatureItem = null;
                for (FeatureItem tempFeatureItem : allFeatureItem) {
                    if (!tempFeatureItem.getName().equalsIgnoreCase((String)topNavigation.getSelectedItem())) continue;
                    selectedFeatureItem = tempFeatureItem;
                    break;
                }
                devicePane.setFeaturePane(selectedFeatureItem);
            }
        }
    }

    private static class MainPane
    extends JPanel {
        private static final long serialVersionUID = -2229239754806718940L;
        private static final ImageIcon LEFT_TOP_CORNER = ResourceManager.getImage("device_lefttop_corner.png");
        private static final ImageIcon TOP_CENTER = ResourceManager.getImage("device_topcenter.png");
        private static final ImageIcon RIGHT_TOP_CORNER = ResourceManager.getImage("device_righttop_corner.png");
        private JPanel contentPane = null;
        private TopNavigationPane topNavigationPane = null;
        private PropertyPane newPane = null;
        private DeviceContext devContext = null;
        private ConcurrentMap<String, JToggleButton> buttonMap = new ConcurrentHashMap<String, JToggleButton>();
        private boolean isTopFeaturetem = false;
        private String showDeviceID;
        private JPanel rightNavigationPane;

        public MainPane(DeviceContext deviceContext) {
            this.devContext = deviceContext;
            this.doLayoutUI();
        }

        public List<FeatureItem> getFeatureItems() {
            ArrayList<FeatureItem> featureItems = new ArrayList<FeatureItem>(0);
            FeatureItem featureItem = FeatureItemFactory.getFeatureItem(this.devContext.getDeviceID(), DeviceType.N8000, "home_dashborder");
            featureItems.add(featureItem);
            featureItem.setTopFeatureItemn(true);
            featureItem = FeatureItemFactory.getFeatureItem(this.devContext.getDeviceID(), DeviceType.N8000, "all_device_view");
            featureItems.add(featureItem);
            featureItem.setTopFeatureItemn(true);
            featureItem = FeatureItemFactory.getFeatureItem(this.devContext.getDeviceID(), DeviceType.N8000, "home_provising");
            featureItems.add(featureItem);
            featureItem.setTopFeatureItemn(true);
            featureItem = FeatureItemFactory.getFeatureItem(this.devContext.getDeviceID(), DeviceType.N8000, "home_event");
            featureItems.add(featureItem);
            featureItem.setTopFeatureItemn(true);
            featureItem = FeatureItemFactory.getFeatureItem(this.devContext.getDeviceID(), DeviceType.N8000, "home_performance");
            featureItems.add(featureItem);
            featureItem.setTopFeatureItemn(true);
            return featureItems;
        }

        private void doLayoutUI() {
            ArrayList<FeatureItem> showFeatureItem = new ArrayList<FeatureItem>();
            boolean isNas = false;
            if (Framework.getInstance().getStrProperty("-devicetype").equals("N8000")) {
                isNas = true;
            }
            this.rightNavigationPane = this.getRightNavigationPanel(isNas, this.showDeviceID, showFeatureItem);
            String showStr = null;
            showStr = null == ((FeatureItem)showFeatureItem.get(0)).getDeviceID() ? "DashBorder" : ((FeatureItem)showFeatureItem.get(0)).getDeviceID();
            this.topNavigationPane = new TopNavigationPane(showStr, isNas);
            this.contentPane = UCD.createTransparentPane(new BorderLayout());
            this.contentPane.setOpaque(false);
            this.contentPane.add((Component)this.topNavigationPane, "North");
            this.contentPane.setBorder(UCD.createEmptyBorder(10));
            this.setFeaturePane((FeatureItem)showFeatureItem.get(0));
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            this.setBackground(Color.WHITE);
            this.add((Component)this.contentPane, "Center");
            this.add((Component)this.rightNavigationPane, "East");
            this.setBorder(new EmptyBorder(0, 0, 1, 0));
        }

        private JPanel getRightNavigationPanel(boolean isTopItem, String showDeviceIDIn, List<FeatureItem> showFeatureItem) {
            RightNavigation firstSelectedButton = null;
            ArrayList<RightNavigation> featureButtons = new ArrayList<RightNavigation>(0);
            ButtonGroup buttonGroup = new ButtonGroup();
            List<FeatureItem> features = null;
            if (isTopItem) {
                this.isTopFeaturetem = true;
                features = SwingUtil.getFeatureItems(this.devContext.getDeviceID());
                LauncherManager.getInstance().setCurrentDeviceID(this.devContext.getDeviceID());
            } else {
                Launcher launcher;
                this.isTopFeaturetem = false;
                if (Framework.getInstance().getStrProperty("-devicetype").equals("N8000")) {
                    launcher = LauncherManager.getInstance().getLauncher(showDeviceIDIn);
                    features = launcher.getFeatureItems();
                } else {
                    launcher = LauncherManager.getInstance().getLauncher(this.devContext.getDeviceID());
                    features = launcher.getFeatureItems();
                }
            }
            RightNavigation featureButton = null;
            for (FeatureItem feature : features) {
                featureButton = new RightNavigation(feature);
                if (null == firstSelectedButton) {
                    firstSelectedButton = featureButton;
                }
                buttonGroup.add(featureButton);
                featureButtons.add(featureButton);
                this.buttonMap.put(feature.getName(), featureButton);
            }
            if (null == firstSelectedButton) {
                LOGGER.error("The firstSelectedButton parameter is null");
                throw new NullPointerException("firstSelectedButton is null");
            }
            FeatureItem feature = firstSelectedButton.getFeatureItem();
            showFeatureItem.add(feature);
            firstSelectedButton.setSelected(true);
            RightNavigationPane navigationBGPane = new RightNavigationPane();
            navigationBGPane.setLayout(new BoxLayout(navigationBGPane, 1));
            navigationBGPane.add(Box.createVerticalGlue());
            for (JToggleButton jToggleButton : featureButtons) {
                navigationBGPane.add(jToggleButton);
            }
            navigationBGPane.add(Box.createVerticalGlue());
            JPanel tempRightNavigationPane = UCD.createTransparentPane(new BorderLayout());
            tempRightNavigationPane.add((Component)navigationBGPane, "Center");
            tempRightNavigationPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            return tempRightNavigationPane;
        }

        private boolean checkDeviceIsExist(FeatureItem featureItem) {
            Launcher launcher = LauncherManager.getInstance().getLauncher(featureItem.getDeviceID());
            return null == launcher && !featureItem.getDeviceType().equals((Object)DeviceType.SWITCHFIBER);
        }

        void setFeaturePane(FeatureItem featureItem) {
            if (this.checkDeviceIsExist(featureItem)) {
                return;
            }
            if (null != this.newPane && featureItem.getPropertyPane() == this.newPane) {
                return;
            }
            if (null != this.newPane && !this.newPane.allowLeaveOff()) {
                return;
            }
            this.contentPane.removeAll();
            PropertyPane oldCurrentPane = this.newPane;
            this.newPane = featureItem.getPropertyPane();
            if (featureItem.isExpandItem()) {
                this.remove(this.rightNavigationPane);
                this.isTopFeaturetem = false;
            } else if (!this.isTopFeaturetem && featureItem.isTopFeatureItemn()) {
                ArrayList<FeatureItem> showFeatureItem = new ArrayList<FeatureItem>();
                JPanel oldPanel = this.rightNavigationPane;
                this.rightNavigationPane = this.getRightNavigationPanel(true, featureItem.getDeviceID(), showFeatureItem);
                this.showDeviceID = featureItem.getDeviceID();
                this.remove(oldPanel);
                this.add((Component)this.rightNavigationPane, "East");
            } else if (this.isTopFeaturetem && !featureItem.isTopFeatureItemn()) {
                ArrayList<FeatureItem> showFeatureItem = new ArrayList<FeatureItem>();
                JPanel oldPanel = this.rightNavigationPane;
                this.rightNavigationPane = this.getRightNavigationPanel(false, featureItem.getDeviceID(), showFeatureItem);
                this.showDeviceID = featureItem.getDeviceID();
                this.remove(oldPanel);
                this.add((Component)this.rightNavigationPane, "East");
            }
            if (!featureItem.isExpandItem()) {
                this.selectedNavButton(featureItem);
            }
            this.topNavigationPane.manualUpdate(featureItem);
            this.contentPane.add((Component)this.topNavigationPane, "North");
            this.contentPane.add((Component)this.newPane, "Center");
            LauncherManager.getInstance().setCurrentDeviceID(featureItem.getDeviceID());
            this.contentPane.revalidate();
            this.contentPane.repaint();
            this.revalidate();
            this.repaint();
            this.stopDisplay(oldCurrentPane);
            this.newPane.clickToUpdate();
        }

        void selectedNavButton(FeatureItem featureItem) {
            String featureName = featureItem.getName();
            if (this.buttonMap.containsKey(featureName)) {
                JToggleButton navButton = (JToggleButton)this.buttonMap.get(featureName);
                navButton.setSelected(true);
                return;
            }
            String name = null;
            for (FeatureItem item : featureItem.getParents()) {
                name = item.getName();
                if (!this.buttonMap.containsKey(name)) continue;
                JToggleButton navButton = (JToggleButton)this.buttonMap.get(name);
                navButton.setSelected(true);
            }
        }

        void updateFeaturePane() {
            if (null != this.newPane) {
                try {
                    this.newPane.autoUpdate();
                }
                catch (Exception e) {
                    LOGGER.error("auto update newPane failed." + e);
                }
                try {
                    this.topNavigationPane.autoUpdate();
                }
                catch (Exception e) {
                    LOGGER.error("auto update topNavigationPane failed." + e);
                }
            }
        }

        void stopShow() {
            if (null != this.newPane) {
                this.newPane.stopDisplay();
            }
        }

        private void stopDisplay(PropertyPane oldPane) {
            if (null == oldPane) {
                return;
            }
            MyStpTask runnable = new MyStpTask(oldPane);
            ThreadPoolManager.getInstance().execute(runnable);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int width = this.getWidth();
            Graphics2D g2d = (Graphics2D)graphics;
            IsmPlafUtils.fillTexture(this, g2d, LEFT_TOP_CORNER, new Rectangle(0, 0, LEFT_TOP_CORNER.getIconWidth(), LEFT_TOP_CORNER.getIconHeight()));
            IsmPlafUtils.fillTexture(this, g2d, TOP_CENTER, new Rectangle(LEFT_TOP_CORNER.getIconWidth(), 0, width - LEFT_TOP_CORNER.getIconWidth() - RIGHT_TOP_CORNER.getIconWidth(), TOP_CENTER.getIconHeight()));
            IsmPlafUtils.fillTexture(this, g2d, RIGHT_TOP_CORNER, new Rectangle(width - RIGHT_TOP_CORNER.getIconWidth(), 0, RIGHT_TOP_CORNER.getIconWidth(), RIGHT_TOP_CORNER.getIconHeight()));
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, LEFT_TOP_CORNER.getIconHeight(), width, this.getHeight() - LEFT_TOP_CORNER.getIconHeight() - 1);
        }

        private static final class MyStpTask
        implements Runnable {
            private final PropertyPane oldPane;

            private MyStpTask(PropertyPane oldPane) {
                this.oldPane = oldPane;
            }

            @Override
            public void run() {
                this.oldPane.stopDisplay();
            }
        }
    }

    private static class DeviceNameLabel
    extends JLabel {
        private static final long serialVersionUID = -377605612865874406L;
        private static final int DEVICE_NAME_LENGTH = 150;
        private String deviceID = null;
        private boolean isNas;

        public DeviceNameLabel(String deviceID) {
            super(ResourceManager.getImage("state_normal.png"));
            this.setHorizontalTextPosition(4);
            this.deviceID = deviceID;
            this.setFont(IsmFontFactory.getBold12Font());
            this.update();
            this.doHandler();
        }

        public DeviceNameLabel(String deviceID, boolean isNas) {
            super(ResourceManager.getImage("state_normal.png"));
            this.isNas = isNas;
            this.setHorizontalTextPosition(4);
            this.deviceID = deviceID;
            this.setFont(IsmFontFactory.getBold12Font());
            this.update();
        }

        private void doHandler() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    JLabel lable = (JLabel)mouseEvent.getSource();
                    DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, lable);
                    DeviceContext deviceConxt = LauncherManager.getInstance().getDeviceContext(deviceID);
                    if (null == deviceConxt) {
                        throw new NullPointerException();
                    }
                    FeatureItem featureItem = FeatureItemFactory.getFeatureItem(deviceID, deviceConxt.getDeviceType(), "physical_view");
                    devicePane.setFeaturePane(featureItem);
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    JLabel lable = (JLabel)mouseEvent.getSource();
                    lable.setForeground(UIManager.getColor("IsmOEMTheme.renderColor"));
                    lable.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    JLabel lable = (JLabel)mouseEvent.getSource();
                    lable.setForeground(UIManager.getColor("PlainFont.color"));
                    lable.setCursor(Cursor.getDefaultCursor());
                }
            });
        }

        void update() {
            Launcher launcher = LauncherManager.getInstance().getLauncher(this.deviceID);
            if (null == launcher) {
                return;
            }
            String deviceName = launcher.getDeviceName();
            if (null == deviceName || deviceName.isEmpty()) {
                deviceName = "SN_" + this.deviceID;
            }
            this.setText(deviceName);
            Dimension preferredSize = this.getUI().getPreferredSize(this);
            if (null == preferredSize) {
                throw new NullPointerException();
            }
            if (preferredSize.width > 150) {
                preferredSize = new Dimension(150, preferredSize.height);
            }
            if (!this.isNas) {
                this.setPreferredSize(preferredSize);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private static class StatusBar
    extends IsmGradientPanel {
        private static final long serialVersionUID = -5305951094985875188L;
        private transient RefreshTimeTask refreshTimeTask;
        private String deviceID;
        private JLabel deviceTimeLabel;

        public StatusBar(String deviceID) {
            this.deviceID = deviceID;
            this.doLayoutUI();
            this.initData();
        }

        @Override
        public Image getBackgroudImage() {
            return ResourceManager.getImage("statusBar_background.png").getImage();
        }

        public void update() {
            this.initData();
        }

        private void doLayoutUI() {
            JLabel uLabel = new JLabel(ResourceManager.getStringWithColon("USER_MANAGER_SELECT_USER_TABLE"));
            Launcher launcher = LauncherManager.getInstance().getLauncher(this.deviceID);
            User user = launcher.getDeviceContext().getCurrentUser();
            JLabel usernameLabel = new JLabel(user.getUserName());
            JLabel userLevelLabel = Framework.getInstance().getStrProperty("-devicetype").equals("N8000") && user.getLevel().equals((Object)User.Level.Admin) ? new JLabel("(" + ResourceManager.getString("Cluster.User.SystemAdmin_1") + ")") : new JLabel("(" + user.getLevel().getDescription() + ")");
            this.deviceTimeLabel = new JLabel("");
            this.setLayout(new BoxLayout(this, 0));
            this.add(this.deviceTimeLabel);
            this.add(Box.createHorizontalGlue());
            this.add(uLabel);
            this.add(Box.createHorizontalStrut(5));
            this.add(usernameLabel);
            this.add(Box.createHorizontalStrut(2));
            this.add(userLevelLabel);
            this.setPreferredSize(new Dimension(0, 30));
            this.setBorder(new EmptyBorder(0, 15, 0, 15));
        }

        private void initData() {
            if (null == this.refreshTimeTask) {
                this.refreshTimeTask = new RefreshTimeTask();
                TimerTaskManager.getScheduledTimer().scheduleAtFixedRate(this.refreshTimeTask, 0L, 1L, TimeUnit.SECONDS);
            }
            this.setTimezoneName();
        }

        private void setTimezoneName() {
            Launcher launcher = LauncherManager.getInstance().getLauncher(this.deviceID);
            if (null == launcher) {
                return;
            }
            TimeZone timeZone = launcher.getDeviceTimeZone();
            if (null == timeZone) {
                return;
            }
            List<Pair<String, String>> items = this.getTimeZoneItmes();
            boolean isSetTooltip = false;
            for (Pair<String, String> item : items) {
                if (!timeZone.getID().equalsIgnoreCase(item.getKey())) continue;
                this.deviceTimeLabel.setToolTipText(item.getValue());
                isSetTooltip = true;
                break;
            }
            if (!isSetTooltip && timeZone instanceof SimpleTimeZone) {
                this.deviceTimeLabel.setToolTipText(CommonUtil.getShowTimeZoneValue(timeZone));
            }
        }

        private List<Pair<String, String>> getTimeZoneItmes() {
            String timezoneStr = null;
            timezoneStr = CommonUtil.isXVEDevice(this.deviceID) ? ResourceManager.getString("ALL_TIME_ZONE_XVEC01") : ResourceManager.getString("ALL_TIME_ZONE");
            String[] timezones = timezoneStr.split(";");
            ArrayList<Pair<String, String>> items = new ArrayList<Pair<String, String>>(0);
            String key = null;
            for (String timezone : timezones) {
                key = timezone.substring(timezone.indexOf("'") + 1);
                items.add(new Pair<String, String>(key, timezone.substring(0, timezone.indexOf("'"))));
            }
            return items;
        }

        private Runnable createRefreshTimeTask() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
                    if (null == launcher) {
                        return;
                    }
                    String dateNowStr = TimeUtil.toGMTString(launcher.getDeviceTime() * 1000L, launcher.getDeviceTimeZone());
                    deviceTimeLabel.setText(dateNowStr);
                    this.setTimezoneName();
                }
            };
            return runnable;
        }

        private class RefreshTimeTask
        implements Runnable {
            private RefreshTimeTask() {
            }

            @Override
            public void run() {
                SwingUtil.runInEventDispatchThread(StatusBar.this.createRefreshTimeTask());
            }
        }
    }

    private static final class MouseGrabberListener
    implements AWTEventListener {
        private MouseGrabberListener() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 501 && aboutPopup.isVisible()) {
                Component src = (Component)event.getSource();
                if (!this.isInCurrentWindow(src)) {
                    return;
                }
                if (this.isInPopup(src)) {
                    return;
                }
                aboutPopup.setVisible(false);
            }
        }

        private boolean isInPopup(Component src) {
            for (Component c = src; c != null && !(c instanceof Applet); c = c.getParent()) {
                if (!(c instanceof AboutPopup)) continue;
                return true;
            }
            return false;
        }

        private boolean isInCurrentWindow(Component src) {
            Window window = SwingUtilities.getWindowAncestor(src);
            Frame parent = Framework.getInstance().getMainFrame();
            return parent.equals(window);
        }
    }

    private static class ShowLoginUserPane
    extends JPanel {
        private static final long serialVersionUID = -9247310463254624L;
        private DeviceApplet deviceApplet = null;
        private JLabel logout = null;
        private JLabel help = null;
        private JPopupMenu popmenu;

        public ShowLoginUserPane(DeviceApplet deviceApplet) {
            this.deviceApplet = deviceApplet;
            this.setOpaque(false);
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            this.logout = new JLabel(ResourceManager.getImage("logout.png"));
            this.logout.setForeground(Color.WHITE);
            this.logout.setToolTipText(ResourceManager.getString("SYSTEM.LOGOUT"));
            this.help = new JLabel(ResourceManager.getImage("mainHelp.png"));
            this.help.setForeground(Color.WHITE);
            this.help.setToolTipText(ResourceManager.getString("FEATURE.NAME.HELP"));
            this.popmenu = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(ResourceManager.getString("MAIN.HELP.TOPICS"));
            this.popmenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.displayHelp();
                }
            });
            menuItem = new JMenuItem(ResourceManager.getString("MAIN.ABOUT"));
            this.popmenu.add(menuItem);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.displayAbout();
                }
            });
            this.addHandler();
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createHorizontalStrut(10));
            this.add(this.logout);
            this.add(Box.createHorizontalStrut(10));
            this.add(this.help);
        }

        private void displayHelp() {
            HelpManager.getInstance().displayHelp("default");
        }

        private void displayAbout() {
            aboutPopup.showDialog();
        }

        private void addHandler() {
            this.logout.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    JLabel jLabel = (JLabel)mouseEvent.getSource();
                    this.setCursor(new Cursor(12));
                    jLabel.setForeground(UIManager.getColor("IsmButton.defaultBorderColor"));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    JLabel jLabel = (JLabel)mouseEvent.getSource();
                    jLabel.setForeground(Color.WHITE);
                    this.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Component label = (Component)mouseEvent.getSource();
                    int choice = DialogUtils.showYesNoDialog(SwingUtilities.getWindowAncestor(label), ResourceManager.getString("SYSTEM.LOGOUT.SURE.MESSAGE")).getValue();
                    if (choice == 0) {
                        DevicePane devicePane = (DevicePane)SwingUtilities.getAncestorOfClass(DevicePane.class, label);
                        devicePane.stopShow();
                        deviceApplet.logout();
                    }
                }
            });
            this.help.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    JLabel label = (JLabel)mouseEvent.getSource();
                    this.setCursor(new Cursor(12));
                    label.setForeground(UIManager.getColor("IsmButton.defaultBorderColor"));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    JLabel label = (JLabel)mouseEvent.getSource();
                    label.setForeground(Color.WHITE);
                    this.setCursor(new Cursor(0));
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    JLabel label = (JLabel)mouseEvent.getSource();
                    popmenu.show(label, -label.getWidth() - 65, label.getY() + label.getHeight() + 2);
                }
            });
        }
    }

    private static class BuzzerConfigPane
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = -4202926047337729275L;

        public BuzzerConfigPane() {
            this.setIcon(ResourceManager.getImage("tooltips_buzzer.png"));
            this.addMouseListener(this);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setCursor(new Cursor(0));
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JMenuItem menuItem = new JMenuItem(ResourceManager.getString("alarm.buzzer.setting.title"));
            menuItem.addActionListener(new MyMenuItmListner());
            JPopupMenu popmenu = new JPopupMenu();
            popmenu.add(menuItem);
            popmenu.show(this, 0, this.getHeight());
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private static final class MyMenuItmListner
        implements ActionListener {
            private MyMenuItmListner() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                IsmAlarmBuzzerSwitchDialog dialog = new IsmAlarmBuzzerSwitchDialog();
                dialog.setVisible(true);
            }
        }
    }

    private static class LogoutTimeSettingPane
    extends JLabel
    implements MouseListener {
        private static final long serialVersionUID = -5677336441763118564L;

        LogoutTimeSettingPane() {
            this.setIcon(ResourceManager.getImage("logout_setting.png"));
            this.setForeground(Color.WHITE);
            this.setToolTipText(ResourceManager.getString("PLATFORM_SYSTEM_SETTINGS"));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            LogoutTimeSettingDialog logoutTimeSettingDialog = new LogoutTimeSettingDialog();
            logoutTimeSettingDialog.setVisible(true);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.setCursor(new Cursor(0));
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private static class TitleBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel titleLabel = new JLabel();
        private ShowLoginUserPane showLoginUserPane = null;
        private DefaultEventStatPane eventStatPane = new DefaultEventStatPane();

        public TitleBar(DeviceApplet deviceApplet) {
            this.showLoginUserPane = new ShowLoginUserPane(deviceApplet);
            this.doLayoutUI();
        }

        private void doLayoutUI() {
            BuzzerConfigPane showBuzzerPane = new BuzzerConfigPane();
            this.titleLabel = new JLabel();
            this.titleLabel.setForeground(Color.WHITE);
            this.titleLabel.setFont(new Font("Dialog", 1, 14));
            this.titleLabel.setText(ResourceManager.getOEMString("SOFTWARE_NAME"));
            this.setLayout(new BoxLayout(this, 0));
            this.add(Box.createRigidArea(new Dimension(0, 40)));
            this.add(this.titleLabel);
            this.add(Box.createHorizontalGlue());
            this.add(this.createBuzzerButton());
            this.add(showBuzzerPane);
            this.add(Box.createHorizontalStrut(10));
            this.add(this.eventStatPane);
            this.eventStatPane.setMaximumSize(new Dimension(300, this.eventStatPane.getPreferredSize().height));
            LogoutTimeSettingPane logoutTimeSettingPane = new LogoutTimeSettingPane();
            this.add(Box.createHorizontalStrut(30));
            this.add(logoutTimeSettingPane);
            this.add(Box.createHorizontalStrut(10));
            this.add(this.showLoginUserPane);
            this.setOpaque(false);
            this.setBorder(new EmptyBorder(0, 15, 0, 15));
        }

        private JButton createBuzzerButton() {
            String opentImgName = "open_alarm_buzzer.png";
            ToolBarButton buzzerBtn = new ToolBarButton(ResourceManager.getImage(opentImgName), new Dimension(24, 24), ResourceManager.getString("OPEN_ALARM_BUZZER"));
            buzzerBtn.addActionListener(new MineBuzzBtnListner(buzzerBtn));
            return buzzerBtn;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int width = this.getWidth();
            int height = this.getHeight();
            ImageIcon imgIcon = ResourceManager.getImage("device_header_highlight.png");
            int imgW = imgIcon.getIconWidth();
            int imgH = imgIcon.getIconHeight();
            int abs = Math.abs((width - imgW) / 2);
            int abs1 = Math.abs((height - imgH) / 2);
            graphics.drawImage(imgIcon.getImage(), abs, abs1, imgW, imgH, null);
        }

        private static final class MineBuzzBtnListner
        implements ActionListener {
            private final JButton buzzerBtn;

            private MineBuzzBtnListner(JButton buzzerBtn) {
                this.buzzerBtn = buzzerBtn;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean isEnable = EventBuzzHandle.getInstance().isBuzzEnable();
                EventBuzzHandle.getInstance().setBuzzEnable(!isEnable);
                String opentImgName = "open_alarm_buzzer.png";
                String closeImgName = "close_alarm_buzzer.png";
                ImageIcon icon = isEnable ? ResourceManager.getImage(closeImgName) : ResourceManager.getImage(opentImgName);
                String tip = isEnable ? ResourceManager.getString("SHUTDOWN_ALARM_BUZZER") : ResourceManager.getString("OPEN_ALARM_BUZZER");
                this.buzzerBtn.setToolTipText(tip);
                this.buzzerBtn.setIcon(icon);
            }
        }
    }
}

