/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import com.huawei.ism.common.Framework;
import com.huawei.ism.common.Launcher;
import com.huawei.ism.common.LauncherManager;
import com.huawei.ism.common.bean.DeviceContext;
import com.huawei.ism.common.bean.DeviceType;
import com.huawei.ism.common.bean.Event;
import com.huawei.ism.common.bean.ProductModelType;
import com.huawei.ism.common.bean.ProductSpeciality;
import com.huawei.ism.common.bean.User;
import com.huawei.ism.common.entity.Type;
import com.huawei.ism.common.resourcemanager.LocalResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.exception.IsmException;
import com.huawei.ism.message.IMsgCallback;
import com.huawei.ism.message.IsmMsg;
import com.huawei.ism.message.IsmMsgManager;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.ui.module.task.BackgroundTask;
import com.huawei.ism.ui.module.task.TaskManager;
import com.huawei.ism.ui.swing.PropertyPane;
import com.huawei.ism.ui.swing.dialog.ConfirmDialog;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.text.IsmPasswordField;
import com.huawei.ism.ui.swing.tree.IsmTreeNode;
import com.huawei.ism.util.Assert;
import com.huawei.ism.util.SceneEnum;
import com.huawei.ism.util.TimeUtil;
import com.huawei.ism.util.Utils;
import com.huawei.json.JSONException;
import com.huawei.json.JSONObject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtil.class);
    public static final String HISTORYFILE = ".sav";
    private static Writer lockOwner;
    private static final List<String> STOPDEVICEIDS;
    private static final Hashtable<Container, Object> CONTAINERS;

    public static String addColon(String str) {
        if (null == str) {
            return null;
        }
        if (str.endsWith(":")) {
            return str;
        }
        return str + ":";
    }

    public static String removeColon(String str) {
        if (Utils.isNullStr(str)) {
            return str;
        }
        String colon = ":";
        String rightSymbol = ")";
        String rightSymbolZH = "\uff09";
        String leftSymbol = "(";
        String leftSymbolZH = "\uff08";
        if (str.endsWith(rightSymbol + colon)) {
            return str.substring(0, str.lastIndexOf(leftSymbol));
        }
        if (str.endsWith(rightSymbolZH + colon)) {
            return str.substring(0, str.lastIndexOf(leftSymbolZH));
        }
        if (str.endsWith(colon)) {
            return str.substring(0, str.lastIndexOf(colon));
        }
        return str;
    }

    public static boolean isNullStr(String content) {
        return null == content || content.isEmpty();
    }

    public static boolean isNullList(List<?> fList) {
        return null == fList || fList.isEmpty();
    }

    public static String[] i18n(String[] keys) {
        if (CommonUtil.isNullArray(keys)) {
            return keys;
        }
        String[] result = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            if (null == keys[i]) continue;
            result[i] = ResourceManager.getString(keys[i]);
        }
        return result;
    }

    public static boolean isJunitTest() {
        String object = System.getProperty("ISM_JUNIT");
        return null != object && Boolean.parseBoolean(object);
    }

    public static boolean isNullString(String str, boolean needTrim) {
        if (str == null || str.length() < 1) {
            return true;
        }
        return needTrim && str.trim().length() < 1;
    }

    public static <T> boolean isNullArray(T ... something) {
        return null == something || something.length == 0;
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            throw new EncapsulatedRuntimeException("get system property [os.name] failed.");
        }
        return (osName = osName.toLowerCase(Locale.ENGLISH)).contains("windows") || osName.contains("Windows") || osName.contains("win") || osName.contains("Win");
    }

    public static boolean isReadOnly(String deviceID, Frame mainFrame) {
        String reason;
        boolean result = false;
        if (null != deviceID && !"".equals(deviceID) && null != (reason = CommonUtil.checkUserLevel(deviceID, User.Level.Admin))) {
            DialogUtils.showErrorDialog((Window)mainFrame, reason);
            result = true;
        }
        return result;
    }

    public static boolean isV2IntegratedN8000() {
        boolean debug = Boolean.valueOf(Framework.getInstance().getStrProperty("DEBUG_ISM"));
        if (debug) {
            return false;
        }
        String name = Framework.getInstance().getStrProperty("-account");
        String password = Framework.getInstance().getStrProperty("-password");
        String ip = Framework.getInstance().getStrProperty("-ip");
        String deviceType = Framework.getInstance().getStrProperty("-devicetype");
        return name != null && password != null && ip != null && !DeviceType.N8000.name().equals(deviceType);
    }

    public static boolean isSupportINode(String deviceID) {
        return false;
    }

    public static String addFullStop(String str) {
        String fullStop = "";
        fullStop = "zh".equals(ResourceManager.getLocale().getLanguage()) ? "\u3002" : ".";
        if (null == str) {
            return null;
        }
        if (str.endsWith(fullStop)) {
            return str;
        }
        return str + fullStop;
    }

    public static void saveDiscoveriedDevice(List<DeviceContext> deviceList) {
        block6: {
            try {
                File savFile = LocalResourceManager.getInstance().getFile(HISTORYFILE, true);
                if (!deviceList.isEmpty()) {
                    try (FileOutputStream fos = new FileOutputStream(savFile);){
                        fos.write(CommonUtil.encodeDeviceContext(deviceList));
                        break block6;
                    }
                }
                savFile.deleteOnExit();
            }
            catch (Throwable e) {
                LOGGER.error("Save History file error : IOException ", e);
            }
        }
    }

    public static boolean isExistedFile(String dir, String fileName) {
        File directory = new File(dir);
        File[] files = directory.listFiles();
        if (null == files) {
            return false;
        }
        for (File aFile : files) {
            if (!aFile.getName().equalsIgnoreCase(fileName)) continue;
            return true;
        }
        return false;
    }

    public static Launcher getLauncher(String deviceID) {
        return LauncherManager.getInstance().getLauncher(deviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<DeviceContext> readDeviceContexts() {
        List<DeviceContext> deviceList = new ArrayList<DeviceContext>(0);
        try {
            File savFile = LocalResourceManager.getInstance().getFile(HISTORYFILE, false);
            if (!savFile.exists()) {
                return deviceList;
            }
            try (FileInputStream fis = new FileInputStream(savFile);){
                int fileSize = fis.available();
                byte[] datas = new byte[fileSize];
                int length = fis.read(datas);
                if (length == fileSize) {
                    deviceList = CommonUtil.decodeDeviceContext();
                }
            }
        }
        catch (Throwable e) {
            LOGGER.error("read history fail", e);
        }
        return deviceList;
    }

    private static byte[] encodeDeviceContext(List<DeviceContext> deviceList) {
        StringBuffer buffer = new StringBuffer();
        for (DeviceContext context : deviceList) {
            buffer.append(context.getPreferedIP());
            buffer.append('\n');
            buffer.append(context.getDeviceModelType().name());
            buffer.append('\n');
            buffer.append((Object)context.getDeviceType());
            buffer.append('\n');
            buffer.append(context.getCurrentUser().getUserName());
            buffer.append('\n');
            String pwd = context.getCurrentUser().getPassword();
            buffer.append(pwd);
            buffer.append('\n');
            pwd = null;
            buffer.append(context.getDeviceName());
            buffer.append('\n');
            buffer.append(context.getDeviceID());
            buffer.append('\n');
            buffer.append(context.getProtocalType().name());
            buffer.append('\n');
        }
        return new byte[0];
    }

    private static List<DeviceContext> decodeDeviceContext() {
        String val = "";
        String[] items = val.split("\n");
        ArrayList<DeviceContext> contexts = new ArrayList<DeviceContext>(0);
        String ip = null;
        String account = null;
        String passW = null;
        DeviceContext context = null;
        for (int i = 0; i < items.length / 8; ++i) {
            ip = items[i * 8];
            account = items[i * 8 + 3];
            passW = items[i * 8 + 4];
            context = new DeviceContext(account, passW, new String[]{ip});
            context.setDeviceModelType(ProductModelType.valueOf(items[i * 8 + 1]));
            context.setDeviceName(items[i * 8 + 5]);
            context.setDeviceType(DeviceType.getDeviceType(items[i * 8 + 2]));
            context.setDeviceID(items[i * 8 + 6]);
            context.setProtocalType(DeviceContext.ProtocalType.valueOf(items[i * 8 + 7]));
            contexts.add(context);
        }
        return contexts;
    }

    public static void holdLock() {
        try {
            File lockFile = LocalResourceManager.getInstance().getFile(".lck", false);
            if (lockFile.exists()) {
                lockOwner = new OutputStreamWriter((OutputStream)new FileOutputStream(lockFile), Charset.defaultCharset());
                lockOwner.write(0);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public static BackgroundTask createDiscoveryBGTask(String taskKey, String ip, DeviceContext context) {
        BackgroundTask task = new BackgroundTask(taskKey, BackgroundTask.State.RUNNING_NORMAL, "--", ip, ResourceManager.getString("TASK_TYPE_DISCOVER_ARRAY"), "--", 1, "", true, context);
        task.setRemoveOnCompleted(false);
        TaskManager.getInstance().updateTask(task);
        return task;
    }

    public static BackgroundTask createDiscoveryBGTask(String taskKey, String ip) {
        BackgroundTask task = new BackgroundTask(taskKey, BackgroundTask.State.RUNNING_NORMAL, "--", ip, ResourceManager.getString("TASK_TYPE_DISCOVER_ARRAY"), "--", 1, "", true);
        task.setRemoveOnCompleted(false);
        TaskManager.getInstance().updateTask(task);
        return task;
    }

    public static String change2ErrMsg(Throwable throwable) {
        String msg = null;
        if (throwable instanceof IsmException) {
            IsmException ismException = CommonUtil.convertObject(throwable, IsmException.class);
            String cause = ismException.getErrorMessage();
            if (null != cause && !"".equals(cause)) {
                msg = cause;
            }
        } else {
            msg = throwable instanceof TimeoutException ? ResourceManager.getString("SERVER_TIMEOUT_ERROR") : ResourceManager.getString("SERVER_INNER_ERROR");
        }
        return msg;
    }

    public static boolean isProxyMode() {
        return Framework.getInstance().getRunMode().equalsIgnoreCase("PROXY");
    }

    public static IsmTreeNode buildTreeNode(String imgName, String nodeTextKey, final PropertyPane propertypane) {
        IsmTreeNode node = new IsmTreeNode(propertypane.getDeviceID()){
            private static final long serialVersionUID = 1098530417229404400L;

            @Override
            protected PropertyPane createPropertyPane() {
                return propertypane;
            }
        };
        node.setIcon(ResourceManager.getImage(imgName));
        node.setNodeText(ResourceManager.getString(nodeTextKey));
        return node;
    }

    public static String buildCallHomeMsg(Event event, String arrayId, String address, String clientName) {
        String ret = "";
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        buf.append("\"version\":\"1.0\",");
        buf.append("\"properties\":");
        buf.append('{');
        buf.append("\"SN\":");
        buf.append("\"" + arrayId + "\",");
        buf.append("\"status\":");
        buf.append("\"" + event.getName() + "\",");
        buf.append("\"address\":");
        buf.append("\"" + address + "\"");
        buf.append("\"clientName\":");
        buf.append("\"" + clientName + "\"");
        buf.append('}');
        buf.append('}');
        ret = buf.toString();
        return ret;
    }

    public static String getDeviceName(String deviceId) {
        String devicename = "";
        if (null != deviceId) {
            Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
            if (launcher == null) {
                return devicename;
            }
            devicename = launcher.getDeviceName();
        }
        return devicename == null ? "" : devicename;
    }

    public static String checkUserLevel(String deviceId, User.Level minUserLevel) {
        if (null == minUserLevel || null == deviceId) {
            return null;
        }
        String reason = null;
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
        User user = launcher.getDeviceContext().getCurrentUser();
        User.Level level = user.getLevel();
        if (null != level && level.getValue() > minUserLevel.getValue()) {
            if (minUserLevel == User.Level.Admin) {
                reason = DeviceType.N8000.equals((Object)launcher.getDeviceContext().getDeviceType()) ? ResourceManager.getString("N8000_USER_TYPE_NOT_ABOVE_STORAGE") : ResourceManager.getString("USER_TYPE_NOT_ABOVE_ADMINISTRATOR");
            } else if (minUserLevel == User.Level.SuperAdmin) {
                reason = DeviceType.N8000.equals((Object)launcher.getDeviceContext().getDeviceType()) ? ResourceManager.getString("N8000_USER_TYPE_NOT_ABOVE_SYSTEM_ADMIN") : ResourceManager.getString("USER_TYPE_NOT_ABOVE_SUPERADMIN");
            }
        }
        return reason;
    }

    public static String checkProductSpeciality(String deviceId, ProductSpeciality ps) {
        if (null == ps || null == deviceId) {
            return null;
        }
        String reason = null;
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceId);
        boolean support = launcher.isSupportSpeciality(ps);
        if (!support) {
            reason = ResourceManager.getString("DEVICE_NOT_SUPPORT_OPERATION");
        }
        return reason;
    }

    public static List<User.Level> getSupportUserLevel() {
        String[] supportUserLevel = ResourceManager.getString("USER_LEVEL").split(",");
        ArrayList<User.Level> userTypes = new ArrayList<User.Level>(0);
        int l = 0;
        User.Level type = null;
        for (String level : supportUserLevel) {
            l = Integer.parseInt(level.trim());
            type = User.Level.valueOf(l);
            userTypes.add(type);
        }
        return userTypes;
    }

    public static void logout(final Launcher launcher) {
        Callable<Object> task = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                launcher.stop();
                return null;
            }
        };
        AsyncExcutor.execute(task);
    }

    public static void exitSystem(boolean saveDeviceInfo) {
        CommonUtil.dealPreExit(saveDeviceInfo);
        CommonUtil.dealExit();
        ProgressDialog dialog = new ProgressDialog((Window)Framework.getInstance().getMainFrame());
        dialog.setVisible(true);
    }

    private static void dealExit() {
        Thread exitThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("exit ISM");
                    3.sleep(30000L);
                }
                catch (Throwable e) {
                    LOGGER.error("exit exception! ", e);
                }
                finally {
                    Utils.exitSystem();
                }
            }
        };
        exitThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Uncaught excetion on thread " + t.getName(), e);
            }
        });
        exitThread.setName("CommonUtil-Thread-2");
        exitThread.start();
    }

    private static void dealPreExit(final boolean saveDeviceInfo) {
        Thread logoutThread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.currentThread().setName("logout before exit ISM");
                    LOGGER.error("start logout>>>>>>>>");
                    if (saveDeviceInfo) {
                        LauncherManager launcherManager = LauncherManager.getInstance();
                        List<DeviceContext> deviceList = launcherManager.getDeviceContexts();
                        CommonUtil.saveDiscoveriedDevice(deviceList);
                    } else {
                        CommonUtil.saveDiscoveriedDevice(new ArrayList<DeviceContext>(0));
                    }
                    LauncherManager.getInstance().stopAllLauncher();
                    LOGGER.error("<<<<<<<<<<<end logout");
                }
                catch (Throwable e) {
                    LOGGER.error("logout exception! ", e);
                }
                finally {
                    Utils.exitSystem();
                }
            }
        };
        logoutThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LOGGER.error("Uncaught error on sub thread: ", e);
            }
        });
        logoutThread.setName("CommonUtil-Thread-1");
        logoutThread.start();
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = null;
        try {
            method = clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            method = CommonUtil.getMethodBy(clazz, name, parameterTypes);
        }
        if (null == method) {
            throw new NoSuchMethodException(clazz.getName() + "." + name);
        }
        return method;
    }

    private static Method getMethodBy(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        Method[] methods = clazz.getMethods();
        Class<?>[] curParameterTypes = null;
        Class<?> parameterType = null;
        Class<?> curParameterType = null;
        for (Method curMethod : methods) {
            curParameterTypes = curMethod.getParameterTypes();
            if (!curMethod.getName().equals(name) || curParameterTypes.length != parameterTypes.length) continue;
            for (int i = 0; i < parameterTypes.length && (curParameterType = curParameterTypes[i]).isAssignableFrom(parameterType = parameterTypes[i]); ++i) {
                if (i != parameterTypes.length - 1) continue;
                return curMethod;
            }
        }
        return null;
    }

    public static void closeLogs() {
        System.setProperty("ENABLE_RESOURCE_LOG", "true");
    }

    public static void stopMonitorDevice(String[] deviceIDs, final IMsgCallback stopMonitorCallback) {
        String desc;
        Frame frame = Framework.getInstance().getMainFrame();
        if (ConfirmDialog.showDialog((Window)frame, ConfirmDialog.Level.INFO, desc = ResourceManager.getString("DELETE_ARRAY_WARNING_DIALOG_TIP"), "", "", new String[0])) {
            IsmMsg msg = IsmMsgManager.getInstance().buildMsg("MSG_DELETE_DEVICE");
            msg.setProperty("DEVICE_ID", deviceIDs);
            final ProgressDialog progressDialog = new ProgressDialog((Window)frame);
            IMsgCallback wraper = new IMsgCallback(){

                @Override
                public void processMsgEnd(IsmMsg ismMsg) {
                    progressDialog.dispose();
                    stopMonitorCallback.processMsgEnd(ismMsg);
                }
            };
            IsmMsgManager.getInstance().postAsyncMsg(msg, wraper);
            progressDialog.setVisible(true);
        }
    }

    public static DeviceContext getDeviceContext(String deviceID) {
        Launcher launcher = CommonUtil.getLauncher(deviceID);
        if (null != launcher) {
            return launcher.getDeviceContext();
        }
        return null;
    }

    public static boolean isModuleEnable(String moduleName) {
        if (moduleName == null || "".equals(moduleName)) {
            return false;
        }
        return Boolean.valueOf(Framework.getInstance().getStrProperty(moduleName, "false")) == false;
    }

    public static void compareDeviceType(DeviceContext context, DeviceType type) throws IsmException {
        String errMsg = null;
        if (null == type) {
            errMsg = ResourceManager.getString("LOAD_DEVICE_TYPE_FAILED");
        }
        DeviceType oldType = context.getDeviceType();
        if (DeviceType.isVISSerias(type) && !DeviceType.isVISSerias(oldType)) {
            errMsg = ResourceManager.getString("LOAD_DEVICE_TYPE_FAILED");
        }
        if (DeviceType.isVISSerias(oldType) && !DeviceType.isVISSerias(type)) {
            errMsg = ResourceManager.getString("LOAD_DEVICE_TYPE_FAILED");
        }
        if (null != errMsg) {
            throw new IsmException(errMsg);
        }
    }

    public static <T> List<T> listCopy(List<T> aList) {
        ArrayList<T> clone = new ArrayList<T>(0);
        if (Utils.isNullList(aList)) {
            return clone;
        }
        clone.addAll(aList);
        return clone;
    }

    public static boolean isV2Integrated() {
        boolean debug = Boolean.valueOf(Framework.getInstance().getStrProperty("DEBUG_ISM"));
        if (debug) {
            return false;
        }
        String name = Framework.getInstance().getStrProperty("-account");
        String password = Framework.getInstance().getStrProperty("-password");
        String ip = Framework.getInstance().getStrProperty("-ip");
        String deviceType = Framework.getInstance().getStrProperty("-devicetype");
        return name != null && password != null && ip != null && !DeviceType.N8000.name().equals(deviceType);
    }

    public static String checkImportFileValid(File file, long thresholdSize, String threshold) {
        if (null == file) {
            return null;
        }
        if (file.length() > thresholdSize) {
            return ResourceManager.getStringWithParams("IMPORT_FILE_SIZE_ERROR", threshold);
        }
        return null;
    }

    public static boolean isTSeriesUnitary(String deviceID) {
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
        if (null != launcher) {
            return launcher.isSupportSpeciality(ProductSpeciality.T_SERIES_UNITARY);
        }
        return false;
    }

    public static String getRoleTableDisplay(Boolean bean) {
        String str = "--";
        if (null != bean) {
            str = bean != false ? ResourceManager.getString("PROPERTYPANE_HYPERMIRRORS_ISPRIMARY") : ResourceManager.getString("PROPERTYPANE_HYPERMIRRORS_ISSECOND");
        }
        return str;
    }

    public static boolean checkPasswordSecurity(String passwordStr, String accountStr, boolean isPrivilege) {
        Assert.notNullStr(passwordStr);
        boolean isSucess = false;
        StringBuffer strBuffer = new StringBuffer(accountStr);
        StringBuffer strReverseBuffer = strBuffer.reverse();
        String accountReverseStr = strReverseBuffer.toString();
        if (!isPrivilege && passwordStr.length() < 6) {
            return isSucess;
        }
        if (isPrivilege && passwordStr.length() < 8) {
            return isSucess;
        }
        if (!CommonUtil.isContainAppointLetter(passwordStr)) {
            return isSucess;
        }
        if (accountReverseStr.equals(passwordStr) || passwordStr.equals(accountStr)) {
            return isSucess;
        }
        isSucess = true;
        return isSucess;
    }

    private static boolean isContainAppointLetter(String passwordStr) {
        int fitNum = 0;
        if (CommonUtil.checkRegex(passwordStr, ".*[a-z]{1}.*")) {
            ++fitNum;
        }
        if (CommonUtil.checkRegex(passwordStr, ".*[A-Z]{1}.*")) {
            ++fitNum;
        }
        if (fitNum <= 1 && CommonUtil.checkRegex(passwordStr, ".*[0-9]{1}.*")) {
            ++fitNum;
        }
        if (fitNum <= 1 && CommonUtil.checkRegex(passwordStr, ".*[`~!@#$%^&*()-//_//=+\\\\|\\[{}\\];:'\",<\\.>/? ]{1}.*")) {
            ++fitNum;
        }
        return fitNum >= 2;
    }

    private static boolean checkRegex(String checkStr, String regexStr) {
        Pattern pattern = Pattern.compile(regexStr);
        Matcher matcher = pattern.matcher(checkStr);
        return matcher.matches();
    }

    public static boolean checkSystem(Window parent, String deviceID) {
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
        String result = launcher.checkSystemStatus(deviceID);
        if (null != result) {
            if (null != parent) {
                DialogUtils.showErrorDialog(parent, result);
            }
            return false;
        }
        result = CommonUtil.checkUserLevel(deviceID, User.Level.Admin);
        if (null != result) {
            if (null != parent) {
                DialogUtils.showErrorDialog(parent, result);
            }
            return false;
        }
        return true;
    }

    public static String getBlankByLan() {
        if (ResourceManager.getLocale().getLanguage().equals("en")) {
            return " ";
        }
        return "";
    }

    public static String castObject2String(Object obj) {
        if (obj != null) {
            if (obj instanceof Integer && (Integer)obj != Integer.MIN_VALUE) {
                return obj.toString();
            }
            if (obj instanceof Long && (Long)obj != Long.MIN_VALUE && (Long)obj != 0xFFFFFFFFL) {
                return obj.toString();
            }
            if (obj instanceof Double && (Double)obj != -9.223372036854776E18) {
                return obj.toString();
            }
            if (obj instanceof Float && ((Float)obj).floatValue() != -9.223372E18f) {
                return obj.toString();
            }
        }
        return "--";
    }

    public static String handleInputName(String validateTip, String inputName) {
        if (!ResourceManager.getLocale().getLanguage().equals("en") || Utils.isNullStr(inputName) || Utils.isNullStr(validateTip) || !CommonUtil.isNeedTransfer(inputName)) {
            return inputName;
        }
        if (validateTip.indexOf("{0}") == 0) {
            return inputName.substring(0, 1).toUpperCase(Locale.ENGLISH) + inputName.substring(1);
        }
        return inputName.substring(0, 1).toLowerCase(Locale.ENGLISH) + inputName.substring(1);
    }

    public static void addComponent(Container component, Object value) {
        CONTAINERS.put(component, value);
    }

    public static void removeComponent(Container component) {
        CONTAINERS.remove(component);
    }

    public static void setName(Container container) {
        if (null == container) {
            return;
        }
        CommonUtil.setName(container, new HashMap(0));
    }

    private static void setName(Container container, Map<Class<?>, Integer> counter) {
        boolean isValidType = CommonUtil.checkContainerType(container);
        if (isValidType) {
            Class<?> clazz = container.getClass();
            if (!counter.containsKey(clazz)) {
                counter.put(clazz, 0);
            }
            int count = counter.get(clazz);
            counter.put(clazz, ++count);
            String name = container.getClass().getSimpleName() + "_" + count;
            container.setName(name);
            if (!(container instanceof Dialog || container instanceof Frame || container instanceof Window || container instanceof JPanel || container instanceof JTabbedPane)) {
                return;
            }
        }
        Component[] children = container.getComponents();
        JComponent jc = null;
        for (Component comp : children) {
            if (!(comp instanceof JComponent)) continue;
            jc = (JComponent)comp;
            CommonUtil.setName(jc, counter);
        }
    }

    private static boolean checkContainerType(Container container) {
        boolean b1 = container instanceof JLabel || container instanceof AbstractButton || container instanceof JTextComponent || container instanceof JComboBox;
        boolean b2 = container instanceof Dialog || container instanceof Frame || container instanceof Window || container instanceof JPanel;
        boolean b3 = container instanceof JTable || container instanceof JList || container instanceof JTabbedPane;
        return b1 || b2 || b3;
    }

    private static boolean isNeedTransfer(String inputName) {
        if (Utils.isNullStr(inputName)) {
            return false;
        }
        String name = inputName.split(" ")[0];
        return !CommonUtil.checkRegex(name, "[A-Z]*");
    }

    public static boolean isNullIPv4Address(String ip) {
        if (ip == null) {
            return true;
        }
        int ch = 48;
        for (int i = 0; i < ip.length(); ++i) {
            ch = ip.charAt(i);
            if (ch == 32 || ch == 46) continue;
            return false;
        }
        return true;
    }

    public static HashMap<String, TimeZone> getTimeZones() {
        List<Launcher> launchers = LauncherManager.getInstance().getAllLauncher();
        HashMap<String, TimeZone> timeZones = new HashMap<String, TimeZone>(0);
        Collection<Launcher> sublaunchers = null;
        for (Launcher launcher : launchers) {
            timeZones.put(launcher.getDeviceID(), launcher.getDeviceTimeZone());
            sublaunchers = launcher.getSubLaunchers();
            if (null == sublaunchers) continue;
            for (Launcher sublauncher : sublaunchers) {
                timeZones.put(sublauncher.getDeviceID(), sublauncher.getDeviceTimeZone());
            }
        }
        return timeZones;
    }

    public static void addStopDeviceIDs(String[] deviceIDs) {
        for (String deviceID : deviceIDs) {
            STOPDEVICEIDS.add(deviceID);
        }
    }

    public static boolean isXVEDevice(String deviceID) {
        Launcher launcher = CommonUtil.getLauncher(deviceID);
        if (null != launcher) {
            return launcher.getDeviceContext().getDeviceType() == DeviceType.C3;
        }
        return false;
    }

    public static boolean isXVEDevice() {
        List<Launcher> listLauncher = LauncherManager.getInstance().getAllLauncher();
        if (!listLauncher.isEmpty()) {
            return listLauncher.get(0).getDeviceContext().getDeviceType() == DeviceType.C3;
        }
        return false;
    }

    public static String getNasDeviceIDByArrayID(String arrayID) {
        Launcher launcher = CommonUtil.getLauncher(arrayID);
        if (null != launcher) {
            List<String> subDeviceIDs = launcher.getSubDeviceIDs();
            if (!subDeviceIDs.isEmpty()) {
                return subDeviceIDs.get(0);
            }
            return null;
        }
        return null;
    }

    public static boolean showMultDeviceType(String arrayID) {
        return null != CommonUtil.getNasDeviceIDByArrayID(arrayID);
    }

    public static void removeStopDeviceIDs() {
        STOPDEVICEIDS.clear();
    }

    public static List<String> getStopDeviceIDs() {
        return STOPDEVICEIDS;
    }

    public static synchronized String gmtToString(String deviceID, long gmtTimeInMS) {
        Date date = new Date(gmtTimeInMS);
        TimeZone timeZone = TimeZone.getDefault();
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
        if (launcher != null) {
            timeZone = launcher.getDeviceTimeZone();
        }
        return TimeUtil.gmtToString(date, timeZone);
    }

    public static synchronized String gmtToString(Date gmtTime, String deviceID) {
        Launcher launcher = LauncherManager.getInstance().getLauncher(deviceID);
        if (null != launcher) {
            return TimeUtil.gmtToString(gmtTime, launcher.getDeviceTimeZone());
        }
        throw new IsmException("Can't find launch by deviceID:" + deviceID);
    }

    public static boolean isN8000V1(DeviceContext context) {
        if (DeviceType.N8000 != context.getDeviceType()) {
            return false;
        }
        if (context.getDeviceModelType() == ProductModelType.N8000) {
            return true;
        }
        return context.getDeviceModelType() == ProductModelType.N8300 && (context.getProductVersion() == null || !context.getProductVersion().contains("V200"));
    }

    public static boolean isNas() {
        return Framework.getInstance().getStrProperty("-devicetype").equals(DeviceType.N8000.name());
    }

    public static String getShowTimeZoneValue(TimeZone timeZone) {
        StringBuilder sb = new StringBuilder();
        try {
            sb.append("UTC");
            sb.append(CommonUtil.convertTimezoneOffset(timeZone));
        }
        catch (Exception e) {
            LOGGER.error("convert rawOffset error!");
        }
        sb.append('(');
        sb.append(timeZone.getID());
        sb.append(')');
        return sb.toString();
    }

    public static String convertTimezoneOffset(TimeZone timeZone) {
        StringBuilder returnStr = new StringBuilder();
        float rawOffsetF = timeZone.getRawOffset();
        BigDecimal bigDecimal = new BigDecimal((double)rawOffsetF / 3600000.0);
        float rawOffset = bigDecimal.setScale(2, 4).floatValue();
        int offsetMinit = (int)(Math.abs(rawOffset) * 60.0f);
        int minit = offsetMinit % 60;
        int hour = offsetMinit / 60;
        if (0.0f > rawOffset) {
            returnStr.append('-');
        } else {
            returnStr.append('+');
        }
        if (hour < 10) {
            returnStr.append('0');
        }
        returnStr.append(hour);
        returnStr.append(':');
        if (minit < 10) {
            returnStr.append('0');
        }
        returnStr.append(minit);
        return returnStr.toString();
    }

    public static boolean isSupportProductSpeciality(String deviceID, ProductSpeciality productSpeciality) {
        Launcher launcher = CommonUtil.getLauncher(deviceID);
        if (null != launcher) {
            return launcher.isSupportSpeciality(productSpeciality);
        }
        return false;
    }

    public static boolean isSupportLun2Nas(String deviceID) {
        if (null == deviceID) {
            return false;
        }
        return CommonUtil.isSupportProductSpeciality(deviceID, ProductSpeciality.FILE_ENGINE_NODE);
    }

    public static Locale getAvailableLocale(String localeStr) {
        if (null != localeStr) {
            if (localeStr.toLowerCase(ResourceManager.getLocale()).startsWith("zh")) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            return Locale.ENGLISH;
        }
        return null;
    }

    public static String getLanguageSet(String ismArg) {
        if (ismArg != null) {
            String[] argv;
            for (String str : argv = ismArg.split(";")) {
                String[] strs = str.split("=");
                if (strs.length != 2 || !"-language".equals(strs[0])) continue;
                return strs[1].replaceAll("-", "_");
            }
        }
        return null;
    }

    public static void checkStringParameter(String strParam) throws IsmException {
        if (null == strParam || "".equals(strParam)) {
            LOGGER.error("Parameter is invalid");
            throw new IsmException(16806405L);
        }
    }

    public static void checkObjectParameter(Object objParam) throws IsmException {
        if (null == objParam) {
            LOGGER.error("Parameter is null");
            throw new IsmException(16806405L);
        }
    }

    public static String formatCommonString(String targetStr) {
        if (null == targetStr || "".equals(targetStr)) {
            return "--";
        }
        return targetStr;
    }

    public static Type.LicenseFuncFeatureType getShowLicenseFeature(String deviceID, Type.LicenseFuncFeatureType hvsFeature, Type.LicenseFuncFeatureType xveFeature) {
        return xveFeature;
    }

    public static boolean isPasswordMoreThanMaxValu(IsmPasswordField ismPasswordField, String password) {
        return ismPasswordField.getMaxValidRestrict() < password.length();
    }

    public static String substring(String text, int length) {
        if (null == text) {
            return "--";
        }
        StringBuilder sb = new StringBuilder();
        int currentLength = 0;
        try {
            for (char c : text.toCharArray()) {
                if ((currentLength += String.valueOf(c).getBytes("UTF8").length) > length) break;
                sb.append(c);
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("UnsupportedEncodingException", (Throwable)e);
        }
        return sb.toString();
    }

    public static Map<DeviceType, List<DeviceContext>> getSystemXveAndNexDevices() {
        HashMap<DeviceType, List<DeviceContext>> deviceContextMaps = new HashMap<DeviceType, List<DeviceContext>>(0);
        List<DeviceContext> allDeviceContexts = LauncherManager.getInstance().getAllDeviceContexts();
        ArrayList<DeviceContext> nexDeviceContexts = new ArrayList<DeviceContext>(0);
        ArrayList<DeviceContext> xveDeviceContexts = new ArrayList<DeviceContext>(0);
        DeviceType deviceType = null;
        for (DeviceContext deviceContext : allDeviceContexts) {
            deviceType = deviceContext.getDeviceType();
            if (DeviceType.NEX.equals((Object)deviceType)) {
                nexDeviceContexts.add(deviceContext);
                continue;
            }
            if (!DeviceType.C3.equals((Object)deviceType)) continue;
            xveDeviceContexts.add(deviceContext);
        }
        deviceContextMaps.put(DeviceType.NEX, nexDeviceContexts);
        deviceContextMaps.put(DeviceType.C3, xveDeviceContexts);
        return deviceContextMaps;
    }

    public static boolean hasSystemIncludeTargetDevice(DeviceType deviceType) {
        Map<DeviceType, List<DeviceContext>> deviceContextMaps = CommonUtil.getSystemXveAndNexDevices();
        List<DeviceContext> deviceContext = deviceContextMaps.get((Object)deviceType);
        return !CommonUtil.isNullList(deviceContext);
    }

    public static boolean isAnySubArrayExsit() {
        Map<DeviceType, List<DeviceContext>> deviceContextMaps = CommonUtil.getSystemXveAndNexDevices();
        List<DeviceContext> nexDeviceContexts = deviceContextMaps.get((Object)DeviceType.NEX);
        List<DeviceContext> xveDeviceContexts = deviceContextMaps.get((Object)DeviceType.C3);
        return !CommonUtil.isNullList(nexDeviceContexts) || !CommonUtil.isNullList(xveDeviceContexts);
    }

    public static String getDeviceNameOrDeviceID(String deviceID) {
        String deviceName = "";
        Launcher tempLauncher = LauncherManager.getInstance().getLauncher(deviceID);
        deviceName = null == tempLauncher ? "--" : (null == tempLauncher.getDevContext().getDeviceName() ? tempLauncher.getDevContext().getDeviceID() : tempLauncher.getDevContext().getDeviceName());
        return deviceName;
    }

    public static <T> T convertObject(Object obj, Class<T> clazz) {
        if (clazz == null || obj == null) {
            return null;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        throw new ClassCastException("case " + obj.getClass().getName() + " to " + clazz.getName() + " exception.");
    }

    public static boolean isFwUpgradeScene() {
        try {
            String sceneArgsString = System.getenv("jsonSceneArgsList");
            LOGGER.info("jsonSceneArgsList: {}", (Object)sceneArgsString);
            String sceneString = System.getenv("jsonScene");
            LOGGER.info("jsonScene: {}", (Object)sceneString);
            if (StringUtils.isNULLStr((String)sceneArgsString) || StringUtils.isNULLStr((String)sceneString)) {
                return false;
            }
            JSONObject jsonScene = new JSONObject(sceneString);
            String mainScene = jsonScene.getStringOrDefault("mainScene", "");
            String subScene = jsonScene.getStringOrDefault("subScene", "");
            JSONObject jsonSceneArgs = new JSONObject(sceneArgsString);
            String toolDescription = jsonSceneArgs.getStringOrDefault("toolDescription", "");
            return "Fusion_Strg_Svr_Upgrade".equals(toolDescription) && "Upgrade".equals(mainScene) && "Upgrade_FSFW".equals(subScene);
        }
        catch (JSONException e) {
            LOGGER.error("Failed to obtain tool scene.", (Throwable)e);
            return false;
        }
    }

    public static boolean isSpecifiedScenario(SceneEnum sceneEnum) {
        String sceneString = System.getenv("jsonScene");
        LOGGER.info("jsonScene: {}", (Object)sceneString);
        if (StringUtils.isNULLStr((String)sceneString)) {
            return false;
        }
        try {
            JSONObject jsonScene = new JSONObject(sceneString);
            String mainScene = jsonScene.getStringOrDefault("mainScene", "");
            String subScene = jsonScene.getStringOrDefault("subScene", "");
            String stepId = jsonScene.getStringOrDefault("stepID", "");
            return sceneEnum.isCurrentScene(mainScene, subScene, stepId);
        }
        catch (JSONException e) {
            LOGGER.error("Failed to obtain tool scene.", (Throwable)e);
            return false;
        }
    }

    static {
        STOPDEVICEIDS = Collections.synchronizedList(new ArrayList());
        CONTAINERS = new Hashtable();
    }
}

