/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.util;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumberUtils {
    private static final Logger log = LoggerFactory.getLogger(NumberUtils.class);

    private NumberUtils() {
    }

    public static int getFirst8bitOfUint32(long uint32) {
        return (int)(uint32 >> 24);
    }

    public static int getFirst16bitOfUint32(long uint32) {
        return (int)(uint32 >> 16);
    }

    public static int getSecond8bitOfUint32(long uint32) {
        return (int)(uint32 >> 16) & 0xFF;
    }

    public static int getThird8bitOfUint32(long uint32) {
        return (int)(uint32 >> 8 & 0xFFL);
    }

    public static int getLast8bitOfUint32(long uint32) {
        return (int)(uint32 & 0xFFL);
    }

    public static String round(Number value, int n) {
        String formatStr = "";
        if (1 > n) {
            formatStr = "###,###,###,###,##0";
        } else {
            StringBuilder sb = new StringBuilder("###,###,###,###,##0.");
            for (int i = 0; i < n; ++i) {
                sb.append('0');
            }
            formatStr = sb.toString();
        }
        DecimalFormat numberFormat = new DecimalFormat(formatStr);
        return numberFormat.format(value);
    }

    public static int[] getPercent(Number[] numbers) {
        double[] result = NumberUtils.getPercent(numbers, 0);
        if (result.length == 0) {
            return new int[0];
        }
        int length = result.length;
        int[] temp = new int[length];
        for (int i = 0; i < length; ++i) {
            temp[i] = (int)result[i];
        }
        return temp;
    }

    public static double[] getPercent(Number[] numbers, int floatIndex) {
        int i;
        if (numbers == null) {
            return new double[0];
        }
        int length = numbers.length;
        double[] result = new double[length];
        double total = 0.0;
        for (Number number : numbers) {
            total += number.doubleValue();
        }
        if (total == 0.0) {
            for (int i2 = 0; i2 < length; ++i2) {
                result[i2] = 0.0;
            }
            return result;
        }
        double[] value = new double[length];
        int[] intPart = new int[length];
        double[] floatPart = new double[length];
        int ratio = 100;
        for (int n = 0; n < floatIndex; ++n) {
            ratio *= 10;
        }
        int gap = ratio;
        for (i = 0; i < length; ++i) {
            value[i] = numbers[i].doubleValue() / total * (double)ratio;
            intPart[i] = (int)value[i];
            floatPart[i] = value[i] - (double)intPart[i];
            gap -= intPart[i];
        }
        for (int m = 0; m < gap; ++m) {
            int index;
            int n = index = NumberUtils.getIndexOfMaxValue(floatPart);
            intPart[n] = intPart[n] + 1;
            floatPart[index] = 0.0;
        }
        for (i = 0; i < length; ++i) {
            result[i] = (double)intPart[i] / ((double)ratio / 100.0);
        }
        return result;
    }

    private static int getIndexOfMaxValue(double[] floatPart) {
        int index = 0;
        int length = floatPart.length;
        double maxValue = 0.0;
        for (int i = 0; i < length; ++i) {
            if (!(floatPart[i] > maxValue)) continue;
            maxValue = floatPart[i];
            index = i;
        }
        return index;
    }

    public static int parseIntDefault(String param, int defaultValue) {
        try {
            return Integer.parseInt(param);
        }
        catch (NumberFormatException e) {
            log.error("parse string to int error with param:{}", (Object)param);
            return defaultValue;
        }
    }
}

